// -*-c++-*-

/*!
  \file body_intercept.h
  \brief ball chasing action including smart planning.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef RCSC_ACTION_BODY_INTERCEPT_H
#define RCSC_ACTION_BODy_INTERCEPT_H

#include <rcsc/player/soccer_action.h>
#include <rcsc/player/intercept_table.h>
#include <rcsc/param/player_type.h>
#include <rcsc/geom/vector_2d.h>

namespace rcsc {

/*!
  \class Body_Intercept
  \brief ball chasing action including smart planning.
*/
class Body_Intercept
    : public BodyAction {
private:
    //! if true, agent must save recovery parameter
    const bool M_save_recovery;

public:
    /*!
      \brief construct with all parameters
      \param save_recovery if true, agent must save recovery parameter
    */
    explicit
    Body_Intercept( const bool save_recovery = true )
        : M_save_recovery( save_recovery )
      { }

    /*!
      \brief execute action
      \param agent pointer to the agent itself
      \return true if action is performed
    */
    bool execute( PlayerAgent * agent );


private:

    /*!
      \brief if kickable opponent exists, perform special action
      \param agent pointer to the agent itself
      \return true if action is performed
    */
    bool doKickableOpponentCheck( PlayerAgent * agent );

    /*!
      \brief calculate best interception point using cached table
      \param wm const refefence to the WorldModel
      \param table const pointer to the cached table
      \return interception info object
    */
    InterceptInfo getBestPoint( const WorldModel & wm,
                                const InterceptTable * table ) const;

    /*!
      \brief try to perform ball wait action
      \param agent pointer to the agent itself
      \param info interception info that is considered now
      \return true if action is performed
    */
    bool doWaitTurn( PlayerAgent * agent,
                     const InterceptInfo & info );

    /*!
      \brief adjutment dash action. if possible try to perform turn action.
      \param agent pointer to agent itself
      \param target_point intercept target ball point
      \param dash_power origianal intercept dash power parameter
      \param cycle estimated interception cycle
      \return true if action is performed
    */
    bool doInertiaDash( PlayerAgent * agent,
                        const Vector2D & target_point,
                        const double & dash_power,
                        const int cycle );

};

}

#endif
