// -*-c++-*-

/*!
  \file holder.h
  \brief rcg data holder Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef RCSC_RCG_HOLDER_H
#define RCSC_RCG_HOLDER_H

#include <rcsc/rcg/types.h>

#include <string>

namespace rcsc {
namespace rcg {

/*!
  \class Holder
  \brief data holder interface class

  The class that implements this interface should hold the
  whole game log data.
*/
class Holder {
private:

public:

    /*!
      \brief virtual destructor
     */
    virtual
    ~Holder()
      { }

    /*!
      \brief add new dispinfo_t (rcg v1, monitor v1)
      \param dinfo dispinfo_t struct data
      \retval true if successfully added.
      \retval false mode is incorrect, or failed to add.
     */
    virtual
    bool addDispInfo( const dispinfo_t & dinfo );

    /*!
      \brief add new dispinfo_t2 (monitor v2)
      \param dinfo2 dispinfo_t2 struct data
      \retval true if successfully added.
      \retval false mode is incorrect, or failed to add.
    */
    virtual
    bool addDispInfo2( const dispinfo_t2 & dinfo2 );

    /*!
      \brief (pure virtual) add showinfo_t (rcg v2, monitor v1)
      \param show added data
      \retval true if successfully added.
      \retval false mode is incorrect, or failed to add.
    */
    virtual
    bool addShowInfo( const showinfo_t & show ) = 0;

    /*!
      \brief (pure virtual) add showinfo_t2 (monitor v2 only)
      \param show added data
      \retval true if successfully added.
      \retval false mode is incorrect, or failed to add.
    */
    virtual
    bool addShowInfo2( const showinfo_t2 & show ) = 0;

    /*!
      \brief (pure virtual) add short_showinfo_t2 (rcg v3 only)
      \param show2 added data
      \retval true if successfully added.
      \retval false mode is incorrect, or failed to add.
    */
    virtual
    bool addShortShowInfo2( const short_showinfo_t2 & show2 ) = 0;

    /*!
      \brief (pure virtual) add msginfo_t
      \param board added message type
      \param msg added message
      \retval true if successfully added.
      \retval false mode is incorrect, or failed to add.
    */
    virtual
    bool addMsgInfo( const short board,
                     const std::string & msg ) = 0;

    /*!
      \brief (pure virtual) add drawinfo_t(rcg v1:v2, monitor v1)
      \param draw added data
      \retval true if successfully added.
      \retval false mode is incorrect, or failed to add.
    */
    virtual
    bool addDrawInfo( const drawinfo_t & draw ) = 0;

    /*!
      \brief (pure virtual) add playmode
      \param pmode added playmode character
      \retval true if successfully added.
      \retval false mode is incorrect, or failed to add.
    */
    virtual
    bool addPlayMode( const char pmode ) = 0;

    /*!
      \brief (pure virtual) add team_t * 2
      \param team_l added left team data
      \param team_r added right team data
      \retval true if successfully added.
      \retval false mode is incorrect, or failed to add.
    */
    virtual
    bool addTeamInfo( const team_t & team_l,
                      const team_t & team_r ) = 0;

    /*!
      \brief (pure virtual) add player_type_t
      \param ptinfo added data
      \retval true if successfully added.
      \retval false mode is incorrect, or failed to add.
    */
    virtual
    bool addPlayerType( const player_type_t & ptinfo ) = 0;

    /*!
      \brief (pure virtual) add server_params_t
      \param sparams added data
      \retval true if successfully added.
      \retval false mode is incorrect, or failed to add.
    */
    virtual
    bool addServerParam( const server_params_t & sparams ) = 0;

    /*!
      \brief (pure virtual) add player_param_t
      \param pparams added data
      \retval true if successfully added.
      \retval false mode is incorrect, or failed to add.
    */
    virtual
    bool addPlayerParam( const player_params_t & pparams ) = 0;

};

} // end namespace
} // end namespace

#endif
