// -*-c++-*-

/*!
  \file team.cpp
  \brief team data class Source File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif

#include "team.h"

#include <rcsc/rcg/util.h>

/*-------------------------------------------------------------------*/
/*!

*/
Team::Team( const rcsc::rcg::team_t & team )
    : M_team_name( "" )
    , M_score( 0 )
{
    char buf[18];
    std::memset( buf, '\0', 18 );
    std::strncpy( buf, team.name, 16 );
    M_team_name = buf;

    M_score = static_cast< int >( ntohs( team.score ) );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
Team::assign( const rcsc::rcg::team_t & team )
{
    char buf[18];
    std::memset( buf, '\0', 18 );
    std::strncpy( buf, team.name, 16 );
    M_team_name = buf;

    M_score = static_cast< int >( ntohs( team.score ) );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
Team::convertTo( rcsc::rcg::team_t & team ) const
{
    std::memset( team.name, 0, sizeof( team.name ) );
    std::strncpy( team.name,
                  name().c_str(),
                  std::min( sizeof( team.name ), name().length() ) );
    team.score = rcsc::rcg::hitons( score() );
}
