// -*-c++-*-

/*!
  \file team.h
  \brief team data class Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef SOCCERWINDOW2_MODEL_TEAM_H
#define SOCCERWINDOW2_MODEL_TEAM_H

#include <rcsc/rcg/types.h>
#include <string>

//! team data class.
class Team {
private:
    std::string M_team_name;
    int M_score;
public:
    //! default constructor
    Team()
        : M_team_name( "" )
        , M_score( 0 )
      { }

    //! construct from log data
    Team( const rcsc::rcg::team_t & team );

    //! assign from log data
    void assign( const rcsc::rcg::team_t & team );

    //! assign directly
    void assign( const short score )
      {
          M_score = static_cast< int >( score );
      }

    //! convert data to the log format
    void convertTo( rcsc::rcg::team_t & team ) const;

    //! get team name const reference
    const
    std::string & name() const
      {
          return M_team_name;
      }

    //! get score
    int score() const
      {
          return M_score;
      }
};

#endif
