// -*-c++-*-

/*!
  \file view_holder.h
  \brief view data repository Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef SOCCERWINDOW2_QT_VIEW_HOLDER_H
#define SOCCERWINDOW2_QT_VIEW_HOLDER_H

#include "monitor_view_data.h"
#include "debug_view_data.h"

#include <rcsc/common/player_type.h>
#include <rcsc/rcg/holder.h>

#include <map>
#include <ostream>

//! drawing data repository
class ViewHolder
    : public rcsc::rcg::Holder {
private:

    //! last changed playmode
    rcsc::PlayMode M_last_playmode;
    //! last changed left team info
    rcsc::rcg::team_t M_last_team_left;
    //! last changed right team info
    rcsc::rcg::team_t M_last_team_right;

    //! the record of score change
    std::vector< std::size_t > M_score_change_indexes;

    //! the record of penalty score/miss, first: time, second: playmode
    std::vector< std::pair< long, rcsc::PlayMode > > M_penalty_scores_left;
    std::vector< std::pair< long, rcsc::PlayMode > > M_penalty_scores_right;

    //! player_type set
    std::vector< rcsc::PlayerType > M_player_types;

    //! last received view data
    MonitorViewPtr M_latest_view_data;

    //! view data container.
    std::vector< MonitorViewPtr > M_monitor_view_cont;

    //! debug view data set for left players (key:cycle)
    std::map< long, DebugViewCont > M_left_debug_view;

    //! debug view data set for right players (key:cycle)
    std::map< long, DebugViewCont > M_right_debug_view;


    //! nocopyable
    ViewHolder( const ViewHolder & );
    //! nocopyable
    ViewHolder & operator=( const ViewHolder & );

public:
    //! constructor.
    ViewHolder();

    ~ViewHolder();
    //--------------------------------------------------
    //! clear all stored data
    void clear();

    //! save a stored rcg data
    std::ostream & saveRCG( std::ostream & os ) const;

    //! save debug view data to directory
    void saveDebugView( const std::string & dir_path ) const;

    //! load debug view data from directory
    void loadDebugView( const std::string & dir_path );

    //--------------------------------------------------
    // override methods.

    //! register showinfo_t (rcg v2, monitor v1)
    bool addShowInfo( const rcsc::rcg::showinfo_t & show );
    //! register showinfo_t (monitor v2 only)
    bool addShowInfo2( const rcsc::rcg::showinfo_t2 & show2 );
    //! register showinfo_t (rcg v3 only)
    bool addShortShowInfo2( const rcsc::rcg::short_showinfo_t2 & show2 );

    void pushBackLatestViewData();

    //! register msginfo_t
    bool addMsgInfo( const rcsc::rcg::Int16 board,
                     const std::string & msg );

    //! register drawinfo_t
    bool addDrawInfo( const rcsc::rcg::drawinfo_t & draw );

    //! register playmode
    bool addPlayMode( const char pmode );
    //! register team_t * 2
    bool addTeamInfo( const rcsc::rcg::team_t & team_l,
                      const rcsc::rcg::team_t & team_r );

    //! register server_params_t
    bool addServerParam( const rcsc::rcg::server_params_t & sparams );
    //! register player_params_t
    bool addPlayerParam( const rcsc::rcg::player_params_t & pparams );
    //! register player_type_t
    bool addPlayerType( const rcsc::rcg::player_type_t & ptinfo );

    //--------------------------------------------------

    //! set debug view data
    void addDebugView( const long & cycle,
                       const char side,
                       const int unum,
                       DebugViewPtr debug_view );

    //--------------------------------------------------

    rcsc::PlayMode lastPlayMode() const
      {
          return M_last_playmode;
      }

    //! get const reference of data container.
    const
    std::vector< MonitorViewPtr > & monitorViewCont() const
      {
          return M_monitor_view_cont;
      }

    //! get debug view data container
    const
    std::map< long, DebugViewCont > & leftDebugView() const
      {
          return M_left_debug_view;
      }
    //! get debug view data container
    const
    std::map< long, DebugViewCont > & rightDebugView() const
      {
          return M_right_debug_view;
      }

    const
    std::vector< rcsc::PlayerType > & playerTypeCont() const
      {
          return M_player_types;
      }

    const
    rcsc::PlayerType & playerType( const std::size_t id ) const;

    const
    std::vector< std::size_t > & scoreChangeIndexes() const
      {
          return M_score_change_indexes;
      }

    const
    std::vector< std::pair< long, rcsc::PlayMode > > & penaltyScoresLeft() const
      {
          return M_penalty_scores_left;
      }

    const
    std::vector< std::pair< long, rcsc::PlayMode > > & penaltyScoresRight() const
      {
          return M_penalty_scores_right;
      }

    MonitorViewConstPtr getViewData( const std::size_t idx ) const;

    MonitorViewConstPtr latestViewData() const
      {
          return M_latest_view_data;
      }

    std::size_t getIndexOf( const int cycle ) const;

private:
    bool saveDebugView( const std::string & dir_path,
                        const std::string & team_name,
                        const int unum,
                        const std::map< long, DebugViewCont > & data ) const;

    bool loadDebugView( const std::string & dir_path,
                        const std::string & team_name,
                        const int unum );

    void addMonitorViewData( MonitorViewPtr ptr );
};

#endif
