// -*-c++-*-

/*!
	\file field_canvas.h
	\brief field canvas class Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.	If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef SOCCERWINDOW2_QT_FIELD_CANVAS_H
#define SOCCERWINDOW2_QT_FIELD_CANVAS_H

#include <QWidget>

#include "mouse_state.h"

#include <boost/shared_ptr.hpp>

#include <vector>

class QContextMenuEvent;
class QMenu;
class QMouseEvent;
class QPaintEvent;
class QPixmap;
class QPointF;

class MainData;
class PainterInterface;
class FieldPainter;

//! main soccer field canvas class
class FieldCanvas
		: public QWidget {

    Q_OBJECT

private:

    MainData & M_main_data;

    bool M_redraw_all;

    QMenu * M_normal_menu;
    QMenu * M_system_menu;
    QMenu * M_monitor_menu;


    //QPixmap * M_canvas_pixmap;

    //! 0: left, 1: middle, 2: right
    MouseState M_mouse_state[3];


    boost::shared_ptr< FieldPainter > M_field_painter;

    std::vector< boost::shared_ptr< PainterInterface > > M_painters;

    // not used
    FieldCanvas( const FieldCanvas & );
    const FieldCanvas & operator=( const FieldCanvas & );

public:

    explicit
    FieldCanvas( MainData & main_data );

    ~FieldCanvas();

    void setNormalMenu( QMenu * menu );
    void setSystemMenu( QMenu * menu );
    void setMonitorMenu( QMenu * menu );

    void draw( QPainter & painter );

private:

    void drawMouseMeasure( QPainter & painter );

protected:

    void mouseDoubleClickEvent( QMouseEvent * event );
    void mousePressEvent( QMouseEvent * event );
    void mouseReleaseEvent( QMouseEvent * event );
    void mouseMoveEvent( QMouseEvent * event );

    void paintEvent( QPaintEvent * );

public slots:

    void setRedrawAllFlag();

    void dropBall();
    void freeKickLeft();
    void freeKickRight();

signals:

    void dropBall( const QPoint & pos );
    void freeKickLeft( const QPoint & pos );
    void freeKickRight( const QPoint & pos );

    void focusChanged( const QPoint & point );
    void mouseMoved( const QPoint & point );

};

#endif
