// -*-c++-*-

/*!
  \file score_board_painter.cpp
  \brief score board painter class Source File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QtGui>

#include "score_board_painter.h"

#include "draw_config.h"
// model
#include "main_data.h"
#include "monitor_view_data.h"

#include <iostream>


/*-------------------------------------------------------------------*/
/*!

*/
ScoreBoardPainter::ScoreBoardPainter( const MainData & main_data )
    : M_main_data( main_data )
#if 1
    , M_last_width( -100 )
    , M_last_height( -100 )
    , M_last_left_name()
    , M_last_left_score( -100 )
    , M_last_right_name()
    , M_last_right_score( -100 )
    , M_last_playmode()
    , M_last_cycle( -100 )
#endif
{

}

/*-------------------------------------------------------------------*/
/*!

*/
void
ScoreBoardPainter::draw( QPainter & painter )
{
    const ViewConfig & vconf = M_main_data.viewConfig();

    if ( ! vconf.isShownScoreBoard() )
    {
        return;
    }

    MonitorViewConstPtr view = M_main_data.getViewData( M_main_data.viewIndex() );

    if ( ! view )
    {
        return;
    }

    const DrawConfig & dconf = DrawConfig::instance();

#if 0
    bool redraw = false;

    if ( M_last_width != vconf.canvasWidth()
         || M_last_height != vconf.scoreBoardHeight() )
    {
        int board_left_x = 0;
        int board_top_y = 0;
        // check score board width & start point x
        int board_width = vconf.canvasWidth();

        M_time_rect = QRect( board_width/3 - 1,
                             board_top_y,
                             board_width/3 + 2,
                             vconf.scoreBoardHeight() );
        M_left_rect = QRect( board_left_x,
                             board_top_y,
                             board_width/3,
                             vconf.scoreBoardHeight() );
        M_right_rect = QRect( board_left_x + board_width*2/3,
                              board_top_y,
                              board_width/3 + 1,
                              vconf.scoreBoardHeight() );

        M_time_pixmap
            = boost::shared_ptr< QPixmap >
            ( new QPixmap( board_width / 3 + 2,
                           vconf.scoreBoardHeight() ) );
        M_left_pixmap
            = boost::shared_ptr< QPixmap >
            ( new QPixmap( board_width / 3,
                           vconf.scoreBoardHeight() ) );
        M_right_pixmap
            = boost::shared_ptr< QPixmap >
            ( new QPixmap( board_width / 3 + 1,
                           vconf.scoreBoardHeight() ) );

        M_last_width = vconf.canvasWidth();
        M_last_height = vconf.scoreBoardHeight();
        redraw = true;
    }

    //------------------------------------------------
    // draw left team info

    if ( redraw
         || M_last_left_name != view->leftTeam().name()
         || M_last_left_score != view->leftTeam().score() )
    {
        M_left_pixmap->fill( dconf.leftTeamBrush().color() );

        QString temp_str;
        if ( view->leftTeam().name().empty() )
        {
            temp_str = QString::fromAscii( "left team" );
        }
        else
        {
            char buf[32];
            std::snprintf( buf, 32,
                           "%s  %d",
                           AppConfig::instance().anonymousMode()
                           ? "left team"
                           : view->leftTeam().name().c_str(),
                           view->leftTeam().score() );
            temp_str = QString::fromAscii( buf );
        }

        QPainter pm_painter( M_left_pixmap.get() );
        pm_painter.setFont( dconf.scoreBoardFont() );
        pm_painter.setPen( dconf.scoreBoardFontPen() );
        pm_painter.drawText( M_left_pixmap->rect(),
                             Qt::AlignCenter,
                             temp_str );

        M_last_left_name = view->leftTeam().name();
        M_last_left_score = view->leftTeam().score();
    }

    painter.drawPixmap( M_left_rect.topLeft(),
                        *M_left_pixmap );

    //------------------------------------------------
    // draw right team info
    if ( redraw
         || M_last_right_name != view->rightTeam().name()
         || M_last_right_score != view->rightTeam().score() )
    {
        M_right_pixmap->fill( dconf.rightTeamBrush().color() );

        QString temp_str;
        if ( view->rightTeam().name().empty() )
        {
            temp_str = QString::fromAscii( "right team" );
        }
        else
        {
            char buf[32];
            std::snprintf( buf, 32,
                           "%s  %d",
                           AppConfig::instance().anonymousMode()
                           ? "right team"
                           : view->rightTeam().name().c_str(),
                           view->rightTeam().score() );
            temp_str = QString::fromAscii( buf );
        }

        QPainter pm_painter( M_right_pixmap.get() );
        pm_painter.setFont( dconf.scoreBoardFont() );
        pm_painter.setPen( dconf.scoreBoardFontPen() );
        pm_painter.drawText( M_right_pixmap->rect(),
                             Qt::AlignCenter,
                             temp_str );

        M_last_right_name = view->rightTeam().name();
        M_last_right_score = view->rightTeam().score();
    }

    painter.drawPixmap( M_right_rect.topLeft(),
                        *M_right_pixmap );

    //------------------------------------------------
    // draw playmode & game cycle
    if ( redraw
         || M_last_cycle != view->cycle()
         || M_last_playmode != view->playmode().name() )
    {
        M_time_pixmap->fill( dconf.scoreBoardBrush().color() );

        char buf[32];
        std::snprintf( buf, 32,
                       "%s %4ld",
                       view->playmode().name().c_str(),
                       view->cycle() );

        QPainter pm_painter( M_time_pixmap.get() );
        pm_painter.setFont( dconf.scoreBoardFont() );
        pm_painter.setPen( dconf.scoreBoardFontPen() );
        pm_painter.drawText( M_time_pixmap->rect(),
                             Qt::AlignCenter,
                             QString::fromAscii( buf ) );

        M_last_playmode = view->playmode().name();
        M_last_cycle = view->cycle();
    }
    painter.drawPixmap( M_time_rect.topLeft(),
                        *M_time_pixmap );
#else
    int board_left_x = 0;
    int board_top_y = 0;
    int board_width = vconf.canvasWidth();

    painter.setFont( dconf.scoreBoardFont() );
    painter.setPen( dconf.scoreBoardFontPen() );

    //std::cerr << "font = " << painter.font().toString().toStdString()
    //          << std::endl;

    {
        QRect left_rect( board_left_x,
                         board_top_y,
                         board_width/3,
                         vconf.scoreBoardHeight() );

        painter.fillRect( left_rect, dconf.leftTeamBrush() );

        QString temp_str;
        if ( view->leftTeam().name().empty() )
        {
            temp_str = QString::fromAscii( "left team" );
        }
        else
        {
            char buf[32];
            std::snprintf( buf, 32,
                           "%s  %d",
                           view->leftTeam().name().c_str(),
                           view->leftTeam().score() );
            temp_str = QString::fromAscii( buf );
        }

        painter.drawText( left_rect,
                          Qt::AlignCenter,
                          temp_str );
    }
    {
        QRect right_rect( board_left_x + board_width*2/3 + 1,
                          board_top_y,
                          board_width/3,
                          vconf.scoreBoardHeight() );

        painter.fillRect( right_rect, dconf.rightTeamBrush() );

        QString temp_str;
        if ( view->rightTeam().name().empty() )
        {
            temp_str = QString::fromAscii( "right team" );
        }
        else
        {
            char buf[32];
            std::snprintf( buf, 32,
                           "%s  %d",
                           view->rightTeam().name().c_str(),
                           view->rightTeam().score() );
            temp_str = QString::fromAscii( buf );
        }

        painter.drawText( right_rect,
                          Qt::AlignCenter,
                          temp_str );
    }
    {
        QRect time_rect( board_width/3 - 1,
                         board_top_y,
                         board_width/3 + 2,
                         vconf.scoreBoardHeight() );

        painter.fillRect( time_rect, dconf.scoreBoardBrush() );

        char buf[32];
        std::snprintf( buf, 32,
                       "%s  %4ld",
                       view->playmode().name().c_str(),
                       view->cycle() );

        painter.drawText( time_rect,
                          Qt::AlignCenter,
                          QString::fromAscii( buf ) );
    }
#endif

}
