// -*-c++-*-

/*!
  \file logger.cpp
  \brief Logger class Source File
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "logger.h"
#include "player_agent.h"

#include <string>
#include <iostream>
#include <cstdarg>

namespace rcsc {

namespace  {

#define G_BUFFER_SIZE 2048

//! temporary buffer
char g_buffer[G_BUFFER_SIZE];

//! main buffer
std::string g_str;

}

//! global variable
Logger dlog;

/*-------------------------------------------------------------------*/
/*!

*/
Logger::Logger()
    : M_agent( static_cast< PlayerAgent * >( 0 ) )
    , M_fout( NULL )
    , M_flags( 0 )
{
    g_str.reserve( 8192 * 4 );
    std::strcpy( g_buffer, "" );
}

/*-------------------------------------------------------------------*/
/*!

*/
Logger::~Logger()
{
    if ( M_fout )
    {
        this->flush();
        fclose( M_fout );
        M_fout = NULL;
    }
}

/*-------------------------------------------------------------------*/
/*!
  destructor
*/
void
Logger::open( const char * file_path )
{
    M_fout = std::fopen( file_path, "w" );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
Logger::setLogFlag( const PlayerAgent * agent,
                    const boost::int32_t id,
                    const bool on )
{
    M_agent = agent;
    if ( on )
    {
        M_flags |= id;
    }
    else
    {
        M_flags &= ~id;
    }
}

/*-------------------------------------------------------------------*/
/*!

*/
void
Logger::print( const char * msg )
{
    if ( M_fout )
    {
        fputs( msg, M_fout );
    }
}

/*-------------------------------------------------------------------*/
/*!

*/
void
Logger::addText( const boost::int32_t id,
                 char * msg, ... )
{
    if ( M_fout && ( id & M_flags ) && M_agent )
    {
        va_list argp;
        va_start( argp, msg );
        vsnprintf( g_buffer, G_BUFFER_SIZE, msg, argp );
        va_end( argp );

        char header[32];
        std::snprintf( header, 32, "%ld %d T ",
                       M_agent->world().time().cycle(),
                       id );

        g_str += header;
        g_str += g_buffer;
        g_str += '\n';
        if ( g_str.length() > 8192 * 3 )
        {
            flush();
        }
    }
}

/*-------------------------------------------------------------------*/
/*!

*/
void
Logger::flush()
{
    if ( M_fout && g_str.length() > 0 )
    {
        fputs( g_str.c_str(), M_fout );
        //fwrite( g_str.c_str(), sizeof( char ), g_str.length(), M_fout );
        fflush( M_fout );
    }
    g_str.erase();
}

/*-------------------------------------------------------------------*/
/*!

*/
void
Logger::clear()
{
    g_str.erase();
}

}
