// -*-c++-*-

/*!
  \file serializer_v3.cpp
  \brief v3 format rcg serializer Source File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif

#include "serializer_v3.h"

namespace rcsc {
namespace rcg {

/*-------------------------------------------------------------------*/
/*!

*/
std::ostream &
SerializerV3::serializeHeader( std::ostream & os )
{
    return serializeImpl( os, REC_VERSION_3 );
}

/*-------------------------------------------------------------------*/
/*!

*/
std::ostream &
SerializerV3::serialize( std::ostream & os,
                         const server_params_t & param )
{
    return serializeImpl( os, param );
}

/*-------------------------------------------------------------------*/
/*!

*/
std::ostream &
SerializerV3::serialize( std::ostream & os,
                         const player_params_t & pparam )
{
    return serializeImpl( os, pparam );
}

/*-------------------------------------------------------------------*/
/*!

*/
std::ostream &
SerializerV3::serialize( std::ostream & os,
                         const player_type_t & type )
{
    return serializeImpl( os, type );
}

/*-------------------------------------------------------------------*/
/*!

*/
std::ostream &
SerializerV3::serialize( std::ostream & os,
                         const showinfo_t2 & show2 )
{
    return serializeImpl( os, show2 );
}

/*-------------------------------------------------------------------*/
/*!

*/
std::ostream &
SerializerV3::serialize( std::ostream & os,
                         const msginfo_t & msg )
{
    return serializeImpl( os, msg );
}

} // end of namespace
} // end of namespace
