// win_src\IndexSelectDialog.cpp : t@C
//

#include "stdafx.h"
#include "win_src\IndexSelectDialog.h"
#include "StepDebugManager.h"
#include "CommandList.h"
#include "SelectPlayerDialog.h"
#include <afxdlgs.h>

// CIndexSelectDialog _CAO

IMPLEMENT_DYNAMIC(CIndexSelectDialog, CDialog)

CIndexSelectDialog::CIndexSelectDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CIndexSelectDialog::IDD, pParent)
{

}

CIndexSelectDialog::~CIndexSelectDialog()
{
}

void CIndexSelectDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST_INDEX, m_listbox);
	DDX_Control(pDX, IDC_LIST_COMMAND, m_listCommand);
}


BEGIN_MESSAGE_MAP(CIndexSelectDialog, CDialog)
	ON_BN_CLICKED(IDC_BUTTON_LOAD, &CIndexSelectDialog::OnBnClickedButtonLoad)
	ON_LBN_DBLCLK(IDC_LIST_INDEX, &CIndexSelectDialog::OnLbnDblclkListIndex)
	ON_BN_CLICKED(IDC_BUTTON_OUTPUT_DECISION, &CIndexSelectDialog::OnBnClickedButtonOutputDecision)
	ON_BN_CLICKED(IDC_BUTTON_LOAD_RCL, &CIndexSelectDialog::OnBnClickedButtonLoadRcl)
END_MESSAGE_MAP()


// CIndexSelectDialog bZ[W nh

BOOL CIndexSelectDialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	std::map< int, STEPDEBUG_INDEX >  *pIndexLoopMap;
	CStepDebugManager::Instance()->GetIndexLoopMap( &pIndexLoopMap );

	
	std::map< int, STEPDEBUG_INDEX >::const_iterator	itr;
	for( itr = pIndexLoopMap->begin();
		 itr != pIndexLoopMap->end();
		 itr ++ )
	{
		CString str;
		str.Format( "Index: %04d - ( Loop: %04d, Position: %08x )", 
			itr->second._dwIndex,
			itr->second._dwLoop,
			itr->second._dwPosition );

		m_listbox.InsertString( itr->first, str );
	}

	return TRUE; 
}

void CIndexSelectDialog::OnBnClickedButtonLoad()
{
	CWaitCursor	wc;

	if( m_listbox.GetCurSel() >= 0 )
	{
		this->GetDlgItem(IDC_EDIT_DECISION)->SetWindowText("");
		const char* pData = CStepDebugManager::Instance()->Load_By_Index( m_listbox.GetCurSel() );
		if( pData == 0 )
		{
			::MessageBox( NULL, "Fail to load data", "error", MB_OK );
		}
		else
		{
			CStepDebugManager::Instance()->agent_action( pData );
			this->GetDlgItem(IDC_EDIT_DECISION)->SetWindowText( CStepDebugManager::Instance()->GetDecision() );


			// compare decision with command that server recieved
			this->GetDlgItem(IDC_EDIT_COMMAND)->SetWindowText( "" );
			this->GetDlgItem(IDC_STATIC_CHECK)->SetWindowText( "?" );
			if( CStepDebugManager::Instance()->_iCommandList_PlayerIndex > 0 )
			{
				std::map< int, std::string > *pMap = NULL;
				CCommandList::Instance().GetPlayer( CStepDebugManager::Instance()->_iCommandList_PlayerIndex, &pMap );

				DWORD dwLoop = CStepDebugManager::Instance()->GetIndexBlock( m_listbox.GetCurSel() )->_dwLoop;
				if( pMap->find( dwLoop ) != pMap->end() )
				{
					m_listCommand.SetCurSel(dwLoop);
					GetDlgItem(IDC_EDIT_COMMAND)->SetWindowText( (*pMap)[dwLoop].c_str() );

					if( (*pMap)[dwLoop].compare( CStepDebugManager::Instance()->GetDecision() ) == 0 )
					{
						GetDlgItem(IDC_STATIC_CHECK)->SetWindowText( "==" );
					}
					else
					{
						GetDlgItem(IDC_STATIC_CHECK)->SetWindowText( "!=" );
					}
				}
			}

		}
	}
	else
	{
		::MessageBox( NULL, "Please select one before clicking load", "error", MB_OK );
	}
}

void CIndexSelectDialog::OnLbnDblclkListIndex()
{
	OnBnClickedButtonLoad();
}

void CIndexSelectDialog::OnBnClickedButtonOutputDecision()
{
	CStepDebugManager::Instance()->OutputAllDecision();
}

void CIndexSelectDialog::OnBnClickedButtonLoadRcl()
{
	char szFilters[]=
	  "Rssserver Command Log (*.rcl)|*.rcl|All Files (*.*)|*.*||";

	CFileDialog fileDlg (TRUE, "rcl", "*.rcl",
	  OFN_FILEMUSTEXIST| OFN_HIDEREADONLY, szFilters, NULL);

	if( fileDlg.DoModal ()==IDOK )
	{
		if( CCommandList::Instance().Load( (LPCTSTR)fileDlg.GetPathName() ) )
		{
			CSelectPlayerDialog	dlg;
			std::map< int, int >	mapPlayer;	// index -> num

			// list existing player
			for( size_t i=0, j=0; i<22; i++ )
			{
				std::map< int, std::string > *pMap = NULL;
				if( !CCommandList::Instance().GetPlayer( i, &pMap ) )
					break;
				if ( pMap == NULL || pMap->size() == 0) 
					continue;

				CString strPlayer;
				if( i<11 )
				{
					strPlayer.Format( "%s %d", 
						CCommandList::Instance().m_strLeftTeamname.c_str(),
						i+1 );
				}
				else
				{
					strPlayer.Format( "%s %d", 
						CCommandList::Instance().m_strRightTeamname.c_str(),
						i+1-11 );
				}
				dlg._players.push_back( (LPCTSTR)strPlayer );
				mapPlayer[ j ] = i;
				j++;
			}

			// user selects one
			if( dlg.DoModal() == IDOK )
			{
				std::map< int, std::string > *pMap = NULL;
				CCommandList::Instance().GetPlayer( mapPlayer[dlg._iCurrentSelected], &pMap );
				CStepDebugManager::Instance()->_iCommandList_PlayerIndex = mapPlayer[dlg._iCurrentSelected];


				// show the command to list
				m_listCommand.ResetContent();
				std::map< int, std::string >::iterator	itr;
				for( itr = pMap->begin(); itr != pMap->end(); itr++ )
				{
					CString str;
					str.Format("Loop %d : %s", itr->first, itr->second.c_str());
					m_listCommand.AddString(str);
				}
			}
			else
			{
				CCommandList::Instance().Clear();
			}
		}
		else
		{
			AfxMessageBox("Fail to load file");
		}
	}
}
