// -*-c++-*-

/*!
  \file log_player_tool_bar.cpp
  \brief log player control tool bar class Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qt.h>

#include "log_player_tool_bar.h"
#include "log_player.h"
#include "main_data.h"

#include <iostream>

#include "xpm/logplayer_one_step_back.xpm"
#include "xpm/logplayer_one_step_forward.xpm"
#include "xpm/logplayer_play_or_stop.xpm"
//#include "xpm/logplayer_stop.xpm"
//#include "xpm/logplayer_play_back.xpm"
//#include "xpm/logplayer_play_forward.xpm"
#include "xpm/logplayer_go_prev_score.xpm"
#include "xpm/logplayer_go_next_score.xpm"
#include "xpm/logplayer_go_first.xpm"
#include "xpm/logplayer_go_last.xpm"
#include "xpm/logplayer_shift_down.xpm"
#include "xpm/logplayer_shift_up.xpm"

#if 0
class CycleEdit
    : public QLineEdit {

public:

    CycleEdit( QWidget * parent )
        : QLineEdit( tr( "0" ), parent )
      {
          /*
          //this->setStatusTip( tr( "You can select the cycle directly." ) );
          this->setMaximumSize( 28, 20 );
          this->setMinimumSize( 16, 16 );

          QSizePolicy policy( QSizePolicy::Maximum, QSizePolicy::Maximum );
          policy.setHorStretch( 1 );
          policy.setVerStretch( 1 );
          this->setSizePolicy( policy );

          QFont font = this->font();
          font.setPointSize( 6 );
          this->setFont( font );
          */
      }
    /*
      virtual
      QSize sizeHint() const
      {
      QSize size = QLineEdit::sizeHint();
      if ( size.width() > 32 )
      {
      size.setWidth( 32 );
      }
      if ( size.height() > 24 )
      {
      size.setHeight( 24 );
      }
      return size;
      }
    */
};
#endif


class CycleSlider
    : public QSlider {
private:

public:

    CycleSlider( Qt::Orientation orientation,
                 QWidget * parent = 0 )
        : QSlider( orientation, parent )
      { }

protected:
#if 0
    void mousePressEvent( QMouseEvent * event )
      {
          if ( event->button() == Qt::LeftButton )
          {
              double rate = 0;
              if ( this->orientation() == Qt::Horizontal )
              {
                  rate = static_cast< double >( event->pos().x() )
                      / static_cast< double >( this->width() );

              }
              else
              {
                  rate = static_cast< double >( event->pos().y() )
                      / static_cast< double >( this->height() );
              }

              int val = this->minValue()
                  + static_cast< int >( rint( ( this->maxValue() - this->minValue() )
                                              * rate ) );

              this->setValue( val );
          }

          QSlider::mousePressEvent( event );
    }

    void mouseReleaseEvent( QMouseEvent * event )
      {
          event->ignore();
      }
#endif
};


/*-------------------------------------------------------------------*/
/*!

 */
LogPlayerToolBar::LogPlayerToolBar( LogPlayer * log_player,
                                    const MainData & main_data,
                                    QMainWindow * parent )
    : QToolBar( tr( "LogPlayer" ), parent )
    , M_main_data( main_data )
{
    //this->setIconSize( QSize( 16, 16 ) ); // qt4

    //this->setAllowedAreas( Qt::TopToolBarArea
    //                       | Qt::BottomToolBarArea );
    //this->setMovable( false );

    //this->setMaximumSize( 640, 640 );

    this->setHorizontallyStretchable( true );
    this->setVerticallyStretchable( true );
    this->setMaximumWidth( 800 );

    createControls( log_player );

    connect( this, SIGNAL( cycleChanged( int ) ),
             log_player, SLOT( goToCycle( int ) ) );

    connect( this, SIGNAL( orientationChanged( Orientation ) ),
             this, SLOT( setOrientation( Orientation ) ) );
}

/*-------------------------------------------------------------------*/
/*!

 */
LogPlayerToolBar::~LogPlayerToolBar()
{
    //std::cerr << "delete LogPlayerToolBar" << std::endl;
}

/*-------------------------------------------------------------------*/
/*!

 */
void
LogPlayerToolBar::createControls( LogPlayer * log_player )
{
    // visible actions
    {
        QAction * act
            = new QAction( QIconSet( QPixmap( logplayer_go_first_xpm ) ),
                           tr( "Go first" ), QKeySequence(), log_player );
        act->setAccel( Qt::Key_Home );
        act->setStatusTip( tr( "Go to the first.(" )
                           + static_cast< QString >( act->accel() ) + tr( ")" ) );
        connect( act, SIGNAL( activated() ),
                 log_player, SLOT( goToFirst() ) );
        act->addTo( this ); //this->addAction( act );
    }
    {
        QAction * act
            = new QAction( QIconSet( QPixmap( logplayer_go_prev_score_xpm ) ),
                           tr( "Go prev score" ), QKeySequence(), log_player );
        act->setAccel( Qt::CTRL + Qt::Key_G );
        act->setStatusTip( tr( "Go to the previous goal scene.(" )
                           + static_cast< QString >( act->accel() ) + tr( ")" ) );
        connect( act, SIGNAL( activated() ),
                 log_player, SLOT( goToPrevScore() ) );
        act->addTo( this ); //this->addAction( act );
    }
    {
        QAction * act
            = new QAction( QIconSet( QPixmap( logplayer_one_step_back_xpm ) ),
                           tr( "Step Back" ), QKeySequence(), log_player );
        act->setAccel( Qt::Key_Left );
        act->setStatusTip( tr( "One step back the log player. (" )
                           + static_cast< QString >( act->accel() )
                           + tr ( ")" ) );
        connect( act, SIGNAL( activated() ),
                 log_player, SLOT( stepBack() ) );
        act->addTo( this ); //this->addAction( act );
    }
    {
        QAction * act
            = new QAction( QIconSet( QPixmap( logplayer_play_or_stop_xpm ) ),
                           tr( "Play/Stop." ), QKeySequence(), log_player );
        act->setAccel( Qt::Key_Space );
        act->setStatusTip( tr( "Play or Stop the log player.(" )
                           + static_cast< QString >( act->accel() )
                           + tr( ")" ) );
        connect( act, SIGNAL( activated() ),
                 log_player, SLOT( playOrStop() ) );
        act->addTo( this ); //this->addAction( act );
    }
    {
        QAction * act
            = new QAction( QIconSet( QPixmap( logplayer_one_step_forward_xpm ) ),
                           tr( "Step Forward" ), QKeySequence(), log_player );
        act->setAccel( Qt::Key_Right );
        act->setStatusTip( tr( "One step forward the log player.(" )
                           + static_cast< QString >( act->accel() )
                           + tr( ")" ) );
        connect( act, SIGNAL( activated() ),
                 log_player, SLOT( stepForward() ) );
        act->addTo( this ); //this->addAction( act );
    }
    {
        QAction * act
            = new QAction( QIconSet( QPixmap( logplayer_go_next_score_xpm ) ),
                           tr( "Go next score" ), QKeySequence(), log_player );
        act->setAccel( Qt::Key_G );
        act->setStatusTip( tr( "Go to the next goal scene.(" )
                           + static_cast< QString >( act->accel() )
                           + tr( ")" ) );
        connect( act, SIGNAL( activated() ),
                 log_player, SLOT( goToNextScore() ) );
        act->addTo( this ); //this->addAction( act );
    }
    {
        QAction * act
            = new QAction( QIconSet( QPixmap( logplayer_go_last_xpm ) ),
                           tr( "Go last" ), QKeySequence(), log_player );
        act->setAccel( Qt::Key_End );
        act->setStatusTip( tr( "Go to the last.(" )
                           + static_cast< QString >( act->accel() )
                           + tr( ")" ) );
        connect( act, SIGNAL( activated() ),
                 log_player, SLOT( goToLast() ) );
        act->addTo( this ); //this->addAction( act );
    }
    {
        QAction * act
            = new QAction( QIconSet( QPixmap( logplayer_shift_down_xpm ) ),
                           tr( "Decelerate" ), QKeySequence(), log_player );
        act->setAccel( Qt::CTRL + Qt::Key_Left );
        act->setStatusTip( tr( "Decelerate the log player.(" )
                           + static_cast< QString >( act->accel() )
                           + tr( ")" ) );
        connect( act, SIGNAL( activated() ),
                 log_player, SLOT( decelerate() ) );
        act->addTo( this ); //this->addAction( act );
    }
    {
        QAction * act
            = new QAction( QIconSet( QPixmap( logplayer_shift_up_xpm ) ),
                           tr( "Accelerate" ), QKeySequence(), log_player );
        act->setAccel( Qt::CTRL + Qt::Key_Right );
        act->setStatusTip( tr( "Accelerate the log player.(" )
                           + static_cast< QString >( act->accel() )
                           + tr( ")" ) );
        connect( act, SIGNAL( activated() ),
                 log_player, SLOT( accelerate() ) );
        act->addTo( this ); //this->addAction( act );
    }

    // invisible actions
    //QAccel * accel = new QAccel( this );
    QAccel * accel = new QAccel( this->parentWidget() );
    {
        int id = accel->insertItem( Qt::Key_Down );
        accel->connectItem( id, log_player, SLOT( stop() ) );

//         QAction * act
//             = new QAction( QIconSet( QPixmap( logplayer_stop_xpm ) ),
//                            tr( "Stop" ), QKeySequence(), log_player );
//         act->setStatusTip( tr( "Stop the log player. (" )
//                            + static_cast< QString >( accel->key( id ) )
//                            + tr( ")" ) );
//         act->addTo( this ); //this->addAction( act );
//         act->setVisible( false );
    }
    {
        int id = accel->insertItem( Qt::CTRL + Qt::Key_Down );
        accel->connectItem( id, log_player, SLOT( playBack() ) );

//         QAction * act
//             = new QAction( QIconSet( QPixmap( logplayer_play_back_xpm ) ),
//                            tr( "Play Backward" ), QKeySequence(), log_player );
//         act->setStatusTip( tr( "Play backward the log player.(" )
//                            + static_cast< QString >( accel->key( id ) )
//                            + tr( ")" ) );
//         act->addTo( this ); //this->addAction( act );
//         act->setVisible( false );

    }
    {
        int id = accel->insertItem( Qt::Key_Up );
        accel->connectItem( id, log_player, SLOT( playForward() ) );

//         QAction * act
//             = new QAction( QIconSet( QPixmap( logplayer_play_forward_xpm ) ),
//                            tr( "Play Forward" ), QKeySequence(), log_player );
//         act->setStatusTip( tr( "Play forward the log player.(" )
//                            + static_cast< QString >( accel->key( id ) )
//                            + tr( ")" ) );
//         act->addTo( this ); //this->addAction( act );
//         act->setVisible( false );
    }

    // visible widgets

    M_cycle_slider = new CycleSlider( this->orientation(), this );
    M_cycle_slider->setOrientation( this->orientation() );
    M_cycle_slider->setMinimumWidth( 16 );
    M_cycle_slider->setMaximumWidth( 640 );
    M_cycle_slider->setMaximumHeight( 640 );
    M_cycle_slider->setRange( 0, 0 );
    M_cycle_slider->setValue( 0 );
    M_cycle_slider->setTickInterval( 1 );
    M_cycle_slider->setEnabled( false );
    //     connect( M_cycle_slider, SIGNAL( sliderMoved( int ) ),
    //              log_player, SLOT( goToIndex( int ) ) );
    connect( M_cycle_slider, SIGNAL( valueChanged( int ) ),
             log_player, SLOT( goToIndex( int ) ) );
    QToolTip::add( M_cycle_slider, tr( "Cycle Slider" ) );

    M_cycle_edit = new QLineEdit( tr( "0" ), this );
    M_cycle_edit->setFocusPolicy( QWidget::ClickFocus );
    M_cycle_edit->setMaximumSize( 28, 20 );
    M_cycle_edit->setMinimumSize( 16, 16 );
    {
        QFont font = this->font();
        font.setPointSize( 6 );
        M_cycle_edit->setFont( font );
    }
    connect( M_cycle_edit, SIGNAL( returnPressed() ),
             this, SLOT( editCycle() ) );
    QToolTip::add( M_cycle_edit, tr( "Cycle Input" ) );

    // invisible action
//     {
//         accel->connectItem( accel->insertItem( Qt::CTRL + Qt::Key_F ),
//                             M_cycle_edit, SLOT( setFocus() ) );
//
//         QAction * act
//             = new QAction( tr( "Focus Cycle Edit" ), QKeySequence(), log_player );
//         act->addTo( this );
//         act->setVisible( false );
//     }
}

/*-------------------------------------------------------------------*/
/*!

 */
void
LogPlayerToolBar::editCycle()
{
    bool ok = true;
    int cycle = M_cycle_edit->text().toInt( &ok );

    if ( ok
         && cycle >= 0 )
    {
        emit cycleChanged( cycle );
    }
}

/*-------------------------------------------------------------------*/
/*!

 */
void
LogPlayerToolBar::setOrientation( Orientation orientation )
{
    M_cycle_slider->setOrientation( orientation );

    QToolBar::setOrientation( orientation );
}

/*-------------------------------------------------------------------*/
/*!

 */
void
LogPlayerToolBar::updateSlider()
{
    if ( ! this->isVisible() )
    {
        return;
    }

    //std::cerr << "LogPlaeyrToolBar::update()" << std::endl;

    int size = M_main_data.viewHolder().monitorViewCont().size();

    if ( size <= 1 )
    {
        size = 0;
        M_cycle_slider->setEnabled( false );
    }
    else
    {
        M_cycle_slider->setEnabled( true );
    }

    if ( M_cycle_slider->maxValue() != size )
    {
        M_cycle_slider->setRange( 0, size );
    }

    int val = M_main_data.viewIndex();

    if ( M_cycle_slider->value() != val )
    {
        M_cycle_slider->setValue( val );
    }
}
