// -*-c++-*-

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "bhv_basic_move.h"
#include "bhv_opuci_center_back_move.h"
#include "bhv_basic_tackle.h"
#include "strategy.h"

#include <rcsc/action/basic_actions.h>
#include <rcsc/action/body_go_to_point.h>
#include <rcsc/action/body_intercept.h>
#include <rcsc/action/neck_turn_to_ball_or_scan.h>
#include <rcsc/action/neck_turn_to_low_conf_teammate.h>

#include <rcsc/player/player_agent.h>
#include <rcsc/player/debug_client.h>
#include <rcsc/player/intercept_table.h>

#include <rcsc/common/logger.h>
#include <rcsc/common/server_param.h>

/*-------------------------------------------------------------------*/
/*!
  execute action
*/
bool
Bhv_opuciCenterBackMove::execute( rcsc::PlayerAgent * agent )
{
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: Bhv_opuciDefensiveMove"
                        ,__FILE__, __LINE__ );

    // tackle
    const rcsc::WorldModel & wm = agent->world();
    if ( Bhv_BasicTackle( 0.9, 80.0 ).execute( agent ) )
    {
        return true;
    }
    else if( wm.ball().pos().x < -35.0 && wm.ball().distFromSelf() < 3.0 )
    {
        if( Bhv_BasicTackle( 0.80, 80.0 ).execute( agent ) )
        {
            return true;
        }
    }
    else if( wm.ball().pos().x < -32.0 
             && ! wm.existKickableTeammate() 
             && std::abs( wm.ball().pos().y - wm.self().pos().y ) < 2.0 
             && wm.ball().distFromSelf() < 6.0 )
    {
        if( Bhv_BasicTackle( 0.80, 80.0 ).execute( agent ) )
        {
            return true;
        }
    }

    // check ball owner

    int self_min = wm.interceptTable()->selfReachCycle();
    int mate_min = wm.interceptTable()->teammateReachCycle();
    int opp_min = wm.interceptTable()->opponentReachCycle();
    int ball_reach_step = 0;
    if( !wm.existKickableTeammate()
        && !wm.existKickableOpponent() )
    {
        ball_reach_step = std::min( wm.interceptTable()->teammateReachCycle(),
                                    wm.interceptTable()->opponentReachCycle() );
    }
    const rcsc::Vector2D base_pos = wm.ball().inertiaPoint( ball_reach_step );

    if ( ! wm.existKickableTeammate()
         && ( self_min <= 3
              || ( self_min < mate_min + 3 && self_min < opp_min + 3 )
              || ( wm.ball().pos().x < -34.0 && wm.ball().pos().absY() < 7.0 && self_min < mate_min + 3 )
         )
	 && base_pos.absY() < 20.0
       )
      /*bhv_basic_move
          if ( ! wm.existKickableTeammate()
         && ( self_min <= 3
              || ( self_min < mate_min + 3
                   && self_min < opp_min + 4 )
              )
         ) */
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: intercept"
                            ,__FILE__, __LINE__ );
        rcsc::Body_Intercept2008().execute( agent );
        if ( wm.ball().distFromSelf()
             < rcsc::ServerParam::i().visibleDistance() )
        {
            agent->setNeckAction( new rcsc::Neck_TurnToLowConfTeammate() );;
        }
        else
        {
            agent->setNeckAction( new rcsc::Neck_TurnToBallOrScan() );
        }
        return true;
    }

    // go to home position
    rcsc::Vector2D mark_home_pos;
    const rcsc::PlayerPtrCont & mates = wm.teammatesFromSelf();
    const rcsc::PlayerPtrCont & opps = wm.opponentsFromSelf();
    rcsc::Vector2D nearest_opp_pos( 0.0, 0.0 );
    bool is_self_nearest_ball = true;
    bool is_self_nearest_opp = true;
    bool is_self_nearest_dribble = true;
    const rcsc::PlayerPtrCont::const_iterator mates_end = mates.end();
    const rcsc::PlayerPtrCont::const_iterator opps_end = opps.end();
    for( rcsc::PlayerPtrCont::const_iterator it = opps.begin();
         it != opps_end;
         ++it )
    {
        if( M_home_pos.dist( (*it)->pos() ) < M_home_pos.dist( nearest_opp_pos ) )
        {
            nearest_opp_pos = (*it)->pos();
        }
    }
    for( rcsc::PlayerPtrCont::const_iterator it = mates.begin();
         it != mates_end;
         ++it )
    {
        if( (*it)->pos().x < wm.ball().pos().x
            && abs( (*it)->pos().y - base_pos.y ) + 3.0 < abs( wm.self().pos().y - base_pos.y ) )
        {
            is_self_nearest_dribble = false;
        }
        if( (*it)->pos().dist( base_pos ) < wm.self().pos().dist( base_pos )
            && (*it)->unum() != 1 )
        {
            is_self_nearest_ball = false;
        }
        if( (*it)->pos().dist( nearest_opp_pos ) + 1.0 < M_home_pos.dist( nearest_opp_pos ) )
        {
            is_self_nearest_opp = false;
        }
    }

    const rcsc::Line2D shoot_line( wm.ball().pos(), base_pos );

    if( base_pos.x < -rcsc::ServerParam::i().pitchHalfLength()
        && shoot_line.intersection( rcsc::Line2D( rcsc::Vector2D( -52.0, -10.0 ), rcsc::Vector2D( -52.0, 10.0 ) ) ).absY() < 9.0 )
    {
        mark_home_pos = shoot_line.projection( wm.self().pos() );
        agent->debugClient().addMessage("InterceptDash");
    }
    else if( base_pos.x < -rcsc::ServerParam::i().pitchHalfLength() + rcsc::ServerParam::i().penaltyAreaLength()
  	     && wm.self().pos().x < -30.0 )
    {
      if( wm.ball().pos().dist( wm.self().pos() ) < wm.self().playerType().realSpeedMax() + wm.self().playerType().kickableArea() )
	{
	  mark_home_pos = wm.ball().pos();
	  agent->debugClient().addMessage("Intercept");
	}
      else if( is_self_nearest_ball
	       && base_pos.absY() < rcsc::ServerParam::i().penaltyAreaHalfWidth() )
	{
	  mark_home_pos.x = base_pos.x * 0.9 + rcsc::ServerParam::i().ourTeamGoalPos().x * 0.1;
	  mark_home_pos.y = base_pos.y * 0.9 + rcsc::ServerParam::i().goalHalfWidth() * ( M_home_pos.y / M_home_pos.absY() ) * 0.1;
	  agent->debugClient().addMessage("SelfNearestBall");
	}
      else if( is_self_nearest_opp
	       || nearest_opp_pos.dist( base_pos ) < 5.0 )
	{
	  mark_home_pos = nearest_opp_pos * 0.9 + rcsc::ServerParam::i().ourTeamGoalPos() * 0.1;
	  agent->debugClient().addMessage("MarkNearestOpponent(1)");
	}
      else if( base_pos.absY() < rcsc::ServerParam::i().goalAreaHalfWidth() )
	{
	  mark_home_pos = nearest_opp_pos * 0.7 + rcsc::ServerParam::i().ourTeamGoalPos() * 0.3;
	  agent->debugClient().addMessage("CutShootLine");
	}
      /*
	else if( base_pos.absY() < rcsc::ServerParam::i().goalAreaHalfWidth() )
	{
	mark_home_pos = base_pos * 0.5 + nearest_opp_pos * 0.5;
	//mark_home_pos = ( base_pos * 0.2 + nearest_opp_pos * 0.8 ) * 0.5 + M_home_pos * 0.5;
	agent->debugClient().addMessage("CutPassLine(2)");
	agent->debugClient().addLine( base_pos, nearest_opp_pos );
	}
      */
      /*
	else if( nearest_opp_pos.dist( M_home_pos ) < 10.0 )
	{
	mark_home_pos = nearest_opp_pos * 0.5 + M_home_pos * 0.5;
	agent->debugClient().addMessage("Mark_nearest_opp(2)");
	}
      */
      else
	{
	  mark_home_pos = M_home_pos;
	}
    }
    else if( base_pos.x < wm.self().pos().x
	     && opp_min <= self_min
	     && opp_min <= mate_min )
    {
        mark_home_pos.x = base_pos.x - 3.0;
        mark_home_pos.y = wm.self().pos().y;
        if( is_self_nearest_ball
            && base_pos.absY() < wm.self().pos().absY() )
        {
            mark_home_pos.y = base_pos.y;
        }
        agent->debugClient().addMessage("DefendThroughPass");
    }
    else if( opp_min <= self_min
             && opp_min <= mate_min
             && base_pos.x - wm.self().pos().x < 20.0
             && base_pos.absY() < M_home_pos.absY() + 5.0
             && is_self_nearest_dribble )
    {
        mark_home_pos.x = wm.self().pos().x;
        mark_home_pos.y = base_pos.y;
        if( base_pos.x - 1.0 < wm.self().pos().x )
        {
            mark_home_pos.x = base_pos.x - 3.0;
        }
        else if( wm.self().pos().x < M_home_pos.x
                 && abs( base_pos.y - wm.self().pos().y ) < 3.0 )
        {
            mark_home_pos.x = M_home_pos.x;
        }
        agent->debugClient().addMessage("DefendDribble");
    }
    else if( is_self_nearest_opp )
    {
        if( nearest_opp_pos.x < M_home_pos.x )
        {
            mark_home_pos = M_home_pos * 0.3 + nearest_opp_pos * 0.7;
            agent->debugClient().addMessage("CloseNearestOpponet(1)");
        }
        else
        {
            mark_home_pos.x = M_home_pos.x;
            mark_home_pos.y = M_home_pos.y * 0.5 + nearest_opp_pos.y * 0.5;
            agent->debugClient().addMessage("CloseNearestOppnent(2)");
        }
    }
    else if( nearest_opp_pos.dist( M_home_pos ) < 15.0 )
      {
	mark_home_pos = nearest_opp_pos * 0.3 + M_home_pos * 0.7;
	agent->debugClient().addMessage("CloseNearestOpponent(3)");
      }
    else if( wm.ball().vel().x < -0.5 && wm.ball().pos().x < -10.0 && wm.ball().pos().x > -38.0 )
    {
		mark_home_pos.y = M_home_pos.y;
		mark_home_pos.x = M_home_pos.x - 1.0;
    }
    else if( wm.ball().pos().x < -30.0 && wm.ball().distFromSelf() < 5.0 )
    {
		mark_home_pos.y = M_home_pos.y * 0.1 + wm.ball().pos().y * 0.9;
		mark_home_pos.x = M_home_pos.x * 0.1 + wm.ball().pos().x * 0.9;
    }
    else if( wm.ball().pos().x < -30.0 )
    {
		mark_home_pos.y = M_home_pos.y;
		mark_home_pos.x = M_home_pos.x * 0.4 + wm.ball().pos().x * 0.6;
    }
    else if( ! wm.ball().posValid() )
    {
        for( rcsc::PlayerPtrCont::const_iterator it = opps.begin();
             it != opps_end;
             ++it )
        {
            if( M_home_pos.dist( (*it)->pos() ) < M_home_pos.dist( nearest_opp_pos ) )
            {
                nearest_opp_pos = (*it)->pos();
            }
        }
        mark_home_pos = nearest_opp_pos;
    }
    else
    {
        mark_home_pos = M_home_pos;
    }
/*
    if( base_pos.x > 35.0
        && is_self_nearest_opp
        && nearest_opp_pos.x < wm.self().pos().x )
    {
        mark_home_pos.x = nearest_opp_pos.x - 3.0;
    }
*/
    const double dash_power = getDashPower( agent, mark_home_pos );

    double dist_thr = wm.ball().distFromSelf() * 0.1;
    if ( dist_thr < 1.0 ) dist_thr = 1.0;

    agent->debugClient().addMessage( " BasicMove%.0f", dash_power );
    agent->debugClient().setTarget( mark_home_pos );

    if ( ! rcsc::Body_GoToPoint( mark_home_pos, dist_thr, dash_power, 1
                                 ).execute( agent ) )
    {
        rcsc::Body_TurnToBall().execute( agent );
    }

    if ( wm.existKickableOpponent()
         && wm.ball().distFromSelf() < 18.0 )
    {
        agent->setNeckAction( new rcsc::Neck_TurnToBall() );
    }
    else if( wm.ball().posCount() >= 1 )
    {
        agent->setNeckAction( new rcsc::Neck_TurnToBall() );
    }
    else if( wm.self().pos().x < -35.0
             && wm.self().pos().absY() < 20.0
             && wm.existKickableOpponent() )
    {
        agent->setNeckAction( new rcsc::Neck_TurnToBall() );
    }
    else
    {
        agent->setNeckAction( new rcsc::Neck_TurnToBallOrScan() );
    }

    return true;
}

/*-------------------------------------------------------------------*/
/*!

*/
double
Bhv_opuciCenterBackMove::getDashPower( const rcsc::PlayerAgent * agent,
                             const rcsc::Vector2D & target_point )
{
    static bool s_recover_mode = false;

    const rcsc::WorldModel & wm = agent->world();
    /*--------------------------------------------------------*/
    // check recover
    if (( wm.ball().pos().x < 5.0 && wm.existKickableOpponent() )
	|| wm.ball().pos().x < wm.self().pos().x + 5.0 )
    {
        s_recover_mode = false;
    }
    else if ( wm.self().stamina() < rcsc::ServerParam::i().staminaMax() * 0.5 )
    {
        s_recover_mode = true;
    }
    else if ( wm.self().stamina() > rcsc::ServerParam::i().staminaMax() * 0.7 )
    {
        s_recover_mode = false;
    }

    /*--------------------------------------------------------*/
    double dash_power = rcsc::ServerParam::i().maxDashPower();
    const double my_inc
        = wm.self().playerType().staminaIncMax()
        * wm.self().recovery();

    int self_min = wm.interceptTable()->selfReachCycle();
    int mate_min = wm.interceptTable()->teammateReachCycle();
    int opp_min = wm.interceptTable()->opponentReachCycle();

    if (
	(( wm.ball().pos().x < wm.defenseLineX() + 8.0 )
	 || ( wm.ball().pos().x < wm.self().pos().x + 5.0  )  )
	&& ! wm.existKickableTeammate()
	)
      /*bhv_basic_move
      if ( wm.defenseLineX() > wm.self().pos().x
         && wm.ball().pos().x < wm.defenseLineX() + 20.0 )*/
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            __FILE__": correct DF line. keep max power" );
        // keep max power
        dash_power = rcsc::ServerParam::i().maxDashPower();
    }
    else if( opp_min <= mate_min
             && opp_min <= self_min )
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            __FILE__": exist kickable opponent dash" );
        dash_power = rcsc::ServerParam::i().maxDashPower();
    }
    else if ( ! wm.existKickableTeammate()
              && opp_min < self_min
              && opp_min < mate_min
              && target_point.x < wm.self().pos().x
              && target_point.x < -25.0
              && wm.ball().inertiaPoint( opp_min ).x < -25.0 )
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            __FILE__": defense dash" );
        dash_power = rcsc::ServerParam::i().maxDashPower();
    }
    else if (( ( wm.ball().pos().x < wm.defenseLineX() + 20.0 )
	       || ( wm.ball().pos().x < wm.self().pos().x - 15.0 ) )
	       && ! wm.existKickableTeammate())
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: correct DF line. keep max power"
                            ,__FILE__, __LINE__ );
        // keep max power
        dash_power = rcsc::ServerParam::i().maxPower() * 0.9;
    }
    else if ( ( wm.existKickableOpponent()
                || ( opp_min < self_min
                     && opp_min < mate_min  ) )
              && wm.ball().pos().x < 0.0 )
    {
        dash_power = rcsc::ServerParam::i().maxPower();
    }
    else if ( s_recover_mode )
    {
        dash_power = my_inc - 25.0; // preffered recover value
        if ( dash_power < 0.0 ) dash_power = 0.0;

        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            __FILE__": recovering" );
    }
    // exist kickable teammate
    else if ( wm.existKickableTeammate()
              && wm.ball().distFromSelf() > 15.0 )
    {
        dash_power = std::min( my_inc - 20.0,
                               rcsc::ServerParam::i().maxPower() * 0.5 );
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: exist kickable teammate. dash_power= %f"
                            ,__FILE__, __LINE__,
                            dash_power );
    }
    /*bhv_basic_move
    // exist kickable teammate
    else if ( wm.existKickableTeammate()
              && wm.ball().distFromSelf() < 20.0 )
    {
        dash_power = std::min( my_inc * 1.1,
                               rcsc::ServerParam::i().maxDashPower() );
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            __FILE__": exist kickable teammate. dash_power=%.1f",
                            dash_power );
    }*/
    // in offside area
    else if ( wm.self().pos().x > wm.offsideLineX() )
    {
        dash_power = rcsc::ServerParam::i().maxDashPower();
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            __FILE__": in offside area. dash_power=%.1f",
                            dash_power );
    }
    //nomal
    else
    {
        dash_power = std::min( my_inc * 1.3,
                               rcsc::ServerParam::i().maxPower() * 0.75 );
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: normal mode dash_power= %f"
                            ,__FILE__, __LINE__,
                            dash_power );
    }
    /*bhv_basic_move
    // normal
    else
    {
      dash_power = std::min( my_inc * 1.3,
			     rcsc::ServerParam::i().maxDashPower() * 0.75 );
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            __FILE__": normal mode dash_power=%.1f",
                            dash_power );
			    }*/

    return dash_power;
}
