// -*-c++-*-

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "bhv_basic_move.h"
#include "bhv_opuci_defensivehalf_move.h"

#include "bhv_basic_tackle.h"

#include <rcsc/action/basic_actions.h>
#include <rcsc/action/body_go_to_point.h>
#include <rcsc/action/body_intercept.h>
#include <rcsc/action/neck_turn_to_ball_or_scan.h>
#include <rcsc/action/neck_turn_to_low_conf_teammate.h>
#include <rcsc/action/neck_turn_to_point.h>

#include <rcsc/player/player_agent.h>
#include <rcsc/player/debug_client.h>
#include <rcsc/player/intercept_table.h>

#include <rcsc/common/logger.h>
#include <rcsc/common/server_param.h>

/*-------------------------------------------------------------------*/
/*!
  execute action
*/
bool
Bhv_opuciDefensiveHalfMove::execute( rcsc::PlayerAgent * agent )
{
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: Bhv_opuciDefensiveHalfMove"
                        ,__FILE__, __LINE__ );

    // tackle
    const rcsc::WorldModel & wm = agent->world();

    if ( Bhv_BasicTackle( 0.9, 80.0 ).execute( agent ) )
    {
        return true;
    }
    else if( wm.ball().pos().x < -38.0 && wm.ball().distFromSelf() < 4.0 )
    {
	if( Bhv_BasicTackle( 0.75, 80.0 ).execute( agent ) )
	{
		return true;
	}
    }

    // check ball owner

    int self_min = wm.interceptTable()->selfReachCycle();
    int mate_min = wm.interceptTable()->teammateReachCycle();
    int opp_min = wm.interceptTable()->opponentReachCycle();

    if ( ! wm.existKickableTeammate()
         && ( self_min <= 3
	      //              || ( self_min < mate_min + 3
              || ( self_min < mate_min + 3
                   && self_min < opp_min + 4 )
              )
         )
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: intercept"
                            ,__FILE__, __LINE__ );
        rcsc::Body_Intercept2008().execute( agent );
        if ( wm.ball().distFromSelf()
             < rcsc::ServerParam::i().visibleDistance() )
        {
            agent->setNeckAction( new rcsc::Neck_TurnToLowConfTeammate() );;
        }
        else
        {
            agent->setNeckAction( new rcsc::Neck_TurnToBallOrScan() );
        }
        return true;
    }

    // go to home position
/*
    double dist = 100.0;
    rcsc::Vector2D righttarget_pos( -44.0 , 10.0 );
    rcsc::Vector2D lefttarget_pos( -44.0 , -10.0 );
//    const rcsc::PlayerObject * target_opp = wm.getOpponentNearestToBall(1);
    const rcsc::PlayerObject * target_opp_right = wm.getOpponentNearestTo( righttarget_pos ,
								     1,
								     &dist
								   );
    const rcsc::PlayerObject * target_opp_left = wm.getOpponentNearestTo( lefttarget_pos ,
								     1,
								     &dist
								   );
*/

    rcsc::Vector2D mark_home_pos;
    int ball_reach_step = 0;
    if( !wm.existKickableTeammate()
        && !wm.existKickableOpponent() )
    {
        ball_reach_step = std::min( wm.interceptTable()->teammateReachCycle(),
                                    wm.interceptTable()->opponentReachCycle() );
    }
    const rcsc::Vector2D base_pos = wm.ball().inertiaPoint( ball_reach_step );
    const rcsc::PlayerPtrCont & opps = wm.opponentsFromSelf();
    const rcsc::PlayerPtrCont::const_iterator opps_end = opps.end();
    const double ball_decay = rcsc::ServerParam::i().ballDecay();
    const double ball_speed = rcsc::ServerParam::i().ballSpeedMax();
    if( base_pos.x < -35.0 )
    {
        rcsc::Vector2D nearest_opp_pos( 40.0, 7.0 );
        rcsc::Vector2D second_opp_pos( 40.0, 7.0 );
        for( rcsc::PlayerPtrCont::const_iterator it = opps.begin();
             it != opps_end;
             ++it )
        {
            if( M_home_pos.dist( (*it)->pos() ) < M_home_pos.dist( nearest_opp_pos ) )
            {
                nearest_opp_pos = (*it)->pos();
            }
        }
        for( rcsc::PlayerPtrCont::const_iterator it = opps.begin();
             it != opps_end;
             ++it )
        {
            if( M_home_pos.dist( (*it)->pos() ) < M_home_pos.dist( second_opp_pos )
                && M_home_pos.dist( (*it)->pos() ) > M_home_pos.dist( nearest_opp_pos ) )
            {
                second_opp_pos = (*it)->pos();
            }
        }
	if( base_pos.dist( nearest_opp_pos ) < base_pos.dist( second_opp_pos ) )
	  {
	    mark_home_pos = second_opp_pos * 0.9 + rcsc::ServerParam::i().ourTeamGoalPos() * 0.1;
	  }
	else
	  {
	    mark_home_pos = nearest_opp_pos * 0.9 + rcsc::ServerParam::i().ourTeamGoalPos() * 0.1;
	  }
        agent->debugClient().addMessage("CutPassLine");
    }
    else if( wm.teammate(2) && wm.teammate(3) )
    {
        rcsc::Line2D first_line( wm.self().pos(), wm.teammate(2)->pos() );
        rcsc::Line2D second_line( wm.self().pos(), wm.teammate(3)->pos() );
        rcsc::Line2D third_line( rcsc::Vector2D( wm.defenseLineX(), -1.0 ), rcsc::Vector2D( wm.defenseLineX(), 1.0 ) );
        rcsc::Triangle2D center_triangle( first_line.intersection( second_line ),
                                          first_line.intersection( third_line ),
                                          second_line.intersection( third_line ) );
        rcsc::Vector2D opp_pos = center_triangle.centroid();
        rcsc::Vector2D opp_vel( 0.0, 0.0 );
        bool opp_in_center_triangle = false;
        for( rcsc::PlayerPtrCont::const_iterator it = opps.begin();
             it != opps_end;
             ++it )
        {
            if( center_triangle.contains( (*it)->pos() ) )
            {
                opp_in_center_triangle = true;
                opp_pos = (*it)->pos();
                opp_vel = (*it)->vel();
            }
        }
        if( opp_in_center_triangle )
        {
            //kickable opponent in triangle
            if( opp_pos.dist( wm.ball().pos() ) < 3.0 )
            {
                agent->debugClient().addMessage("KickableOppInTriangle:%lf",opp_vel.r() );
                mark_home_pos = base_pos + wm.ball().vel();
            }
            else
            {
                agent->debugClient().addMessage("OppInTriangle:%lf",opp_vel.r() );
                mark_home_pos = M_home_pos * 0.7 + opp_pos * 0.3;
                
                rcsc::Vector2D projection = rcsc::Line2D( base_pos, rcsc::Vector2D( wm.defenseLineX(), opp_pos.y ) ).projection( mark_home_pos );
                int ball_reach_cycle = log( 1.0 - ( 1.0 - ball_decay ) * base_pos.dist( opp_pos ) / ball_speed ) / log( ball_decay );
                int self_cycle = wm.self().playerType().cyclesToReachDistance( mark_home_pos.dist( projection ) );
                if( ( ball_reach_cycle < self_cycle
                      || ball_reach_cycle < 5 )
                    && ( wm.self().body().degree() < -90.0
                         || wm.self().body().degree() > 90.0 ) )
                {
                    agent->debugClient().addMessage("GoToPassLine:%lf",opp_vel.r() );
                    mark_home_pos = projection;
                }
            }
        }
        else
        {
            rcsc::Vector2D near_to_left( 1000.0, 0.0 );
            rcsc::Vector2D near_to_left_vel( 0.0, 0.0 );
            rcsc::Vector2D near_to_right( 1000.0, 0.0 );
            rcsc::Vector2D near_to_right_vel( 0.0, 0.0 ); 
            for( rcsc::PlayerPtrCont::const_iterator it = opps.begin();
                 it != opps_end;
                 ++it )
            {
                if( wm.teammate(2)->pos().dist( near_to_left ) > wm.teammate(2)->pos().dist( (*it)->pos() ) )
                {
                    near_to_left = (*it)->pos();
                    near_to_left_vel = (*it)->vel(); 
                }
                if( wm.teammate(3)->pos().dist( near_to_right ) > wm.teammate(3)->pos().dist( (*it)->pos() ) )
                {
                    near_to_right = (*it)->pos();
                    near_to_right_vel = (*it)->vel();
                }
            }
            if( base_pos.dist( near_to_left ) > base_pos.dist( near_to_right ) )
            {
                agent->debugClient().addMessage("MarkLeftOpponent:%lf",near_to_left_vel.r() );
                mark_home_pos = M_home_pos * 0.7 + near_to_left * 0.3;

                rcsc::Vector2D projection = rcsc::Line2D( base_pos, near_to_left ).projection( mark_home_pos );
                int ball_reach_cycle = log( 1.0 - ( 1.0 - ball_decay ) * base_pos.dist( near_to_left ) / ball_speed ) / log( ball_decay );
                int self_cycle = wm.self().playerType().cyclesToReachDistance( mark_home_pos.dist( projection ) );
                if( ( ball_reach_cycle < self_cycle
                      || ball_reach_cycle < 5 )
                    && ( wm.self().body().degree() < -90.0
                         || wm.self().body().degree() > 90.0 ) )
                {
                    agent->debugClient().addMessage("GoToPassLine:%lf",near_to_left_vel.r() );
                    mark_home_pos = projection;
                }
            }
            else
            {
                agent->debugClient().addMessage("MarkRightOpponent:%lf",near_to_right_vel.r() );
                mark_home_pos = M_home_pos * 0.7 + near_to_right * 0.3;

                rcsc::Vector2D projection = rcsc::Line2D( base_pos, near_to_right ).projection( mark_home_pos );
                int ball_reach_cycle = log( 1.0 - ( 1.0 - ball_decay ) * base_pos.dist( near_to_right ) / ball_speed ) / log( ball_decay );
                int self_cycle = wm.self().playerType().cyclesToReachDistance( mark_home_pos.dist( projection ) );
                if( ( ball_reach_cycle < self_cycle
                      || ball_reach_cycle < 5 )
                    && ( wm.self().body().degree() < -90.0
                         || wm.self().body().degree() > 90.0 ) )
                {
                    agent->debugClient().addMessage("GoToPassLine:%lf",near_to_right_vel.r() );
                    mark_home_pos = projection;
                }
            }
        }
    }
    else
    {
        mark_home_pos = M_home_pos;
    }

    if( mark_home_pos.x < wm.defenseLineX() + 1.0 )
    {
        mark_home_pos.x = wm.defenseLineX() + 1.0;
    }

/*
    if( wm.ball().pos().x < -32.0 && wm.self().pos().x < -32.0 )
    {
        if( wm.ball().pos().y > 0.0 )	
        {
            if( ! target_opp_right )
            {
                mark_home_pos.x = M_home_pos.x;
                mark_home_pos.y = M_home_pos.y + 2.0 * ( wm.ball().pos().y / wm.ball().pos().absY() ) ;
            }
            else
            {
                mark_home_pos.x = target_opp_right->pos().x * 0.8 + wm.ball().pos().x * 0.2;
                mark_home_pos.y = target_opp_right->pos().y * 0.8 + wm.ball().pos().y * 0.2;
                if( std::abs(mark_home_pos.y) > 14.0 )
                {
                    mark_home_pos.x = righttarget_pos.x;
                    mark_home_pos.y = righttarget_pos.y * 1.4;
                }					
            }
        }
        else if( wm.ball().pos().y <= 0.0 )
        {
            if( ! target_opp_left )
            {
                mark_home_pos.x = M_home_pos.x;
                mark_home_pos.y = M_home_pos.y + 2.0 * ( wm.ball().pos().y / wm.ball().pos().absY() );	   
            }
            else
            {
                mark_home_pos.x = target_opp_left->pos().x * 0.8 + wm.ball().pos().x * 0.2;
                mark_home_pos.y = target_opp_left->pos().y * 0.8 + wm.ball().pos().y * 0.2;
            }
            if( std::abs(mark_home_pos.y) > 13.0 )
            {
                mark_home_pos.x = righttarget_pos.x;
                mark_home_pos.y = righttarget_pos.y * 1.3;
            }					
        }
        else
        {
            mark_home_pos.x = M_home_pos.x;
            mark_home_pos.y = M_home_pos.y;
        }
    }
    else
    {
	mark_home_pos.x = M_home_pos.x;
	mark_home_pos.y = M_home_pos.y;
    }
*/
    const double dash_power = getDashPower( agent, mark_home_pos );

    double dist_thr = wm.ball().distFromSelf() * 0.1;
    if ( dist_thr < 1.0 ) dist_thr = 1.0;

    agent->debugClient().addMessage( " BasicMove%.0f", dash_power );
    agent->debugClient().setTarget( mark_home_pos );

    if ( ! rcsc::Body_GoToPoint( mark_home_pos, dist_thr, dash_power, 1
                                 ).execute( agent ) )
    {
        rcsc::Body_TurnToBall().execute( agent );
    }
/*
    if ( wm.existKickableOpponent()
         && wm.ball().distFromSelf() < 18.0 )
    {
        agent->setNeckAction( new rcsc::Neck_TurnToBall() );
        return true;
    }
*/
    if( wm.ball().posCount() > 3 )
    {
        agent->setNeckAction( new rcsc::Neck_TurnToBall() );
        return true;
    }
    if( wm.teammate(2) )
    {
        if( wm.teammate(2)->posCount() > 5 )
        {
            agent->setNeckAction( new rcsc::Neck_TurnToPoint( wm.teammate(2)->pos() ) );
            return true;
        }
    }
    if( wm.teammate(3) )
    {
        if( wm.teammate(3)->posCount() > 5 )
        {
            agent->setNeckAction( new rcsc::Neck_TurnToPoint( wm.teammate(3)->pos() ) );
            return true;
        }
    }
    agent->setNeckAction( new rcsc::Neck_TurnToBallOrScan() );
    return true;
}

/*-------------------------------------------------------------------*/
/*!

*/
double
Bhv_opuciDefensiveHalfMove::getDashPower( const rcsc::PlayerAgent * agent,
                             const rcsc::Vector2D & target_point )
{
    static bool s_recover_mode = false;

    const rcsc::WorldModel & wm = agent->world();
    /*--------------------------------------------------------*/
    // check recover
    if (( wm.ball().pos().x < 25.0 && wm.existKickableOpponent() )
	 || wm.ball().pos().x < wm.self().pos().x + 15.0 )
    {
        s_recover_mode = false;
    }
    else if ( wm.self().stamina() < rcsc::ServerParam::i().staminaMax() * 0.5 )
    {
        s_recover_mode = true;
    }
    else if ( wm.self().stamina() > rcsc::ServerParam::i().staminaMax() * 0.8 )
    {
        s_recover_mode = false;
    }

    /*--------------------------------------------------------*/
    double dash_power = rcsc::ServerParam::i().maxDashPower();
    const double my_inc
        = wm.self().playerType().staminaIncMax()
        * wm.self().recovery();

    int self_min = wm.interceptTable()->selfReachCycle();
    int mate_min = wm.interceptTable()->teammateReachCycle();
    int opp_min = wm.interceptTable()->opponentReachCycle();

    if ( ( wm.defenseLineX() < wm.self().pos().x
           && wm.ball().pos().x < wm.defenseLineX() + 5.0 )
       || wm.ball().pos().x < wm.self().pos().x + 3.0 
       ||( wm.ball().distFromSelf() < 7.0 && ! wm.existKickableTeammate()) 
       || wm.ball().pos().x < -36.0 )
      /*bhv_basic_move
    if ( wm.defenseLineX() > wm.self().pos().x
    && wm.ball().pos().x < wm.defenseLineX() + 20.0 )*/
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            __FILE__": correct DF line. keep max power" );
        // keep max power
        dash_power = rcsc::ServerParam::i().maxDashPower();
    }
    else if( wm.ball().pos().x < 0.0
             && wm.self().pos().dist( target_point ) > 5.0 )
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            __FILE__": target point far from here" );
        dash_power = rcsc::ServerParam::i().maxDashPower();
    }
    else if( wm.ball().pos().x < -30.0
             && opp_min <= self_min
             && opp_min <= mate_min )
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            __FILE__": exist kickable opponent dash" );
        dash_power = rcsc::ServerParam::i().maxDashPower();
    }
    else if( wm.self().pos().x < wm.offsideLineX() + 1.0 )
    {
        dash_power = rcsc::ServerParam::i().maxDashPower();
    }
    else if ( ! wm.existKickableTeammate()
              && opp_min < self_min
              && opp_min < mate_min
              && target_point.x < wm.self().pos().x
              && target_point.x < -25.0
              && wm.ball().inertiaPoint( opp_min ).x < -25.0 )
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            __FILE__": defense dash" );
        dash_power = rcsc::ServerParam::i().maxDashPower();
    }

    else if ( s_recover_mode )
    {
        dash_power = my_inc - 25.0; // preffered recover value
        if ( dash_power < 0.0 ) dash_power = 0.0;

        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            __FILE__": recovering" );
    }
    // exist kickable teammate
    else if ( wm.existKickableTeammate()
              && wm.ball().distFromSelf() < 5.0 )
    {
        dash_power = std::min( my_inc * 1.4 ,
                               rcsc::ServerParam::i().maxPower() * 0.8  );
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: exist kickable teammate. dash_power= %f"
                            ,__FILE__, __LINE__,
                            dash_power );
    }
    else if ( wm.existKickableTeammate()
              && wm.ball().distFromSelf() > 10.0 )
    {
        dash_power = std::min( my_inc - 20.0 ,
                               rcsc::ServerParam::i().maxPower() * 0.5 );
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: exist kickable teammate. dash_power= %f"
                            ,__FILE__, __LINE__,
                            dash_power );
    }
    // normal
    else
    {
        dash_power = std::min( my_inc * 1.3,
                               rcsc::ServerParam::i().maxPower() * 0.7 );
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: normal mode dash_power= %f"
                            ,__FILE__, __LINE__,
                            dash_power );
    }
    /*bhv_basic_move
    // exist kickable teammate
    else if ( wm.existKickableTeammate()
              && wm.ball().distFromSelf() < 20.0 )
    {
        dash_power = std::min( my_inc * 1.1,
                               rcsc::ServerParam::i().maxDashPower() );
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            __FILE__": exist kickable teammate. dash_power=%.1f",
                            dash_power );
    }
    // in offside area
    else if ( wm.self().pos().x > wm.offsideLineX() )
    {
        dash_power = rcsc::ServerParam::i().maxDashPower();
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            __FILE__": in offside area. dash_power=%.1f",
                            dash_power );
    }
    // normal
    else
    {
        dash_power = std::min( my_inc * 1.7,
                               rcsc::ServerParam::i().maxDashPower() );
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            __FILE__": normal mode dash_power=%.1f",
                            dash_power );
			    }*/

    return dash_power;
}
