// -*-c++-*-

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "bhv_basic_offensive_kick.h"
#include "bhv_opuci_offensive_kick.h"
#include "bhv_opuci_offensive_move.h"
#include "body_kick_to_corner.h"
#include "body_opuci_pass.h"
#include "body_opuci_smart_kick.h"
#include "strategy.h"
#include <rcsc/action/body_advance_ball.h>
#include <rcsc/action/body_kick_one_step.h>
#include <rcsc/action/obsolete/body_kick_multi_step.h>
#include <rcsc/action/body_smart_kick.h>
#include <rcsc/action/body_dribble.h>
#include <rcsc/action/obsolete/body_dribble2007.h>
#include <rcsc/action/body_hold_ball.h>
#include <rcsc/action/body_pass.h>
#include <rcsc/action/body_turn_to_angle.h>
#include <rcsc/action/neck_scan_field.h>
#include <rcsc/action/neck_turn_to_low_conf_teammate.h>
#include <rcsc/action/neck_turn_to_goalie_or_scan.h>
#include <rcsc/action/neck_turn_to_point.h>
#include <rcsc/player/say_message_builder.h>
#include <rcsc/player/player_agent.h>
#include <rcsc/player/debug_client.h>

#include <rcsc/common/logger.h>
#include <rcsc/common/server_param.h>
#include <rcsc/geom/sector_2d.h>
#include <rcsc/math_util.h>
#include <rcsc/action/neck_turn_to_ball_or_scan.h>
#include <rcsc/action/intention_dribble2008.h>
#include "opuci_intention_dribble.h"
#include "neck_opuci_turn_to_next_receiver.h"
/*-------------------------------------------------------------------*/
/*!

*/
bool
Bhv_opuciOffensiveKick::execute( rcsc::PlayerAgent * agent )
{
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: Bhv_opuciOffensiveKick"
                        ,__FILE__, __LINE__ );

    const rcsc::WorldModel & wm = agent->world();

    rcsc::Vector2D dribble_target( wm.self().pos().x + 10, wm.self().pos().y );
    if( wm.ball().pos().x > 30 )
    {
        if( wm.ball().pos().y > 7 )
        {
            dribble_target.y = 7;
        }
        if( wm.ball().pos().y < -7 )
        {
            dribble_target.y = -7;
        }
        if( wm.ball().pos().absY() <= 7 )
        {
            dribble_target.y = 0;
        }
    }
    if( dribble_target.y > 32 )
    {
        dribble_target.y = 32;
    }
    else if( dribble_target.y < -32 )
    {
        dribble_target.y = -32;
    }
    if( dribble_target.x > 51 )
    {
        dribble_target.x = 51;
    }
    

    const rcsc::PlayerPtrCont & opps = wm.opponentsFromSelf();
    const rcsc::PlayerObject * nearest_opp
        = ( opps.empty()
            ? static_cast< rcsc::PlayerObject * >( 0 )
            : opps.front() );
    const double nearest_opp_dist = ( nearest_opp
                                      ? nearest_opp->distFromSelf()
                                      : 1000.0 );
    const rcsc::Vector2D nearest_opp_pos = ( nearest_opp
                                             ? nearest_opp->pos()
                                             : rcsc::Vector2D( -1000.0, 0.0 ) );
///////////////////////////////////////////////////////////////////////////

    if( ( wm.self().pos().x > 35.0 && wm.self().pos().absY() < 7.0 ) 
        || ( wm.self().pos().x > 38.0 && wm.self().pos().absY() < 12.5 ) )
    {
        // shoot
        agent->debugClient().addMessage( "OpuciShoot" );
        double first_speed = rcsc::ServerParam::i().ballSpeedMax();
        bool found = false;
        const rcsc::PlayerObject * goalie = wm.getOpponentGoalie();
        if( !goalie )
        {
            const rcsc::Vector2D right_pole(52.5, 5.9);
            const rcsc::Vector2D left_pole(52.5, -5.9);
            if( wm.self().pos().y < 0)
            {
                rcsc::Body_opuciSmartKick( right_pole, first_speed, first_speed * 0.9, 3, true ).execute( agent );
                agent->debugClient().setTarget( right_pole );
                agent->debugClient().addMessage( "toRight" );
                agent->setNeckAction( new rcsc::Neck_TurnToGoalieOrScan() );
                return true;
            }
            else
            {
                rcsc::Body_opuciSmartKick( left_pole, first_speed, first_speed * 0.9, 3, true ).execute( agent );
                agent->debugClient().addMessage( "toLeft" );
                agent->debugClient().setTarget( left_pole );
                agent->setNeckAction( new rcsc::Neck_TurnToGoalieOrScan() );
                return true;
            }
        }
        else
        {
            double target_x = 52.5;
            double tmp_y = -5.8;
            double target_y = 0;
            if( wm.offsideLineX() < wm.self().pos().x )
            {
                if( goalie->pos().y > 0 )
                {
                    target_y = -6.0;
                }
                else
                {
                    target_y = 6.0;
                }
            }
            else
            {
                int count = 0;
                double max = 0;
                int best = 0;
                std::vector< double > cands;
                std::vector< double > dists;
                while( tmp_y <= 5.8 )
                {
                    rcsc::Vector2D tmp_target( target_x, tmp_y );
                    rcsc::Vector2D narimoto_point( wm.offsideLineX(),
                                                   ( wm.offsideLineX() - wm.self().pos().x ) / (tmp_target.x - wm.self().pos().x) 
                                                   * (tmp_target.y - wm.self().pos().y) );
                    double dist = 0;
                    const rcsc::PlayerObject * narimoto = wm.getOpponentNearestTo( narimoto_point, 10, &dist );
                    if( !narimoto )
                    {
                        dist = 2.0;
                    }
                    if( dist > 0.4 )
                    {
                        cands.push_back( tmp_y );
                        dists.push_back( tmp_target.dist( goalie->pos() ) );
                        count++;
                    }
                    tmp_y += 0.1;
                }
                for( unsigned int i = 0; i < cands.size(); i++ )
                {
                    if( max < dists.at( i ) )
                    {
                        max = dists.at( i );
                        best = i;
                    }
                }
                if( count > 0 )
                {
                    target_y = cands.at( best );
                    found = true;
                }
            }
            if( found )
            {
                rcsc::Vector2D target_pos( target_x, target_y );
                rcsc::Body_opuciSmartKick( target_pos, first_speed, first_speed * 0.96, 3, true ).execute( agent );
                agent->debugClient().setTarget( target_pos );
                agent->debugClient().addMessage( "Narimoto" );
                agent->setNeckAction( new rcsc::Neck_TurnToGoalieOrScan() );
                return true;
            }
        }
    }
    
    if( Strategy::get_ball_area( wm.ball().pos() ) == Strategy::BA_Cross
        || Strategy::get_ball_area( wm.ball().pos() ) == Strategy::BA_ShootChance )
    {
        if( Body_opuciPass().execute( agent ) )
        {
            agent->setNeckAction( new rcsc::Neck_TurnToGoalieOrScan() );
            return true;
        }
    }
    
///////////////////////////////////////

    rcsc::Vector2D next_pos = wm.self().pos() + wm.self().vel();
    rcsc::Vector2D next_bpos = wm.ball().inertiaPoint( 1 );
    if( next_pos.dist( next_bpos ) < wm.self().kickableArea() && fabs( wm.self().body().degree() ) > 90.0 )
    {
      // turn if player's body does not face along x-axis
      rcsc::Body_TurnToAngle( rcsc::AngleDeg( 0.0 ) ).execute( agent );
      rcsc::Neck_TurnToPoint( rcsc::Vector2D( rcsc::ServerParam::i().pitchLength() / 2.0, wm.self().pos().y ) ).execute( agent );
      return true;
    }

///////////////////////////////////////

    double front_line = -50;
    rcsc::Vector2D goal( 52, 0 );
    double dist_goal = 100;
    const rcsc::PlayerPtrCont::const_iterator mates_end = wm.teammatesFromSelf().end();
    for( rcsc::PlayerPtrCont::const_iterator it = wm.teammatesFromSelf().begin();
         it != mates_end;
         ++it )
    {
        if( (*it)->pos().dist( goal ) < dist_goal )
        {
            dist_goal = (*it)->pos().dist( goal );
        }
        if( (*it)->pos().x > front_line )
        {
            front_line = (*it)->pos().x;
        }
    }
    bool front = false;
    if( Strategy::get_ball_area( wm.ball().pos() ) == Strategy::BA_Cross
        || Strategy::get_ball_area( wm.ball().pos() ) == Strategy::BA_ShootChance )
    {
        if( wm.self().pos().dist( goal ) <= dist_goal  )
        {
            front = true;
        }
    }
    else if( wm.self().pos().x >= front_line )
    {
        front = true;
    }

    
    if( front )
    {
        agent->debugClient().addMessage( "SelfFront" );
        rcsc::Vector2D p1( wm.offsideLineX(), -34 );
        rcsc::Vector2D p2( wm.offsideLineX(), 34 );
        agent->debugClient().addLine( p1, p2 );
        if( Strategy::get_ball_area( wm.ball().pos() ) == Strategy::BA_ShootChance )
        {
            if( rcsc::Body_Dribble( dribble_target,
                                    0.5,
                                    100,
                                    1,
                                    true ).execute( agent ) )
            {
                agent->debugClient().addMessage( "DribbleToGoal" );
                agent->setNeckAction( new rcsc::Neck_TurnToGoalieOrScan() );
                return true;
            }
        }
        if( wm.self().pos().x > wm.offsideLineX() - 10 ) //near offside line
        {
            agent->debugClient().addMessage( "NearOffside" );
            /////////////////////////
            //self pass
            rcsc::AngleDeg target_angle = 0;
            int dash_count = 10;
            if( getSelfPassAngle( agent, target_angle, dash_count, true ) )
            {
                if( doSelfPass( agent, target_angle, dash_count, false ) )
                {
                    agent->debugClient().addMessage( "SelfPass%d", dash_count );
                    agent->setNeckAction( new rcsc::Neck_TurnToLowConfTeammate() );
                    return true;
                }
            }
            ////////////////////////////
        }
        else
        {
            //through pass
            //direct pass
            agent->debugClient().addMessage( "FarFromOffside" );
            if( Body_opuciPass( 1 ).execute( agent ) )
            {
                agent->setNeckAction( new rcsc::Neck_TurnToLowConfTeammate() );
                return true;
            }
            //dribble
            int power = 65;
            int dash = 1;
            if( nearest_opp_dist < 3 )
            {
                power = 100;
                dash = 1;
            }
            if( rcsc::Body_Dribble( dribble_target,
                                    0.5,
                                    power,
                                    dash,
                                    true ).execute( agent ) )
            {
                agent->debugClient().addMessage( "YukkuriDribble" );
//                agent->setNeckAction( new rcsc::Neck_OpuciTurnToNextReceiver() );
                agent->setNeckAction( new rcsc::Neck_TurnToLowConfTeammate() );
                return true;
            }
            if( Body_opuciPass( -1 ).execute( agent ) )
            {
                agent->setNeckAction( new rcsc::Neck_TurnToLowConfTeammate() );
                return true;
            }
        }
    }//end if front
    else
    {
        agent->debugClient().addMessage( "NotFront" );
        //through pass
        //direct pass
        if( Body_opuciPass( 1 ).execute( agent ) )
        {
            agent->setNeckAction( new rcsc::Neck_TurnToLowConfTeammate() );
            return true;
        }


        ///////////////////////////////////////////////////////////////////////////////
        //self pass
        double top_y = -34;
        double bottom_y = 34;
        double min_x = 52;
        rcsc::PlayerPtrCont::const_iterator opp_end = wm.opponentsFromSelf().end();
        for( rcsc::PlayerPtrCont::const_iterator it = wm.opponentsFromSelf().begin();
             it != opp_end;
             ++it )
        {
            if( (*it)->pos().x > wm.self().pos().x )
            {
                if( (*it)->pos().y > wm.self().pos().y )
                {
                    if( (*it)->pos().y < bottom_y )
                    {
                        bottom_y = (*it)->pos().y;
                        if( (*it)->pos().x < min_x )
                        {
                            min_x = (*it)->pos().x;
                        }
                    }
                }
                else
                {
                    if( (*it)->pos().y < top_y )
                    {
                        top_y = (*it)->pos().y;
                    }
                    if( (*it)->pos().x < min_x )
                    {
                        min_x = (*it)->pos().x;
                    }
                }
            }
        }
        double dif_thr = 8.0;
        if( fabs( top_y - bottom_y ) > dif_thr 
            && fabs( min_x - wm.self().pos().x ) > dif_thr )
        {
            /* by nazo */
            // clear along x-axis direction
            // check opponents
            // 10m, +-20 degree
            const rcsc::Sector2D x_axis_sector( wm.self().pos(),
                                                0.5, 10.0,
                                                -20.0, +20.0 );
            if ( ! wm.existOpponentIn( x_axis_sector, 10, true ) 
                 && wm.self().pos().x < 42 )
            {
                rcsc::AngleDeg target_angle = 0.0;
                if( doSelfPass( agent, target_angle, 5, false ) ){
                    agent->debugClient().addMessage( "SelfPass(nazo)" );
                    agent->setNeckAction( new rcsc::Neck_TurnToLowConfTeammate() );
                    return true;
                }
            }
        }
        
        rcsc::AngleDeg target_angle( 0 );
        int dash_count = 6;
        if( getSelfPassAngle( agent, target_angle, dash_count, false ) )
        {
            if( doSelfPass( agent, target_angle, dash_count, false ) )
            {
                agent->debugClient().addMessage( "SelfPass%d", dash_count );
                agent->setNeckAction( new rcsc::Neck_TurnToLowConfTeammate() );
                return true;
            }
        }
        
        ///////////////////////////////////////////////////////////////////////

        
        
        
        //dribble
        int power = 65;
        int dash = 1;
        if( nearest_opp_dist < 3 )
        {
            power = 100;
            dash = 1;
        }

        if( rcsc::Body_Dribble( dribble_target,
                                0.5,
                                power,
                                dash,
                                true ).execute( agent ) )
        {
            agent->debugClient().addMessage( "YukkuriDribble" );
//            agent->setNeckAction( new rcsc::Neck_OpuciTurnToNextReceiver() );
            agent->setNeckAction( new rcsc::Neck_TurnToLowConfTeammate() );
            return true;
        }

        //pass to back
        if( Body_opuciPass( -1 ).execute( agent ) )
        {
            agent->setNeckAction( new rcsc::Neck_TurnToLowConfTeammate() );
            return true;
        }
    }
    


/*
    else if( ( self_most_front && nearest_opp_dist < 3.0 ) && wm.ball().pos().x > 30.0 && wm.ball().pos().x < 40.0 )
    {
        if( wm.self().pos().y > 0 )
        {
            drib_goal.y = -6.0;
        }
        else
        {
            drib_goal.y = 6.0;
        }
        rcsc::Body_Dribble2007( drib_goal,
				1.0,
				rcsc::ServerParam::i().maxPower(),
				1
	    ).execute( agent );
        agent->debugClient().addMessage( "LastDrible" );
        agent->setNeckAction( new rcsc::Neck_TurnToLowConfTeammate() );
        return true;
    }
*/
/*
    if( ( wm.self().pos().x > 30.0 
          && wm.self().pos().absY() < 14.0 
          && nearest_opp_dist > 2.0 )
        || ( wm.self().pos().x > wm.offsideLineX() - 0.5 
             && wm.self().pos().absY() < 14.0 ) )
    {
	rcsc::dlog.addText( rcsc::Logger::TEAM,
			    "%s:%d: slow dribble to (%f, %f)"
			    ,__FILE__, __LINE__,
			    drib_goal.x, drib_goal.y );
	agent->debugClient().addMessage( "OffKickDrib(3)" );
	rcsc::Body_Dribble2007( drib_goal,
                                1.0,
                                rcsc::ServerParam::i().maxPower(),
                                2
	    ).execute( agent );
    }
    else if( wm.self().pos().x > 35.0 && wm.self().pos().absY() < 27.0 )
    {
	rcsc::dlog.addText( rcsc::Logger::TEAM,
			    "%s:%d: do best pass"
			    ,__FILE__, __LINE__ );
	agent->debugClient().addMessage( "OpuciPass" );
	if( Body_opuciPass().execute( agent ) )
	{
	    agent->setNeckAction( new rcsc::Neck_TurnToLowConfTeammate() );
	    return true;
	}
    }

#if 1 //dribble
    rcsc::Vector2D drib_target( 45.0, wm.self().pos().absY() );
    if ( drib_target.y > 29.0 ) drib_target.y = 27.0;
    if ( wm.ball().pos().x > 40.0 )
    {
        drib_target.x = 52.0;
        drib_target.y = 6.0;
    }
    if ( wm.self().pos().y < 0.0 ) drib_target.y *= -1.0;
    const rcsc::AngleDeg drib_angle = ( drib_target - wm.self().pos() ).th();

    bool dodge = true;
    // opp is far from me
    if ( nearest_opp_dist > 5.0 )
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: opp far. dribble(%f, %f)"
                            ,__FILE__, __LINE__,
                            drib_target.x, drib_target.y );
        agent->debugClient().addMessage( "OffKickDrib(4)" );
        rcsc::Body_Dribble2007( drib_target,
				1.0,
				rcsc::ServerParam::i().maxPower(),
				1,
				dodge
	    ).execute( agent );
        agent->setNeckAction( new rcsc::Neck_TurnToLowConfTeammate() );
        return true;
    }
*/

/*    
    // opponent is behind of me
    if ( nearest_opp_pos.x < wm.self().pos().x )
    {
        // check opponents
        // 10m, +-20 degree
        const rcsc::Sector2D sector( wm.self().pos(),
                                     0.5, 10.0,
                                     drib_angle - 20.0,
                                     drib_angle + 20.0 );
        // opponent check with goalie
        if ( ! wm.existOpponentIn( sector, 10, true ) )
        {
            const int max_dash_step
                = wm.self().playerType()
                .cyclesToReachDistance( wm.self().pos().dist( drib_target ) );
            if ( wm.self().pos().x > 30.0 )
            {
                drib_target.y *= ( 10.0 / drib_target.absY() );
            }

            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                "%s:%d: fast dribble to (%.1f, %.1f) max_step=%d"
                                ,__FILE__, __LINE__,
                                drib_target.x, drib_target.y,
                                max_dash_step );
            agent->debugClient().addMessage( "OffKickDrib(2)" );
            rcsc::Body_Dribble2007( drib_target,
				    1.0,
				    rcsc::ServerParam::i().maxPower(),
				    std::min( 6, max_dash_step ),
				    dodge
		).execute( agent );
        }
        else
        {
            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                "%s:%d: slow dribble to (%f, %f)"
                                ,__FILE__, __LINE__,
                                drib_target.x, drib_target.y );
            agent->debugClient().addMessage( "OffKickDrib(3)" );
            rcsc::Body_Dribble2007( drib_target,
				    1.0,
				    rcsc::ServerParam::i().maxPower(),
				    1,
				    dodge
		).execute( agent );
        }
        agent->setNeckAction( new rcsc::Neck_TurnToLowConfTeammate() );
        return true;
    }
#endif //end dribble
*/




    
    rcsc::Vector2D pass_point;

    if( doSelfPass( agent, wm.self().body(), 2, true ) )
    {
        agent->debugClient().addMessage( "TwoStep" );
        agent->setNeckAction( new rcsc::Neck_TurnToLowConfTeammate() );
        return true;
    }



    if( rcsc::Body_HoldBall().execute( agent ) )
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: hold"
                            ,__FILE__, __LINE__ );
        agent->debugClient().addMessage( "OffKickHold" );
        agent->setNeckAction( new rcsc::Neck_OpuciTurnToNextReceiver() );
//        agent->setNeckAction( new rcsc::Neck_TurnToLowConfTeammate() );
        return true;
    }

    if ( wm.self().pos().x > wm.offsideLineX() - 10.0 )
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: kick near side"
                            ,__FILE__, __LINE__ );
        agent->debugClient().addMessage( "OffKickToCorner" );
        Body_KickToCorner( (wm.self().pos().y < 0.0) ).execute( agent );
        agent->setNeckAction( new rcsc::Neck_ScanField() );
    }
    else
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: advance"
                            ,__FILE__, __LINE__ );
        agent->debugClient().addMessage( "OffKickAdvance" );
        rcsc::Body_AdvanceBall().execute( agent );
        agent->setNeckAction( new rcsc::Neck_ScanField() );
    }


    return true;
}

bool
Bhv_opuciOffensiveKick::doSelfPass( rcsc::PlayerAgent * agent, rcsc::AngleDeg angle, int dash_count, bool force )
{
    const rcsc::WorldModel & wm = agent->world();

    int turn_count = 1;
    int kick_count = 1;
    rcsc::AngleDeg turn_angle = angle - wm.self().body();
    if( fabs( turn_angle.degree() ) < 5 || force )
    {
        turn_count = 0;
    }
    else if( wm.self().canTurn( turn_angle.degree() ) )
    {
        turn_count = 1;
    }
    else
    {
        turn_count = 2;
    }


    double base_dist = getDashDist( agent, dash_count );

    
    rcsc::Vector2D inertia_self = wm.self().playerType().inertiaPoint( wm.self().pos(),
                                                                       wm.self().vel(),
                                                                       dash_count + turn_count + kick_count );
   
    rcsc::Vector2D dash_vec( base_dist, 0 );
    dash_vec.rotate( angle );
    rcsc::Vector2D tmp_target = wm.self().pos() + dash_vec; 
    
    rcsc::Vector2D rel = tmp_target - inertia_self;
    dash_vec = rcsc::Vector2D( base_dist, 0 );
    dash_vec.rotate( rel.th() );

    rcsc::Vector2D target_pos = inertia_self + dash_vec;


    rcsc::Vector2D ball_move = target_pos - wm.ball().pos();
    rcsc::Segment2D ball_segment( target_pos, wm.ball().pos() );
    if( target_pos.dist( wm.ball().pos() ) < 0.1 )
    {
        agent->debugClient().addMessage( "BadTarget" );
        return false;
    }
    rcsc::Circle2D self_size( wm.self().pos(), rcsc::ServerParam::i().defaultPlayerSize() );
    if( self_size.intersection( ball_segment, NULL, NULL ) != 0 )
    {
        agent->debugClient().addMessage( "Collision?TryDribble" );
        return rcsc::Body_Dribble2008( target_pos,
                                       0.5,
                                       100,
                                       1,
                                       false ).execute( agent );
    }
    
    double ball_dist = ball_move.r();                               

    double ball_speed = rcsc::calc_first_term_geom_series( ball_dist,
                                                           rcsc::ServerParam::i().ballDecay(),
                                                           dash_count + turn_count + kick_count  );
    if( ball_speed > rcsc::ServerParam::i().ballSpeedMax() )
    {
        agent->debugClient().addMessage( "OverMaxSpeed" );
        if( dash_count > 2 )
        {
            return doSelfPass( agent, angle, dash_count - 1, false );
        }
        return false;
    }
/*
    if( ball_speed < 1.5 && !force )
    {
        agent->debugClient().addMessage( "Slow.TryFaster" );
        if( doSelfPass( agent, angle, dash_count + 5, true ) )
        {
            std::cout << wm.time().cycle() << std::endl;
            return true;
        }
        else
        {
            doSelfPass( agent, angle, dash_count, true );
        }
    }
*/
    
    rcsc::Vector2D first_move = ball_move;
    first_move.setLength( ball_speed );
    
    rcsc::Vector2D ball_accel = first_move - wm.ball().vel();

    double kick_power = ball_accel.r() / wm.self().kickRate();
    
    if( fabs( kick_power ) > 100 )
    {
        agent->debugClient().addMessage( "OverMaxPower" );
        return false;
    }
    
    if( dash_count == 2 )
    {
    }
    else if( target_pos.x > 52
             || target_pos.absY() > 32 )
    {
        agent->debugClient().addMessage( "OverLine" );
        if( dash_count > 2 )
        {
            agent->debugClient().addMessage( "TryHalfDash" );
            return doSelfPass( agent, angle, dash_count/2, false );
            
        }
        return false;
    }

    const rcsc::PlayerObject * opp = wm.getOpponentNearestTo( target_pos, 10, NULL );
    if( opp )
    {
        rcsc::Segment2D segment( wm.ball().pos(), target_pos );
        rcsc::Segment2D opp_seg( opp->pos(), 20, opp->body() );
        int opp_turn = 1;
        if( segment.existIntersection( opp_seg ) )
        {
            opp_turn = 0;
        }
/*
        if( opp->velCount() < 3 )
        {
            agent->debugClient().addMessage( "LowConfAngle:DoDribble" );
              return rcsc::Body_Dribble2008( target_pos,
                                           0.5,
                                           100,
                                           1,
                                           false ).execute( agent );
        }
*/
        if( !force
            && target_pos.dist( opp->pos() ) < ( dash_count + turn_count - opp_turn ) * 0.6 + 1.0 )
        {
            agent->debugClient().addMessage( "MaybeFail%d", opp->unum() );
            return false;
        }
    }
    rcsc::AngleDeg angle_thr( 45 );
    if( turn_angle.degree() > angle_thr.degree() )
    {
        agent->debugClient().addMessage( "SelfDribble" );
        return rcsc::Body_Dribble2008( target_pos,
                                       0.5,
                                       100,
                                       1,
                                       true ).execute( agent );
    }

    agent->debugClient().setTarget( target_pos );
    agent->debugClient().addMessage( "BallSpeed%.2f", ball_speed );
    if( rcsc::Body_KickOneStep( target_pos,
                                ball_speed,
                                false ).execute( agent ) )
    {
        agent->setIntention( new OpuciIntentionDribble( target_pos,
                                                        0.3,
                                                        turn_count,
                                                        dash_count + 1,
                                                        100,
                                                        false,
                                                        wm.time() ) );

        return true;
    }
    else
    {
        agent->debugClient().addMessage( "CantKick" );
        return false;
    }

}

bool
Bhv_opuciOffensiveKick::getSelfPassAngle( rcsc::PlayerAgent * agent, rcsc::AngleDeg & angle, int & dash_count, bool force )
{
    const rcsc::WorldModel & wm = agent->world();
    int small = 4;
    rcsc::AngleDeg front_angle = 0;
    if( wm.ball().pos().x > 30 )
    {
        rcsc::Vector2D goal_center( 51, 0 );
        if( wm.self().pos().y > 7 )
        {
            goal_center.y = 7;
        }
        if( wm.self().pos().y < -7 )
        {
            goal_center.y = -7;
        }
        if( wm.self().pos().absY() <= 7 )
        {
            goal_center.y = 0;
        }
        rcsc::Vector2D goal_vector = goal_center - wm.self().pos();
        front_angle = goal_vector.th();
    }
            
    rcsc::Sector2D front_sector( wm.self().pos(),
                                 0.1, 15,
                                 front_angle - 30,
                                 front_angle + 30 );
    rcsc::Sector2D left_sector( wm.self().pos(),
                                0.1, 10,
                                front_angle - 30 ,
                                front_angle - 90 );
    rcsc::Sector2D right_sector( wm.self().pos(),
                                 0.1, 10,
                                 front_angle + 30,
                                 front_angle + 90 );
        
    const rcsc::PlayerObject * front_opp1 = NULL;
    const rcsc::PlayerObject * front_opp2 = NULL;

    rcsc::PlayerPtrCont::const_iterator end = wm.opponentsFromSelf().end();
    for( rcsc::PlayerPtrCont::const_iterator it = wm.opponentsFromSelf().begin();
         it != end;
         ++it )
    {
        if( !front_opp1 )
        {
            if( ( front_sector.contains( (*it)->pos() )
                  || right_sector.contains( (*it)->pos() )
                  || left_sector.contains( (*it)->pos() ) )
                && !(*it)->goalie() )
            {
                front_opp1 = (*it);
                break;
            }
        }
    }
    if( !front_opp1 ) //no opponent
    {
        angle = front_angle;
        agent->debugClient().addMessage( "Free" );
        if( wm.ball().pos().x < 35 )
        {
            std::vector< rcsc::Vector2D > candidates(5);
            std::vector< rcsc::Vector2D > oppline(4);
            Bhv_opuciOffensiveMove::findDefenseLine( agent, &candidates, &oppline );
            double min = 10;
            int num = -1;
            for( unsigned int i = 0; i < candidates.size(); i++ )
            {
                if( !candidates.at( i ).valid() )
                {
                    break;
                }
                agent->debugClient().addCircle( candidates.at( i ), 1 );
                if( min > candidates.at( i ).dist( wm.self().pos() ) )
                {
                    min = candidates.at( i ).dist( wm.self().pos() );
                    num = i;
                }
            }
            if( num >= 0 )
            {
                rcsc::Vector2D target_pos = candidates.at( num );
                for( unsigned int i = 0; i < oppline.size(); i++ )
                {
                    if( !oppline.at( i ).valid() )
                    {
                        break;
                    }
                    if( i + 1 >= oppline.size() )
                    {
                        break;
                    }
                    if( !oppline.at( i + 1 ).valid() )
                    {
                        break;
                    }
                    if( oppline.at( i ).y > candidates.at( num ).y
                        && candidates.at( num ).y > oppline.at( i + 1 ).y )
                    {
                        rcsc::Line2D opp_line( oppline.at( i ), oppline.at( i + 1 ) );
                        rcsc::Line2D line = opp_line.perpendicular( candidates.at( num ) );
                        target_pos.x = wm.self().pos().x + 10;
                        target_pos.y = line.getY( target_pos.x );
                        agent->debugClient().addCircle( target_pos, 3 );
                        break;
                    }
                }
                rcsc::Vector2D rel = target_pos - wm.ball().pos();
                angle = rel.th();
                double dist = rel.r();
//                    dist *= 1.5;
                int cycle = 1;
                while( getDashDist( agent, cycle ) < dist 
                       && cycle < 15 )
                {
                    cycle++;
                }
                dash_count = cycle;
                if( dash_count < 10 )
                {
                    dash_count = 10;
                }
            }
        }
/*
            front_opp1 = wm.getOpponentNearestToSelf( 10, false );
            if( front_opp1 )
            {
                for( rcsc::PlayerPtrCont::const_iterator it = wm.opponentsFromSelf().begin();
                     it != end;
                     ++it )
                {
                    if( (*it)->pos().x > wm.self().pos().x - 2 )
                    {
                        if( ( (*it)->pos().y > wm.self().pos().y
                              && wm.self().pos().y > front_opp1->pos().y )
                            || ( (*it)->pos().y < wm.self().pos().y
                                 && wm.self().pos().y < front_opp1->pos().y ) )
                        {
                            if( fabs( (*it)->pos().y  - wm.self().pos().y ) < 15 )
                            {
                                front_opp2 = (*it);
                                break;
                            }
                        }
                    }
                }
                if( front_opp2 )
                {
                    rcsc::Line2D opp12( front_opp1->pos(), front_opp2->pos() );
                    rcsc::Vector2D mid_opp12 = ( front_opp1->pos() + front_opp2->pos() ) / 2.0;
                    rcsc::Line2D ppndclr = opp12.perpendicular( mid_opp12 );
                    rcsc::Vector2D target_pos( 50.0, ppndclr.getY( 50.0 ) );
                    
                    
                    //                double mid_y = front_opp1->pos().y - ( front_opp1->pos().y - front_opp2->pos().y ) / 2.0;
                    //                rcsc::Vector2D target_pos( 50, mid_y );
                    
                    rcsc::Vector2D rel = target_pos - wm.self().pos();
                    angle = rel.th();
                }
            }

        }
*/
        if( wm.ball().pos().x > 30 )
        {
            dash_count = small;
        }
        
        return true;
    }
    else
    {
        if( wm.ball().pos().x < 35 )
        {
            std::vector< rcsc::Vector2D > candidates(5);
            std::vector< rcsc::Vector2D > oppline(4);
            Bhv_opuciOffensiveMove::findDefenseLine( agent, &candidates, &oppline );
            double min = 10;
            int num = -1;
            for( unsigned int i = 0; i < candidates.size(); i++ )
            {
                if( !candidates.at( i ).valid() )
                {
                    break;
                }
                rcsc::dlog.addText( rcsc::Logger::TEAM,
                                    "%s:%d: candidates[%d](%.00f, %.00f)"
                                    ,__FILE__, __LINE__, i, candidates[i].x, candidates[i].y );
	    }
            for( unsigned int i = 0; i < candidates.size(); i++ )
            {
                if( !candidates.at( i ).valid() )
                {
                    break;
                }
                agent->debugClient().addCircle( candidates.at( i ), 1 );
                if( min > candidates.at( i ).dist( wm.self().pos() ) )
                {
                    min = candidates.at( i ).dist( wm.self().pos() );
                    num = i;
                }
            }
            if( num >= 0 )
            {
                if( candidates.at( num ).x > wm.self().pos().x )
                {
                    rcsc::Vector2D target_pos = candidates.at( num );
                    for( unsigned int i = 0; i < oppline.size(); i++ )
                    {
                        if( !oppline.at( i ).valid() )
                        {
                            break;
                        }
                        if( i + 1 >= oppline.size() )
                        {
                            break;
                        }
                        if( !oppline.at( i + 1 ).valid() )
                        {
                            break;
                        }
                        if( oppline.at( i ).y > candidates.at( num ).y
                            && candidates.at( num ).y > oppline.at( i + 1 ).y )
                        {
                            rcsc::Line2D opp_line( oppline.at( i ), oppline.at( i + 1 ) );
                            rcsc::Line2D line = opp_line.perpendicular( candidates.at( num ) );
                            target_pos.x = wm.self().pos().x + 10;
                            target_pos.y = line.getY( target_pos.x );
                            agent->debugClient().addCircle( target_pos, 3 );
                            break;
                        }
                    }
                    rcsc::Vector2D rel = target_pos - wm.ball().pos();
                    angle = rel.th();
                    double dist = rel.r();
                    int cycle = 1;
                    while( getDashDist( agent, cycle ) < dist 
                           && cycle < 15 )
                    {
                        cycle++;
                    }
                    dash_count = cycle;
                    if( dash_count < 10 )
                    {
                        dash_count = 10;
                    }
                    if( wm.ball().pos().x > 30 )
                    {
                        dash_count = small;
                    }
                    return true;
                }
            }
        }
        rcsc::Vector2D to_opp1 = front_opp1->pos() - wm.ball().pos();
        for( rcsc::PlayerPtrCont::const_iterator it = wm.opponentsFromSelf().begin();
             it != end;
             ++it )
        {
            if( (*it)->pos().x > wm.self().pos().x - 1 )
            {
                rcsc::Vector2D to_opp2 = (*it)->pos() - wm.ball().pos();
                if( fabs( to_opp1.th().degree() - to_opp2.th().degree() ) > 50 )
                {
                    front_opp2 = (*it);
                    break;
                }
            }
        }
        rcsc::Vector2D opp1_pos = front_opp1->pos();
        rcsc::Vector2D opp2_pos = opp1_pos;
        agent->debugClient().addCircle( opp1_pos, 2 );
        if( front_opp2 )
        {
            opp2_pos = front_opp2->pos();
            agent->debugClient().addCircle( opp2_pos, 3 );
            rcsc::Vector2D self_to1 = opp1_pos - wm.ball().pos();
            rcsc::Vector2D self_to2 = opp2_pos - wm.ball().pos();
            rcsc::AngleDeg angle1 = self_to1.th();
            rcsc::AngleDeg angle2 = self_to2.th();
            
            double dif = angle1.degree() - angle2.degree();
            rcsc::AngleDeg angle_thr( 50 );
            if( fabs( dif ) >= angle_thr.degree() )
            {
                rcsc::Vector2D tmp = opp1_pos - opp2_pos;
                rcsc::Vector2D target_pos = opp2_pos + tmp / 2.0;
                rcsc::Vector2D rel = target_pos - wm.ball().pos();
                angle = rel.th();
                rcsc::Line2D opp_line( opp1_pos, opp2_pos );
                rcsc::Line2D line( wm.ball().pos(), angle );
                rcsc::Vector2D target = opp_line.intersection( line );
                double dist = target.dist( wm.self().pos() );
//                dist *= 1.5;
                dash_count = 1;
                while( dist > getDashDist( agent, dash_count ) )
                {
                    dash_count++;
                }
                if( dash_count < 10 )
                {
                    dash_count = 10;
                }
                if( wm.ball().pos().x > 30 )
                {
                    dash_count = small;
                }
                agent->debugClient().addTriangle( wm.self().pos(),
                                                  opp1_pos,
                                                  opp2_pos );
                return true;
            }
        }
        else
        {
            if( !force )
            {
                agent->debugClient().addMessage( "MissOpponent" );
                return false;
            }
            else
            {
                rcsc::Vector2D opp1_pos = front_opp1->pos();

                int direction = 1;
                if( to_opp1.th().degree() > front_angle.degree() )
                {
                    direction = -1;
                }

                rcsc::AngleDeg angle_thr( 120 );
                rcsc::AngleDeg vir( direction * angle_thr.degree() );
                
                rcsc::Vector2D opp2_pos = wm.ball().pos() + to_opp1.rotatedVector( vir );
                if( opp2_pos.x > 52 )
                {
                    opp2_pos.x = 52;
                }
                if( opp2_pos.y > 34 )
                {
                    opp2_pos.y = 34;
                }
                if( opp2_pos.y < -34 )
                {
                    opp2_pos.y = -34;
                }
                
                rcsc::Vector2D to_opp2 = opp2_pos - wm.ball().pos();
                rcsc::AngleDeg angle2 = to_opp2.th();
                
                double dif = to_opp1.th().degree() - angle2.degree();
                dif = to_opp1.th().degree() -  dif / 2.0;
                angle = rcsc::AngleDeg( dif );
                rcsc::Line2D opp_line( opp1_pos, opp2_pos );
                rcsc::Line2D line( wm.ball().pos(), angle );
                rcsc::Vector2D target = opp_line.intersection( line );
                double dist = target.dist( wm.self().pos() );
                dist *= 1.8;
                dash_count = 1;
                while( dist > getDashDist( agent, dash_count ) )
                {
                    dash_count++;
                }
                if( dash_count < 10 )
                {
                    dash_count = 10;
                }
                if( wm.ball().pos().x > 30 )
                {
                    dash_count = small;
                }
                agent->debugClient().addTriangle( wm.self().pos(),
                                                  opp1_pos,
                                                  opp2_pos );
                return true;
            }
        }
    }
    return false;
}


double
Bhv_opuciOffensiveKick::getDashDist( rcsc::PlayerAgent * agent, int dash_count )
{
    const rcsc::WorldModel & wm = agent->world();
    double dist = 0;
    double self_speed = agent->world().self().vel().r();
    double stamina = wm.self().stamina();
    double effort = wm.self().effort();
    double recovery = wm.self().recovery();
    for( int i = 0; i <= dash_count; i++ )
    {
        self_speed += effort * wm.self().playerType().dashPowerRate() * 100;
        if( self_speed > wm.self().playerType().playerSpeedMax() )
        {
            self_speed = wm.self().playerType().playerSpeedMax();
        }
        dist += self_speed;
        self_speed *= wm.self().playerType().playerDecay();

        stamina -= wm.self().playerType().getOneStepStaminaComsumption( rcsc::ServerParam::i() );
        
        if( stamina <= 
            rcsc::ServerParam::i().staminaMax() 
            * rcsc::ServerParam::i().recoverDecThr() )
        {
            if( recovery > rcsc::ServerParam::i().recoverMin() )
            {
                recovery -= rcsc::ServerParam::i().recoverDec();
            }
            if( recovery > rcsc::ServerParam::i().recoverMin() )
            {
                recovery = rcsc::ServerParam::i().recoverMin();
            }
        }
        if( stamina < 
            rcsc::ServerParam::i().staminaMax() 
            * rcsc::ServerParam::i().effortDecThr() )
        {
            if( effort > wm.self().playerType().effortMin() )
            {
                effort -= rcsc::ServerParam::i().effortDec();
            }
            if( effort < wm.self().playerType().effortMin() )
            {
                effort = wm.self().playerType().effortMin();
            }
        }
        if( stamina >=
            rcsc::ServerParam::i().staminaMax()
            * rcsc::ServerParam::i().effortIncThr() )
        {
            if( effort < wm.self().playerType().effortMax() )
            {
                effort += rcsc::ServerParam::i().effortInc();
                if( effort > wm.self().playerType().effortMax() )
                {
                    effort = wm.self().playerType().effortMax();
                }
            }
        }
        stamina += recovery * wm.self().playerType().staminaIncMax();
    }
    
    return dist;
}
