// -*-c++-*-

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "bhv_basic_move.h"
#include "bhv_opuci_offensive_move.h"
#include "bhv_basic_tackle.h"

#include <rcsc/action/basic_actions.h>
#include <rcsc/action/body_go_to_point.h>
#include <rcsc/action/body_intercept.h>
#include <rcsc/action/obsolete/body_intercept2007.h>
#include <rcsc/action/neck_turn_to_ball_or_scan.h>
#include <rcsc/action/neck_turn_to_low_conf_teammate.h>

#include <rcsc/player/player_agent.h>
#include <rcsc/player/debug_client.h>
#include <rcsc/player/intercept_table.h>

#include <rcsc/common/logger.h>
#include <rcsc/common/server_param.h>

/*-------------------------------------------------------------------*/
/*!
  execute action
*/
bool
Bhv_opuciOffensiveMove::execute( rcsc::PlayerAgent * agent )
{
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: Bhv_opuciOffensiveMove"
                        ,__FILE__, __LINE__ );

    // tackle

    if ( Bhv_BasicTackle( 0.9, 80.0 ).execute( agent ) )
    {
        agent->debugClient().addMessage( "offmovetackle" );
        return true;
    }

    const rcsc::WorldModel & wm = agent->world();

    // check ball owner

    int self_min = wm.interceptTable()->selfReachCycle();
    int mate_min = wm.interceptTable()->teammateReachCycle();
    int opp_min = wm.interceptTable()->opponentReachCycle();

    // check nearest opponent
    const rcsc::PlayerPtrCont & opps = wm.opponentsFromSelf();
    const rcsc::PlayerObject * nearest_opp
        = ( opps.empty()
            ? static_cast< rcsc::PlayerObject * >( 0 )
            : opps.front() );
    const double nearest_opp_dist = ( nearest_opp
                                      ? nearest_opp->distFromSelf()
                                      : 1000.0 );
    const rcsc::Vector2D nearest_opp_pos = ( nearest_opp
                                             ? nearest_opp->pos()
                                             : rcsc::Vector2D( -1000.0, 0.0 ) );

    if ( ! wm.existKickableTeammate() && ( self_min < mate_min ) )
    {
      if(self_min < opp_min)
	{
	  rcsc::dlog.addText( rcsc::Logger::TEAM,
			      "%s:%d: intercept"
			      ,__FILE__, __LINE__ );
	  rcsc::Body_Intercept2008().execute( agent );
	  if ( wm.ball().distFromSelf()
	       < rcsc::ServerParam::i().visibleDistance() )
	    {
	      agent->setNeckAction( new rcsc::Neck_TurnToLowConfTeammate() );;
	    }
	  else
	    {
	      agent->setNeckAction( new rcsc::Neck_TurnToBallOrScan() );
	    }
	  agent->debugClient().addMessage( "OffMoveIntercept" );
	  return true;
	}
      else
	{
	  rcsc::dlog.addText( rcsc::Logger::TEAM,
			      "%s:%d: attack the opponent ball intercepter"
			      ,__FILE__, __LINE__ );
	  
	  if ( rcsc::Body_GoToPoint( wm.ball().inertiaPoint( opp_min ),
				     0.3, rcsc::ServerParam::i().maxPower() ).execute( agent ) )
	    {
	      if ( wm.ball().distFromSelf() < rcsc::ServerParam::i().visibleDistance() )
		  agent->setNeckAction( new rcsc::Neck_TurnToLowConfTeammate() );
	      else
		  agent->setNeckAction( new rcsc::Neck_TurnToBallOrScan() );
	      agent->debugClient().addMessage( "OffMoveIntercept" );
	      return true;
	    }
	  else
	    {
	      agent->debugClient().addMessage( "Todo" );
	      return true;
	    }
	}
    }

    // go to home position

    double dist_thr = wm.ball().distFromSelf() * 0.1;
    if( wm.self().pos().x > wm.offsideLineX() )
      dist_thr = 0.1;
    else if ( dist_thr < 1.0 ) dist_thr = 1.0;

    rcsc::Vector2D target_pos = M_home_pos;
    agent->debugClient().addCircle( rcsc::Circle2D( M_home_pos, 2 ) );
    if( (self_min > mate_min && opp_min > mate_min)
        || agent->world().ball().pos().x > agent->world().self().pos().x
	|| wm.existKickableTeammate() )
    {
        rcsc::Vector2D focus_point = wm.ball().pos();
        if( !wm.existKickableTeammate() && !wm.existKickableOpponent() )
            focus_point = wm.ball().inertiaPoint( mate_min );
        
        std::vector<rcsc::Vector2D> candidate(5);
        findDefenseLine( agent, &candidate );

        // nearest candidate to home_position.
        double min_dist = rcsc::ServerParam::i().pitchLength()*100.0; //very large
	int isDirectPos = false;
        for( int i = 0 ; i < 5 ; i++ )
        {
	  if( !candidate[i].valid() )
	    continue;

            if( candidate[i].dist( M_home_pos ) < min_dist )
            {
                min_dist = candidate[i].dist( M_home_pos );
                target_pos = candidate[i];
            }
        }
        
	// direct pass position
	std::vector<rcsc::Vector2D> candidate2;
	findSorroundings( agent, &candidate2, focus_point );
	for( std::vector<rcsc::Vector2D>::iterator it = candidate2.begin();
	     it != candidate2.end() ; it++ )
	  {
	    if( !it->valid() )
	      continue;

	    if( it->dist( M_home_pos ) < min_dist )
	      {
		min_dist = it->dist( M_home_pos );
		target_pos = (*it);
		isDirectPos = true;
	      }
	  }

	if( isDirectPos == true )
	  agent->debugClient().addMessage( "DPassPos" );
        else
            agent->debugClient().addMessage( "ThrPassPos" );

	/*
	if( target_pos.x - wm.ball().pos().x > 10.0 && wm.self().pos().x < 20.0 ){
	  rcsc::Vector2D ball2tgt = target_pos - wm.ball().pos();
	  rcsc::dlog.addText( rcsc::Logger::TEAM,
			      __FILE__": original target_pos(%.0f, %.0f), ball2tgt(%.0f, %.0f)",
			      target_pos.x, target_pos.y, ball2tgt.x, ball2tgt.y );
	  target_pos = wm.ball().pos() + ball2tgt.scale( 0.9 );
	  //	  target_pos = target_pos * (target_pos.x - wm.ball().pos().x - 9.0) / (target_pos.x - wm.ball().pos().x) + wm.ball().pos() * 9.0 / (target_pos.x - wm.ball().pos().x );	
	  rcsc::dlog.addText( rcsc::Logger::TEAM,
			      __FILE__": modified target_pos( %.0f, %.0f)",
			      target_pos.x, target_pos.y );
	}
	*/

        if( target_pos.x > wm.offsideLineX() )
            target_pos.x = wm.offsideLineX()-1.0;
    }
    else if( (self_min > opp_min && mate_min > opp_min) || agent->world().existKickableOpponent() )
    {
      
      // check if any opponent near target_point exists around the player
      const rcsc::PlayerPtrCont & opps = agent->world().opponentsFromSelf();
      rcsc::PlayerObject *target_opp = static_cast< rcsc::PlayerObject *>(0);
      bool alreadyMarked = false;
      double dist2candidate;
      const rcsc::PlayerPtrCont::const_iterator opps_end = opps.end();
      for ( rcsc::PlayerPtrCont::const_iterator it = opps.begin(); it != opps_end ; ++it ){
	dist2candidate = (*it)->pos().dist( agent->world().self().pos() );
	if(  dist2candidate < 20)
	  break;

	alreadyMarked = false;
	const rcsc::PlayerPtrCont & mates = agent->world().teammatesFromSelf();
	const rcsc::PlayerPtrCont::const_iterator mates_end = mates.end();
	for ( rcsc::PlayerPtrCont::const_iterator it2 = opps.begin(); it2 != opps_end ; ++it2 ){
	  if(  (*it2)->pos().dist( agent->world().self().pos() ) > 20 )
	    break;
	  if( (*it)->pos().dist( (*it2)->pos() ) < dist2candidate ){
	    alreadyMarked = true;
	    break;
	  }
	}
	if( alreadyMarked == false ){
	  target_pos = (*it)->pos();
	  target_pos.x -= (*it)->playerTypePtr()->kickableArea();
	  break;
	}
      }
      if( alreadyMarked == true ){
        agent->debugClient().addMessage( "PreparingPos" );
        std::vector<rcsc::Vector2D> candidate(5);
        findDefenseLine( agent, &candidate );
	
        // nearest candidate to home_position.
        double min_dist = rcsc::ServerParam::i().pitchLength()*100.0; //very large
        for( int i = 0 ; i < 5 ; i++ )
        {
            if( candidate[i].dist( M_home_pos ) < min_dist )
            {
                min_dist = candidate[i].dist( M_home_pos );
                target_pos = candidate[i];
            }
        }

	if( M_home_pos.x > wm.ball().pos().x &&
	    target_pos.x > wm.ball().pos().x )
	  target_pos = M_home_pos;
	else
	  target_pos.x = target_pos.x < M_home_pos.x ? target_pos.x : M_home_pos.x;
      }
      else{
        agent->debugClient().addMessage( "Marking" );
      }
    }
    else
    {
        agent->debugClient().addMessage( "NoKickablePlayer" );
    }
    if( agent->world().self().pos().x > agent->world().offsideLineX() - 0.5)
      {
	target_pos.x = agent->world().offsideLineX() - 1.0;
	target_pos.y = agent->world().self().pos().y;
      }


    const double dash_power = getDashPower( agent, target_pos );
    agent->debugClient().addMessage( "opuci_offensiveMove%.0f", dash_power );
    agent->debugClient().setTarget( target_pos );

    if ( ! rcsc::Body_GoToPoint( target_pos, dist_thr, dash_power
         ).execute( agent ) )
    {
        rcsc::Body_TurnToBall().execute( agent );
    }

    if ( wm.existKickableOpponent()
         && wm.ball().distFromSelf() < 18.0 )
    {
        agent->setNeckAction( new rcsc::Neck_TurnToBall() );
    }
    else
    {
        agent->setNeckAction( new rcsc::Neck_TurnToBallOrScan() );
    }

    return true;
}

/*-------------------------------------------------------------------*/
/*!

 */
double
Bhv_opuciOffensiveMove::getDashPower( rcsc::PlayerAgent * agent,
                                      const rcsc::Vector2D & target_point )
{
    static bool s_recover_mode = false;

    const rcsc::WorldModel & wm = agent->world();
    /*--------------------------------------------------------*/
    // check recover

    if ( wm.self().stamina() < rcsc::ServerParam::i().staminaMax() * 0.5 )
    {
        s_recover_mode = true;
    }
    else if ( wm.self().stamina() > rcsc::ServerParam::i().staminaMax() * 0.7 )
    {
        s_recover_mode = false;
    }

    /*--------------------------------------------------------*/
    double dash_power = rcsc::ServerParam::i().maxDashPower();
    const double my_inc
        = wm.self().playerType().staminaIncMax()
        * wm.self().recovery();

    int self_min = wm.interceptTable()->selfReachCycle();
    int mate_min = wm.interceptTable()->teammateReachCycle();
    int opp_min = wm.interceptTable()->opponentReachCycle();

    if (( wm.defenseLineX() > wm.self().pos().x
          && wm.ball().pos().x < wm.defenseLineX() + 20.0 )
        ||
        ( wm.ball().pos().x - wm.self().pos().x > 10.0 
          && ! wm.existKickableOpponent() )
        ||
        wm.ball().pos().x > 40.0 )
        /*bhv_basic_move
          if ( wm.defenseLineX() > wm.self().pos().x
          && wm.ball().pos().x < wm.defenseLineX() + 20.0 )*/
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            __FILE__": correct DF line. keep max power" );
        // keep max power
        agent->debugClient().addMessage( "Case1" );
        dash_power = rcsc::ServerParam::i().maxDashPower();
    }
    else if ( ! wm.existKickableTeammate()
              && opp_min < self_min
              && opp_min < mate_min
              && target_point.x < wm.self().pos().x
              && target_point.x < -25.0
              && wm.ball().inertiaPoint( opp_min ).x < -25.0 )
    {
        agent->debugClient().addMessage( "Case2" );
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            __FILE__": defense dash" );
        dash_power = rcsc::ServerParam::i().maxDashPower();
    }
    else if ( wm.ball().pos().x > 30.0 )
    {
        agent->debugClient().addMessage( "Case3" );
        std::min( my_inc * 1.3, rcsc::ServerParam::i().maxPower() * 0.6 );
    }
    else if ( ( ( wm.existKickableTeammate() && ! wm.self().isKickable() )
                || ( self_min < mate_min && self_min < opp_min ) 
                || ( mate_min < opp_min ) )
              && wm.ball().pos().x > -25.0 )
    {
        agent->debugClient().addMessage( "Case4" );
        //dash_power = std::min( my_inc * 1.1, rcsc::ServerParam::i().maxDashPower() );
        dash_power = rcsc::ServerParam::i().maxDashPower();
    }
    else if ( s_recover_mode )
    {
        agent->debugClient().addMessage( "Case5" );
        dash_power = my_inc - 25.0; // preffered recover value
        if ( dash_power < 0.0 ) dash_power = 0.0;

        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            __FILE__": recovering" );
    }
    // exist kickable teammate
    else if ( wm.existKickableTeammate()
              && wm.ball().distFromSelf() < 10.0 )
        /*bhv_basic_move
          else if ( wm.existKickableTeammate()
          && wm.ball().distFromSelf() < 20.0 )*/
    {
        agent->debugClient().addMessage( "Case6" );
        dash_power = std::min( my_inc * 1.1,
                               rcsc::ServerParam::i().maxDashPower() );
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            __FILE__": exist kickable teammate. dash_power=%.1f",
                            dash_power );
    }
    // in offside area
    else if ( wm.self().pos().x > wm.offsideLineX() )
    {
        agent->debugClient().addMessage( "Case7" );
        dash_power = rcsc::ServerParam::i().maxDashPower();
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            __FILE__": in offside area. dash_power=%.1f",
                            dash_power );
    }
    else if( wm.existKickableTeammate()
             && wm.ball().pos().x > 25 )
    {
        agent->debugClient().addMessage( "Case8" );
        dash_power = rcsc::ServerParam::i().maxPower();
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: before shoot chance mode dash_power= %f"
                            ,__FILE__, __LINE__,
                            dash_power );
    }
    else    // normal
    {
        agent->debugClient().addMessage( "Case9" );
        dash_power = std::min( my_inc * 1.1,
                               rcsc::ServerParam::i().maxPower() );
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: normal mode dash_power= %f"
                            ,__FILE__, __LINE__,
                            dash_power );
    }
    /*bhv_basic_move
      else
      {
      dash_power = std::min( my_inc * 1.7,
      rcsc::ServerParam::i().maxDashPower() );
      rcsc::dlog.addText( rcsc::Logger::TEAM,
      __FILE__": normal mode dash_power=%.1f",
      dash_power );
      }*/

    return dash_power;
}
/*-------------------------------------------------------------------*/
/*!
  function for finding the opponent defense line
*/
void
Bhv_opuciOffensiveMove::findDefenseLine( rcsc::PlayerAgent * agent, std::vector<rcsc::Vector2D> *candidate )
{
  std::vector <rcsc::Vector2D> far(4);
  far[0].invalidate();
  far[1].invalidate();
  far[2].invalidate();
  far[3].invalidate();
  rcsc::Vector2D top, bottom;
    
  const rcsc::PlayerCont opps = agent->world().opponents();
  const rcsc::PlayerCont::const_iterator opps_end = opps.end();
  for ( rcsc::PlayerCont::const_iterator it = opps.begin(); it != opps_end ; ++it )
    {
      if( (*it).goalie() == true 
	  || (*it).pos().x > 47.0 )
	continue;
      if( (*it).pos().x < agent->world().self().pos().x )
	continue;
        
      bool isvalid = false;
      for( rcsc::PlayerCont::const_iterator it2 = opps.begin() ; it2 != opps_end ; ++it2 )
        {
	  if( (*it).unum() == (*it2).unum() )
	    continue;
	  if( (*it).pos().x - (*it2).pos().x < 20 )
            {
	      isvalid = true;
	      break;
            }
        }
      if( isvalid )
        {
	  if( !far[0].valid() )
	    far[0] = (*it).pos();
	  else if( far[0].x < (*it).pos().x )
	    far[0] = (*it).pos();
        }
    }
  if( far[0].valid() )
    rcsc::dlog.addText( rcsc::Logger::TEAM,
			"%s:%d: far[0](%.0f, %.0f)"
			,__FILE__, __LINE__, far[0].x, far[0].y );
  else
    rcsc::dlog.addText( rcsc::Logger::TEAM,
			"%s:%d: far[0] invalid",
			__FILE__, __LINE__ );
  for ( rcsc::PlayerCont::const_iterator it = opps.begin(); it != opps_end ; ++it )
    {
      if( (*it).goalie() == true || (*it).pos().x > 47.0 )
	continue;
        
      if( far[0].valid() && far[0].x - (*it).pos().x < 15 
	  && far[0].x >= (*it).pos().x )
        {
	  if( !top.valid() || top.y < (*it).pos().y )
	    top = (*it).pos();
            
	  if( !bottom.valid() || bottom.y > (*it).pos().y )
	    bottom = (*it).pos();
        }
    }
  rcsc::dlog.addText( rcsc::Logger::TEAM,
		      "%s:%d: top(%.0f, %.0f), bottom(%.0f, %.0f)"
		      ,__FILE__, __LINE__, top.x, top.y, bottom.x, bottom.y );

  // far[1] identification
  for ( rcsc::PlayerCont::const_iterator it = opps.begin(); it != opps_end ; ++it )
    {
      if( (*it).goalie() == true || (*it).pos().x > 47.0
	  || (*it).pos().x > far[0].x
	  || (*it).pos().x == far[0].x)
	continue;

      if( (*it).pos().y > far[0].y ) // check against top
        {
	  if( (*it).pos().x < top.x )
	    continue;

	  if( !far[1].valid() || far[1].x < (*it).pos().x )
	    far[1] = (*it).pos();
        }
      else // check against bottom
        {
	  if( (*it).pos().x < bottom.x )
	    continue;

	  if( !far[1].valid() || far[1].x < (*it).pos().x )
	    far[1] = (*it).pos();
        }
    }
  if( far[1].valid() )
    rcsc::dlog.addText( rcsc::Logger::TEAM,
			"%s:%d: far[1](%.0f, %.0f)"
			,__FILE__, __LINE__, far[1].x, far[1].y );
  else
    rcsc::dlog.addText( rcsc::Logger::TEAM,
			"%s:%d: far[1] invalid",
			__FILE__, __LINE__ );

  // far[2] identification
  for ( rcsc::PlayerCont::const_iterator it = opps.begin(); it != opps_end ; ++it )
    {
      if( (*it).goalie() == true || (*it).pos().x > 47.0
	  || (*it).pos().x > far[0].x
	  || (*it).pos().x == far[0].x
	  || (*it).pos().x == far[1].x )
	continue;

      if( (*it).pos().y > far[0].y ) // check against top
        {
	  if( (*it).pos().x < top.x )
	    continue;

	  if( !far[2].valid() || far[2].x < (*it).pos().x )
	    far[2] = (*it).pos();
        }
      else // check against bottom
        {
	  if( (*it).pos().x < bottom.x )
	    continue;

	  if( !far[2].valid() || far[2].x < (*it).pos().x )
	    far[2] = (*it).pos();
        }
    }
  if( far[2].valid() )
    rcsc::dlog.addText( rcsc::Logger::TEAM,
			"%s:%d: far[2](%.0f, %.0f)"
			,__FILE__, __LINE__, far[2].x, far[2].y );
  else
    rcsc::dlog.addText( rcsc::Logger::TEAM,
			"%s:%d: far[2] invalid",
			__FILE__, __LINE__ );
  // far[3] identification
  for ( rcsc::PlayerCont::const_iterator it = opps.begin(); it != opps_end ; ++it )
    {
      if( (*it).goalie() == true || (*it).pos().x > 47.0
	  || (*it).pos().x > far[0].x
	  || (*it).pos().x == far[0].x
	  || (*it).pos().x == far[1].x 
	  || (*it).pos().x == far[2].x )
	continue;

      if( (*it).pos().y > far[0].y ) // check against top
        {
	  if( (*it).pos().x < top.x )
	    continue;

	  if( !far[3].valid() || far[3].x < (*it).pos().x )
	    far[3] = (*it).pos();
        }
      else // check against bottom
        {
	  if( (*it).pos().x < bottom.x )
	    continue;

	  if( !far[3].valid() || far[3].x < (*it).pos().x )
	    far[3] = (*it).pos();
        }
    }
  if( far[3].valid() )
    rcsc::dlog.addText( rcsc::Logger::TEAM,
			"%s:%d: far[3](%.0f, %.0f)"
			,__FILE__, __LINE__, far[3].x, far[3].y );
  else
    rcsc::dlog.addText( rcsc::Logger::TEAM,
			"%s:%d: far[3] invalid",
			__FILE__, __LINE__ );

    
  // sort based on y-axis
  rcsc::Vector2D tmp_2D;
  for( int i = 0 ; i < 3 ; i++ )
    {
      for( int j = i + 1 ; j < 4 ; j++ )
        {
	  if( !far[i].valid() )
	    {
	      tmp_2D = far[i];
	      far[i] = far[j];
	      far[j] = tmp_2D;
	      far[j].invalidate();
	    }
	  else if( far[j].valid() && far[i].y < far[j].y )
	    {
	      tmp_2D = far[i];
	      far[i] = far[j];
	      far[j] = tmp_2D;
	    }
        }
    }

  for( int i = 0 ; i < 4 ; i++ )
    {
      if( far[i].valid() )
	rcsc::dlog.addText( rcsc::Logger::TEAM,
			    "%s:%d: sorted far[%d](%.0f, %.0f)"
			    ,__FILE__, __LINE__, i, far[i].x, far[i].y );
      else
	rcsc::dlog.addText( rcsc::Logger::TEAM,
			    "%s:%d: sorted far[%d] invaliid"
			    ,__FILE__, __LINE__, i );
    }


  // add lines
  for( int i = 3 ; i > 0 ; i-- )
    {
      if( !far[i].valid() )
	continue;
      agent->debugClient().addLine( far[i], far[i-1] );
    }

  for( int i = 0 ; i < 5 ; i++ )
    (*candidate)[i].invalidate();
  if( !far[0].valid() )
    return;
  (*candidate)[0].x = far[0].x;
  (*candidate)[0].y = (far[0].y + rcsc::ServerParam::i().pitchHalfWidth()) / 2.0;
  if( !far[1].valid() )
    {
      (*candidate)[1].x = far[0].x;
      (*candidate)[1].y = (far[0].y - rcsc::ServerParam::i().pitchHalfWidth()) / 2.0;
      return;
    }
  (*candidate)[1].x = (far[0].x + far[1].x) / 2.0;
  (*candidate)[1].y = (far[0].y + far[1].y) / 2.0;
  if( !far[2].valid() )
    {
      (*candidate)[2].x = far[1].x;
      (*candidate)[2].y = (far[1].y - rcsc::ServerParam::i().pitchHalfWidth()) / 2.0;
      return;
    }
  (*candidate)[2].x = (far[1].x + far[2].x) / 2.0;
  (*candidate)[2].y = (far[1].y + far[2].y) / 2.0;
  if( !far[3].valid() )
    {
      (*candidate)[3].x = far[2].x;
      (*candidate)[3].y = (far[2].y - rcsc::ServerParam::i().pitchHalfWidth()) / 2.0;
      return;
    }
  (*candidate)[3].x = (far[2].x + far[3].x) / 2.0;
  (*candidate)[3].y = (far[2].y + far[3].y) / 2.0;
  (*candidate)[4].x = far[3].x;
  (*candidate)[4].y = (far[3].y - rcsc::ServerParam::i().pitchHalfWidth()) / 2.0;

  for( int i = 0 ; i < 5 ; i++ )
    {
      if( !(*candidate)[i].valid() )
	break;
      rcsc::dlog.addText( rcsc::Logger::TEAM,
			  "%s:%d: candidate[%d](%.0f, %.0f)"
			  ,__FILE__, __LINE__, i, (*candidate)[i].x, (*candidate)[i].y );
    }

  return;
}
/*-------------------------------------------------------------------*/
/*!
  function for finding the opponent defense line
*/
void
Bhv_opuciOffensiveMove::findDefenseLine( rcsc::PlayerAgent * agent, std::vector<rcsc::Vector2D> *candidate, std::vector<rcsc::Vector2D> *oppline )
{
  std::vector <rcsc::Vector2D> far(4);
  far[0].invalidate();
  far[1].invalidate();
  far[2].invalidate();
  far[3].invalidate();
  rcsc::Vector2D top, bottom;
    
  const rcsc::PlayerCont opps = agent->world().opponents();
  const rcsc::PlayerCont::const_iterator opps_end = opps.end();
  for ( rcsc::PlayerCont::const_iterator it = opps.begin(); it != opps_end ; ++it )
    {
      if( (*it).goalie() == true 
	  || (*it).pos().x > 47.0 )
	continue;
      if( (*it).pos().x < agent->world().self().pos().x )
	continue;
        
      bool isvalid = false;
      for( rcsc::PlayerCont::const_iterator it2 = opps.begin() ; it2 != opps_end ; ++it2 )
        {
	  if( (*it).unum() == (*it2).unum() )
	    continue;
	  if( (*it).pos().x - (*it2).pos().x < 20 )
            {
	      isvalid = true;
	      break;
            }
        }
      if( isvalid )
        {
	  if( !far[0].valid() )
	    far[0] = (*it).pos();
	  else if( far[0].x < (*it).pos().x )
	    far[0] = (*it).pos();
        }
    }
  if( far[0].valid() )
    rcsc::dlog.addText( rcsc::Logger::TEAM,
			"%s:%d: far[0](%.0f, %.0f)"
			,__FILE__, __LINE__, far[0].x, far[0].y );
  else
    rcsc::dlog.addText( rcsc::Logger::TEAM,
			"%s:%d: far[0] invalid",
			__FILE__, __LINE__ );
  for ( rcsc::PlayerCont::const_iterator it = opps.begin(); it != opps_end ; ++it )
    {
      if( (*it).goalie() == true || (*it).pos().x > 47.0 )
	continue;
        
      if( far[0].valid() && far[0].x - (*it).pos().x < 15 
	  && far[0].x >= (*it).pos().x )
        {
	  if( !top.valid() || top.y < (*it).pos().y )
	    top = (*it).pos();
            
	  if( !bottom.valid() || bottom.y > (*it).pos().y )
	    bottom = (*it).pos();
        }
    }
  rcsc::dlog.addText( rcsc::Logger::TEAM,
		      "%s:%d: top(%.0f, %.0f), bottom(%.0f, %.0f)"
		      ,__FILE__, __LINE__, top.x, top.y, bottom.x, bottom.y );

  // far[1] identification
  for ( rcsc::PlayerCont::const_iterator it = opps.begin(); it != opps_end ; ++it )
    {
      if( (*it).goalie() == true || (*it).pos().x > 47.0
	  || (*it).pos().x > far[0].x
	  || (*it).pos().x == far[0].x)
	continue;

      if( (*it).pos().y > far[0].y ) // check against top
        {
	  if( (*it).pos().x < top.x )
	    continue;

	  if( !far[1].valid() || far[1].x < (*it).pos().x )
	    far[1] = (*it).pos();
        }
      else // check against bottom
        {
	  if( (*it).pos().x < bottom.x )
	    continue;

	  if( !far[1].valid() || far[1].x < (*it).pos().x )
	    far[1] = (*it).pos();
        }
    }
  if( far[1].valid() )
    rcsc::dlog.addText( rcsc::Logger::TEAM,
			"%s:%d: far[1](%.0f, %.0f)"
			,__FILE__, __LINE__, far[1].x, far[1].y );
  else
    rcsc::dlog.addText( rcsc::Logger::TEAM,
			"%s:%d: far[1] invalid",
			__FILE__, __LINE__ );

  // far[2] identification
  for ( rcsc::PlayerCont::const_iterator it = opps.begin(); it != opps_end ; ++it )
    {
      if( (*it).goalie() == true || (*it).pos().x > 47.0
	  || (*it).pos().x > far[0].x
	  || (*it).pos().x == far[0].x
	  || (*it).pos().x == far[1].x )
	continue;

      if( (*it).pos().y > far[0].y ) // check against top
        {
	  if( (*it).pos().x < top.x )
	    continue;

	  if( !far[2].valid() || far[2].x < (*it).pos().x )
	    far[2] = (*it).pos();
        }
      else // check against bottom
        {
	  if( (*it).pos().x < bottom.x )
	    continue;

	  if( !far[2].valid() || far[2].x < (*it).pos().x )
	    far[2] = (*it).pos();
        }
    }
  if( far[2].valid() )
    rcsc::dlog.addText( rcsc::Logger::TEAM,
			"%s:%d: far[2](%.0f, %.0f)"
			,__FILE__, __LINE__, far[2].x, far[2].y );
  else
    rcsc::dlog.addText( rcsc::Logger::TEAM,
			"%s:%d: far[2] invalid",
			__FILE__, __LINE__ );
  // far[3] identification
  for ( rcsc::PlayerCont::const_iterator it = opps.begin(); it != opps_end ; ++it )
    {
      if( (*it).goalie() == true || (*it).pos().x > 47.0
	  || (*it).pos().x > far[0].x
	  || (*it).pos().x == far[0].x
	  || (*it).pos().x == far[1].x 
	  || (*it).pos().x == far[2].x )
	continue;

      if( (*it).pos().y > far[0].y ) // check against top
        {
	  if( (*it).pos().x < top.x )
	    continue;

	  if( !far[3].valid() || far[3].x < (*it).pos().x )
	    far[3] = (*it).pos();
        }
      else // check against bottom
        {
	  if( (*it).pos().x < bottom.x )
	    continue;

	  if( !far[3].valid() || far[3].x < (*it).pos().x )
	    far[3] = (*it).pos();
        }
    }
  if( far[3].valid() )
    rcsc::dlog.addText( rcsc::Logger::TEAM,
			"%s:%d: far[3](%.0f, %.0f)"
			,__FILE__, __LINE__, far[3].x, far[3].y );
  else
    rcsc::dlog.addText( rcsc::Logger::TEAM,
			"%s:%d: far[3] invalid",
			__FILE__, __LINE__ );

    
  // sort based on y-axis
  rcsc::Vector2D tmp_2D;
  for( int i = 0 ; i < 3 ; i++ )
    {
      for( int j = i + 1 ; j < 4 ; j++ )
        {
	  if( !far[i].valid() )
	    {
	      tmp_2D = far[i];
	      far[i] = far[j];
	      far[j] = tmp_2D;
	      far[j].invalidate();
	    }
	  else if( far[j].valid() && far[i].y < far[j].y )
	    {
	      tmp_2D = far[i];
	      far[i] = far[j];
	      far[j] = tmp_2D;
	    }
        }
    }

  for( int i = 0 ; i < 4 ; i++ )
    {
      if( far[i].valid() ){
	rcsc::dlog.addText( rcsc::Logger::TEAM,
			    "%s:%d: sorted far[%d](%.0f, %.0f)"
			    ,__FILE__, __LINE__, i, far[i].x, far[i].y );
	(*oppline)[i] = far[i];
      }
      else{
	rcsc::dlog.addText( rcsc::Logger::TEAM,
			    "%s:%d: sorted far[%d] invaliid"
			    ,__FILE__, __LINE__, i );
	(*oppline)[i].invalidate();
      }
    }

  // add lines
  for( int i = 3 ; i > 0 ; i-- )
    {
      if( !far[i].valid() )
	continue;
      agent->debugClient().addLine( far[i], far[i-1] );
    }

  for( int i = 0 ; i < 5 ; i++ )
    (*candidate)[i].invalidate();
  if( !far[0].valid() )
    return;
  (*candidate)[0].x = far[0].x;
  (*candidate)[0].y = (far[0].y + rcsc::ServerParam::i().pitchHalfWidth()) / 2.0;
  if( !far[1].valid() )
    {
      (*candidate)[1].x = far[0].x;
      (*candidate)[1].y = (far[0].y - rcsc::ServerParam::i().pitchHalfWidth()) / 2.0;
      return;
    }
  (*candidate)[1].x = (far[0].x + far[1].x) / 2.0;
  (*candidate)[1].y = (far[0].y + far[1].y) / 2.0;
  if( !far[2].valid() )
    {
      (*candidate)[2].x = far[1].x;
      (*candidate)[2].y = (far[1].y - rcsc::ServerParam::i().pitchHalfWidth()) / 2.0;
      return;
    }
  (*candidate)[2].x = (far[1].x + far[2].x) / 2.0;
  (*candidate)[2].y = (far[1].y + far[2].y) / 2.0;
  if( !far[3].valid() )
    {
      (*candidate)[3].x = far[2].x;
      (*candidate)[3].y = (far[2].y - rcsc::ServerParam::i().pitchHalfWidth()) / 2.0;
      return;
    }
  (*candidate)[3].x = (far[2].x + far[3].x) / 2.0;
  (*candidate)[3].y = (far[2].y + far[3].y) / 2.0;
  (*candidate)[4].x = far[3].x;
  (*candidate)[4].y = (far[3].y - rcsc::ServerParam::i().pitchHalfWidth()) / 2.0;

  for( int i = 0 ; i < 5 ; i++ )
    {
      if( !(*candidate)[i].valid() )
	break;
      rcsc::dlog.addText( rcsc::Logger::TEAM,
			  "%s:%d: candidate[%d](%.0f, %.0f)"
			  ,__FILE__, __LINE__, i, (*candidate)[i].x, (*candidate)[i].y );
    }

  return;
}
/*-------------------------------------------------------------------*/
/*!
  function for finding the opponent around the focus point
*/
void
Bhv_opuciOffensiveMove::findSorroundings( rcsc::PlayerAgent * agent,
                                          std::vector<rcsc::Vector2D> *candidate,
                                          rcsc::Vector2D ball_pos )
{
    std::vector<rcsc::Vector2D> opp_sorrounding;
    const rcsc::PlayerPtrCont opps = agent->world().opponentsFromBall();
    if( opps.empty() )
        return;
    const rcsc::PlayerPtrCont::const_iterator opps_end = opps.end();
    for ( rcsc::PlayerPtrCont::const_iterator it = opps.begin(); it != opps_end ; ++it )
    {
        if( (*it)->goalie() == true 
            || (*it)->pos().dist( ball_pos ) > 25.0)
            continue;
        if( (*it)->pos().dist( ball_pos ) <= (*it)->playerTypePtr()->kickableArea()  )
            continue;

        bool valid_candidate = true;
        for( rcsc::PlayerPtrCont::const_iterator it2 = opps.begin(); it2 != opps_end ; ++it2 )
        {
            if( (*it)->unum() == (*it2)->unum() )
                continue;
            if( (*it2)->pos().dist( ball_pos ) <= (*it2)->playerTypePtr()->kickableArea()  )
                continue;
        
            if( ball_pos.x <= (*it)->pos().x )
            {
                if( ball_pos.y >= (*it)->pos().y )
                {
                    if( (*it2)->pos().x < (*it)->pos().x && (*it)->pos().y < (*it2)->pos().y 
                        && (*it2)->pos().x >= ball_pos.x && (*it2)->pos().y <= ball_pos.y )
                    {
                        valid_candidate = false;
                        break;
                    }
                }
                else
                {
                    if( (*it2)->pos().x < (*it)->pos().x && (*it)->pos().y > (*it2)->pos().y 
                        && (*it2)->pos().x >= ball_pos.x && (*it2)->pos().y >= ball_pos.y )
                    {
                        valid_candidate = false;
                        break;
                    }
                }
            }
            else if( ball_pos.y >= (*it)->pos().y )
            {
                if( (*it2)->pos().x > (*it)->pos().x && (*it)->pos().y < (*it2)->pos().y
                    && (*it2)->pos().x <= ball_pos.x && (*it2)->pos().y <= ball_pos.y ) 
                {
                    valid_candidate = false;
                    break;
                }
            }
            else
            {
                if( (*it2)->pos().x > (*it)->pos().x && (*it)->pos().y > (*it2)->pos().y 
                    && (*it2)->pos().x <= ball_pos.x && (*it2)->pos().y >= ball_pos.y )
                {
                    valid_candidate = false;
                    break;
                }
            }
        }
        if( valid_candidate )
            opp_sorrounding.push_back( (*it)->pos() );
        
    }
    if( opp_sorrounding.empty() )
        return;

    // sort opp_sorrounding clockwise from the focus point(ball)
    rcsc::Vector2D tmp_2D;
    for(unsigned int i = 0 ; i < opp_sorrounding.size() ; i++ )
    {
        rcsc::Vector2D b2i = opp_sorrounding[i] - ball_pos;
        for(unsigned int j = i + 1; j < opp_sorrounding.size() ; j++ )
        {
            rcsc::Vector2D b2j = opp_sorrounding[j] - ball_pos;
            if( b2i.th().degree() < b2j.th().degree() )
            {
                tmp_2D = opp_sorrounding[i];
                opp_sorrounding[i] = opp_sorrounding[j];
                opp_sorrounding[j] = tmp_2D;
                b2i = opp_sorrounding[i] - ball_pos;
            }
        }
    }
    // cut unnecessary sorrounding
    for(std::vector<rcsc::Vector2D>::iterator it = opp_sorrounding.begin();
        it != opp_sorrounding.end() ;
        it++ )
    {
        if( it == opp_sorrounding.begin() || it == (opp_sorrounding.end()-1) )
            continue;

        rcsc::Vector2D i2pre = *(it-1) - *it;
        rcsc::Vector2D i2next = *(it+1) - *it;
        i2next.rotate( -i2pre.th() );
        if( std::fabs( i2next.th().degree() ) < 20.0 )
        {
            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                "%s:%d: erased unnecessary sorrounding (%.0f, %.0f) %.0f degree"
                                ,__FILE__, __LINE__, it->x, it->y, i2next.th().degree() );
            opp_sorrounding.erase( it );
            it--;
            it--;
        }            
    }


    // show ball and opp_sorrounding
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: ball_pos(%.0f, %.0f)"
                        ,__FILE__, __LINE__, ball_pos.x, ball_pos.y );
    for(unsigned int i = 0 ; i < opp_sorrounding.size() ; i++ )
    {
        tmp_2D = opp_sorrounding[i] - ball_pos;
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: opp_sorrounding[%d](%.0f, %.0f), %.0f degree"
                            ,__FILE__, __LINE__, i, opp_sorrounding[i].x, opp_sorrounding[i].y
                            , tmp_2D.th().degree() );
    }

    // add lines and candidate generation
    for(unsigned int i = 0 ; i < opp_sorrounding.size()-1 ; i++ )
    {
        agent->debugClient().addLine( opp_sorrounding[i], opp_sorrounding[i+1] );

        tmp_2D = (opp_sorrounding[i] + opp_sorrounding[i+1])/2;
        candidate->push_back(tmp_2D);
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: gererated candidate[%d](%.0f, %.0f)"
                            ,__FILE__, __LINE__, i, (*candidate)[i].x, (*candidate)[i].y );
    }
    
    return;
}
