// -*-c++-*-

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "bhv_basic_move.h"
#include "bhv_opuci_shootchance_move.h"
#include "bhv_basic_tackle.h"

#include <rcsc/action/basic_actions.h>
#include <rcsc/action/body_go_to_point.h>
#include <rcsc/action/body_intercept.h>
#include <rcsc/action/neck_turn_to_ball_or_scan.h>
#include <rcsc/action/neck_turn_to_low_conf_teammate.h>
#include <rcsc/action/neck_turn_to_point.h>
#include "neck_opuci_turn_to_next_receiver.h"

#include <rcsc/player/player_agent.h>
#include <rcsc/player/debug_client.h>
#include <rcsc/player/intercept_table.h>

#include <rcsc/common/logger.h>
#include <rcsc/common/server_param.h>
#include "strategy.h"
#include "bhv_opuci_offensive_move.h"

/*-------------------------------------------------------------------*/
/*!
  execute action
*/
bool
Bhv_opuciShootChanceMove::execute( rcsc::PlayerAgent * agent )
{
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: Bhv_opuciOffensiveMove"
                        ,__FILE__, __LINE__ );

    // tackle

    if ( Bhv_BasicTackle( 0.9, 80.0 ).execute( agent ) )
    {
        return true;
    }

    const rcsc::WorldModel & wm = agent->world();

    // check ball owner

    int self_min = wm.interceptTable()->selfReachCycle();
    int mate_min = wm.interceptTable()->teammateReachCycle();
    int opp_min = wm.interceptTable()->opponentReachCycle();

    // check nearest opponent
    const rcsc::PlayerPtrCont & opps = wm.opponentsFromSelf();
    const rcsc::PlayerObject * nearest_opp
        = ( opps.empty()
            ? static_cast< rcsc::PlayerObject * >( 0 )
            : opps.front() );
    const double nearest_opp_dist = ( nearest_opp
                                      ? nearest_opp->distFromSelf()
                                      : 1000.0 );
    const rcsc::Vector2D nearest_opp_pos = ( nearest_opp
                                             ? nearest_opp->pos()
                                             : rcsc::Vector2D( -1000.0, 0.0 ) );

    if ( ! wm.existKickableTeammate()
         && 
         ( self_min <= 3 || self_min < mate_min + 3 )
        )
        /*bhv_basic_move
          if ( ! wm.existKickableTeammate()
          && ( self_min <= 3
          || ( self_min < mate_min + 3
          && self_min < opp_min + 4 )
          )
          )*/
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: intercept"
                            ,__FILE__, __LINE__ );
        rcsc::Body_Intercept2008().execute( agent );
	if( wm.ball().posCount() < 2 )
        {
            if( wm.getOpponentGoalie() )
            {
                if( wm.getOpponentGoalie()->posCount() < 3 )
                {
                    agent->setNeckAction( new rcsc::Neck_OpuciTurnToNextReceiver() );
                    agent->debugClient().addMessage( "LookTeammate" );
                }
                else
                {
                    agent->setNeckAction( new rcsc::Neck_TurnToPoint( wm.getOpponentGoalie()->pos() ) );
                    agent->debugClient().addMessage( "LookOpponentGoalie" );
                }
            }
            else
            {
                agent->setNeckAction( new rcsc::Neck_TurnToBallOrScan() );
            }
        }
        else if ( wm.ball().distFromSelf()
                  < rcsc::ServerParam::i().visibleDistance() )
        {
            agent->setNeckAction( new rcsc::Neck_TurnToLowConfTeammate() );
        }
        else
        {
            agent->setNeckAction( new rcsc::Neck_TurnToBallOrScan() );
        }
        return true;
    }

    // go to home position

    double dist_thr = wm.ball().distFromSelf() * 0.1;
    if ( dist_thr < 1.0 ) dist_thr = 1.0;


    rcsc::Vector2D target_pos = M_home_pos;
#if 1
    if( mate_min > self_min && opp_min > self_min && !wm.existKickableTeammate() )
      target_pos = wm.ball().pos();
    else if( !wm.existKickableOpponent() 
        || mate_min <= opp_min )
    {
        const rcsc::PlayerObject * passer = wm.getTeammateNearestToBall( 10, false );
        rcsc::Vector2D passer_pos;
        bool found = false;
        if( passer )
        {
            passer_pos = passer->pos();
            found = true;
        }
        else
        {
            const rcsc::PlayerObject * near = wm.getTeammateNearestToSelf( 10, false );
            if( near )
            {
                passer_pos = near->pos();
                found = true;
            }
        }
        if( found )
        {
            rcsc::Vector2D top_left( 35, -20);
            rcsc::Vector2D bottom_right( 52, 20 );
            if( passer_pos.y < M_home_pos.y ) //paser is upper
            {
                top_left.y = passer_pos.y;
                bottom_right.y = M_home_pos.y;
            }
            else
            {
                top_left.y = M_home_pos.y;
                bottom_right.y = passer_pos.y;
            }
            rcsc::Rect2D rect( top_left, bottom_right );
            agent->debugClient().addRectangle( rect );
            std::vector< rcsc::Vector2D > opponents;
            rcsc::PlayerPtrCont::const_iterator opp_end = wm.opponentsFromSelf().end();
            for( rcsc::PlayerPtrCont::const_iterator it = wm.opponentsFromSelf().begin();
                 it != opp_end;
                 ++it )
            {
                if( rect.contains( (*it)->pos() ) )
                {
                    opponents.push_back( (*it)->pos() );
                }
            }
            if( !opponents.empty() )
            {
                double min = 30;
                int num = 0;
                for( unsigned int i = 0; i < opponents.size(); i++ )
                {
                    if( opponents.at( i ).dist( passer_pos ) < min )
                    {
                        min = opponents.at( i ).dist( passer_pos );
                        num = i;
                    }
                }
                rcsc::Vector2D mark = opponents.at( num );
                agent->debugClient().addCircle( mark, 1.5 );
                std::vector< rcsc::Vector2D > others;
                for( unsigned int i = 0; i < opponents.size(); i++ )
                {
                    if( i != num )
                    {
                        others.push_back( opponents.at( i ) );
                    }
                }
                if( others.empty() )
                {
                    target_pos.x = mark.x - 5;
                    target_pos.y = mark.y;
                }
                else
                {
                    min = 30;
                    num = 0;
                    for( unsigned int i = 0; i < others.size(); i++ )
                    {
                        if( others.at( i ).dist( mark ) < min )
                        {
                            min = others.at( i ).dist( mark );
                            num = i;
                        }
                    }
                    if( others.at( num ).x > mark.x )
                    {
                        target_pos.x = mark.x + ( others.at( num ).x - mark.x ) / 2.0;
                    }
                    else
                    {
                        target_pos.x = others.at( num ).x + ( mark.x - others.at( num ).x ) / 2.0;
                    }
                    agent->debugClient().addCircle( others.at( num ), 1.5 );
                }
            }//end if opponent
        }//end if found
    }
    else
    {
      agent->debugClient().addMessage( "DPassPosKicker" );
      std::vector<rcsc::Vector2D> candidate2;
      Bhv_opuciOffensiveMove::findSorroundings( agent, &candidate2, wm.ball().pos() );
      double min_dist = rcsc::ServerParam::i().pitchLength()*100.0; //very large
      for( std::vector<rcsc::Vector2D>::iterator it = candidate2.begin();
	   it != candidate2.end() ; it++ )
	{
	  if( it->dist( M_home_pos ) < min_dist )
	    {
	      min_dist = it->dist( M_home_pos );
	      target_pos = (*it) * 0.8 + M_home_pos * 0.2;
	    }
	}
    }
#endif

    const double dash_power = getDashPower( agent, target_pos );
    agent->debugClient().addMessage( " OpuciShootMove%.0f", dash_power );
    agent->debugClient().addCircle( M_home_pos, 2 );
    agent->debugClient().setTarget( target_pos );

    if ( ! rcsc::Body_GoToPoint( target_pos, dist_thr, dash_power
             ).execute( agent ) )
    {
        rcsc::Body_TurnToBall().execute( agent );
    }

    if( wm.ball().posCount() < 2 )
    {
        if( wm.getOpponentGoalie() )
        {
            if( wm.getOpponentGoalie()->posCount() < 3 )
            {
                agent->setNeckAction( new rcsc::Neck_OpuciTurnToNextReceiver() );
                agent->debugClient().addMessage( "LookTeammate" );
            }
            else
            {
                agent->setNeckAction( new rcsc::Neck_TurnToPoint( wm.getOpponentGoalie()->pos() ) );
                agent->debugClient().addMessage( "LookOpponentGoalie" );
            }
        }
        else
        {
            agent->setNeckAction( new rcsc::Neck_TurnToBallOrScan() );
        }
    }
    else if ( wm.existKickableOpponent()
              && wm.ball().distFromSelf() < 18.0 )
    {
	agent->setNeckAction( new rcsc::Neck_TurnToBall() );
    }
    else
    {
	agent->setNeckAction( new rcsc::Neck_TurnToBallOrScan() );
    }

    return true;
}

/*-------------------------------------------------------------------*/
/*!

 */
double
Bhv_opuciShootChanceMove::getDashPower( const rcsc::PlayerAgent * agent,
					const rcsc::Vector2D & target_point )
{
    static bool s_recover_mode = false;

    const rcsc::WorldModel & wm = agent->world();
    /*--------------------------------------------------------*/
    // check recover

    if ( wm.self().stamina() < rcsc::ServerParam::i().staminaMax() * 0.5 )
    {
        s_recover_mode = true;
    }
    else if ( wm.self().stamina() > rcsc::ServerParam::i().staminaMax() * 0.7 )
    {
        s_recover_mode = false;
    }

    /*--------------------------------------------------------*/
    double dash_power = rcsc::ServerParam::i().maxDashPower();
    const double my_inc
        = wm.self().playerType().staminaIncMax()
        * wm.self().recovery();

    int self_min = wm.interceptTable()->selfReachCycle();
    int mate_min = wm.interceptTable()->teammateReachCycle();
    int opp_min = wm.interceptTable()->opponentReachCycle();

    if (( wm.defenseLineX() > wm.self().pos().x
	  && wm.ball().pos().x < wm.defenseLineX() + 20.0 )
        ||
	( wm.ball().pos().x - wm.self().pos().x > 10.0 
	  && ! wm.existKickableOpponent() )
        ||
	wm.ball().pos().x > 40.0 )
        /*bhv_basic_move
          if ( wm.defenseLineX() > wm.self().pos().x
          && wm.ball().pos().x < wm.defenseLineX() + 20.0 )*/
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            __FILE__": correct DF line. keep max power" );
        // keep max power
        dash_power = rcsc::ServerParam::i().maxDashPower();
    }
    else if ( ! wm.existKickableTeammate()
              && opp_min < self_min
              && opp_min < mate_min
              && target_point.x < wm.self().pos().x
              && target_point.x < -25.0
              && wm.ball().inertiaPoint( opp_min ).x < -25.0 )
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            __FILE__": defense dash" );
        dash_power = rcsc::ServerParam::i().maxDashPower();
    }
    else if ( wm.ball().pos().x > 30.0 )
    {
        std::min( my_inc * 1.3, rcsc::ServerParam::i().maxPower() * 0.6 );
    }
    else if ( s_recover_mode )
    {
        dash_power = my_inc - 25.0; // preffered recover value
        if ( dash_power < 0.0 ) dash_power = 0.0;

        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            __FILE__": recovering" );
    }
    // exist kickable teammate
    else if ( wm.existKickableTeammate()
              && wm.ball().distFromSelf() < 10.0 )
        /*bhv_basic_move
          else if ( wm.existKickableTeammate()
          && wm.ball().distFromSelf() < 20.0 )*/
    {
        dash_power = std::min( my_inc * 1.1,
                               rcsc::ServerParam::i().maxDashPower() );
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            __FILE__": exist kickable teammate. dash_power=%.1f",
                            dash_power );
    }
    // in offside area
    else if ( wm.self().pos().x > wm.offsideLineX() )
    {
        dash_power = rcsc::ServerParam::i().maxDashPower();
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            __FILE__": in offside area. dash_power=%.1f",
                            dash_power );
    }
    // normal
    // normal
    else
    {
        dash_power = std::min( my_inc * 1.1,
                               rcsc::ServerParam::i().maxPower() );
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: normal mode dash_power= %f"
                            ,__FILE__, __LINE__,
                            dash_power );
    }
    /*bhv_basic_move
      else
      {
      dash_power = std::min( my_inc * 1.7,
      rcsc::ServerParam::i().maxDashPower() );
      rcsc::dlog.addText( rcsc::Logger::TEAM,
      __FILE__": normal mode dash_power=%.1f",
      dash_power );
      }*/
    if( target_point.dist( wm.self().pos() ) > 1.0 
        && opp_min > mate_min )
    {
        dash_power = rcsc::ServerParam::i().maxDashPower();
    }
    return dash_power;
}
