// -*-c++-*-

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "bhv_pre_process.h"
#include "bhv_opuci_shoot.h"
#include "strategy.h"

#include <rcsc/action/basic_actions.h>
#include <rcsc/action/bhv_before_kick_off.h>
#include <rcsc/action/bhv_emergency.h>
#include <rcsc/action/body_go_to_point.h>
#include <rcsc/action/body_intercept.h>
#include <rcsc/action/body_kick_one_step.h>
#include <rcsc/action/body_turn_to_angle.h>
#include <rcsc/action/bhv_shoot.h>
#include <rcsc/action/neck_scan_field.h>
#include <rcsc/action/neck_turn_to_ball_or_scan.h>
#include <rcsc/action/neck_turn_to_low_conf_teammate.h>
#include <rcsc/action/neck_turn_to_point.h>
#include "neck_opuci_turn_to_next_receiver.h"
#include "bhv_danger_area_tackle.h"
#include <rcsc/action/view_synch.h>

#include <rcsc/player/player_agent.h>
#include <rcsc/player/intercept_table.h>
#include <rcsc/player/debug_client.h>

#include <rcsc/common/audio_memory.h>
#include <rcsc/common/logger.h>
#include <rcsc/common/server_param.h>
#include <rcsc/geom/ray_2d.h>
#include <rcsc/soccer_math.h>
#include <rcsc/action/obsolete/body_intercept2007.h>
/*-------------------------------------------------------------------*/
/*!
  execute action
*/
bool
Bhv_PreProcess::execute( rcsc::PlayerAgent * agent )
{
  static bool forceReceive = false;
  static long startTime = -1;
  rcsc::dlog.addText( rcsc::Logger::TEAM,
		      "%s:%d: Bhv_PreProcess"
		      ,__FILE__, __LINE__ );

  //////////////////////////////////////////////////////////////
  // freezed by tackle effect
  if ( agent->world().self().isFreezed() )
    {
      rcsc::dlog.addText( rcsc::Logger::TEAM,
			  "%s:%d: tackle wait. expires= %d"
			  ,__FILE__, __LINE__,
			  agent->world().self().tackleExpires() );
      // face neck to ball
      agent->setViewAction( new rcsc::View_Synch() );
      agent->setNeckAction( new rcsc::Neck_TurnToBallOrScan() );
      return true;
    }

  //////////////////////////////////////////////////////////////
  // BeforeKickOff or AfterGoal. should jump to the initial position
  if ( agent->world().gameMode().type() == rcsc::GameMode::BeforeKickOff
       || agent->world().gameMode().type() == rcsc::GameMode::AfterGoal_ )
    {
      rcsc::dlog.addText( rcsc::Logger::TEAM,
			  "%s:%d: before_kick_off"
			  ,__FILE__, __LINE__ );
      rcsc::Vector2D move_point = M_strategy.getBeforeKickOffPos( agent->config().playerNumber() );
      //agent->setViewAction( new rcsc::View_Synch() );
      agent->setViewAction( new rcsc::View_Wide() );
      rcsc::Bhv_BeforeKickOff( move_point ).execute( agent );
      return true;
    }

  //////////////////////////////////////////////////////////////
  // my pos is unknown
  if ( ! agent->world().self().posValid() )
    {
      rcsc::dlog.addText( rcsc::Logger::TEAM,
			  "%s:%d: invalid my pos"
			  ,__FILE__, __LINE__ );
      // included change view
      rcsc::Bhv_Emergency().execute( agent );
      return true;
    }
  //////////////////////////////////////////////////////////////
  // ball search
  // included change view
  int count_thr = 5;
  if ( agent->world().self().goalie() ) count_thr = 10;
  if ( agent->world().ball().posCount() > count_thr )
    //|| agent->world().ball().rposCount() > count_thr + 3 )
    {
      agent->debugClient().addMessage( "BallPosCount%d,rPosCount%d", 
				       agent->world().ball().posCount(),
				       agent->world().ball().rposCount() );
      rcsc::dlog.addText( rcsc::Logger::TEAM,
			  "%s:%d: search ball"
			  ,__FILE__, __LINE__ );
      //agent->setViewAction( new rcsc::View_Synch() );
      //agent->setViewAction( new rcsc::View_Wide() );
      rcsc::Bhv_NeckBodyToBall().execute( agent );
      return true;
    }

  //////////////////////////////////////////////////////////////
  // default change view

  agent->setViewAction( new rcsc::View_Synch() );


  //////////////////////////////////////////////////////////////
  // check queued action
  if ( agent->doIntention() )
    {
      rcsc::dlog.addText( rcsc::Logger::TEAM,
			  "%s:%d: do queued intention"
			  ,__FILE__, __LINE__ );
      return true;
    }

  //////////////////////////////////////////////////////////////
  // check shoot chance
  if ( agent->world().gameMode().type() != rcsc::GameMode::IndFreeKick_
       && agent->world().self().isKickable()
       && rcsc::Bhv_Shoot2008().execute( agent ) )
    {
      rcsc::dlog.addText( rcsc::Logger::TEAM,
			  __FILE__": shooted" );

      // reset intention
      agent->setIntention( static_cast< rcsc::SoccerIntention * >( 0 ) );
      return true;
    }

  //////////////////////////////////////////////////////////////
  // tackle when in real danger
  if ( Strategy::get_ball_area( agent->world().ball().pos() ) == Strategy::BA_Danger &&  Bhv_DangerAreaTackle(0.75).execute( agent ) )
    {
      rcsc::dlog.addText( rcsc::Logger::TEAM,
			  __FILE__": emergency tackle" );

      // reset intention
      agent->setIntention( static_cast< rcsc::SoccerIntention * >( 0 ) );
      return true;
    }

  //////////////////////////////////////////////////////////////
  // check simultaneous kick
  if ( agent->world().gameMode().type() == rcsc::GameMode::PlayOn
       && ! agent->world().self().goalie()
       && agent->world().self().isKickable()
       && agent->world().existKickableOpponent() )
    {
      rcsc::dlog.addText( rcsc::Logger::TEAM,
			  "%s:%d: simultaneous kick"
			  ,__FILE__, __LINE__ );
      agent->debugClient().addMessage( "SimultaneousKick" );
      rcsc::Vector2D goal_pos( rcsc::ServerParam::i().pitchHalfLength(), 0.0 );

      if ( agent->world().self().pos().x > 36.0
	   && agent->world().self().pos().absY() > 10.0 )
        {
	  goal_pos.x = 45.0;
	  rcsc::dlog.addText( rcsc::Logger::TEAM,
			      "%s:%d: simultaneous kick cross type"
			      ,__FILE__, __LINE__ );
        }
      rcsc::Body_KickOneStep( goal_pos,
			      rcsc::ServerParam::i().ballSpeedMax()
			      ).execute( agent );
      agent->setNeckAction( new rcsc::Neck_ScanField() );
      return true;
    }

  //////////////////////////////////////////////////////////////
  // check communication intention
  if ( agent->world().audioMemory().passTime() == agent->world().time()
       && ! agent->world().audioMemory().pass().empty()
       && ( agent->world().audioMemory().pass().back().receiver_
	    == agent->world().self().unum() )
       )
    {
      forceReceive = true;
      startTime = agent->world().time().cycle();
    }
  const rcsc::WorldModel & wm = agent->world();
  static int passer_unum = 0;

  if( forceReceive == true )
    {
      rcsc::dlog.addText( rcsc::Logger::TEAM,
			  "%s:%d: forceReceive is true since %d-th cycle"
			  ,__FILE__, __LINE__, startTime );

      const rcsc::PlayerObject * passer = wm.getTeammateNearestToBall( 3 );
      rcsc::dlog.addText( rcsc::Logger::TEAM,
			  "%s:%d: possible passer: %d"
			  ,__FILE__, __LINE__, passer_unum );

      // check if you really can get the ball at receive_point
      rcsc::Vector2D receive_pos = wm.audioMemory().pass().back().receive_pos_;
      double min_rcvpos2ball = rcsc::ServerParam::i().pitchLength() * 2.0; // very large value
      double pre_rcvpos2ball = rcsc::ServerParam::i().pitchLength() * 2.0; // very large value
      rcsc::Vector2D simed_ball = wm.ball().pos();
      rcsc::Vector2D pre_simed_ball( rcsc::ServerParam::i().pitchLength() * 2.0,
				     rcsc::ServerParam::i().pitchLength() ); // unrealistic pos
      rcsc::Vector2D next_simed_ball = wm.ball().pos();
      double rcvpos2ball;
      bool inCheck = true;
      int elapsed_sim_time = 0;
      while( inCheck )
        {
	  rcvpos2ball = receive_pos.dist( simed_ball );
	  if( min_rcvpos2ball > rcvpos2ball )
	    min_rcvpos2ball = rcvpos2ball;

	  //check if the simulated ball passed you
	  if( pre_rcvpos2ball < rcvpos2ball )
	    inCheck = false;
	  //check if the simulated ball has almost stopped
	  else if( pre_simed_ball.dist( simed_ball ) < wm.self().playerType().kickableMargin() )
	    inCheck = false;

	  pre_rcvpos2ball = rcvpos2ball;
	  pre_simed_ball = simed_ball;
	  elapsed_sim_time++;
	  simed_ball = wm.ball().inertiaPoint( elapsed_sim_time );
        }
      rcsc::dlog.addText( rcsc::Logger::TEAM,
			  "%s:%d: elapsed simulated time was %d"
			  ,__FILE__, __LINE__, elapsed_sim_time - 1 );
      rcsc::dlog.addText( rcsc::Logger::TEAM,
			  "%s:%d: rcvpnt(%0.00f,%0.00f), min_rcvpos2ball = %f"
			  ,__FILE__, __LINE__, receive_pos.x, receive_pos.y, min_rcvpos2ball );
      rcsc::dlog.addText( rcsc::Logger::TEAM,
			  "%s:%d: my kickablemargin: %f, body size: %f, ball size: %f",
			  __FILE__, __LINE__, wm.self().playerType().kickableMargin(),
			  wm.self().playerType().playerSize(), rcsc::ServerParam::i().ballSize() );
      int self_min = agent->world().interceptTable()->selfReachCycle();
      if( (startTime + 5 < agent->world().time().cycle() && elapsed_sim_time -1 < 3 ) )
        {
	  agent->debugClient().addMessage( "earlyBadRcvPnt" );
	  rcsc::dlog.addText( rcsc::Logger::TEAM,
			      "%s:%d: elapsed_sim_time-1: %d, posCnt: %d, self_min: %d",
			      __FILE__, __LINE__, elapsed_sim_time-1, wm.ball().posCount(), self_min );
	  forceReceive = false;
        }


      if( wm.self().isKickable() )
	{
	  agent->debugClient().addMessage( "SelfKickable" );
	  forceReceive = false;
	}
      else if( wm.existKickableOpponent() )
	{
	  agent->debugClient().addMessage( "OpponentKickable" );
	  forceReceive = false;
            }
      else if( startTime + 10 < agent->world().time().cycle() 
	       || wm.existKickableTeammate() )
        {
	  /*
	    if( wm.existKickableTeammate() )
	    {
	    if( !passer || (passer && passer->unum() != passer_unum) )
	    {
	    agent->debugClient().addMessage( "MateSmrtKicking" );
	    forceReceive = false;
	    }
	    }
	  */
	  /*
	    if( wm.interceptTable()->teammateReachCycle() + 3 < wm.interceptTable()->selfReachCycle() )
	    {
	    agent->debugClient().addMessage( "yieldBall2Mate" );
	    forceReceive = false;
	    }
	  */

	  // check if the minimum distance is acceptable
	  if( min_rcvpos2ball > wm.self().kickableArea() || self_min > 20 )
            {
	      // check if you really can't catch the ball
	      rcsc::Line2D body_line( wm.self().pos(), wm.self().body() );
	      rcsc::Line2D ball_line( wm.ball().pos(), wm.ball().inertiaPoint( 1 ) );
	      rcsc::Vector2D cross_pnt = body_line.intersection( ball_line );

	      bool eval_finished = false;
	      if( !cross_pnt.valid() )
		{
		  agent->debugClient().addMessage( "NeverX" );
		  rcsc::dlog.addText( rcsc::Logger::TEAM,
				      "%s:%d: the ball trajectory never crosses the body line."
				      ,__FILE__, __LINE__ );
		  forceReceive = false;
		  eval_finished = true;
		}

	      double dist_pnt2ball = cross_pnt.dist( wm.ball().pos() );
	      double dist_pnt2agent = cross_pnt.dist( wm.self().pos() );
	      int elapsed_time = 1;
	      bool is_simulating = true;
	      rcsc::Vector2D simball;
	      rcsc::Vector2D simagent = wm.self().pos();
	      rcsc::Vector2D nmlzed_dash_dir = rcsc::Vector2D::from_polar( 1.0, wm.self().body() );
	      double current_effort = wm.self().effort();
	      double current_recovery = wm.self().recovery();
	      double current_stamina = wm.self().stamina();
	      double accel;
	      if( eval_finished == false )
		{
		  // simulation where you move forward only
		  while( is_simulating )
		    {
		      simball = wm.ball().inertiaPoint( elapsed_time );
		      accel = current_effort * wm.self().playerType().dashPowerRate() * rcsc::ServerParam::i().maxDashPower();
		      simagent += nmlzed_dash_dir.setLength( accel );
		      if( simball.dist( wm.ball().pos() ) > dist_pnt2ball 
			  && simagent.dist( wm.self().pos() ) < dist_pnt2agent )
			{
			  // the ball is faster than you
			  agent->debugClient().addMessage( "Can'tCatch(%d)", elapsed_time );      
			  forceReceive = false;
			  is_simulating = false;
			  eval_finished = true;
			}
		      else if( simball.dist( wm.ball().pos() ) < dist_pnt2ball
			       && simagent.dist( wm.self().pos() ) > dist_pnt2agent )
			{
			  // you can catch the ball
			  agent->debugClient().addMessage( "CanCatch!(%d)", elapsed_time );
			  forceReceive = true;
			  is_simulating = false;
			  eval_finished = true;
			}
		      else if( simball.dist( wm.ball().pos() ) > dist_pnt2ball
			       && simagent.dist( wm.ball().pos() ) > dist_pnt2ball )
			{
			  // you may think you can catch the ball
			  agent->debugClient().addMessage( "thinkCanCatch(%d)", elapsed_time );
			  forceReceive = true;
			  is_simulating = false;
			  eval_finished = true;
			}

		      // stamina update
		      current_stamina -= 100;
		      if( current_stamina <= rcsc::ServerParam::i().recoverDecThr() * rcsc::ServerParam::i().staminaMax() )
			{
			  if( current_recovery > rcsc::ServerParam::i().recoverMin() )
			    current_recovery -= rcsc::ServerParam::i().recoverDec();
			  if( current_recovery < rcsc::ServerParam::i().recoverMin() )
			    current_recovery = rcsc::ServerParam::i().recoverMin();
			}
		      if( current_stamina <= rcsc::ServerParam::i().effortDecThr() * rcsc::ServerParam::i().staminaMax() )
			{
			  if( current_effort > wm.self().playerType().effortMin() )
			    current_effort -= rcsc::ServerParam::i().effortDec();
			  if( current_effort < wm.self().playerType().effortMin() )
			    current_effort = wm.self().playerType().effortMin();
			}
		      if( current_stamina >= rcsc::ServerParam::i().effortIncThr() * rcsc::ServerParam::i().staminaMax() )
			{
			  if( current_effort < wm.self().playerType().effortMax() )
			    {
			      current_effort += rcsc::ServerParam::i().effortInc();
			      if( current_effort > wm.self().playerType().effortMax() )
				current_effort = wm.self().playerType().effortMax();
			    }
			}
		      current_stamina += current_recovery * wm.self().playerType().staminaIncMax();
		      elapsed_time++;
		      if(elapsed_time > 30)
			is_simulating = false;
		    }
		}

	      if( eval_finished == false )
		{
		  elapsed_time = 1;
		  is_simulating = true;
		  simagent = wm.self().pos();
		  current_effort = wm.self().effort();
		  current_stamina = wm.self().stamina();
		  // simulation where you just move backward
		  while( is_simulating )
		    {
		      simball = wm.ball().inertiaPoint( elapsed_time );
		      accel = -current_effort * wm.self().playerType().dashPowerRate() * rcsc::ServerParam::i().maxDashPower();
		      simagent += nmlzed_dash_dir.setLength( accel );
		      if( simball.dist( wm.ball().pos() ) > dist_pnt2ball 
			  && simagent.dist( wm.self().pos() ) < dist_pnt2agent )
			{
			  // the ball is faster than you
			  agent->debugClient().addMessage( "Can'tCatch2(%d)", elapsed_time );
			  forceReceive = false;
			  is_simulating = false;
			  eval_finished = true;
			}
		      else if( simball.dist( wm.ball().pos() ) < dist_pnt2ball
			       && simagent.dist( wm.self().pos() ) > dist_pnt2agent )
			{
			  // you can catch the ball
			  agent->debugClient().addMessage( "CanCatch2!(%d)", elapsed_time );
			  forceReceive = true;
			  is_simulating = false;
			  eval_finished = true;
			}
		      else if( simball.dist( wm.ball().pos() ) > dist_pnt2ball
			       && simagent.dist( wm.ball().pos() ) > dist_pnt2ball )
			{
			  // you may think you can catch the ball
			  agent->debugClient().addMessage( "thnkCanCatch2(%d)", elapsed_time );
			  forceReceive = true;
			  is_simulating = false;
			  eval_finished = true;
			}

		      // stamina update
		      current_stamina -= 200;
		      if( current_stamina <= rcsc::ServerParam::i().recoverDecThr() * rcsc::ServerParam::i().staminaMax() )
			{
			  if( current_recovery > rcsc::ServerParam::i().recoverMin() )
			    current_recovery -= rcsc::ServerParam::i().recoverDec();
			  if( current_recovery < rcsc::ServerParam::i().recoverMin() )
			    current_recovery = rcsc::ServerParam::i().recoverMin();
			}
		      if( current_stamina <= rcsc::ServerParam::i().effortDecThr() * rcsc::ServerParam::i().staminaMax() )
			{
			  if( current_effort > wm.self().playerType().effortMin() )
			    current_effort -= rcsc::ServerParam::i().effortDec();
			  if( current_effort < wm.self().playerType().effortMin() )
			    current_effort = wm.self().playerType().effortMin();
			}
		      if( current_stamina >= rcsc::ServerParam::i().effortIncThr() * rcsc::ServerParam::i().staminaMax() )
			{
			  if( current_effort < wm.self().playerType().effortMax() )
			    {
			      current_effort += rcsc::ServerParam::i().effortInc();
			      if( current_effort > wm.self().playerType().effortMax() )
				current_effort = wm.self().playerType().effortMax();
			    }
			}
		      current_stamina += current_recovery * wm.self().playerType().staminaIncMax();
		      elapsed_time++;
		      if( elapsed_time > 30 )
			is_simulating = false;
		    }
		}
	      if( eval_finished == false )
		{
		  agent->debugClient().addMessage( "giveUp" );
		  forceReceive = false;
		}
	    }
	}


      if( passer )
        {
	  passer_unum = passer->unum();
	  rcsc::dlog.addText( rcsc::Logger::TEAM,
			      "%s:%d: passer: %d, previous passer %d",
			      __FILE__, __LINE__, passer->unum(), passer_unum );
        }

      if( forceReceive == true )
        {
	  rcsc::dlog.addText( rcsc::Logger::TEAM,
			      "%s:%d: communication receive"
			      ,__FILE__, __LINE__ );
	  doReceiveMove( agent );
	  return true;
        }
    }
  if( forceReceive == false )
    passer_unum = 0;


  return false;
}


/*-------------------------------------------------------------------*/
/*!

 */
void
Bhv_PreProcess::doReceiveMove( rcsc::PlayerAgent * agent )
{

    const rcsc::WorldModel & wm = agent->world();
    int self_min = wm.interceptTable()->selfReachCycle();
    int opp_min = wm.interceptTable()->opponentReachCycle();
    bool rcv_modified = false;
    int expected_reachtime = 0;

    agent->debugClient().addMessage( "IntentionRecv%d", self_min );

    rcsc::Vector2D receive_pos = wm.audioMemory().pass().back().receive_pos_;
    if( self_min > 30 && (33 < receive_pos.x && receive_pos.x < 35) )
      {
	// check if you really can't catch the ball
	rcsc::Line2D ball_line( wm.ball().pos(), wm.ball().inertiaPoint( 1 ) );
	rcsc::Vector2D cross_pnt = ball_line.projection( wm.self().pos() );
	
	if( !cross_pnt.valid() )
	  {
	    agent->debugClient().addMessage( "NeverX" );
	    rcsc::dlog.addText( rcsc::Logger::TEAM,
				"%s:%d: the ball trajectory never crosses the body line."
				,__FILE__, __LINE__ );
	  }
	else
	  {
	    receive_pos = cross_pnt;
	    rcv_modified = true;
	    agent->debugClient().addMessage( "RcvPntModfd" );
	    rcsc::dlog.addText( rcsc::Logger::TEAM,
				"%s:%d: modified receive point (%.00f, %.00f)"
				,__FILE__, __LINE__, receive_pos.x, receive_pos.y );
	    double sim_travel = 0.0;
	    double sim_vel = 0.0;
	    while( sim_travel < receive_pos.dist( wm.self().pos() ) ){
	      sim_vel += wm.self().playerType().dashPowerRate() * 100;
	      if( sim_vel > wm.self().playerType().playerSpeedMax() )
		sim_vel = wm.self().playerType().playerSpeedMax();
	      sim_travel += sim_vel;
	      sim_vel *= wm.self().playerType().playerDecay();
	      expected_reachtime++;
	    }
	  }
      }

    if ( ( ! wm.existKickableTeammate()
           && self_min < 3 )
         || wm.audioMemory().pass().empty() 
	 || rcv_modified == false )
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: PreProcess. Receiver. intercept cycle=%d"
                            ,__FILE__, __LINE__,
                            self_min );
        agent->debugClient().addMessage( "Intercept_1" );
        rcsc::Body_Intercept2008().execute( agent );

	//if( Strategy::get_ball_area( wm.ball().pos() ) == Strategy::BA_ShootChance
	//    || Strategy::get_ball_area( wm.ball().pos() ) == Strategy::BA_Cross )
        //{
	    if( wm.ball().velCount() < 2 )
            {
	      agent->setNeckAction( new rcsc::Neck_OpuciTurnToNextReceiver() );
	      /*
                if( wm.getOpponentGoalie() )
		{
                    if( wm.getOpponentGoalie()->posCount() < 3 )
                    {
                        agent->setNeckAction( new rcsc::Neck_OpuciTurnToNextReceiver() );
                        agent->debugClient().addMessage( "LookTeammate" );
                    }
                    else
                    {
                        agent->setNeckAction( new rcsc::Neck_TurnToPoint( wm.getOpponentGoalie()->pos() ) );
                        agent->debugClient().addMessage( "LookOpponentGoalie" );
                    }
                }
                else
                {
                    agent->setNeckAction( new rcsc::Neck_TurnToPoint( rcsc::ServerParam::i().theirTeamGoalPos() ) );
                    agent->debugClient().addMessage( "LookOpponentGoalPos" );
                }
	      */
            }
            else
            {
                agent->setNeckAction( new rcsc::Neck_TurnToBall() );
            }
	    //}
	    //else
	    //{
	    //agent->setNeckAction( new rcsc::Neck_TurnToBall() );
	    //}

        return;
    }


    rcsc::Vector2D future_ball = rcsc::inertia_n_step_point( wm.ball().pos(),
                                                             wm.ball().vel(),
                                                             10,
                                                             rcsc::ServerParam::i().ballDecay() );
    rcsc::Circle2D circle( receive_pos, wm.self().playerType().kickableArea() * 0.9 );
    
    rcsc::Line2D line( wm.ball().pos(), future_ball );
    if( !wm.existKickableTeammate()
        && wm.ball().velCount() < 1
        )
    {

    }
/*
    int cycle = 10;
    bool back = false;
    double dist_thr = 2.0; 
    if( receive_pos.dist( wm.self().pos() ) < dist_thr 
        && receive_pos.x < wm.self().pos().x )
    {
        back = true; //danger
        agent->debugClient().addMessage( "CanBack" );
    }
*/
    if( rcv_modified == true )
      self_min = expected_reachtime;
    if( rcsc::Body_GoToPoint( receive_pos,
                              0.5,
                              rcsc::ServerParam::i().maxDashPower(),
			      self_min,
			      false,
			      false,
			      20.0 
            ).execute( agent ) )
        {
            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                "%s:%d: PreProcess. Receiver. intercept cycle=%d. go to receive point(%.0f, %.0f"
                                ,__FILE__, __LINE__,
                                self_min, receive_pos.x, receive_pos.y );
            agent->debugClient().setTarget( receive_pos );
            agent->debugClient().addMessage( "Go2rcvPos" );
        }
    else
    {
        // already there. turn to the opponent side
        rcsc::AngleDeg tgt_ad = agent->world().ball().rpos().th();
        if( agent->world().time().cycle() % 3 == 0 )
            tgt_ad += 110;
        else if( agent->world().time().cycle() % 3 == 1 )
            tgt_ad -= 110;
        if( tgt_ad.degree() > 180 ) tgt_ad -= (int)((tgt_ad.degree()+180)/360) * 360.0;
        else if( tgt_ad.degree() < -180 ) tgt_ad += (int)((tgt_ad.degree()-180)/360) * 360;
        rcsc::Body_TurnToAngle( tgt_ad ).execute( agent );
        agent->debugClient().addMessage( "Turn%0.1f", tgt_ad.degree() );
    }
    agent->setNeckAction( new rcsc::Neck_OpuciTurnToNextReceiver() );

    return;
}

