// -*-c++-*-

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "bhv_set_play_kick_in.h"

#include "bhv_set_play.h"
#include "bhv_prepare_set_play_kick.h"

#include <rcsc/action/basic_actions.h>
#include <rcsc/action/body_advance_ball.h>
#include <rcsc/action/body_go_to_point.h>
#include <rcsc/action/body_kick_one_step.h>
#include <rcsc/action/body_kick_collide_with_ball.h>
#include <rcsc/action/body_pass.h>
#include <rcsc/action/neck_scan_field.h>

#include <rcsc/player/player_agent.h>
#include <rcsc/player/debug_client.h>

#include <rcsc/common/logger.h>
#include <rcsc/common/server_param.h>

#include <rcsc/player/say_message_builder.h>
#include <rcsc/math_util.h>
#include <math.h>
#include <rcsc/geom/polygon_2d.h>
#include <rcsc/geom/rect_2d.h>
#include <rcsc/action/neck_turn_to_low_conf_teammate.h>

bool Bhv_SetPlayKickIn::reachedBase = false;
/*-------------------------------------------------------------------*/
/*!
  execute action
*/
bool
Bhv_SetPlayKickIn::execute( rcsc::PlayerAgent * agent )
{
    rcsc::dlog.addText( rcsc::Logger::TEAM,
                        "%s:%d: Bhv_SetPlayKickIn"
                        ,__FILE__, __LINE__ );
    const rcsc::WorldModel & wm = agent->world();
    thrX = 33.0;
    if( wm.ball().pos().x >= thrX )
    {
       if( wm.ball().pos().y > 0 
           && wm.self().unum() == 8 )
       {
	  doKick( agent );
       }
       else if( wm.ball().pos().y < 0 
                && wm.self().unum() == 7 )
       {
	  doKick( agent );
       }
       else
       {
	  doMove( agent );
       }
       return true;
    }
    if ( isKicker( agent ) )
    {
        doKick( agent );
    }
    else
    {
        doMove( agent );
    }

    return true;
}

/*-------------------------------------------------------------------*/
/*!

*/
bool
Bhv_SetPlayKickIn::isKicker( const rcsc::PlayerAgent * agent )
{
    const rcsc::WorldModel & wm = agent->world();

    if ( wm.teammatesFromBall().empty() )
    {
        return true;
    }

    long max_wait1 = 30;
    long max_wait2 = 50;

    const rcsc::PlayerObject * nearest_mate
        = static_cast< rcsc::PlayerObject * >( 0 );
    nearest_mate = wm.teammatesFromBall().front();

    if ( wm.setplayCount() < max_wait1
         || ( wm.setplayCount() < max_wait2
              && wm.self().pos().dist( M_home_pos ) > 20.0 )
         || ( nearest_mate
              && nearest_mate->distFromBall() < wm.ball().distFromSelf() * 0.9 )
         )
    {
        return false;
    }

    return true;
}

/*-------------------------------------------------------------------*/
/*!

*/
void
Bhv_SetPlayKickIn::doKick( rcsc::PlayerAgent * agent )
{
    const rcsc::WorldModel & wm = agent->world();

    rcsc::AngleDeg ball_place_angle = ( wm.ball().pos().y > 0.0
                                        ? -90.0
                                        : 90.0 );

    if ( Bhv_PrepareSetPlayKick( ball_place_angle, 20 ).execute( agent ) )
    {
        agent->debugClient().addMessage( "MoveToBall" );
        reachedBase = false;
        // go to kick point
        return;
    }


    rcsc::Vector2D target_point;
    double ball_speed;
    int receiver = rcsc::Unum_Unknown;

    if( wm.ball().pos().x >= thrX 
        && wm.self().unum() >= 7 )
    {
       target_point = getKickPos( agent, receiver );
       double dist = target_point.dist( wm.ball().pos() );
       ball_speed = getBestSpeed( dist );
       rcsc::Body_KickOneStep( target_point, ball_speed ).execute( agent );
       agent->setNeckAction( new rcsc::Neck_ScanField() );

    }
/*
    else if  ( rcsc::Body_Pass::get_best_pass( wm,
                                          & target_point,
                                          & ball_speed,
                                          & receiver )
          && target_point.x > -25.0
          && target_point.x < 48.0 )
    {
        // enforce one step kick
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: pass to (%f, %f)"
                            ,__FILE__, __LINE__,
                            target_point.x, target_point.y );
        rcsc::Body_KickOneStep( target_point,
                                ball_speed
                                ).execute( agent );
        agent->setNeckAction( new rcsc::Neck_ScanField() );
	agent->debugClient().addMessage( "UseBestPass" );
    }
*/
    else
    {
       target_point = getMiddleKickPos( agent, receiver );
       double dist = target_point.dist( wm.ball().pos() );
       ball_speed = getBestSpeed( dist );
       if( receiver >= 1 )
       {
	  rcsc::Body_KickOneStep( target_point,
	  ball_speed ).execute( agent );
	  agent->setNeckAction( new rcsc::Neck_ScanField() );
	  agent->debugClient().addMessage( "NewSetKick" );
       }
       else
       {
	  rcsc::Body_AdvanceBall().execute( agent );
	  agent->setNeckAction( new rcsc::Neck_ScanField() );
       }
    }
/*
    else if ( wm.self().pos().x < 20.0 )
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: advance"
                            ,__FILE__, __LINE__);
        rcsc::Body_AdvanceBall().execute( agent );
        agent->setNeckAction( new rcsc::Neck_ScanField() );
    }
    else
    {
        rcsc::Vector2D target_point( rcsc::ServerParam::i().pitchHalfLength() - 2.0,
                                     ( rcsc::ServerParam::i().pitchHalfWidth() - 5.0 )
                                     * ( 1.0 - ( wm.self().pos().x
                                                 / rcsc::ServerParam::i().pitchHalfLength() ) ) );
        if ( wm.self().pos().y < 0.0 )
        {
            target_point.y *= -1.0;
        }
        // enforce one step kick
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: advance 2 to (%f, %f)"
                            ,__FILE__, __LINE__,
                            target_point.x, target_point.y );
        rcsc::Body_KickOneStep( target_point,
                                rcsc::ServerParam::i().ballSpeedMax()
                                ).execute( agent );
        agent->setNeckAction( new rcsc::Neck_ScanField() );
    }
*/
    if ( agent->config().useCommunication()
         && receiver != rcsc::Unum_Unknown )
    {
       // cout << agent->world().self().unum() << "say" << receiver <<"("<< target_point.x
       //     << ","<< target_point.y << ")" << endl;
       rcsc::dlog.addText( rcsc::Logger::ACTION,
			     "%s:%d: execute() set pass communication.freekick"
       ,__FILE__, __LINE__ );
       rcsc::Vector2D target_buf = target_point - agent->world().self().pos();
       target_buf.setLength( 0.3 );
//       std::cout << wm.time().cycle() << " " << "pass to "
//		 << target_point.x << "," << target_point.y << std::endl;

       agent->addSayMessage( new rcsc::PassMessage( receiver,
                                                    target_point,
                                                    agent->effector().queuedNextBallPos(),
                                                    agent->effector().queuedNextBallVel() ) );
    }
}

/*-------------------------------------------------------------------*/
/*!

*/
void
Bhv_SetPlayKickIn::doMove( rcsc::PlayerAgent * agent )
{
    rcsc::Vector2D target_point = M_home_pos;
    const rcsc::WorldModel & wm = agent->world();
    if( wm.ball().pos().x >= thrX 
        && wm.self().unum() >= 7 
        && wm.gameMode().side() == wm.ourSide() )
    {
       target_point = getMovePos( agent );
    }
    else if( wm.ball().pos().x < thrX )
    {
       target_point = getMiddleMovePos( agent );
       agent->debugClient().addMessage( "MiddleMovePos" );
    }
    if( target_point.x >= agent->world().offsideLineX() )
      target_point.x = agent->world().offsideLineX() - 1.0;
    
    double dash_power
        = Bhv_SetPlay::get_set_play_dash_power( agent );
    double dist_thr = agent->world().ball().distFromSelf() * 0.07;
    if ( dist_thr < 1.0 ) dist_thr = 1.0;
    dist_thr = 0.3;
    agent->debugClient().addMessage( "KickInMove" );
    agent->debugClient().setTarget( target_point );
    
    if ( ! rcsc::Body_GoToPoint( target_point,
                                 dist_thr,
                                 dash_power
                                 ).execute( agent ) )
    {
        agent->debugClient().addMessage( "KickInTurn" );
        if( wm.self().unum() >= 7 
            && wm.ball().pos().x >= thrX )
        {
            agent->doTurn( 10 );
            agent->setNeckAction( new rcsc::Neck_ScanField() );
            return;
        }
        else
        {
            if( wm.ball().pos().x > wm.self().pos().x )
            {
                rcsc::Vector2D front( wm.self().pos().x + 3, wm.self().pos().y );
                rcsc::Body_TurnToPoint( front ).execute( agent );
                agent->setNeckAction( new rcsc::Neck_ScanField() );
                return;
            }
            rcsc::Body_TurnToBall().execute( agent );
            agent->setNeckAction( new rcsc::Neck_ScanField() );
            return;
        }

//       rcsc::Body_TurnToAngle( wm.self().body() + 30 );

    }

    agent->setNeckAction( new rcsc::Neck_TurnToLowConfTeammate() );
    return;
}

/*-------------------------------------------------------------------*/
/*!

*/
rcsc::Vector2D
Bhv_SetPlayKickIn::getKickPos( const rcsc::PlayerAgent * agent, int & receiver )
{
   const rcsc::WorldModel & wm = agent->world();
   rcsc::Vector2D target_pos;
   const rcsc::PlayerObject * target_mate = NULL;
   const rcsc::PlayerPtrCont::const_iterator end = wm.teammatesFromBall().end();
   for( rcsc::PlayerPtrCont::const_iterator it = wm.teammatesFromBall().begin();
	it != end;
	++it )
   {
      if( (*it)->pos().absY() < wm.self().pos().absY()
          && (*it)->pos().x >= thrX
          && (*it)->distFromSelf() < 20 )
      {
	 target_mate = (*it);
	 break;
      }
   }
   if( !target_mate )
   {
      target_mate = wm.getTeammateNearestToSelf( 5, false );
   }

   if( target_mate )
   {
      receiver = target_mate->unum();
      rcsc::Vector2D tmp_target = target_mate->pos();
      bool found = false;
      std::vector< rcsc::Vector2D > candidates;
      std::vector< bool > eval;
      setCandidates( tmp_target, candidates );
      
      for( unsigned int i = 0; i < candidates.size(); i++ )
      {
	 std::vector< rcsc::Vector2D > vertices;
	 double tmpY = 0;
	 if( wm.self().pos().y > 0 )
	 {
	    tmpY = candidates.at( i ).y;
	 }
	 else
	 {
	    tmpY = candidates.at( i ).y;
	 }
	 vertices.push_back( rcsc::Vector2D( candidates.at( i ).x + 1, tmpY ) );
	 vertices.push_back( rcsc::Vector2D( candidates.at( i ).x - 1, tmpY ) );
	 vertices.push_back( wm.self().pos() );
	 rcsc::Polygon2D polygon( vertices );
	 if( !wm.existOpponentIn( polygon, 3, true )
	     && candidates.at( i ).x < 51 )
	 {
	    found = true;
	    eval.push_back( true );
	 }
	 else
	 {
	    eval.push_back( false );
	 }
      }
      if( !found )
      {
	 target_pos = tmp_target;
      }
      else
      {
	 double dist = 0;
	 double max = 0;
	 int best = 0;
	 for( unsigned int i = 0; i < eval.size(); i++ )
	 {
	    if( eval.at( i ) )
	    {

	       const rcsc::PlayerObject * target_opp = 
		  wm.getOpponentNearestTo( candidates.at( i ), 3, & dist );
	       if( target_opp )
	       {
		  if( max < dist )
		  {
		     max = dist;
		     best = i;
		  }
	       }
	       else
	       {
		  best = i;
		  dist = 100;
	       }
	    }
	 }
	 target_pos = candidates.at( best );
      }
   }
   else
   {
      target_pos = rcsc::Vector2D( 50, 0 );
   }
   return target_pos;
}

/*-------------------------------------------------------------------*/
/*!

*/
rcsc::Vector2D
Bhv_SetPlayKickIn::getMovePos( const rcsc::PlayerAgent * agent )
{
   const rcsc::WorldModel & wm = agent->world();
   rcsc::Vector2D target_pos;
   rcsc::Vector2D base_pos = M_home_pos;
//   static bool reachedBase = false;
   static int start = 0;
   if( wm.lastSetPlayStartTime().cycle() > start )
   {
      start = wm.lastSetPlayStartTime().cycle();
      reachedBase = false;
   }
   int reverse = 1;
   if( wm.ball().pos().y < 0 )
   {
      reverse = -1;
   }
   double length = 10.0;
   base_pos.x = wm.ball().pos().x;
   base_pos.x += length;
   if( base_pos.x > 52 )
   {
      base_pos.x = 51;
   }
   switch( wm.self().unum() )
   {
      case 7:
	 base_pos.y = 0;
	 base_pos.x -= 7.0;
	 break;
      case 8:
	 base_pos.y = 0;
	 base_pos.x -= 7.0;
	 break;
      case 9:
	 if( reverse < 0 )
	 {
	    base_pos.y = 20;
	 }
	 else
	 {
	    base_pos.y = 7;
	 }
	 base_pos.x -= 3.0;
	 break;
      case 10:
	 if( reverse < 0 )
	 {
	    base_pos.y = 7;
	 }
	 else
	 {
	    base_pos.y = 20;
	 }
	 base_pos.x -= 3.0;
	 break;
      case 11:
	 base_pos.y = 10;
	 base_pos.x -= 2.0;
	 break;
   }
   base_pos.y *= reverse;
   double yoko = 9;
   double tate = 9;
   if( wm.self().unum() == 10
       && reverse > 0 )
   {
      tate = 15;
   }
   if( wm.self().unum() == 9
       && reverse < 0 )
   {
      tate = 15;
   }
   rcsc::Vector2D top_left( base_pos.x - yoko, base_pos.y - tate );
   rcsc::Vector2D bottom_right( base_pos.x + yoko, base_pos.y + tate );
   rcsc::Rect2D self_range( top_left, bottom_right );

   target_pos = base_pos;

   if( wm.self().pos().dist( base_pos ) < 1.5 )
   {
      reachedBase = true;
   }


///////////////////////////////////////////////
   const rcsc::PlayerObject * passer = NULL;
   
   if( !passer )
   {
      const rcsc::PlayerPtrCont::const_iterator end2 = wm.teammatesFromSelf().end();
      for( rcsc::PlayerPtrCont::const_iterator it = wm.teammatesFromSelf().begin();
	   it != end2;
	   ++it )
      {
	 if( (*it)->pos().absY() > wm.self().pos().absY()
	 && (*it)->pos().x >= thrX
	 && (*it)->unum() >= 7 )
	 {
	    if( (*it)->pos().absY() > base_pos.absY() )
	    {
	       passer = (*it);
	       break;
	    }
	    else if( wm.ball().pos().absY() <= base_pos.absY() )
	    {
	       passer = (*it);
	       break;
	    }
	 }
      }
   }
///////////////////////////////////////////////////////////////
   if( reachedBase )
   {
      const rcsc::PlayerObject * target_opp1 = NULL;
      const rcsc::PlayerObject * target_opp2 = NULL;
      const rcsc::PlayerObject * target_opp3 = NULL;

      const rcsc::PlayerPtrCont::const_iterator end = wm.opponentsFromSelf().end();
      for( rcsc::PlayerPtrCont::const_iterator it = wm.opponentsFromSelf().begin();
	   it != end;
	   ++it )
      {
	 if( !target_opp1 )
	 {
	    target_opp1 = (*it);
	 }
	 else if( !target_opp2 )
	 {
	    target_opp2 = (*it);
	 }
	 else if( !target_opp3 )
	 {
	    target_opp3 = (*it);
	    break;
	 }
      }

      rcsc::Vector2D opponent_pos = base_pos;

      if( target_opp1 )
      {
	 double length = 5.0;
	 opponent_pos = target_opp1->pos();
	 if( self_range.contains( opponent_pos ) )
	 {
	    if( opponent_pos.x >= target_pos.x - length )
	    {
	       target_pos.x = opponent_pos.x + length;
	    }
	    if( opponent_pos.absY() >= target_pos.absY() - 3 )
	    {
	       target_pos.y = opponent_pos.y + 3.0 * reverse;
	    }
	 }
	 
	 if( target_opp2 )
	 {

	    opponent_pos = target_opp2->pos();
	    if( self_range.contains( opponent_pos ) )
	    {
	       if( opponent_pos.absY() > target_pos.absY() - 3  )
	       {
		  target_pos.y = opponent_pos.y + 3.0 * reverse;
		  if( opponent_pos.x >= target_pos.x - length )
		  {
		     target_pos.x = opponent_pos.x + length;
		  }
	       }
	    }
	    if( target_opp3 )
	    {

	       opponent_pos = target_opp2->pos();
	       if( self_range.contains( opponent_pos ) )
	       {
		  if( opponent_pos.absY() > target_pos.absY() - 3 )
		  {
		     target_pos.y = opponent_pos.y + 3.0 * reverse;
		     if( opponent_pos.x >= target_pos.x - length )
		     {
			target_pos.x = opponent_pos.x + length;
		     }
		  }
	       }
	    }//end if target_opp3
	 }//end if target_opp2
      }//end if target_opp1
   }//end if reachedBase





/*
   if( target_pos.x > wm.offsideLineX() )
   {
	 target_pos.x = wm.offsideLineX() - 0.5;
   }
*/
   


   double defLine = 0;
   const rcsc::PlayerPtrCont::const_iterator end = wm.opponentsFromSelf().end();
   for( rcsc::PlayerPtrCont::const_iterator it = wm.opponentsFromSelf().begin();
	it != end;
	++it )
   {
      if( !(*it)->goalie() && (*it)->pos().x > defLine )
      {
	 defLine = (*it)->pos().x;
      }
   }
   if( passer )
   {
      if( reachedBase )
      {
	 if( passer->pos().absY() <= 32 
	 && passer->pos().x > defLine )
	 {
	    if( passer->pos().x < target_pos.x + 1.5 )
	    {
	       target_pos.x = passer->pos().x - 1.5;
	    }
	 }
	 if( passer->pos().dist( target_pos ) < 7 )
	 {
	    target_pos.y = passer->pos().y - 7 * reverse;
	 }

	 if( reverse < 0 )
	 {
	    if( wm.self().unum() == 10 )
	    {
	       target_pos.x = defLine - 5;
	    }
	    else if( wm.self().unum() == 8 )
	    {
	       if( passer->pos().x > defLine )
	       {
		  target_pos.x = passer->pos().x - 1;
	       }
	       else
	       {
		  target_pos.x = defLine - 1;
	       }
	    }
	 }
	 else
	 {
	    if( wm.self().unum() == 9 )
	    {
	       target_pos.x = defLine - 5;
	    }
	    else if( wm.self().unum() == 7 )
	    {
	       if( passer->pos().x > defLine )
	       {
		  target_pos.x = passer->pos().x - 1;
	       }
	       else
	       {
		  target_pos.x = defLine - 1;
	       }
	    }
	 }
      }//end if reachedBase
   }//end if passer

   if( target_pos.x > 50.5 )
   {
      target_pos.x = 50.5;
   }
   if( target_pos.y > 32 )
   {
      target_pos.y = 32;
   }
   if( target_pos.y < -32 )
   {
      target_pos.y = -32;
   }
   return target_pos;
}

/*-------------------------------------------------------------------*/
/*!

*/
double
Bhv_SetPlayKickIn::getBestSpeed( double dist )
{
   double speed = rcsc::ServerParam::i().ballSpeedMax();
   int cycle = 0;
   while( cycle < 10 )
   {
      cycle++;
      double sum = rcsc::calc_sum_geom_series( speed, rcsc::ServerParam::i().ballDecay(), cycle );
      if( sum >= dist )
      {
	 speed = rcsc::calc_first_term_geom_series( dist, rcsc::ServerParam::i().ballDecay(), cycle + 1 );
	 break;
      }
   }
   
   return speed;
}

/*-------------------------------------------------------------------*/
/*!

*/
void
Bhv_SetPlayKickIn::setCandidates( rcsc::Vector2D base_pos, std::vector< rcsc::Vector2D > & candidates )
{
   candidates.clear();
   candidates.push_back( base_pos );
   
   rcsc::Vector2D cand1 = base_pos;
   rcsc::Vector2D cand2 = base_pos;
   rcsc::Vector2D cand3 = base_pos;
   rcsc::Vector2D cand4 = base_pos;
   rcsc::Vector2D cand5 = base_pos;
   rcsc::Vector2D cand6 = base_pos;
   rcsc::Vector2D cand7 = base_pos;
   rcsc::Vector2D cand8 = base_pos;

   double radius = 1.5;
   
   cand1.x += radius;

   cand2.x += radius * cos( M_PI_4 );
   cand2.y += radius * sin( M_PI_4 );

   cand3.y += radius;

   cand4.x += radius * cos( M_PI_4 * 3 );
   cand4.y += radius * sin( M_PI_4 * 3 );

   cand5.x -= radius;

   cand6.x += radius * cos( M_PI_4 * 5 );
   cand6.y += radius * sin( M_PI_4 * 5 );

   cand7.y -= radius;

   cand8.x += radius * cos( M_PI_4 * 7 );
   cand8.y += radius * sin( M_PI_4 * 7 );

   candidates.push_back( cand1 );
   candidates.push_back( cand2 );
   candidates.push_back( cand3 );
   candidates.push_back( cand4 );
   candidates.push_back( cand5 );
   candidates.push_back( cand6 );
   candidates.push_back( cand7 );
   candidates.push_back( cand8 );
   

   for( unsigned int i = 0; i < candidates.size(); i++ )
   {

      if( candidates.at( i ).x > 50.2 )
      {
	 candidates.at( i ).x = 50.5;
      }
      if( candidates.at( i ).y > 32 )
      {
	 candidates.at( i ).y = 32;
      }
      if( candidates.at( i ).y < -32 )
      {
	 candidates.at( i ).y = -32;
      }
   }
   return;
}


/*-------------------------------------------------------------------*/
/*!

*/
rcsc::Vector2D
Bhv_SetPlayKickIn::getMiddleMovePos( const rcsc::PlayerAgent * agent )
{
   rcsc::Vector2D target_pos = M_home_pos;
   const rcsc::WorldModel & wm = agent->world();

//   static bool reachedBase = false;
   static int start = 0;
   if( start < wm.lastSetPlayStartTime().cycle() )
   {
      start = wm.lastSetPlayStartTime().cycle();
      reachedBase = false;
   }
   if( wm.self().pos().dist( M_home_pos ) < 2.5 )
   {
      reachedBase = true;
      
   }

   if( reachedBase )
   {
      target_pos = wm.self().pos();
      if( wm.ball().distFromSelf() < 20 )
      {
	 rcsc::Vector2D top_left( 0, 0 );
	 rcsc::Vector2D bottom_right( 0, 0 );
	 double buf = 2.0;
	 if( wm.ball().pos().x <= wm.self().pos().x )
	 {
	    top_left.x = wm.ball().pos().x - buf;
	    bottom_right.x = wm.self().pos().x + buf;
	 }
	 else
	 {
	    top_left.x = wm.self().pos().x - buf;
	    bottom_right.x = wm.ball().pos().x + buf;
	 }
	 if( wm.ball().pos().y <= wm.self().pos().y )
	 {
	    top_left.y = wm.ball().pos().y;
	    bottom_right.y = wm.self().pos().y + buf;
	 }
	 else
	 {
	    top_left.y = wm.self().pos().y - buf;
	    bottom_right.y = wm.ball().pos().y;
	 }
	 rcsc::Rect2D self_range( top_left, bottom_right );
	 
	 const rcsc::PlayerObject * target_opp = NULL;
	 const rcsc::PlayerPtrCont::const_iterator end = wm.opponentsFromSelf().end();
	 for( rcsc::PlayerPtrCont::const_iterator it = wm.opponentsFromSelf().begin();
	      it != end;
	      ++it )
	 {
	    if( self_range.contains( (*it)->pos() ) )
	    {
	       target_opp = (*it);
	       break;
	    }
	 }
	 
	 if( target_opp )
	 {
	    if( wm.ball().pos().x <= wm.self().pos().x )
	    {
	       target_pos.x = target_opp->pos().x - 3;
	    }
	    else
	    {
	       target_pos.x = target_opp->pos().x + 3;
	    }
	    if( wm.ball().pos().y <= wm.self().pos().y )
	    {
	       target_pos.y = target_opp->pos().y - 3;
	    }
	    else
	    {
	       target_pos.y = target_opp->pos().y + 3;
	    }
	 }
	 else
	 {

	    target_opp = wm.getOpponentNearestToSelf( 5, false );
	    if( target_opp )
	    {
                bool checkOpponent = false;
                if( target_opp->distFromSelf() < 3 )
                {
                    if( wm.ball().pos().x <= wm.self().pos().x )
                    {
                        if( target_opp->pos().x > wm.ball().pos().x 
                            && target_opp->pos().x < wm.self().pos().x )
                        {
                            target_pos.x = target_opp->pos().x - 3;
                            checkOpponent = true;
                        }
                    }
                    else
                    {
                        if( target_opp->pos().x < wm.ball().pos().x 
                            && target_opp->pos().x > wm.self().pos().x )
                        {
                            target_pos.x = target_opp->pos().x + 3;
                            checkOpponent = true;
                        }
                    }
                    if( wm.ball().pos().y <= wm.self().pos().y )
                    {
                        if( target_opp->pos().y > wm.ball().pos().y
                            && target_opp->pos().y < wm.self().pos().y )
                        {
                            target_pos.y = target_opp->pos().y - 3;
                            checkOpponent = true;
                        }
                    }
                    else
                    {
                        if( target_opp->pos().y < wm.ball().pos().y
                            && target_opp->pos().y > wm.self().pos().y )
                        {
                            target_pos.y = target_opp->pos().y + 3;
                            checkOpponent = true;
                        }
                    }
                }
                if( !checkOpponent 
                    && wm.ball().distFromSelf() < 10 
                    && target_pos.absY() > 30 )
                {
                    if( wm.ball().pos().y > 0 )
                    {
                        target_pos.y -= 8;
                    }
                    else
                    {
                        target_pos.y += 8;
                    }
                }
            }
	    else if( wm.ball().distFromSelf() < 10
	             && target_pos.absY() > 30 )
	    {
                if( wm.ball().pos().y > 0 )
                {
                    target_pos.y -= 8;
                }
                else
                {
                    target_pos.y += 8;
                }
	    }
            
	 }
      }//end if distFromSelf
   }//end if reachedBase
   if( target_pos.x > 50.5 )
   {
      target_pos.x = 50.5;
   }
   if( target_pos.y > 32 )
   {
      target_pos.y = 32;
   }
   if( target_pos.y < -32 )
   {
      target_pos.y = -32;
   }
   return target_pos;
}

    
/*-------------------------------------------------------------------*/
/*!

*/
rcsc::Vector2D
Bhv_SetPlayKickIn::getMiddleKickPos( const rcsc::PlayerAgent * agent, int & receiver )
{
   rcsc::Vector2D target_pos( 0, 0 );
   const rcsc::WorldModel & wm = agent->world();
   const rcsc::PlayerObject * target_mate1 = NULL;
   const rcsc::PlayerObject * target_mate2 = NULL;
   const rcsc::PlayerObject * target_mate3 = NULL;
   const rcsc::PlayerPtrCont::const_iterator end = wm.teammatesFromSelf().end();
   for( rcsc::PlayerPtrCont::const_iterator it = wm.teammatesFromSelf().begin();
	it != end;
	++it )
   {
      if( !target_mate1
	  && (*it)->pos().absY() < wm.self().pos().absY()
          && (*it)->distFromSelf() < 20 )
      {
	 target_mate1 = (*it);
	 continue;
      }
      else if( !target_mate2
               && (*it)->pos().absY() < wm.self().pos().absY()
               && (*it)->distFromSelf() < 20 )
      {
	 target_mate2 = (*it);
	 continue;
      }
      else if( !target_mate3
               && (*it)->pos().absY() < wm.self().pos().absY()
               && (*it)->distFromSelf() < 20 )
      {
	 target_mate3 = (*it);
	 break;
      }
   }
   if( !target_mate1 )
   {
      target_mate1 = wm.getTeammateNearestToSelf( 5, false );
   }
   if( target_mate1 )
   {
      rcsc::Vector2D tmp_target = target_mate1->pos();
      std::vector< rcsc::Vector2D > candidates1;
      std::vector< bool > eval1;
      setCandidates( tmp_target, candidates1 );
      for( unsigned int i = 0; i < candidates1.size(); i++ )
      {
	 std::vector< rcsc::Vector2D > vertices;
	 double tmpY = 0;
	 if( wm.self().pos().y > 0 )
	 {
	    tmpY = candidates1.at( i ).y;
	 }
	 else
	 {
	    tmpY = candidates1.at( i ).y;
	 }
	 vertices.push_back( rcsc::Vector2D( candidates1.at( i ).x + 1, tmpY ) );
	 vertices.push_back( rcsc::Vector2D( candidates1.at( i ).x - 1, tmpY ) );
	 vertices.push_back( wm.self().pos() );
	 rcsc::Polygon2D polygon( vertices );
	 if( !wm.existOpponentIn( polygon, 3, true )
	     && candidates1.at( i ).x < 51 )
	 {
	    eval1.push_back( true );
	 }
	 else
	 {
	    eval1.push_back( false );
	 }
      }
      double dist = 0;
      double max = 0;
      int best = 0;
      double x_max = -50;
      for( unsigned int i = 0; i < eval1.size(); i++ )
      {
	 if( eval1.at( i ) )
	 {
	    const rcsc::PlayerObject * target_opp = 
	       wm.getOpponentNearestTo( candidates1.at( i ), 3, & dist );
	    if( target_opp )
	    {
	       if( max < dist )
	       {
		  max = dist;
		  best = i;
	       }
	    }
	    else
	    {
	       best = i;
	       dist = 100;
	    }
	 }
      }
      target_pos = candidates1.at( best );
      x_max = candidates1.at( best ).x;
      receiver = target_mate1->unum();

/////////////////////////////////////
      if( target_mate2 )
      {
	 tmp_target = target_mate1->pos();
	 std::vector< rcsc::Vector2D > candidates2;
	 std::vector< bool > eval2;
	 setCandidates( tmp_target, candidates2 );
	 for( unsigned int i = 0; i < candidates2.size(); i++ )
	 {
	    std::vector< rcsc::Vector2D > vertices;
	    double tmpY = 0;
	    if( wm.self().pos().y > 0 )
	    {
	       tmpY = candidates2.at( i ).y;
	    }
	    else
	    {
	       tmpY = candidates2.at( i ).y;
	    }
	    vertices.push_back( rcsc::Vector2D( candidates2.at( i ).x + 1, tmpY ) );
	    vertices.push_back( rcsc::Vector2D( candidates2.at( i ).x - 1, tmpY ) );
	    vertices.push_back( wm.self().pos() );
	    rcsc::Polygon2D polygon( vertices );
	    if( !wm.existOpponentIn( polygon, 3, true )
	        && candidates2.at( i ).x < 51 )
	    {
	       eval2.push_back( true );
	    }
	    else
	    {
	       eval2.push_back( false );
	    }
	 }
	 double dist2 = 0;
	 double max2 = 0;
	 double best2 = 0;
	 for( unsigned int i = 0; i < eval2.size(); i++ )
	 {
	    if( eval2.at( i ) )
	    {
	       const rcsc::PlayerObject * target_opp = 
		  wm.getOpponentNearestTo( candidates2.at( i ), 3, & dist2 );
	       if( target_opp )
	       {
		  if( max2 < dist2 )
		  {
		     max2 = dist2;
		     best2 = i;
		  }
	       }
	       else
	       {
		  best2 = i;
		  dist2 = 100;
	       }
	    }
	 }
	 if( eval2.at( best2 ) && candidates2.at( best2 ).x > x_max )
	 {
	    target_pos = candidates2.at( best2 );
	    x_max = candidates2.at( best2 ).x;
	    receiver = target_mate2->unum();
	 }
	 ///////////////////////////////////
	 if( target_mate3 )
	 {
	    tmp_target = target_mate3->pos();
	    std::vector< rcsc::Vector2D > candidates3;
	    std::vector< bool > eval3;
	    setCandidates( tmp_target, candidates3 );
	    for( unsigned int i = 0; i < candidates3.size(); i++ )
	    {
	       std::vector< rcsc::Vector2D > vertices;
	       double tmpY = 0;
	       if( wm.self().pos().y > 0 )
	       {
		  tmpY = candidates3.at( i ).y;
	       }
	       else
	       {
		  tmpY = candidates3.at( i ).y;
	       }
	       vertices.push_back( rcsc::Vector2D( candidates3.at( i ).x + 1, tmpY ) );
	       vertices.push_back( rcsc::Vector2D( candidates3.at( i ).x - 1, tmpY ) );
	       vertices.push_back( wm.self().pos() );
	       rcsc::Polygon2D polygon( vertices );
	       if( !wm.existOpponentIn( polygon, 3, true )
	           && candidates3.at( i ).x < 51 )
	       {
		  eval3.push_back( true );
	       }
	       else
	       {
		  eval3.push_back( false );
	       }
	    }
	    double dist3 = 0;
	    double max3 = 0;
	    double best3 = 0;
	    for( unsigned int i = 0; i < eval3.size(); i++ )
	    {
	       if( eval3.at( i ) )
	       {
		  const rcsc::PlayerObject * target_opp = 
		     wm.getOpponentNearestTo( candidates3.at( i ), 3, & dist3 );
		  if( target_opp )
		  {
		     if( max3 < dist3 )
		     {
			max3 = dist3;
			best3 = i;
		     }
		  }
		  else
		  {
		     best3 = i;
		     dist3 = 100;
		  }
	       }
	    }
	    if( eval3.at( best3 ) && candidates3.at( best3 ).x > x_max )
	    {
	       target_pos = candidates3.at( best3 );
	       receiver = target_mate3->unum();
	    }
	 }//end if target_mate3 
      }//end if target_mate2
   }//end if target_mate1

   return target_pos;
}
