// -*-c++-*-

/*!
  \file body_pass.h
  \brief advanced pass planning & behavior.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef OPUCI_BODY_OPUCI_PASS_H
#define OPUCI_BODY_OPUCI_PASS_H

#include <rcsc/player/soccer_action.h>
#include <rcsc/geom/vector_2d.h>
#include <rcsc/common/player_type.h>
#include <rcsc/player/player_object.h>
#include <functional>
#include <vector>


//pass rcsc::WorldModel;
//pass rcsc::PlayerObject;

/*!
  \class Body_opuciPass
  \brief advanced pass planning & behavior.
 */
class Body_opuciPass
    : public rcsc::BodyAction {
public:
    /*!
      \enum PassType
      \brief pass type id
     */
    enum PassType {
        DIRECT  = 1,
        LEAD    = 2,
        THROUGH = 3
    };

private:
  int M_mode;


public:
    /*!
      \brief accessible from global.
    */
    Body_opuciPass( int mode = 0 )
      { M_mode = mode; }

    /*!
      \brief execute action
      \param agent pointer to the agent itself
      \return true if action is performed
    */
    bool execute( rcsc::PlayerAgent * agent );

    /*!
      \brief calculate best pass route
      \param world consr rerefence to the WorldModel
      \param target_point receive target point is stored to this
      \param first_speed ball first speed is stored to this
      \param receiver receiver number
      \return true if pass route is found.
    */

    rcsc::Vector2D getKickPos( const rcsc::PlayerAgent * agent, rcsc::Vector2D tmp_target );
    double getBestSpeed( double dist, double move_dist );
    void setCandidates( rcsc::Vector2D base_pos, std::vector< rcsc::Vector2D > & candidates, double radius );
    bool doShootChancePass( rcsc::PlayerAgent * agent );
    bool doThroughPass( rcsc::PlayerAgent * agent );
    bool doDirectPass( rcsc::PlayerAgent * agent );
    bool doAidaPass( rcsc::PlayerAgent * agent );
    int getReceiver( rcsc::PlayerAgent * agent );
    int evalDirect( rcsc::PlayerAgent * agent, rcsc::Vector2D target_pos, std::vector< rcsc::Vector2D > & opponents );
    void findDefenseLine( rcsc::PlayerAgent * agent, std::vector<rcsc::Vector2D> *candidate);
    double getDashDist( const rcsc::PlayerObject * player, int dash_count );
    int getBallCycle( double dist );
    
    bool doThroughPass( rcsc::PlayerAgent * agent, rcsc::PlayerObject * teammate );
    bool doDirectPass( rcsc::PlayerAgent * agent, rcsc::PlayerObject * teammate );
    bool doAidaPass( rcsc::PlayerAgent * agent, rcsc::PlayerObject * teammate );
    bool doShootPass( rcsc::PlayerAgent * agent, rcsc::PlayerObject * teammate );   
    
};



#endif
