// -*-c++-*-

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "opuci_coach.h"

#include <rcsc/coach/coach_command.h>
#include <rcsc/coach/coach_config.h>
#include <rcsc/coach/global_visual_sensor.h>

#include <rcsc/common/basic_client.h>
#include <rcsc/common/player_param.h>
#include <rcsc/common/server_param.h>
#include <rcsc/common/player_type.h>
#include <rcsc/common/audio_memory.h>
#include <rcsc/common/say_message_parser.h>
#include <rcsc/common/free_message_parser.h>

#include <rcsc/param/param_map.h>
#include <rcsc/param/cmd_line_parser.h>

#include <functional>
#include <algorithm>
#include <vector>
#include <sstream>
#include <iostream>
#include <cstdio>

#include <fstream>
#include <sstream>
#include <boost/random.hpp>
#include <time.h>
#include <pthread.h>
#include <rcsc/math_util.h>
#include <ctime>
#include <rcsc/common/audio_codec.h>
#include "team_logo.xpm"

//////////////////global/////////////////////////
static bool useCout = false;
static bool doTrain = false;
static bool doSend = false;
static bool useFigure = true;
rcsc::SideID side = rcsc::NEUTRAL;
const double opuciCoach::PITCH_LENGTH = ( 105.0000000 + 10.0 ) * 1.25;
const double opuciCoach::PITCH_WIDTH = ( 68.00000000 + 10.0 ) * 1.25;
double eta = 0.3;
double alpha = 0.1;
opuciCoach::BPN net1( eta, alpha );
opuciCoach::BPN net2( eta, alpha );
opuciCoach::BPN net3( eta, alpha );
opuciCoach::BPN net4( eta, alpha );
opuciCoach::BPN net5( eta, alpha );
opuciCoach::BPN net6( eta, alpha );
opuciCoach::BPN net7( eta, alpha );
opuciCoach::BPN net8( eta, alpha );
opuciCoach::BPN net9( eta, alpha );
opuciCoach::BPN net10( eta, alpha );
opuciCoach::BPN net11( eta, alpha );


std::vector < std::vector < rcsc::Vector2D > > ballPositions;
std::vector < std::vector < rcsc::Vector2D > > oppPositions;
std::vector < bool > continueFlags;
std::vector < bool > startFlags;
std::vector < bool > endFlags;
std::vector < opuciCoach::SENT > sentFlags;
std::vector < std::vector < double > > errors;

/////////////////////////////////////////////////
double train( long unum, int nth, int loop, opuciCoach::BPN & net, std::vector< rcsc::Vector2D > & bPos, std::vector< rcsc::Vector2D > & oPos );

void *thread_func(void *arg)
{

   int loop = 1000;
//   int pid;
   pthread_t thread_id;
   thread_id = pthread_self();
//   fprintf(stderr , "thread_func called\n");
//   fprintf(stderr , "thread ID = %ld\n" , thread_id);
   pthread_detach(thread_id);
   long unum = (long)arg;
   int count = 0;

   while( continueFlags.at( unum - 1 ) )
   {
      if( startFlags.at( unum - 1 ) )
      {
	 if( useCout )
	 {
	    std::cout << "start thread " << unum << std::endl;
	 }
	 startFlags.at( unum - 1 ) = false;
	 double error = 0;
	 switch( unum )
	 {
	    case 1:
	       error = train( unum, count, loop, net1, ballPositions.at( unum - 1 ), oppPositions.at( unum - 1 ) );
	       break;
	    case 2:
	       error = train( unum, count, loop, net2, ballPositions.at( unum - 1 ), oppPositions.at( unum - 1 ) );
	       break;
	    case 3:
	       error = train( unum, count, loop, net3, ballPositions.at( unum - 1 ), oppPositions.at( unum - 1 ) );
	       break;
	    case 4:
	       error = train( unum, count, loop, net4, ballPositions.at( unum - 1 ), oppPositions.at( unum - 1 ) );
	       break;
	    case 5:
	       error = train( unum, count, loop, net5, ballPositions.at( unum - 1 ), oppPositions.at( unum - 1 ) );
	       break;
	    case 6:
	       error = train( unum, count, loop, net6, ballPositions.at( unum - 1 ), oppPositions.at( unum - 1 ) );
	       break;
	    case 7:
	       error = train( unum, count, loop, net7, ballPositions.at( unum - 1 ), oppPositions.at( unum - 1 ) );
	       break;
	    case 8:
	       error = train( unum, count, loop, net8, ballPositions.at( unum - 1 ), oppPositions.at( unum - 1 ) );
	       break;
	    case 9:
	       error = train( unum, count, loop, net9, ballPositions.at( unum - 1 ), oppPositions.at( unum - 1 ) );
	       break;
	    case 10:
	       error = train( unum, count, loop, net10, ballPositions.at( unum - 1 ), oppPositions.at( unum - 1 ) );
	       break;
	    case 11:
	       error = train( unum, count, loop, net11, ballPositions.at( unum - 1 ), oppPositions.at( unum - 1 ) );
	       break;
	 }
	 if( useCout )
	 {
	    std::cout << unum << " error = " << error << std::endl;
	 }
	 errors.at( unum - 1 ).push_back( error );
	 if( count > 0 )
	 {
	    if( error > errors.at( unum - 1 ).at( count - 1 ) )
	    {
	       sentFlags.at( unum - 1 ).first = true;
	       sentFlags.at( unum - 1 ).second = true;
	    }
	 }
	 count++;
	 endFlags.at( unum - 1 ) = true;
      }
      else
      {
	 sleep( 1 );
      }
   }
   return NULL;
}

/////////////////////////////////////////////////////////

struct IsIgnoredStaminaIncMax
    : public std::unary_function< const rcsc::PlayerType *, bool > {
    const double M_ignore_thr;

    IsIgnoredStaminaIncMax( const double & thr )
        : M_ignore_thr( thr )
      { }

    result_type operator()( argument_type arg ) const
      {
          return arg->staminaIncMax() < M_ignore_thr;
      }
};


/////////////////////////////////////////////////////////

struct IsIgnoredSpeedMax
    : public std::unary_function< const rcsc::PlayerType *, bool > {
    const double M_ignore_thr;

    IsIgnoredSpeedMax( const double & thr )
        : M_ignore_thr( thr )
      { }

    result_type operator()( argument_type arg ) const
      {
          return arg->realSpeedMax() < M_ignore_thr;
      }
};


/////////////////////////////////////////////////////////

struct TypeStaminaIncComp
    : public std::binary_function< const rcsc::PlayerType *,
                                   const rcsc::PlayerType *,
                                   bool > {

    result_type operator()( first_argument_type lhs,
                            second_argument_type rhs ) const
      {
          return lhs->staminaIncMax() > rhs->staminaIncMax();
      }

};

/////////////////////////////////////////////////////////

struct RealSpeedMaxCmp
    : public std::binary_function< const rcsc::PlayerType *,
                                   const rcsc::PlayerType *,
                                   bool > {

    result_type operator()( first_argument_type lhs,
                            second_argument_type rhs ) const
      {
          return lhs->realSpeedMax() < rhs->realSpeedMax();
      }

};

/////////////////////////////////////////////////////////

struct MaxSpeedReachStepCmp
    : public std::binary_function< const rcsc::PlayerType *,
                                   const rcsc::PlayerType *,
                                   bool > {

    result_type operator()( first_argument_type lhs,
                            second_argument_type rhs ) const
      {
          return lhs->cyclesToReachMaxSpeed() > rhs->cyclesToReachMaxSpeed();
      }

};


/////////////////////////////////////////////////////////

/*-------------------------------------------------------------------*/
/*!

 */
opuciCoach::opuciCoach()
    : CoachAgent()
{
    //
    // register audio memory & say message parsers
    //
    typedef boost::shared_ptr< rcsc::SayMessageParser > SMP;

    boost::shared_ptr< rcsc::AudioMemory > audio_memory( new rcsc::AudioMemory );

    M_worldmodel.setAudioMemory( audio_memory );

    addSayMessageParser( SMP( new rcsc::BallMessageParser( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::PassMessageParser( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::InterceptMessageParser( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::GoalieMessageParser( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::OffsideLineMessageParser( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::DefenseLineMessageParser( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::WaitRequestMessageParser( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::PassRequestMessageParser( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::DribbleMessageParser( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::BallGoalieMessageParser( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::OnePlayerMessageParser( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::BallPlayerMessageParser( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::FreeMessageParser< 9 >( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::FreeMessageParser< 8 >( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::FreeMessageParser< 7 >( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::FreeMessageParser< 6 >( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::FreeMessageParser< 5 >( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::FreeMessageParser< 4 >( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::FreeMessageParser< 3 >( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::FreeMessageParser< 2 >( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::FreeMessageParser< 1 >( audio_memory ) ) );

    //
    //
    //

    for ( int i = 0; i < 11; ++i )
    {
        // init map values
        M_player_type_id[i] = rcsc::Hetero_Default;
    }

    for ( int i = 0; i < 11; ++i )
    {
        M_opponent_player_types[i] = rcsc::Hetero_Default;
    }
}

/*-------------------------------------------------------------------*/
/*!

*/
opuciCoach::~opuciCoach()
{

}

/*-------------------------------------------------------------------*/
/*!

 */
bool
opuciCoach::initImpl( rcsc::CmdLineParser & cmd_parser )
{
    bool result = rcsc::CoachAgent::initImpl( cmd_parser );

    rcsc::ParamMap my_params;
#if 0
    std::string formation_conf;
    int role_number = 0;
    bool use_clang = false;
    my_map.add()
        ( "fconf", "", &formation_conf, "set the formation configuration file." )
        ( "strategy-number", "", &strategy_number, "set the strategy number." )
        ( "use_clang", "", rcsc::BoolSwitch( &use_clang ), "" )
        ;
#endif
    cmd_parser.parse( my_params );

    if ( cmd_parser.count( "help" ) )
    {
        my_params.printHelp( std::cout );
        return false;
    }

    if ( cmd_parser.failed() )
    {
        std::cerr << "coach: ***WARNING*** detected unsupported options: ";
        cmd_parser.print( std::cerr );
        std::cerr << std::endl;
    }

    if ( ! result )
    {
        return false;
    }

    if ( config().useTeamGraphic() )
    {
       if ( config().teamGraphicFile().empty() )
       {
	  M_team_graphic.createXpmTiles( team_logo_xpm );
       }
       else
       {
	  M_team_graphic.readXpmFile( config().teamGraphicFile().c_str() );
       }
    }
    
    //////////////////////////////////////////////////////////////////
    // Add your code here.
    //////////////////////////////////////////////////////////////////

    for( int i = 0; i < 11; i++ )
    {
       std::vector < rcsc::Vector2D > ballPos;
       ballPositions.push_back( ballPos );
       std::vector < rcsc::Vector2D > oppPos;
       oppPositions.push_back( oppPos );
       M_oppPositions.push_back( oppPos );
       continueFlags.push_back( true );
       startFlags.push_back( false );
       endFlags.push_back( false );
       SENT sent;
       sent.first = false;
       sent.second = false;
       sentFlags.push_back( sent );
       std::vector < double > error;
       errors.push_back( error );
    }
    return true;
}

/*-------------------------------------------------------------------*/
/*!

 */
void
opuciCoach::actionImpl()
{
    if ( world().time().cycle() == 0
         && config().useTeamGraphic()
         && M_team_graphic.tiles().size() != teamGraphicOKSet().size() )
    {
        sendTeamGraphic();
    }

    if( side == rcsc::NEUTRAL )
    {
       side = world().ourSide();
    }
    if( doTrain )
    {
       static bool firstHalf = false;
       static bool secondHalf = false;
       static bool finishSending = false;
       static bool inTraining = false;
       static bool startThread = false;
       static bool restartThread = false;
       static bool started = false;
       static clock_t start, end;
       static int firstTime = 1000;
//       static int secondTime = -1;
       static int startTime = 0;
       static bool finishFigure = false;
       if( world().time().cycle() >= 1 )
       {
	  if( world().gameMode().type() == rcsc::GameMode::PlayOn )
	  {
	     recordPos();
	  }
       }
       if( !firstHalf && world().gameMode().type() == rcsc::GameMode::PlayOn )
       {
	  firstHalf = true;
       }
       if( !secondHalf && firstHalf && world().gameMode().type() == rcsc::GameMode::BeforeKickOff )
       {
	  secondHalf = true;
       }
       if( !startThread && !inTraining
           && world().time().cycle() == firstTime )
       {
	  startThread = true;
	  started = true;
       }
       if( startThread && !inTraining )
       {
	  startThread = false;
	  inTraining = true;
	  for( unsigned int i = 0; i < ballPos.size(); i++ )
	  {
	     ballPositions.at( 0 ).push_back( ballPos.at( i ) );
	  }
	  for( int i = 1; i < 11; i++ )
	  {
	     ballPositions.at( i ) = ballPositions.at( 0 );
	  }
	  for( int i = 0; i < 11; i++ )
	  {
	     for( unsigned int j = 0; j < M_oppPositions.at( i ).size(); j++ )
	     {
		oppPositions.at( i ).push_back( M_oppPositions.at( i ).at( j ) );
	     }
	  }
	  for( int i = 0; i < 11; i++ )
	  {
	     while( oppPositions.at( i ).size() > ballPositions.at( i ).size() )
	     {
		oppPositions.at( i ).pop_back();
	     }
	     while( oppPositions.at( i ).size() < ballPositions.at( i ).size() )
	     {
		ballPositions.at( i ).pop_back();
	     }
	  }
	  pthread_t thread[11];
	  start = clock();
	  startTime = world().time().cycle();

	  for( int i = 0; i < 11; i++ )
	  {
	     if( pthread_create( &thread[i], NULL, thread_func, (void*)( i + 1 ) ) != 0 )
	     {
		perror( "pthread_Create()" );
	     }
	     startFlags.at( i ) = true;
	     
	  }

	  
       }// end of start training
       else if( restartThread )
       {
   
       }
	
       if( inTraining )
       {
	  for( int i = 0; i < 11; i++ )
	  {
	     if( !endFlags.at( i ) )
	     {
		break;
	     }
	  }

	  if( useCout )
	  {
	     end = clock();
	     double time = ( end - start ) /CLOCKS_PER_SEC;
	     std::cout << "training finished in " << time << "sec" << std::endl;
	  }
	  inTraining = false;
       }

       if( doSend 
           && started && !inTraining && !finishSending 
           && world().gameMode().type() != rcsc::GameMode::PlayOn )
       {
	  finishSending = sendNet();
	  if( finishSending )
	  {
	     started = false;
	  }
       }
       else
       {
	  sayPlayerTypes();
       }

       if( useFigure && !finishFigure
           && world().time().cycle() == 3000 )
       {
	  figure();
	  finishFigure = true;
	  std::cout << "finish figure" << std::endl;
       }
    }//end training and sending
    else
    {
       sayPlayerTypes();
    }

    doSubstitute();

/*
    if ( world().canSendFreeform() )
    {
       char msg[128];
       std::sprintf( msg, "freeform message %d/%d",
       world().freeformSendCount(),
       world().freeformAllowedCount() );
       doSayFreeform( msg );
    }
    if ( world().time().cycle() > 0 )
    {
       M_client->setServerAlive( false );
    }
*/


}

/*-------------------------------------------------------------------*/
/*!

 */
void
opuciCoach::doSubstitute()
{
    static bool S_first_substituted = false;

    if ( config().useHetero()
         && ! S_first_substituted
         && world().time().cycle() == 0
         && world().time().stopped() > 10 )
    {
        doFirstSubstitute();
        S_first_substituted = true;
    }
}

/*-------------------------------------------------------------------*/
/*!

 */
void
opuciCoach::doFirstSubstitute()
{
    std::vector< const rcsc::PlayerType * > candidates;

    std::fprintf( stderr,
                  "id speed step inc  power  stam decay moment dprate   karea  krand effmax effmin\n" );
    for ( rcsc::PlayerTypeSet::PlayerTypeMap::const_iterator it
              = rcsc::PlayerTypeSet::i().playerTypeMap().begin();
          it != rcsc::PlayerTypeSet::i().playerTypeMap().end();
          ++it )
    {
        int pt_max = rcsc::PlayerParam::i().ptMax();
        if ( it->second.id() == rcsc::Hetero_Default )
        {
            if ( rcsc::PlayerParam::i().allowMultDefaultType() )
            {
                pt_max = 11;
            }
            else
            {
                pt_max -= 1; // because goalie is always default type
            }
        }

        for ( int i = 0; i < pt_max; ++i )
        {
            M_available_player_type_id.push_back( it->second.id() );
            candidates.push_back( &(it->second) );
        }

        std::fprintf( stderr,
                      "%d  %.3f  %2d  %.1f %5.1f %5.1f %.3f  %4.1f  %.5f  %.3f  %.2f  %.3f  %.3f\n",
                      it->second.id(),
                      it->second.realSpeedMax(),
                      it->second.cyclesToReachMaxSpeed(),
                      it->second.staminaIncMax(),
                      it->second.getDashPowerToKeepMaxSpeed( rcsc::ServerParam::i() ),
                      it->second.getOneStepStaminaComsumption( rcsc::ServerParam::i() ),
                      it->second.playerDecay(),
                      it->second.inertiaMoment(),
                      it->second.dashPowerRate(),
                      it->second.kickableArea(),
                      it->second.kickRand(),
                      it->second.effortMax(),
                      it->second.effortMin() );
    }
    // uniform number of players that belongs to center defender
    //std::vector< int > center_defender_unum;
    // uniform number of players that belongs to side defender
    //std::vector< int > side_defender_unum;
    // uniform number of players that belongs to midfielder

    // uniform number of players that belongs to forward
    std::vector< int > forward_unum;
    std::vector< int > defender_unum;
    std::vector< int > defensivehalf_unum;
    std::vector< int > midfielder_unum;

    defender_unum.push_back( 2 );
    defender_unum.push_back( 3 );
    defender_unum.push_back( 4 );
    defender_unum.push_back( 5 );
    defensivehalf_unum.push_back( 6 );
    midfielder_unum.push_back( 7 );
    midfielder_unum.push_back( 8 );
    forward_unum.push_back( 11 );
    forward_unum.push_back( 9 );
    forward_unum.push_back( 10 );


    if ( rcsc::PlayerParam::i().allowMultDefaultType() ) //not used
    {
        for ( std::vector< int >::iterator it = defender_unum.begin();
              it != defender_unum.end();
              ++it )
        {
            int type = getFastestType( candidates );
            if ( type == rcsc::Hetero_Unknown ) continue;
            substituteTo( *it, type );
        }

        for ( std::vector< int >::iterator it = forward_unum.begin();
              it != forward_unum.end();
              ++it )
        {
            int type = getFastestType( candidates );
            if ( type == rcsc::Hetero_Unknown ) continue;
            substituteTo( *it, type );
        }

        for ( std::vector< int >::iterator it = midfielder_unum.begin();
              it != midfielder_unum.end();
              ++it )
        {
            int type = getFastestType( candidates );
            if ( type == rcsc::Hetero_Unknown ) continue;
            substituteTo( *it, type );
        }

        for ( std::vector< int >::iterator it = defensivehalf_unum.begin();
              it != defensivehalf_unum.end();
              ++it )
        {
            int type = getFastestType( candidates );
            if ( type == rcsc::Hetero_Unknown ) continue;
            substituteTo( *it, type );
        }
    }
    else //main
    {
        std::vector< std::pair< int, int > > types;
        types.reserve( 10 );
        for ( std::vector< int >::iterator it = forward_unum.begin();
              it != forward_unum.end();
              ++it )
        {
            int type = getFastestType( candidates );
            if ( type == rcsc::Hetero_Unknown ) continue;
            types.push_back( std::make_pair( *it, type ) );
        }
        for ( std::vector< int >::iterator it = defensivehalf_unum.begin();
              it != defensivehalf_unum.end();
              ++it )
        {
            int type = getStaminaType( candidates );
            if ( type == rcsc::Hetero_Unknown ) continue;
            types.push_back( std::make_pair( *it, type ) );
        }
        for ( std::vector< int >::iterator it = midfielder_unum.begin();
              it != midfielder_unum.end();
              ++it )
        {
            int type = getConsumeType( candidates );
            if ( type == rcsc::Hetero_Unknown ) continue;
            types.push_back( std::make_pair( *it, type ) );
        }
        for ( std::vector< int >::iterator it = defender_unum.begin();
              it != defender_unum.end();
              ++it )
        {
            int type = getFastestType( candidates );
            if ( type == rcsc::Hetero_Unknown ) continue;
            types.push_back( std::make_pair( *it, type ) );
        }




        substituteTo( types );
    }
/*
    //if ( config().version() < 12.0 )
    if ( rcsc::PlayerParam::i().allowMultDefaultType() )
    {
        for ( std::vector< int >::iterator it = forward_unum.begin();
              it != forward_unum.end();
              ++it )
        {
            int type = getFastestType( candidates );
            if ( type == rcsc::Hetero_Unknown ) continue;
            substituteTo( *it, type );
        }

        for ( std::vector< int >::iterator it = center_defender_unum.begin();
              it != center_defender_unum.end();
              ++it )
        {
            int type = getFastestType( candidates );
            if ( type == rcsc::Hetero_Unknown ) continue;
            substituteTo( *it, type );
        }

        for ( std::vector< int >::iterator it = side_defender_unum.begin();
              it != side_defender_unum.end();
              ++it )
        {
            int type = getFastestType( candidates );
            if ( type == rcsc::Hetero_Unknown ) continue;
            substituteTo( *it, type );
        }

        for ( std::vector< int >::iterator it = midfielder_unum.begin();
              it != midfielder_unum.end();
              ++it )
        {
            int type = getFastestType( candidates );
            if ( type == rcsc::Hetero_Unknown ) continue;
            substituteTo( *it, type );
        }
    }
    else
    {
        std::vector< std::pair< int, int > > types;
        types.reserve( 10 );

        for ( std::vector< int >::iterator it = forward_unum.begin();
              it != forward_unum.end();
              ++it )
        {
            int type = getFastestType( candidates );
            if ( type == rcsc::Hetero_Unknown ) continue;
            types.push_back( std::make_pair( *it, type ) );
        }

        for ( std::vector< int >::iterator it = center_defender_unum.begin();
              it != center_defender_unum.end();
              ++it )
        {
            int type = getFastestType( candidates );
            if ( type == rcsc::Hetero_Unknown ) continue;
            types.push_back( std::make_pair( *it, type ) );
        }

        for ( std::vector< int >::iterator it = side_defender_unum.begin();
              it != side_defender_unum.end();
              ++it )
        {
            int type = getFastestType( candidates );
            if ( type == rcsc::Hetero_Unknown ) continue;
            types.push_back( std::make_pair( *it, type ) );
        }

        for ( std::vector< int >::iterator it = midfielder_unum.begin();
              it != midfielder_unum.end();
              ++it )
        {
            int type = getFastestType( candidates );
            if ( type == rcsc::Hetero_Unknown ) continue;
            types.push_back( std::make_pair( *it, type ) );
        }

        substituteTo( types );
    }
*/

}

/*-------------------------------------------------------------------*/
/*!

 */
void
opuciCoach::substituteTo( const int unum,
                           const int type )
{
    std::vector< int >::iterator it = std::find( M_available_player_type_id.begin(),
                                                 M_available_player_type_id.end(),
                                                 type );
    if ( it == M_available_player_type_id.end() )
    {
        std::cerr << "***ERROR*** "
                  << config().teamName() << " coach: "
                  << " cannot change the player " << unum
                  << " to type " << type
                  << std::endl;
        return;
    }

    M_available_player_type_id.erase( it );

    std::cout << config().teamName() << " coach: "
              << "change player " << unum
              << " to type " << type
              << std::endl;
    M_player_type_id.insert( std::make_pair( unum, type ) );

    doChangePlayerType( unum, type );
}

/*-------------------------------------------------------------------*/
/*!

 */
void
opuciCoach::substituteTo( const std::vector< std::pair< int, int > > & types )
{
    if ( types.empty() )
    {
        std::cerr << "***WARNING*** "
                  << config().teamName() << " coach: "
                  << " empty player type assignment."
                  << std::endl;
        return;
    }

    for ( std::vector< std::pair< int, int > >::const_iterator t = types.begin();
          t != types.end();
          ++t )
    {
        std::vector< int >::iterator it = std::find( M_available_player_type_id.begin(),
                                                     M_available_player_type_id.end(),
                                                     t->second );
        if ( it == M_available_player_type_id.end() )
        {
            std::cerr << "***ERROR*** "
                      << config().teamName() << " coach: "
                      << " cannot change the player " << t->first
                      << " to type " << t->second
                      << std::endl;
            return;
        }
    }

    for ( std::vector< std::pair< int, int > >::const_iterator t = types.begin();
          t != types.end();
          ++t )
    {
        std::vector< int >::iterator it = std::find( M_available_player_type_id.begin(),
                                                     M_available_player_type_id.end(),
                                                     t->second );
        M_available_player_type_id.erase( it );

        std::cout << config().teamName() << " coach: "
                  << "change player " << t->first
                  << " to type " << t->second
                  << std::endl;
        M_player_type_id.insert( *t );
    }

    doChangePlayerTypes( types );
}
int
opuciCoach::getConsumeType( PlayerTypePtrCont & candidates )
{
    if ( candidates.empty() )
    {
        return rcsc::Hetero_Unknown;
    }
    PlayerTypePtrCont::iterator best_type = candidates.begin();
    double min = 100;
    for ( PlayerTypePtrCont::iterator it = candidates.begin();
          it != candidates.end();
          ++it )
    {
        double consume = (*it)->getOneStepStaminaComsumption( rcsc::ServerParam::i() );
        if( consume < min )
        {
            min = consume;
            best_type = it;
        }
    }
    

    int id = (*best_type)->id();
    candidates.erase( best_type );
    return id;    
}
/*-------------------------------------------------------------------*/
/*!

 */
int
opuciCoach::getFastestType( PlayerTypePtrCont & candidates )
{
    if ( candidates.empty() )
    {
        return rcsc::Hetero_Unknown;
    }

//     std::cerr << "getFastestType available types = ";
//     for ( PlayerTypePtrCont::iterator it = candidates.begin();
//           it != candidates.end();
//           ++it )
//     {
//         std::cerr << (*it)->id() << ' ';
//     }
//     std::cerr << std::endl;;

    // sort by max speed
    std::sort( candidates.begin(),
               candidates.end(),
               std::not2( RealSpeedMaxCmp() ) );

    PlayerTypePtrCont::iterator best_type = candidates.begin();
    double max_speed = (*best_type)->realSpeedMax();
    int min_cycle = 100;
    for ( PlayerTypePtrCont::iterator it = candidates.begin();
          it != candidates.end();
          ++it )
    {
        if ( (*it)->realSpeedMax() < max_speed - 0.01 )
        {
            break;
        }

        if ( (*it)->cyclesToReachMaxSpeed() < min_cycle )
        {
            best_type = it;
            max_speed = (*best_type)->realSpeedMax();
            min_cycle = (*best_type)->cyclesToReachMaxSpeed();
            continue;
        }

        if ( (*it)->cyclesToReachMaxSpeed() == min_cycle )
        {
            if ( (*it)->getOneStepStaminaComsumption( rcsc::ServerParam::i() )
                 < (*best_type)->getOneStepStaminaComsumption( rcsc::ServerParam::i()) )
            {
                best_type = it;
                max_speed = (*best_type)->realSpeedMax();
            }
        }
    }

    int id = (*best_type)->id();
    candidates.erase( best_type );
    return id;
}

/*-------------------------------------------------------------------*/
/*!

*/
int
opuciCoach::getStaminaType( PlayerTypePtrCont & candidates )
{
   if( candidates.empty() )
   {
      return rcsc::Hetero_Unknown;
   }
   std::sort( candidates.begin(),
              candidates.end(),
              std::not2( TypeStaminaIncComp() ) );
   PlayerTypePtrCont::iterator best_type = candidates.begin();
   double max_stamina = (*best_type)->staminaIncMax();
   for( PlayerTypePtrCont::iterator it = candidates.begin();
	it != candidates.end();
	++it )
   {
      if( (*it)->staminaIncMax() < max_stamina - 0.5 )
      {
	 break;
      }

      if( (*it)->getOneStepStaminaComsumption( rcsc::ServerParam::i() )
          < (*best_type)->getOneStepStaminaComsumption( rcsc::ServerParam::i() ) )
      {
	 best_type = it;
	 continue;
      }

      if( (*it)->getOneStepStaminaComsumption( rcsc::ServerParam::i() )
          == (*best_type)->getOneStepStaminaComsumption( rcsc::ServerParam::i() ) )
      {
	 if( (*it)->getDashPowerToKeepMaxSpeed( rcsc::ServerParam::i() )
	     < (*best_type)->getDashPowerToKeepMaxSpeed( rcsc::ServerParam::i() ) )
	 {
	    best_type = it;
	 }
      }
   }

   int id = (*best_type)->id();
   candidates.erase( best_type );
   return id;
}

/*-------------------------------------------------------------------*/
/*!

*/
int
opuciCoach::getDefenderType( PlayerTypePtrCont & candidates )
{
   if( candidates.empty() )
   {
      return rcsc::Hetero_Unknown;
   }
   std::sort( candidates.begin(),
              candidates.end(),
              std::not2( RealSpeedMaxCmp() ) );

   PlayerTypePtrCont::iterator best_type = candidates.begin();
   for( PlayerTypePtrCont::iterator it = candidates.begin();
	it != candidates.end();
	++it )
   {
      if( (*it)->staminaIncMax() > 40.0 )
      {
	 best_type = it;
      }
   }
   int id = (*best_type)->id();
   candidates.erase( best_type );
   return id;
}
/*-------------------------------------------------------------------*/
/*!

*/
void
opuciCoach::sayPlayerTypes()
{
    if ( ! config().useFreeform() )
    {
        return;
    }

    /*
      format:
      "(player_types (1 0) (2 1) (3 2) (4 3) (5 4) (6 5) (7 6) (8 -1) (9 0) (10 1) (11 2))"
      ->
      (say (freeform "(player_type ...)"))
    */

    static rcsc::GameTime s_last_send_time( 0, 0 );

    if ( ! world().canSendFreeform() )
    {
        return;
    }

    int analyzed_count = 0;

    for ( int unum = 1; unum <= 11; ++unum )
    {
        const int id = world().heteroID( world().theirSide(), unum );

        if ( id != M_opponent_player_types[unum - 1] )
        {
            M_opponent_player_types[unum - 1] = id;

            if ( id != rcsc::Hetero_Unknown )
            {
                ++analyzed_count;
            }
        }
    }

    if ( analyzed_count == 0 )
    {
        return;
    }

    std::string msg;
    msg.reserve( 128 );

    msg = "(player_types ";

    for ( int unum = 1; unum <= 11; ++unum )
    {
        char buf[8];
        snprintf( buf, 8, "(%d %d)",
                  unum, M_opponent_player_types[unum - 1] );
        msg += buf;
    }

    msg += ")";

    doSayFreeform( msg );

    s_last_send_time = world().time();

    std::cout << config().teamName()
              << " coach: "
              << world().time()
              << " send freeform " << msg
              << std::endl;
}

/*-------------------------------------------------------------------*/
/*!

*/
void
opuciCoach::sendTeamGraphic()
{
    int count = 0;
    for ( rcsc::TeamGraphic::Map::const_reverse_iterator tile
              = M_team_graphic.tiles().rbegin();
          tile != M_team_graphic.tiles().rend();
          ++tile )
    {
        if ( teamGraphicOKSet().find( tile->first ) == teamGraphicOKSet().end() )
        {
            if ( ! doTeamGraphic( tile->first.first,
                                  tile->first.second,
                                  M_team_graphic ) )
            {
                break;
            }
            ++count;
        }
    }

    if ( count > 0 )
    {
        std::cout << config().teamName()
                  << " coach: "
                  << world().time()
                  << " send team_graphic " << count << " tiles"
                  << std::endl;
    }
}

void 
opuciCoach::recordPos()
{
   static const rcsc::GlobalPlayerObject * opp1 = world().opponents().at(0);
   static const rcsc::GlobalPlayerObject * opp2 = world().opponents().at(1);
   static const rcsc::GlobalPlayerObject * opp3 = world().opponents().at(2);
   static const rcsc::GlobalPlayerObject * opp4 = world().opponents().at(3);
   static const rcsc::GlobalPlayerObject * opp5 = world().opponents().at(4);
   static const rcsc::GlobalPlayerObject * opp6 = world().opponents().at(5);
   static const rcsc::GlobalPlayerObject * opp7 = world().opponents().at(6);
   static const rcsc::GlobalPlayerObject * opp8 = world().opponents().at(7);
   static const rcsc::GlobalPlayerObject * opp9 = world().opponents().at(8);
   static const rcsc::GlobalPlayerObject * opp10 = world().opponents().at(9);
   static const rcsc::GlobalPlayerObject * opp11 = world().opponents().at(10);

   if( opp1 )
   {
      if( opp1->unum() != 1 )
      {

	 for ( std::vector< const rcsc::GlobalPlayerObject * >::const_iterator p = world().opponents().begin();
	       p != world().opponents().end();
	       ++p )
	 {
	    if ( (*p)->unum() == 1 )
	    {
	       opp1 = (*p);
	       break;
	    }
	 }
      }
   }
   if( opp2 )
   {
      if( opp2->unum() != 2 )
      {
	 for ( std::vector< const rcsc::GlobalPlayerObject * >::const_iterator p = world().opponents().begin();
	       p != world().opponents().end();
	       ++p )
	 {
	    if ( (*p)->unum() == 2 )
	    {
	       opp2 = (*p);
	       break;
	    }
	 }
      }
   }
   if( opp3 )
   {
      if( opp3->unum() != 3 )
      {
	 for ( std::vector< const rcsc::GlobalPlayerObject * >::const_iterator p = world().opponents().begin();
	       p != world().opponents().end();
	       ++p )
	 {
	    if ( (*p)->unum() == 3 )
	    {
	       opp3 = (*p);
	       break;
	    }
	 }
      }
   }
   if( opp4 )
   {
      if( opp4->unum() != 4 )
      {
	 for ( std::vector< const rcsc::GlobalPlayerObject * >::const_iterator p = world().opponents().begin();
	       p != world().opponents().end();
	       ++p )
	 {
	    if ( (*p)->unum() == 4 )
	    {
	       opp4 = (*p);
	       break;
	    }
	 }
      }
   }
   if( opp5 )
   {
      if( opp5->unum() != 5 )
      {
	 for ( std::vector< const rcsc::GlobalPlayerObject * >::const_iterator p = world().opponents().begin();
	       p != world().opponents().end();
	       ++p )
	 {
	    if ( (*p)->unum() == 5 )
	    {
	       opp5 = (*p);
	       break;
	    }
	 }
      }
   }
   if( opp6 )
   {
      if( opp6->unum() != 6 )
      {
	 for ( std::vector< const rcsc::GlobalPlayerObject * >::const_iterator p = world().opponents().begin();
	       p != world().opponents().end();
	       ++p )
	 {
	    if ( (*p)->unum() == 6 )
	    {
	       opp6 = (*p);
	       break;
	    }
	 }
      }
   }
   if( opp7 )
   {
      if( opp7->unum() != 7 )
      {
	 for ( std::vector< const rcsc::GlobalPlayerObject * >::const_iterator p = world().opponents().begin();
	       p != world().opponents().end();
	       ++p )
	 {
	    if ( (*p)->unum() == 7 )
	    {
	       opp7 = (*p);
	       break;
	    }
	 }
      }
   }
   if( opp8 )
   {
      if( opp8->unum() != 8 )
      {
	 for ( std::vector< const rcsc::GlobalPlayerObject * >::const_iterator p = world().opponents().begin();
	       p != world().opponents().end();
	       ++p )
	 {
	    if ( (*p)->unum() == 8 )
	    {
	       opp8 = (*p);
	       break;
	    }
	 }
      }
   }
   if( opp9 )
   {
      if( opp9->unum() != 9 )
      {
	 for ( std::vector< const rcsc::GlobalPlayerObject * >::const_iterator p = world().opponents().begin();
	       p != world().opponents().end();
	       ++p )
	 {
	    if ( (*p)->unum() == 9 )
	    {
	       opp9 = (*p);
	       break;
	    }
	 }
      }
   }
   if( opp10 )
   {
      if( opp1->unum() != 10 )
      {
	 for ( std::vector< const rcsc::GlobalPlayerObject * >::const_iterator p = world().opponents().begin();
	       p != world().opponents().end();
	       ++p )
	 {
	    if ( (*p)->unum() == 10 )
	    {
	       opp10 = (*p);
	       break;
	    }
	 }
      }
   }
   if( opp11 )
   {
      if( opp11->unum() != 11 )
      {
	 for ( std::vector< const rcsc::GlobalPlayerObject * >::const_iterator p = world().opponents().begin();
	       p != world().opponents().end();
	       ++p )
	 {
	    if ( (*p)->unum() == 11 )
	    {
	       opp11 = (*p);
	       break;
	    }
	 }
      }
   }

   //  if( world().gameMode().type() != rcsc::GameMode::BeforeKickOff 
   //    && world().gameMode().type() != rcsc::GameMode::AfterGoal_) //world().gameMode().type() == rcsc::GameMode::PlayOn )
   if( true )
   {
      cycle.push_back( world().time().cycle() );
      ballPos.push_back( world().ball().pos() );

      if( opp1 )
      {
	 M_oppPositions.at( 0 ).push_back( opp1->pos() );
      }
      if( opp2 )
      {
	 M_oppPositions.at( 1 ).push_back( opp2->pos() );
      }
      if( opp3 )
      {
	 M_oppPositions.at( 2 ).push_back( opp3->pos() );
      }
      if( opp4 )
      {
	 M_oppPositions.at( 3 ).push_back( opp4->pos() );
      }
      if( opp5 )
      {
	 M_oppPositions.at( 4 ).push_back( opp5->pos() );
      }
      if( opp6 )
      {
	 M_oppPositions.at( 5 ).push_back( opp6->pos() );
      }
      if( opp7 )
      {
	 M_oppPositions.at( 6 ).push_back( opp7->pos() );
      }
      if( opp8 )
      {
	 M_oppPositions.at( 7 ).push_back( opp8->pos() );
      }
      if( opp9 )
      {
	 M_oppPositions.at( 8 ).push_back( opp9->pos() );
      }
      if( opp10 )
      {
	 M_oppPositions.at( 9 ).push_back( opp10->pos() );
      }
      if( opp11 )
      {
	 M_oppPositions.at( 10 ).push_back( opp11->pos() );
      }
   }
   return;
}


bool 
opuciCoach::sendFirst( int num )
{
   int x = 80.000000;
   int y = 1000000;
   std::string msg = "(";
   msg.reserve( 128 );
   // "player number / message number"
   if( 1 <= num && num <= 9 )
   {
      char ch[10];
      sprintf( ch, "%d", num );
      msg += ch;
   }
   else if( num == 10 )
   {
      msg += "0";
   }
   else if( num == 11 )
   {
      msg += "-";
   }
   else
   {
      std::cout << "invalid number" << std::endl;
      return false;
   }
   msg += "1";
   std::ostringstream oss;
   int count = 0;
   if( num == 1 )
   {
      net1.print( oss );
   }
   else if( num == 2 )
   {
      net2.print( oss );
   }
   else if( num == 3 )
   {
      net3.print( oss );
   }
   else if( num == 4 )
   {
      net4.print( oss );
   }
   else if( num == 5 )
   {
      net5.print( oss );
   }
   else if( num == 6 )
   {
      net6.print( oss );
   }
   else if( num == 7 )
   {
      net7.print( oss );
   }
   else if( num == 8 )
   {
      net8.print( oss );
   }
   else if( num == 9 )
   {
      net9.print( oss );
   }
   else if( num == 10 )
   {
      net10.print( oss );
   }
   else if( num == 11 )
   {
      net11.print( oss );
   }

   std::istringstream iss( oss.str() );
   std::string tmp;
   while( count < 23 )
   {
      iss >> tmp;
      count++;
      double tmp2 =  atof( tmp.c_str() ) + x;
      int tmp3 = (int)( tmp2 * y );

      boost::int64_t ival = tmp3;
      int len = 5;
      std::string to = "";
      rcsc::AudioCodec::i().encodeInt64ToStr( ival, len, to );
      msg += to;
   }
   msg += ")";
   doSayFreeform( msg );
   return true;
}

bool
opuciCoach::sendSecond( int num )
{
   int x = 80.000000;
   int y = 1000000;
   std::string msg = "(";
   msg.reserve( 128 );
   if( 1 <= num && num <= 9 )
   {
      char ch[10];
      sprintf( ch, "%d", num );
      msg += ch;
   }
   else if( num == 10 )
   {
      msg += "0";
   }
   else if( num == 11 )
   {
      msg += "-";
   }
   else
   {
      std::cout << "invalid number" << std::endl;
      return false;
   }
   msg += "2";
   std::ostringstream oss;
   int count = 0;
   if( num == 1 )
   {
      net1.print( oss );
   }
   else if( num == 2 )
   {
      net2.print( oss );
   }
   else if( num == 3 )
   {
      net3.print( oss );
   }
   else if( num == 4 )
   {
      net4.print( oss );
   }
   else if( num == 5 )
   {
      net5.print( oss );
   }
   else if( num == 6 )
   {
      net6.print( oss );
   }
   else if( num == 7 )
   {
      net7.print( oss );
   }
   else if( num == 8 )
   {
      net8.print( oss );
   }
   else if( num == 9 )
   {
      net9.print( oss );
   }
   else if( num == 10 )
   {
      net10.print( oss );
   }
   else if( num == 11 )
   {
      net11.print( oss );
   }
   std::istringstream iss( oss.str() );
   std::string tmp;
   while( count < 23 )
   {
      iss >> tmp;
      count++;
   }
   while( count < 47 )
   {
      iss >> tmp;
      count++;
      double tmp2 =  atof( tmp.c_str() ) + x;
      int tmp3 = (int)( tmp2 * y );
      boost::int64_t ival = tmp3;
      int len = 5;
      std::string to = "";
      rcsc::AudioCodec::i().encodeInt64ToStr( ival, len, to );
      msg += to;
   }
   msg += ")";
   doSayFreeform( msg );
   return true;
}

bool
opuciCoach::sendNet()
{
   for( int i = 0; i < 11; i++ )
   {
      if( !sentFlags.at( i ).first )
      {
	 sentFlags.at( i ).first = sendFirst( i + 1 );
      }
      else if( !sentFlags.at( i ).second )
      {
	 sentFlags.at( i ).second = sendSecond( i + 1 );
      }
   }
   return sentFlags.at( 10 ).second;
}

rcsc::Vector2D
opuciCoach::getPos( BPN & net, rcsc::Vector2D ball )
{
   BPN::input_array input;
   BPN::output_array output;
   double ballX = ball.x;
   double ballY = ball.y;
   ballX /= PITCH_LENGTH;
   ballY /= PITCH_WIDTH;
   ballX += 0.5;
   ballY += 0.5;
   input[0] = rcsc::min_max( 0.1, ballX, 0.9 );
   input[1] = rcsc::min_max( 0.1, ballY, 0.9 );
   net.propagate( input, output );
   double out1 = output[0];
   double out2 = output[1];
   if( out1 >= 0.9 ) 
   {
      out1 = 0.9;
   }
   else if( out1 <= 0.1 ) 
   {
      out1 = 0.1;
   }
   if( out2 >= 0.9 )
   {
      out2 = 0.9;
   }
   else if( out2 <= 0.1 ) 
   {
      out2 = 0.1;
   }
   out1 -= 0.5;
   out2 -= 0.5;
   out1 *= PITCH_LENGTH;
   out2 *= PITCH_WIDTH;
   rcsc::Vector2D pos( out1, out2 );
   return pos;
}

void
opuciCoach::figure()
{
   std::vector< rcsc::Vector2D >::iterator end = ballPos.end();
   std::vector< rcsc::Vector2D >::iterator op1 = M_oppPositions.at( 0 ).begin();
   std::vector< rcsc::Vector2D >::iterator op2 = M_oppPositions.at( 1 ).begin();
   std::vector< rcsc::Vector2D >::iterator op3 = M_oppPositions.at( 2 ).begin();
   std::vector< rcsc::Vector2D >::iterator op4 = M_oppPositions.at( 3 ).begin();
   std::vector< rcsc::Vector2D >::iterator op5 = M_oppPositions.at( 4 ).begin();
   std::vector< rcsc::Vector2D >::iterator op6 = M_oppPositions.at( 5 ).begin();
   std::vector< rcsc::Vector2D >::iterator op7 = M_oppPositions.at( 6 ).begin();
   std::vector< rcsc::Vector2D >::iterator op8 = M_oppPositions.at( 7 ).begin();
   std::vector< rcsc::Vector2D >::iterator op9 = M_oppPositions.at( 8 ).begin();
   std::vector< rcsc::Vector2D >::iterator op10 = M_oppPositions.at( 9 ).begin();
   std::vector< rcsc::Vector2D >::iterator op11 = M_oppPositions.at( 10 ).begin();
   std::ofstream of1, of2, of3, of4, of5, of6, of7, of8, of9, of10, of11;
   of1.open( "opp1.txt" );
   of2.open( "opp2.txt" );
   of3.open( "opp3.txt" );
   of4.open( "opp4.txt" );
   of5.open( "opp5.txt" );
   of6.open( "opp6.txt" );
   of7.open( "opp7.txt" );
   of8.open( "opp8.txt" );
   of9.open( "opp9.txt" );
   of10.open( "opp10.txt" );
   of11.open( "opp11.txt" );
   for( std::vector< rcsc::Vector2D >::iterator ball = ballPos.begin();
	ball != end; 
	++ball )
   {
      rcsc::Vector2D ba( ball->x, ball->y );
      rcsc::Vector2D ansPos( 0, 0 );
      
      ansPos = getPos( net1, ba );
      of1 << ansPos.x << " " << op1->x << " "  << ansPos.y << " " << op1->y << std::endl;
      ++op1;

      ansPos = getPos( net2, ba );
      of2 << ansPos.x << " " << op2->x << " " << ansPos.y << " " << op2->y << std::endl;
      ++op2;
      
      ansPos = getPos( net3, ba );
      of3 << ansPos.x << " " << op3->x << " " << ansPos.y << " " << op3->y << std::endl;
      ++op3;
      
      ansPos = getPos( net4, ba );
      of4 << ansPos.x << " " << op4->x << " " << ansPos.y << " " << op4->y << std::endl;
      ++op4;
      
      ansPos = getPos( net5, ba );
      of5 << ansPos.x << " " << op5->x << " " << ansPos.y << " " << op5->y << std::endl;
      ++op5;
      
      ansPos = getPos( net6, ba );
      of6 << ansPos.x << " " << op6->x << " " << ansPos.y << " " << op6->y << std::endl;
      ++op6;

      ansPos = getPos( net7, ba );
      of7 << ansPos.x << " " << op7->x << " " << ansPos.y << " " << op7->y << std::endl;
      ++op7;

      ansPos = getPos( net8, ba );
      of8 << ansPos.x << " " << op8->x << " " << ansPos.y << " " << op8->y << std::endl;
      ++op8;

      ansPos = getPos( net9, ba );
      of9 << ansPos.x << " " << op9->x << " " << ansPos.y << " " << op9->y << std::endl;
      ++op9;

      ansPos = getPos( net10, ba );
      of10 << ansPos.x << " " << op10->x << " " << ansPos.y << " " << op10->y << std::endl;
      ++op10;
      
      ansPos = getPos( net11, ba );
      of11 << ansPos.x << " " << op11->x << " " << ansPos.y << " " << op11->y << std::endl;
      ++op11;
   }
   of1.close();
   of2.close();
   of3.close();
   of4.close();
   of5.close();
   of6.close();
   of7.close();
   of8.close();
   of9.close();
   of10.close();
   of11.close();
   return;
}

double 
train( long unum, int nth, int loop, opuciCoach::BPN & net, std::vector< rcsc::Vector2D > & bPos, std::vector< rcsc::Vector2D > & oPos )
{
   int num = 0;
   int reverse = 1;
   static bool random = true;
   if( side == rcsc::RIGHT )
   {
      reverse = -1;
   }
   else
   {
      reverse = 1;
   }

   if( nth == 0 ) //initialize
   {
      if( random )
      {
	 static boost::mt19937 gen( std::time( 0 ) );
	 boost::uniform_real<> dst( -0.5, 0.5 );
	 boost::variate_generator< boost::mt19937 &, boost::uniform_real<> > rng( gen, dst );
	 net.randomize( rng );
	 if( useCout )
	 {
	    std::cout << unum << " randomized" << std::endl;
	 }
      }
      else
      {
	 std::stringstream ss;
	 std::string name = ss.str();
	 std::ifstream ifs;
	 ifs.open( name.c_str() );
	 net.read( ifs );
	 ifs.close();
	 if( useCout )
	 {
	    std::cout << unum << " read file " << name << std::endl; 
	 }
	 
      }
   }//end initialize

   if( bPos.size() != oPos.size() || bPos.empty() )
   {
      std::cerr << unum << " invalid training data" << std::endl;
      std::cerr << bPos.size() << " " << oPos.size() << std::endl;
      return -1;
   }

   opuciCoach::BPN::input_array input;
   opuciCoach::BPN::output_array teacher;
   double ballX, ballY, oppX, oppY;
   
   std::vector< rcsc::Vector2D >::iterator ball = bPos.begin();
   std::vector< rcsc::Vector2D >::iterator end = bPos.end();
   std::vector< rcsc::Vector2D >::iterator opp = oPos.begin();
   
   while( ++num <= loop )
   {
      opp = oPos.begin();
      
      for( ball = bPos.begin(); ball != end; ++ball )
      {
	 ballX = ball->x;
	 ballX *= reverse;
	 ballY = ball->y;
	 ballX /= opuciCoach::PITCH_LENGTH;
	 ballY /= opuciCoach::PITCH_WIDTH;
	 ballX += 0.5;
	 ballY += 0.5;

	 input[0] = rcsc::min_max( 0.1, ballX, 0.9 );
	 input[1] = rcsc::min_max( 0.1, ballY, 0.9 );

	 oppX = opp->x;
	 oppX *= reverse;
	 oppY = opp->y;
	 oppX /= opuciCoach::PITCH_LENGTH;
	 oppY /= opuciCoach::PITCH_WIDTH;
	 oppX += 0.5;
	 oppY += 0.5;

	 teacher[0] = rcsc::min_max( 0.1, oppX, 0.9 );
	 teacher[1] = rcsc::min_max( 0.1, oppY, 0.9 );

	 net.train( input, teacher );
      }
   }//end training loop

   
   double error = 0;
   
   for( ball = bPos.begin(); ball != end; ++ball )
   {
      ballX = ball->x;
      ballX *= reverse;
      ballY = ball->y;
      ballX /= opuciCoach::PITCH_LENGTH;
      ballY /= opuciCoach::PITCH_WIDTH;
      ballX += 0.5;
      ballY += 0.5;
      
      input[0] = rcsc::min_max( 0.1, ballX, 0.9 );
      input[1] = rcsc::min_max( 0.1, ballY, 0.9 );
      
      oppX = opp->x;
      oppX *= reverse;
      oppY = opp->y;
      oppX /= opuciCoach::PITCH_LENGTH;
      oppY /= opuciCoach::PITCH_WIDTH;
      oppX += 0.5;
      oppY += 0.5;
      
      teacher[0] = rcsc::min_max( 0.1, oppX, 0.9 );
      teacher[1] = rcsc::min_max( 0.1, oppY, 0.9 );

      opuciCoach::BPN::output_array output;

      net.propagate( input, output );

      error += ( pow( ( teacher[0] - output[0] ), 2 )
                 + pow( ( teacher[1] - output[1] ), 2 ) );
   }
   
   error /= (double)bPos.size();
   
   
   return error;
}
