// -*-c++-*-

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "opuci_player.h"

#include "soccer_role.h"

#include "bhv_goalie_free_kick.h"
#include "bhv_opuci_penalty_kick.h"
#include "bhv_pre_process.h"
#include "bhv_set_play.h"
#include "bhv_set_play_kick_in.h"

#include <rcsc/formation/formation.h>
#include <rcsc/action/kick_table.h>
#include <rcsc/player/intercept_table.h>
#include <rcsc/player/say_message_builder.h>
#include <rcsc/player/audio_sensor.h>
#include <rcsc/player/freeform_parser.h>

#include <rcsc/common/basic_client.h>
#include <rcsc/common/logger.h>
#include <rcsc/common/server_param.h>
#include <rcsc/common/player_param.h>
#include <rcsc/common/audio_memory.h>
#include <rcsc/common/say_message_parser.h>
#include <rcsc/common/free_message_parser.h>

#include <rcsc/param/param_map.h>
#include <rcsc/param/cmd_line_parser.h>

#include <boost/shared_ptr.hpp>

#include <sstream>
#include <rcsc/action/body_smart_kick.h>
#include <rcsc/geom/polygon_2d.h>
#include <rcsc/action/body_go_to_point.h>
#include <rcsc/action/body_turn_to_point.h>
#include <rcsc/action/body_intercept.h>
#include <rcsc/action/neck_turn_to_low_conf_teammate.h>
#include <rcsc/action/neck_turn_to_ball_or_scan.h>
#include <rcsc/action/neck_scan_field.h>
#include <rcsc/action/neck_turn_to_ball_and_player.h>
#include <rcsc/action/neck_turn_to_ball.h>
#include <rcsc/action/body_turn_to_ball.h>
#include "strategy.h"
/*-------------------------------------------------------------------*/
/*!

*/
opuciPlayer::opuciPlayer()
    : PlayerAgent()
{
    typedef boost::shared_ptr< rcsc::SayMessageParser > SMP;

    boost::shared_ptr< rcsc::AudioMemory > audio_memory( new rcsc::AudioMemory );

    M_worldmodel.setAudioMemory( audio_memory );

    addSayMessageParser( SMP( new rcsc::BallMessageParser( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::PassMessageParser( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::InterceptMessageParser( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::GoalieMessageParser( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::OffsideLineMessageParser( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::DefenseLineMessageParser( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::WaitRequestMessageParser( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::PassRequestMessageParser( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::DribbleMessageParser( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::BallGoalieMessageParser( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::OnePlayerMessageParser( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::BallPlayerMessageParser( audio_memory ) ) );

    addSayMessageParser( SMP( new rcsc::FreeMessageParser< 9 >( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::FreeMessageParser< 8 >( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::FreeMessageParser< 7 >( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::FreeMessageParser< 6 >( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::FreeMessageParser< 5 >( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::FreeMessageParser< 4 >( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::FreeMessageParser< 3 >( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::FreeMessageParser< 2 >( audio_memory ) ) );
    addSayMessageParser( SMP( new rcsc::FreeMessageParser< 1 >( audio_memory ) ) );

    typedef boost::shared_ptr< rcsc::FreeformParser > FP;

    setFreeformParser( FP( new rcsc::FreeformParser( M_worldmodel ) ) );

}

/*-------------------------------------------------------------------*/
/*!

*/
opuciPlayer::~opuciPlayer()
{

}

/*-------------------------------------------------------------------*/
/*!

*/
void
opuciPlayer::setOpponentTeamName( std::string opponent_team_name )
{
    M_opponentTeamName = opponent_team_name;

    return;
}

/*-------------------------------------------------------------------*/
/*!

*/
std::string
opuciPlayer::opponentTeamName()
{
    return M_opponentTeamName;
}

/*-------------------------------------------------------------------*/
/*!

*/
bool
opuciPlayer::initImpl( rcsc::CmdLineParser & cmd_parser )
{
    bool result = rcsc::PlayerAgent::initImpl( cmd_parser );

    rcsc::ParamMap my_params;
#if 0
    std::string formation_conf;
    my_params.add()
        ( &formation_conf, "fconf" )
        ;

    cmd_parser.parse( my_params );
#endif

    if ( cmd_parser.count( "help" ) > 0 )
    {
        my_params.printHelp( std::cout );
        return false;
    }

    if ( ! result )
    {
        return false;
    }

    if ( cmd_parser.failed() )
    {
        std::cerr << "player: ***WARNING*** detected unsupported options: ";
        cmd_parser.print( std::cerr );
        std::cerr << std::endl;
    }

    if ( ! M_strategy.read( config().configDir() ) )
    {
        std::cerr << "***ERROR*** Failed to read team strategy." << std::endl;
        return false;
    }

    //////////////////////////////////////////////////////////////////
    // Add your code here.
    //////////////////////////////////////////////////////////////////

    inSetPlay = false;
    thrX = 33.0;

    M_opponentTeamName = "nanashi";
    
    return true;
}

/*-------------------------------------------------------------------*/
/*!
  main decision
  virtual method in super class
*/
void
opuciPlayer::actionImpl()
{
/*
  if ( audioSensor().trainerMessageTime() == world().time() )
  {
  std::cerr << world().teamName() << ' '
  << world().self().unum() << ": "
  << world().time()
  << " hear trainer message ["
  << audioSensor().trainerMessage()
  << "]"
  << std::endl;
  }

  if ( audioSensor().freeformMessageTime() == world().time() )
  {
  std::cerr << world().teamName() << ' '
  << world().self().unum() << ": "
  << world().time()
  << " hear freeform message ["
  << audioSensor().freeformMessage()
  << "]"
  << std::endl;
  }
*/

    static int setCycle = -200;
    if( M_opponentTeamName == "nanashi" )
    {
	setOpponentTeamName( M_strategy.read_opponent_name( world() ) );

	if( M_opponentTeamName == "nanashi" ){
	    if ( ! M_strategy.read_formation( config().configDir(), "default" ) )
	    {
		std::cerr << "***ERROR*** Failed to read team strategy." << std::endl;
	    }
	}
	else {
	    std::cout<<"teamname is "<<opponentTeamName()<<std::endl;
	    std::cout<<world().opponentTeamName()<<std::endl;
	    if ( ! M_strategy.read_formation( config().configDir(), opponentTeamName() ) )
	    {
		std::cerr << "***ERROR*** Failed to read team strategy." << std::endl;
	    }
	}
    }

    //////////////////////////////////////////////////////////////
    // check tackle expires
    // check self position accuracy
    // ball search
    // check queued intention
    // check simultaneous kick
    if ( Bhv_PreProcess( M_strategy ).execute( this ) )
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: preprocess done"
                            ,__FILE__, __LINE__ );
        return;
    }
    //////////////////////////////////////////////////////////////
    //check after-setplay
    if(	world().ball().pos().x > thrX  
	&& ( world().gameMode().type() == rcsc::GameMode::KickIn_ 
	     || world().gameMode().type() == rcsc::GameMode::CornerKick_
	    )//|| world().gameMode().type() == rcsc::GameMode::IndFreeKick_ )
	)
    {
        this->debugClient().addMessage( "PreAction" );
	setCycle = world().time().cycle();
    }
    if( world().existKickableOpponent() 
	&& !world().existKickableTeammate() )
    {
	setCycle = - 200;
    }

    //////////////////////////////////////////////////////////////
    // create current role
    boost::shared_ptr< SoccerRole >
        role_ptr = M_strategy.createRole( config().playerNumber(),
                                          world() );

    if ( ! role_ptr )
    {
        std::cerr << config().teamName() << ": "
                  << world().self().unum()
                  << " Error. Role is not registerd.\nExit ..."
                  << std::endl;
        M_client->setServerAlive( false );
        return;
    }
    if  ( ! role_ptr->hasFormation() )
    {
        std::cerr << config().teamName() << ": "
                  << world().self().unum()
                  << " Error. does not have formation.\nExit ..."
                  << std::endl;
        M_client->setServerAlive( false );
        return;
    }
    //////////////////////////////////////////////////////////////
    // after-setplay mode
    if( world().gameMode().type() == rcsc::GameMode::PlayOn
        && world().time().cycle() - setCycle < 50
        && !world().existKickableOpponent()
        && world().self().unum() >= 7 )
    {
	bool kicker = world().self().isKickable();
/*
  if( world().existKickableTeammate()
  && world().teammatesFromBall().front()->distFromBall()
  < world().ball().distFromSelf() )
  {
  kicker = false;
  }
*/
	if( Strategy::get_ball_area( world().ball().pos() ) == Strategy::BA_ShootChance )
	{
	    debugClient().addMessage( "NormalMove" );
	}
	else
	{
	    if( kicker )
	    {
		setPlayKick();
		return;
	    }
	    else
	    {
		if( world().ball().pos().absY() < world().self().pos().absY() - 3 )
		{
		    //do normal move
		    debugClient().addMessage( "NormalMove" );
		}
		else
		{
		    setPlayMove();
		    return;
		}
	    }
	}
    }//end if setplay mode





    //////////////////////////////////////////////////////////////
    // play_on mode
    if ( world().gameMode().type() == rcsc::GameMode::PlayOn  )
    {
        role_ptr->execute( this );
        return;
    }

    //////////////////////////////////////////////////////////////
    // kick_in or corner_kick
    if ( ( world().gameMode().type() == rcsc::GameMode::KickIn_
           || world().gameMode().type() == rcsc::GameMode::CornerKick_ )
         && world().ourSide() == world().gameMode().side() )
    {
        if ( world().self().goalie() )
        {
            Bhv_GoalieFreeKick().execute( this );
        }
        else
        {
            const rcsc::Vector2D base_pos = world().ball().pos();
            rcsc::Vector2D home_pos
                = role_ptr->formation().getPosition( config().playerNumber(),
                                                     base_pos );
            Bhv_SetPlayKickIn( home_pos ).execute( this );
        }
        return;
    }


    //////////////////////////////////////////////////////////////
    // penalty kick mode
    if ( world().gameMode().isPenaltyKickMode() )
    {
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            "%s:%d: penalty kick"
                            ,__FILE__, __LINE__ );
        Bhv_OpuciPenaltyKick().execute( this );
        return;
    }

    //////////////////////////////////////////////////////////////
    // goalie free kick mode
    if ( world().self().goalie() )
    {
        Bhv_GoalieFreeKick().execute( this );
        return;
    }

    //////////////////////////////////////////////////////////////
    // other set play mode

    rcsc::Vector2D move_pos
        = M_strategy.getSetPlayPosition( config().playerNumber(),
                                         role_ptr->formation(),
                                         world() );

    //////////////////////////////////////////////////////////////

    Bhv_SetPlay( move_pos ).execute( this );
}

/*-------------------------------------------------------------------*/
/*!
  communication decision.
  virtual method in super class
*/
void
opuciPlayer::communicationImpl()
{
    if ( ! config().useCommunication()
         || world().gameMode().type() == rcsc::GameMode::BeforeKickOff
         || world().gameMode().type() == rcsc::GameMode::AfterGoal_
         || world().gameMode().isPenaltyKickMode() )
    {
        return;
    }

    if( effector().getSayMessageLength() >= 1 )
    {
       //do not say
    }
    else
    {
       sayBall();
       sayDefenseLine();
       sayGoalie();
       sayIntercept();
       sayOffsideLine();
       saySelf();
    }

#if 0
    const int len = effector().getSayMessageLength();
    switch ( len ) {
    case 7:
        addSayMessage( new rcsc::FreeMessage< 2 >( "10" ) );
        break;
    case 6:
        addSayMessage( new rcsc::FreeMessage< 3 >( "210" ) );
        break;
    case 5:
        addSayMessage( new rcsc::FreeMessage< 4 >( "3210" ) );
        break;
    case 4:
        addSayMessage( new rcsc::FreeMessage< 5 >( "43210" ) );
        break;
    case 3:
        addSayMessage( new rcsc::FreeMessage< 6 >( "543210" ) );
        break;
    case 2:
        addSayMessage( new rcsc::FreeMessage< 7 >( "6543210" ) );
        break;
    case 1:
        addSayMessage( new rcsc::FreeMessage< 8 >( "76543210" ) );
        break;
    default:
        break;
    }
#endif

    attentiontoSomeone();
}

/*-------------------------------------------------------------------*/
/*!

*/
bool
opuciPlayer::sayBall()
{
    // ball Info: seen at current
    const int len = effector().getSayMessageLength();
    if ( static_cast< int >( len + rcsc::BallMessage::slength() )
         > rcsc::ServerParam::i().playerSayMsgSize()
         || world().ball().posCount() > 0
         || world().ball().velCount() > 0 )
    {
        return false;
    }

    const rcsc::PlayerObject * ball_nearest_teammate = NULL;
    const rcsc::PlayerObject * second_ball_nearest_teammate = NULL;

    const rcsc::PlayerPtrCont::const_iterator t_end = world().teammatesFromBall().end();
    for ( rcsc::PlayerPtrCont::const_iterator t = world().teammatesFromBall().begin();
          t != t_end;
          ++t )
    {
        if ( (*t)->isGhost() || (*t)->posCount() >= 10 ) continue;

        if ( ! ball_nearest_teammate )
        {
            ball_nearest_teammate = *t;
        }
        else if ( ! second_ball_nearest_teammate )
        {
            second_ball_nearest_teammate = *t;
            break;
        }
    }

    bool send_ball = false;
    if ( world().self().isKickable()  // I am kickable
         || ( ! ball_nearest_teammate
              || ( ball_nearest_teammate->distFromBall()
                   > world().ball().distFromSelf() - 3.0 ) ) // I am nearest to ball
         || ( second_ball_nearest_teammate
              && ( ball_nearest_teammate->distFromBall()  // nearest to ball teammate is
                   > rcsc::ServerParam::i().visibleDistance() - 0.5 ) // over vis dist
              && ( second_ball_nearest_teammate->distFromBall()
                   > world().ball().distFromSelf() - 5.0 ) ) ) // I am second
    {
        send_ball = true;
    }

    // send ball & goalie
    if ( send_ball
         && static_cast< int >( len + rcsc::BallGoalieMessage::slength() )
         <= rcsc::ServerParam::i().playerSayMsgSize()
         && world().ball().pos().x > 34.0
         && world().ball().pos().absY() < 20.0 )
    {
        const rcsc::PlayerObject * opp_goalie = world().getOpponentGoalie();
        if ( opp_goalie
             && opp_goalie->posCount() == 0
             && opp_goalie->bodyCount() == 0
             && opp_goalie->unum() != rcsc::Unum_Unknown
             && opp_goalie->distFromSelf() < 25.0
             && opp_goalie->pos().x > 52.5 - 16.0
             && opp_goalie->pos().x < 52.5
             && opp_goalie->pos().absY() < 20.0 )
        {
            addSayMessage( new rcsc::BallGoalieMessage( effector().queuedNextBallPos(),
                                                        effector().queuedNextBallVel(),
                                                        opp_goalie->pos(),
                                                        opp_goalie->body() ) );
            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                __FILE__": say ball/goalie status" );
            debugClient().addMessage( "SayG" );
            return true;
        }
    }

    // send only ball
    if ( send_ball )
    {
        addSayMessage( new rcsc::BallMessage( effector().queuedNextBallPos(),
                                              effector().queuedNextBallVel() ) );
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            __FILE__": say ball status" );
        debugClient().addMessage( "Sayb" );
        return true;
    }

    return false;
}

/*-------------------------------------------------------------------*/
/*!

*/
bool
opuciPlayer::sayGoalie()
{
    // goalie info: ball is in chance area
    int len = effector().getSayMessageLength();
    if ( static_cast< int >( len + rcsc::GoalieMessage::slength() )
         > rcsc::ServerParam::i().playerSayMsgSize()
         || world().ball().pos().x < 34.0
         || world().ball().pos().absY() > 20.0 )
    {
        return false;
    }

    const rcsc::PlayerObject * opp_goalie = world().getOpponentGoalie();
    if ( opp_goalie
         && opp_goalie->posCount() == 0
         && opp_goalie->bodyCount() == 0
         && opp_goalie->unum() != rcsc::Unum_Unknown
         && opp_goalie->distFromSelf() < 25.0 )
    {
        addSayMessage( new rcsc::GoalieMessage( opp_goalie->unum(),
                                                opp_goalie->pos(),
                                                opp_goalie->body() ) );
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            __FILE__": say goalie info: %d pos=(%.1f %.1f) body=%.1f",
                            opp_goalie->unum(),
                            opp_goalie->pos().x,
                            opp_goalie->pos().y,
                            opp_goalie->body().degree() );
        debugClient().addMessage( "Sayg" );
        return true;
    }

    return false;
}

/*-------------------------------------------------------------------*/
/*!

*/
bool
opuciPlayer::sayIntercept()
{
    // intercept info
    int len = effector().getSayMessageLength();
    if ( static_cast< int >( len + rcsc::InterceptMessage::slength() )
         > rcsc::ServerParam::i().playerSayMsgSize()
         || world().ball().posCount() > 0
         || world().ball().velCount() > 0 )
    {
        return false;
    }

    int self_min = world().interceptTable()->selfReachCycle();
    int mate_min = world().interceptTable()->teammateReachCycle();
    int opp_min = world().interceptTable()->opponentReachCycle();

    if ( world().self().isKickable() )
    {
        double next_dist =  effector().queuedNextMyPos().dist( effector().queuedNextBallPos() );
        if ( next_dist > world().self().kickableArea() )
        {
            self_min = 10000;
        }
        else
        {
            self_min = 0;
        }
    }

    if ( self_min <= mate_min
         && self_min <= opp_min
         && self_min <= 10 )
    {
        addSayMessage( new rcsc::InterceptMessage( true,
                                                   world().self().unum(),
                                                   self_min ) );
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            __FILE__": say self intercept info %d",
                            self_min );
        debugClient().addMessage( "Sayi_self" );
        return true;
    }
#if 0
    else
    {
        {
            const rcsc::PlayerObject * mate = world().interceptTable()->fastestTeammate();

            if ( mate
                 && mate->unum() != rcsc::Unum_Unknown
                 && mate->posCount() <= 0
                 && mate->distFromSelf() <= 15.0
                 && mate_min <= 10
                 && mate_min <= self_min + 1
                 && mate_min <= opp_min + 1 )
            {
                addSayMessage( new rcsc::InterceptMessage( true,
                                                           mate->unum(),
                                                           mate_min ) );
                rcsc::dlog.addText( rcsc::Logger::TEAM,
                                    __FILE__": say teammate intercept info %d",
                                    mate_min );
                debugClient().addMessage( "Sayi_our" );
                return true;
            }
        }
        {
            const rcsc::PlayerObject * opp = world().interceptTable()->fastestOpponent();
            if ( opp
                 && opp->unum() != rcsc::Unum_Unknown
                 && opp->posCount() <= 0
                 && opp->distFromSelf() <= 15.0
                 && opp_min <= 10
                 && opp_min <= self_min + 1
                 && opp_min <= mate_min + 1 )
            {
                addSayMessage( new rcsc::InterceptMessage( false,
                                                           opp->unum(),
                                                           opp_min ) );
                rcsc::dlog.addText( rcsc::Logger::TEAM,
                                    __FILE__": say opponent intercept info %d",
                                    opp_min );
                debugClient().addMessage( "Sayi_opp" );
                return true;
            }
        }
    }
#endif
    return false;
}

/*-------------------------------------------------------------------*/
/*!

*/
bool
opuciPlayer::sayOffsideLine()
{
    int len = effector().getSayMessageLength();
    if ( static_cast< int >( len + rcsc::OffsideLineMessage::slength() )
         > rcsc::ServerParam::i().playerSayMsgSize() )
    {
        return false;
    }

    if ( world().offsideLineCount() <= 1
         && world().opponentsFromSelf().size() >= 8
         && 0.0 < world().ball().pos().x
         && world().ball().pos().x < 37.0
         && world().ball().pos().x > world().offsideLineX() - 20.0
         && std::fabs( world().self().pos().x - world().offsideLineX() ) < 20.0
         )
    {
        addSayMessage( new rcsc::OffsideLineMessage( world().offsideLineX() ) );
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            __FILE__": say offside line %.1f",
                            world().offsideLineX() );
        debugClient().addMessage( "Sayo" );
        return true;
    }

    return false;
}


/*-------------------------------------------------------------------*/
/*!

*/
bool
opuciPlayer::sayDefenseLine()
{
    int len = effector().getSayMessageLength();
    if ( static_cast< int >( len + rcsc::DefenseLineMessage::slength() )
         > rcsc::ServerParam::i().playerSayMsgSize()
         || std::fabs( world().self().pos().x - world().defenseLineX() ) > 40.0
         )
    {
        return false;
    }

    int opp_min = world().interceptTable()->opponentReachCycle();

    rcsc::Vector2D opp_trap_pos = world().ball().inertiaPoint( opp_min );

    if ( world().self().goalie()
         && -40.0 < opp_trap_pos.x
         && opp_trap_pos.x > 10.0 )
    {
        addSayMessage( new rcsc::DefenseLineMessage( world().defenseLineX() ) );
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            __FILE__": say defense line %.1f",
                            world().defenseLineX() );
        debugClient().addMessage( "Sayd" );
        return true;
    }

    return false;
}


/*-------------------------------------------------------------------*/
/*!

*/
bool
opuciPlayer::saySelf()
{
    const int len = effector().getSayMessageLength();
    if ( static_cast< int >( len + rcsc::DefenseLineMessage::slength() )
         > rcsc::ServerParam::i().playerSayMsgSize()
         || std::fabs( world().self().pos().x - world().defenseLineX() ) > 40.0
         )
    {
        return false;
    }

    bool send_self = false;

    if ( len > 0 )
    {
        send_self = true;
    }

    if ( ! send_self )
    {
        const rcsc::PlayerObject * ball_nearest_teammate = NULL;
        const rcsc::PlayerObject * second_ball_nearest_teammate = NULL;

        const rcsc::PlayerPtrCont::const_iterator t_end = world().teammatesFromBall().end();
        for ( rcsc::PlayerPtrCont::const_iterator t = world().teammatesFromBall().begin();
              t != t_end;
              ++t )
        {
            if ( (*t)->isGhost() || (*t)->posCount() >= 10 ) continue;

            if ( ! ball_nearest_teammate )
            {
                ball_nearest_teammate = *t;
            }
            else if ( ! second_ball_nearest_teammate )
            {
                second_ball_nearest_teammate = *t;
                break;
            }
        }

        if ( ball_nearest_teammate
             && ball_nearest_teammate->distFromBall() < world().ball().distFromSelf()
             && ( ! second_ball_nearest_teammate
                  || second_ball_nearest_teammate->distFromBall() > world().ball().distFromSelf() )
             )
        {
            send_self = true;
        }
    }

    if ( send_self )
    {
        addSayMessage( new rcsc::OnePlayerMessage( world().self().unum(),
                                                   effector().queuedNextMyPos(),
                                                   effector().queuedNextMyBody() ) );
        rcsc::dlog.addText( rcsc::Logger::TEAM,
                            __FILE__": say self status" );
        debugClient().addMessage( "Say1_self" );
        return true;
    }

    return false;
}

/*-------------------------------------------------------------------*/
/*!

*/
void
opuciPlayer::attentiontoSomeone()
{
    if ( world().self().pos().x > world().offsideLineX() - 15.0
         && world().interceptTable()->selfReachCycle() <= 3 )
    {
        std::vector< const rcsc::PlayerObject * > candidates;
        const rcsc::PlayerPtrCont::const_iterator end = world().teammatesFromSelf().end();
        for ( rcsc::PlayerPtrCont::const_iterator p = world().teammatesFromSelf().begin();
              p != end;
              ++p )
        {
            if ( (*p)->goalie() ) continue;
            if ( (*p)->unum() == rcsc::Unum_Unknown ) continue;
            if ( (*p)->pos().x > world().offsideLineX() + 1.0 ) continue;

            if ( (*p)->distFromSelf() > 20.0 ) break;

            candidates.push_back( *p );
        }

        const rcsc::PlayerObject * target_teammate = NULL;
        double max_x = -100.0;
        for ( std::vector< const rcsc::PlayerObject * >::const_iterator p = candidates.begin();
              p != candidates.end();
              ++p )
        {
            if ( (*p)->pos().x > max_x )
            {
                max_x = (*p)->pos().x;
                target_teammate = *p;
            }
        }

        if ( target_teammate )
        {
            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                __FILE__": attentionto most front teammate",
                                world().offsideLineX() );
            debugClient().addMessage( "AttFrontMate" );
            doAttentionto( world().ourSide(), target_teammate->unum() );
            return;
        }

        // maybe ball owner
        if ( world().self().attentiontoUnum() > 0 )
        {
            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                __FILE__": attentionto off. maybe ball owner",
                                world().offsideLineX() );
            debugClient().addMessage( "AttOffBOwner" );
            doAttentiontoOff();
        }
        return;
    }

    const rcsc::PlayerObject * fastest_teammate
        = world().interceptTable()->fastestTeammate();

    int self_min = world().interceptTable()->selfReachCycle();
    int mate_min = world().interceptTable()->teammateReachCycle();
    int opp_min = world().interceptTable()->opponentReachCycle();

    if ( ! fastest_teammate )
    {
        if ( world().self().attentiontoUnum() > 0 )
        {
            rcsc::dlog.addText( rcsc::Logger::TEAM,
                                __FILE__": attentionto off. no fastest teammate",
                                world().offsideLineX() );
            debugClient().addMessage( "AttOffNoMate" );
            doAttentiontoOff();
        }
        return;
    }
    static int last_owner = 0;
    if ( mate_min < self_min
         && mate_min <= opp_min
         && fastest_teammate->unum() != rcsc::Unum_Unknown )
    {
        // set attention to ball nearest teammate
        debugClient().addMessage( "AttBallOwner" );
        doAttentionto( world().ourSide(), fastest_teammate->unum() );
        last_owner = fastest_teammate->unum();
        return;
    }
/*
    else if( mate_min < self_min
             && mate_min <= opp_min + 2
             && fastest_teammate->unum() == rcsc::Unum_Unknown 
             && last_owner != 0 )
*/
    else if( mate_min < self_min
             && ( !world().existKickableOpponent() 
                  || world().existKickableTeammate() ) )
    {
        debugClient().addMessage( "ContinueAttBallOwner" );
        doAttentionto( world().ourSide(), last_owner );
        return;
    }
    else
    {
        if( !( mate_min < self_min ) )
        {
            debugClient().addMessage( "NotMatemin<Selfmin" );
        }
        if( !( mate_min <= opp_min + 2 ) )
        {
            debugClient().addMessage( "NotMatemin<=Oppmin" );
        }
        if( fastest_teammate->unum() == rcsc::Unum_Unknown )
        {
            debugClient().addMessage( "UnumUnknown" );
        }
    }

    debugClient().addMessage( "AttOff" );
    doAttentiontoOff();
}


/*-------------------------------------------------------------------*/
/*!

*/
void
opuciPlayer::handleServerParam()
{
    if ( rcsc::KickTable::instance().createTables() )
    {
        std::cerr << world().teamName() << ' '
                  << world().self().unum() << ": "
                  << " KickTable crated."
                  << std::endl;
    }
    else
    {
        std::cerr << world().teamName() << ' '
                  << world().self().unum() << ": "
                  << " KickTable failed..."
                  << std::endl;
        M_client->setServerAlive( false );
    }
}

/*-------------------------------------------------------------------*/
/*!

*/
void
opuciPlayer::setPlayKick()
{
   debugClient().addMessage( "SetKick" );
   bool shooter = false;
   rcsc::Vector2D target_point( 52, 0 );
   int receiver = rcsc::Unum_Unknown;
   double ball_speed = rcsc::ServerParam::i().ballSpeedMax();


   /////////////////////////////////////////////////////////
   //check shooter
   if( world().self().pos().x > 30
       && world().self().pos().absY() < 20 )
   {
      bool existOtherShooter = false;

      const rcsc::PlayerPtrCont::const_iterator end = world().teammatesFromSelf().end();
      for( rcsc::PlayerPtrCont::const_iterator it = world().teammatesFromSelf().begin();
	   it != end;
	   ++it )
      {
	 rcsc::Vector2D matePos = (*it)->pos();
	 if( matePos.absY() < world().self().pos().absY() - 5
       	     && matePos.x > 25 )
	 {
	    existOtherShooter = true;
	 }
      }
      
      if( !existOtherShooter )
      {
	 shooter = true;
      }
   }

   ///////////////////////////////////////////////////////////
   //shoot
   if( shooter )
   {
      const rcsc::PlayerObject * goalie = world().getOpponentGoalie();
      rcsc::Vector2D tmp_target( 52, 0 );
      if( goalie )
      {
	 if( goalie->pos().y > 0 )
	 {
	    tmp_target.y = -6.5;
	 }
	 else
	 {
	    tmp_target.y = 6.5;
	 }
      }
      else
      {
	 if( world().self().pos().y > 0 )
	 {
	    tmp_target.y = -6.5;
	 }
	 else
	 {
	    tmp_target.y = 6.5;
	 }
      }
      target_point = tmp_target;
      
      rcsc::Body_SmartKick( target_point,
                            ball_speed,
                            ball_speed * 0.96,
                            3 ).execute( this );
      return;
   }

   //////////////////////////////////////////////////////////
   //pass

   const rcsc::PlayerObject * target_mate = NULL;
   double radius = 3.0;
   const rcsc::PlayerPtrCont::const_iterator end = world().teammatesFromSelf().end();
   for( rcsc::PlayerPtrCont::const_iterator it = world().teammatesFromSelf().begin();
	it != end;
	++it )
   {
      if( (*it)->pos().absY() < world().self().pos().absY()
          && (*it)->distFromSelf() > 3
          && (*it)->distFromSelf() < 20
          && (*it)->pos().x >= thrX )
      {
	 target_mate = (*it);
	 break;
      }
   }
   if( !target_mate )
   {
      target_mate = world().getTeammateNearestToSelf( 3 );
   }

   if( target_mate )
   {
      receiver = target_mate->unum();
      rcsc::Vector2D tmp_target = target_mate->pos();
      bool found = false;
      std::vector< rcsc::Vector2D > candidates;
      std::vector< bool > eval;
      setCandidates( tmp_target, candidates, world().offsideLineX(), radius );

      for( unsigned int i = 0; i < candidates.size(); i++ )
      {
	 std::vector< rcsc::Vector2D > vertices;
	 double tmpY = 0;
	 if( world().self().pos().y > 0 )
	 {
	    tmpY = candidates.at( i ).y;
	 }
	 else
	 {
	    tmpY = candidates.at( i ).y;
	 }
	 vertices.push_back( rcsc::Vector2D( candidates.at( i ).x + 0.2, tmpY ) );
	 vertices.push_back( rcsc::Vector2D( candidates.at( i ).x - 0.2, tmpY ) );
	 vertices.push_back( world().self().pos() );
	 rcsc::Polygon2D polygon( vertices );
	 if( !world().existOpponentIn( polygon, 3, true ) )
	 {
	    found = true;
	    eval.push_back( true );
	    target_point = candidates.at( i );
	 }
	 else
	 {
	    eval.push_back( false );
	 }
      }
      if( !found )
      {
	 target_point = tmp_target;
      }
      else
      {
	 double dist = 0;
	 double max = 0;
	 int best = 0;
	 
	 for( unsigned int i = 0; i < eval.size(); i++ )
	 {
	    if( eval.at( i ) )
	    {
/*
	       const rcsc::PlayerObject * target_opp = 
		  world().getOpponentNearestTo( candidates.at( i ), 5, & dist );
	       if( target_opp )
	       {
		  if( max < dist )
		  {
		     max = dist;
		     best = i;
		  }
	       }
	       else
	       {
		  best = i;
		  dist = 100;
		  break;
	       }
*/
	       dist = candidates.at( i ).x;
	       if( dist > max )
	       {
		  max = dist;
		  best = i;
	       }
	    }
	 }
	 target_point = candidates.at( best );	 
      }
   }
   else
   {
      target_point = rcsc::Vector2D( 50, 0 );
   }
   ball_speed = getBestSpeed( target_point.dist( world().ball().pos() ), radius  );
   if( target_mate )
   {
      if( world().time().cycle() % 2 == 0 )
      {
	 this->setNeckAction( new rcsc::Neck_TurnToBallAndPlayer( world().teammate( target_mate->unum() ) ) );
      }
      this->setNeckAction( new rcsc::Neck_TurnToLowConfTeammate() );
   }
   else
   {
      this->setNeckAction( new rcsc::Neck_TurnToLowConfTeammate() );
   }

   rcsc::Body_SmartKick( target_point,
                         ball_speed,
                         ball_speed * 0.96,
                         3 ).execute( this );
   debugClient().setTarget( target_point );
   if ( this->config().useCommunication()
        && receiver != rcsc::Unum_Unknown )
   {
      rcsc::dlog.addText( rcsc::Logger::ACTION,
      "%s:%d: execute() set pass communication.freekick"
      ,__FILE__, __LINE__ );
      rcsc::Vector2D target_buf = target_point - this->world().self().pos();
      target_buf.setLength( 0.3 );
      this->addSayMessage( new rcsc::PassMessage( receiver,
                           target_point,
                           this->effector().queuedNextBallPos(),
                           this->effector().queuedNextBallVel() ) );
   }
   
   return;
}


/*-------------------------------------------------------------------*/
/*!

*/
void
opuciPlayer::setPlayMove()
{
   debugClient().addMessage( "SetMove" );
   int self_min = world().interceptTable()->selfReachCycle();
   int mate_min = world().interceptTable()->teammateReachCycle();
   int opp_min = world().interceptTable()->opponentReachCycle();

   if ( ! world().existKickableTeammate()
        && ( self_min <= 3
             || ( self_min < mate_min + 3
                  && self_min < opp_min + 4 ) ) )
   {
      rcsc::dlog.addText( rcsc::Logger::TEAM,
      "%s:%d: intercept"
      ,__FILE__, __LINE__ );
      rcsc::Body_Intercept().execute( this );
/*
      if ( world().ball().distFromSelf()
      < rcsc::ServerParam::i().visibleDistance() )
      {
	 this->setNeckAction( new rcsc::Neck_TurnToLowConfTeammate() );
      }
      else
      {
	 //this->setNeckAction( new rcsc::Neck_TurnToBallOrScan() );
	 this->setNeckAction( new rcsc::Neck_TurnToLowConfTeammate() );
      }
*/
      if( world().time().cycle() % 2 == 0 )
      {
	 this->setNeckAction( new rcsc::Neck_TurnToBall() );
      }
      else
      {
	 this->setNeckAction( new rcsc::Neck_TurnToLowConfTeammate() );
      }
      return;
   }
   
   //////////////////////////////////////////////////////////////////
   
   rcsc::Vector2D target_pos = world().self().pos();
   int reverse = 1;
   if( target_pos.y < 0 )
   {
      reverse = -1;
   }
   const rcsc::PlayerObject * target_opp1 = NULL;
   const rcsc::PlayerObject * target_opp2 = NULL;
   const rcsc::PlayerObject * target_opp3 = NULL;

   const rcsc::PlayerPtrCont::const_iterator end = world().opponentsFromSelf().end();
   for( rcsc::PlayerPtrCont::const_iterator it = world().opponentsFromSelf().begin();
	it != end;
	++it )
   {
      if( !target_opp1 )
      {
	 target_opp1 = (*it);
      }
      else if( !target_opp2 )
      {
	 target_opp2 = (*it);
      }
      else if( !target_opp3 )
      {
	 target_opp3 = (*it);
	 break;
      }
   }
   rcsc::Vector2D base_pos = world().self().pos();
   rcsc::Vector2D opponent_pos = base_pos;
   
   const rcsc::PlayerObject * passer = NULL;
   const rcsc::PlayerPtrCont::const_iterator end2 = world().teammatesFromSelf().end();
   for( rcsc::PlayerPtrCont::const_iterator it = world().teammatesFromSelf().begin();
	it != end2;
	++it )
   {
      if( (*it)->pos().absY() > world().self().pos().absY()
      && (*it)->pos().x >= thrX )
      {
	 passer = (*it);
	 break;
      }
   }
   if( passer )
   {
      if( target_opp1 )
      {
	 double length = 5.0;
	 opponent_pos = target_opp1->pos();
	 if( ( opponent_pos.absY() >= target_pos.absY()
	       && opponent_pos.absY() <= passer->pos().absY() ) 
	     || target_pos.dist( opponent_pos ) < length )
	 {
	    if( opponent_pos.x >= target_pos.x - length )
	    {
	       target_pos.x = opponent_pos.x + length;
	    }
	    /*
	    if( opponent_pos.absY() >= target_pos.absY() - 3 )
	    {
	       target_pos.y = opponent_pos.y + 3.0 * reverse;
	    }
	    */
	 }
	 
	 if( target_opp2 )
	 {
	    opponent_pos = target_opp2->pos();
	    if( ( opponent_pos.absY() >= target_pos.absY()
	          && opponent_pos.absY() <= passer->pos().absY() ) 
	        || target_pos.dist( opponent_pos ) < length )
	    {
	       if( opponent_pos.x >= target_pos.x - length )
	       {
		  target_pos.x = opponent_pos.x + length;
	       }
	       /*
	       if( opponent_pos.absY() > target_pos.absY() - 3  )
	       {
		  target_pos.y = opponent_pos.y + 3.0 * reverse;
	       }
	       */
	    }
	    if( target_opp3 )
	    {
	       opponent_pos = target_opp2->pos();
	       if( ( opponent_pos.absY() >= target_pos.absY()
	             && opponent_pos.absY() <= passer->pos().absY() ) 
	           || target_pos.dist( opponent_pos ) < length )
	       {
		  if( opponent_pos.x >= target_pos.x - length )
		  {
		     target_pos.x = opponent_pos.x + length;
		  }
		  /*
		  if( opponent_pos.absY() > target_pos.absY() - 3 )
		  {
		     target_pos.y = opponent_pos.y + 3.0 * reverse;
		  }
		  */
	       }
	    }//end if target_opp3
	 }//end if target_opp2
      }//end if target_opp1
   }//end if passer



   double defLine = 0;
   const rcsc::PlayerPtrCont::const_iterator end3 = world().opponentsFromSelf().end();
   for( rcsc::PlayerPtrCont::const_iterator it = world().opponentsFromSelf().begin();
	it != end3;
	++it )
   {
      if( !(*it)->goalie() && (*it)->pos().x > defLine )
      {
	 defLine = (*it)->pos().x;
      }
   }

   if( passer )
   {
      if( passer->pos().absY() <= 32 
      && passer->pos().x > defLine )
      {
	 if( passer->pos().x < target_pos.x + 1.5 )
	 {
	    target_pos.x = passer->pos().x - 1.5;
	 }
      }
      if( passer->pos().dist( target_pos ) < 7 )
      {
	 target_pos.y = passer->pos().y - 7 * reverse;
      }

      
      if( reverse < 0 )
      {
	 if( world().self().unum() == 10 )
	 {
	    target_pos.x = defLine - 5;
	 }
	 else if( world().self().unum() == 8 )
	 {
	    if( passer->pos().x > defLine )
	    {
	       target_pos.x = passer->pos().x - 1;
	    }
	    else
	    {
	       target_pos.x = defLine - 1;
	    }
	 }
      }
      else
      {
	 if( world().self().unum() == 9 )
	 {
	    target_pos.x = defLine - 5;
	 }
	 else if( world().self().unum() == 7 )
	 {
	    if( passer->pos().x > defLine )
	    {
		  target_pos.x = passer->pos().x - 1;
	    }
	    else
	    {
	       target_pos.x = defLine - 1;
	    }
	 }
      }
   }//end if passer

   if( target_pos.x > 51 )
   {
      target_pos.x = 51;
   }
   if( target_pos.y > 33 )
   {
      target_pos.y = 33;
   }
   if( target_pos.y < -33 )
   {
      target_pos.y = -33;
   }
   double dist_thr = 0.2;
   double dash_power = 80;
   debugClient().setTarget( target_pos );
   if( !rcsc::Body_GoToPoint( target_pos, dist_thr, dash_power ).execute( this ) )
   {
      rcsc::Body_TurnToBall().execute( this );
   }
//   this->setNeckAction( new rcsc::Neck_ScanField );
   if( passer )
   {
      if( world().time().cycle() % 2 == 0 )
      {
	 this->setNeckAction( new rcsc::Neck_TurnToBallAndPlayer( world().teammate( passer->unum() ) ) );
      }
      this->setNeckAction( new rcsc::Neck_TurnToLowConfTeammate() );
   }
   else
   {
      this->setNeckAction( new rcsc::Neck_TurnToLowConfTeammate() );
   }

   return;
}


/*-------------------------------------------------------------------*/
/*!

*/
double
opuciPlayer::getBestSpeed( double dist, double move_dist )
{
   double sm = 0;
   double ps = 0;
   int min_cycle = 0;
   move_dist += 0.5;
   while( sm < move_dist )
   {
      min_cycle++;
      ps +=  rcsc::ServerParam::i().defaultDashPowerRate() * rcsc::ServerParam::i().maxPower();
      sm += ps;
      ps *= rcsc::ServerParam::i().defaultPlayerDecay();
   }
   

/////////////////////////////////////////////////////////
   double speed = rcsc::ServerParam::i().ballSpeedMax();
   int cycle = 0;
   while( cycle < 10 )
   {
      cycle++;
      double sum = rcsc::calc_sum_geom_series( speed, rcsc::ServerParam::i().ballDecay(), cycle );
      if( sum >= dist )
      {
	 if( cycle < min_cycle + 2 )
	 {
	    cycle = min_cycle + 2;
	 }
	 speed = rcsc::calc_first_term_geom_series( dist, rcsc::ServerParam::i().ballDecay(), cycle );
	 break;
      }

   }
   
   return speed;
}

/*-------------------------------------------------------------------*/
/*!

*/
void
opuciPlayer::setCandidates( rcsc::Vector2D base_pos, std::vector< rcsc::Vector2D > & candidates, double offsideX, double radius )
{
   candidates.clear();
   candidates.push_back( base_pos );
   
   rcsc::Vector2D cand1 = base_pos;
   rcsc::Vector2D cand2 = base_pos;
   rcsc::Vector2D cand3 = base_pos;
   rcsc::Vector2D cand4 = base_pos;
   rcsc::Vector2D cand5 = base_pos;
   rcsc::Vector2D cand6 = base_pos;
   rcsc::Vector2D cand7 = base_pos;
   rcsc::Vector2D cand8 = base_pos;

   
   cand1.x += radius;

   cand2.x += radius * cos( M_PI_4 );
   cand2.y += radius * sin( M_PI_4 );

   cand3.y += radius;

   cand4.x += radius * cos( M_PI_4 * 3 );
   cand4.y += radius * sin( M_PI_4 * 3 );

   cand5.x -= radius;

   cand6.x += radius * cos( M_PI_4 * 5 );
   cand6.y += radius * sin( M_PI_4 * 5 );

   cand7.y -= radius;

   cand8.x += radius * cos( M_PI_4 * 7 );
   cand8.y += radius * sin( M_PI_4 * 7 );

   candidates.push_back( cand1 );
   candidates.push_back( cand2 );
   candidates.push_back( cand3 );
   candidates.push_back( cand4 );
   candidates.push_back( cand5 );
   candidates.push_back( cand6 );
   candidates.push_back( cand7 );
   candidates.push_back( cand8 );

   for( unsigned int i = 0; i < candidates.size(); i++ )
   {

      if( candidates.at( i ).x > 50.2 )
      {
	 candidates.at( i ).x = 50.5;
      }
      if( candidates.at( i ).y > 32 )
      {
	 candidates.at( i ).y = 32;
      }
      if( candidates.at( i ).y < -32 )
      {
	 candidates.at( i ).y = -32;
      }
   }

   return;
}
