// -*-c++-*-

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef OPUCI_OPUCI_PLAYER_H
#define OPUCI_OPUCI_PLAYER_H

#include <rcsc/player/player_agent.h>

#include "strategy.h"

class opuciPlayer
    : public rcsc::PlayerAgent {
private:
    std::string M_opponentTeamName;

protected:
    Strategy M_strategy;

public:

    void setOpponentTeamName( std::string opponent_team_name );
    std::string opponentTeamName();

    opuciPlayer();

    virtual
    ~opuciPlayer();

protected:

    /*!
      You can override this method.
      But you must call PlayerAgent::initImpl() in this method.
    */
    virtual
    bool initImpl( rcsc::CmdLineParser & cmd_parser );

    //! main decision
    virtual
    void actionImpl();

    //! communication decision
    virtual
    void communicationImpl();

    //! hook method for handling server param message
    virtual
    void handleServerParam();

private:

    bool sayBall();
    bool saySelf();
    bool sayGoalie();
    bool sayIntercept();
    bool sayOffsideLine();
    bool sayDefenseLine();

    void attentiontoSomeone();
      void setPlayKick();
      void setPlayMove();
      double getBestSpeed( double dist, double move_dist );
      void setCandidates( rcsc::Vector2D base_pos, std::vector< rcsc::Vector2D > & candidates, double offsideX, double radius );
      bool inSetPlay;
      double thrX;
};

#endif
