/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.nexaweb.controller;

import com.nexaweb.client.ClientEvent;
import com.nexaweb.client.ClientSession;
import com.nexaweb.client.mco.AbstractMco;
import com.nexaweb.client.mco.Container;
import com.nexaweb.client.netservice.NetServiceException;
import com.nexaweb.util.Log;
import com.nexaweb.util.LogConsumer;
import com.nexaweb.util.LogFactory;
import com.nexaweb.xml.Document;
import com.nexaweb.xml.DocumentRegistry;
import com.nexaweb.xml.Element;
import com.nexaweb.xml.events.ChangeRejectedException;
import com.nexaweb.xml.events.StructureChangeEvent;
import com.nexaweb.xml.events.StructureChangeListener;
import com.nexaweb.xml.xpath.XPathFactory;
import java.net.SocketException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jp.co.fujitsu.reffi.client.nexaweb.action.AbstractAction;
import jp.co.fujitsu.reffi.client.nexaweb.action.Action;
import jp.co.fujitsu.reffi.client.nexaweb.action.BaseAction;
import jp.co.fujitsu.reffi.client.nexaweb.controller.ClientConfig;
import jp.co.fujitsu.reffi.client.nexaweb.controller.EventBinder;
import jp.co.fujitsu.reffi.client.nexaweb.controller.ParameterMapping;
import jp.co.fujitsu.reffi.client.nexaweb.event.ModelProcessEvent;
import jp.co.fujitsu.reffi.client.nexaweb.listener.ModelProcessListener;
import jp.co.fujitsu.reffi.client.nexaweb.model.BaseModel;
import jp.co.fujitsu.reffi.client.nexaweb.model.Model;
import jp.co.fujitsu.reffi.client.nexaweb.util.DialogUtil;
import jp.co.fujitsu.reffi.client.nexaweb.util.ElementSnapshot;
import jp.co.fujitsu.reffi.common.exception.CoreExceptionIF;
import jp.co.fujitsu.reffi.common.exception.CoreLogicException;
import jp.co.fujitsu.reffi.common.nexaweb.dialog.CoreDialog;
import jp.co.fujitsu.reffi.common.nexaweb.dialog.CoreDialogIF;

public class BaseController
extends AbstractMco {
    public static final String HANDLER_ENTRY_POINT = "mco:controller.handlerFacade()";
    private EventBinder eventBinder;
    private Map<Object, Object> permanent;
    private ElementSnapshot errorElementSnapshot;
    volatile Vector<String> invokeThreadNames = new Vector();
    private Log clientLogger;
    private ClientConfig clientConfig;

    public EventBinder getEventBinder() {
        return this.eventBinder;
    }

    public void setEventBinder(EventBinder eventBinder) {
        this.eventBinder = eventBinder;
    }

    public Map<Object, Object> getPermanent() {
        return this.permanent;
    }

    public void setPermanent(Map<Object, Object> Permanent) {
        this.permanent = Permanent;
    }

    public ElementSnapshot getErrorElementSnapshot() {
        return this.errorElementSnapshot;
    }

    public void setErrorElementSnapshot(ElementSnapshot errorElementSnapshot) {
        this.errorElementSnapshot = errorElementSnapshot;
    }

    public Log getClientLogger() {
        return this.clientLogger;
    }

    public void setClientLogger(Log clientLogger) {
        this.clientLogger = clientLogger;
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public void setClientConfig(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public BaseController() {
        this.setEventBinder(new EventBinder(this));
        this.setPermanent(Collections.synchronizedMap(new HashMap()));
        this.setClientConfig(new ClientConfig());
        this.setErrorElementSnapshot(new ElementSnapshot());
        this.bind(this.getEventBinder());
    }

    public void addedToContainer(Container container, String name) {
        super.addedToContainer(container, name);
        ClientSession clientSession = this.getSession();
        DocumentRegistry registry = clientSession.getDocumentRegistry();
        Document document = registry.getUiDocument();
        document.addStructureChangeListener(new StructureChangeListener(){

            public void beforeChildAdded(StructureChangeEvent evt) throws ChangeRejectedException {
                if (evt.getChange() instanceof Element) {
                    Element source = (Element)evt.getChange();
                    Vector addedElements = XPathFactory.createXPath((String)"descendant-or-self::*").evaluate(source);
                    for (int ii = 0; ii < addedElements.size(); ++ii) {
                        String[] eventTypes;
                        String name;
                        Element addedElement = (Element)addedElements.get(ii);
                        if ("window".equals(addedElement.getLocalName()) && BaseController.this.getClientConfig().isWindowElementDefaultFocus()) {
                            addedElement.setAttribute("focused", "true");
                        }
                        if ((name = addedElement.getAttribute("name")) == null || (eventTypes = BaseController.this.getEventBinder().getEventTypes(name)) == null) continue;
                        for (int jj = 0; jj < eventTypes.length; ++jj) {
                            String eventType = eventTypes[jj];
                            addedElement.setAttribute(eventType, BaseController.HANDLER_ENTRY_POINT);
                        }
                    }
                }
            }

            public void beforeChildRemoved(StructureChangeEvent evt) throws ChangeRejectedException {
            }

            public void onChildAdded(StructureChangeEvent arg0) {
            }

            public void onChildRemoved(StructureChangeEvent arg0) {
            }
        });
        this.initialize(this.getClientConfig());
        this.postInitialize(this.getClientConfig());
    }

    protected void initialize(ClientConfig config) {
    }

    private void postInitialize(ClientConfig config) {
        LogConsumer logConsumer = null;
        Class<? extends LogConsumer> clazz = config.getLogConsumerClass();
        try {
            logConsumer = clazz.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logConsumer.init((Object)config);
        Log clientLogger = LogFactory.getLog((String)"clientlogger");
        clientLogger.setLevel((short)1);
        clientLogger.addLogConsumer(logConsumer);
        this.setClientLogger(clientLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlerFacade() {
        final ParameterMapping parameterMapping = this.createParameterMapping();
        final Class<? extends Action> actionClass = this.getEventBinder().getActionClass(parameterMapping.getEventSourceElementName(), parameterMapping.getEventType());
        if (this.getClientConfig().isDuplicateActionInvoke()) {
            this.invoke(actionClass, parameterMapping);
        } else {
            Vector<String> vector = this.invokeThreadNames;
            synchronized (vector) {
                if (!this.invokeThreadNames.contains(parameterMapping.getEventSourceElementName())) {
                    this.invokeThreadNames.add(parameterMapping.getEventSourceElementName());
                    this.getSession().getUiUpdateQueue().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BaseController.this.invoke(actionClass, parameterMapping);
                            BaseController.this.getSession().getUiUpdateQueue().invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    BaseController.this.invokeThreadNames.remove(parameterMapping.getEventSourceElementName());
                                }
                            });
                        }
                    });
                }
            }
        }
    }

    protected ParameterMapping createParameterMapping() {
        ParameterMapping ret = new ParameterMapping();
        ClientSession clientSession = this.getSession();
        Document uiDocument = clientSession.getDocumentRegistry().getUiDocument();
        ClientEvent clientEvent = clientSession.getEventHandler().getClientEvent();
        Element eventSourceElement = (Element)clientEvent.getSource();
        String eventType = clientEvent.getParameter("event");
        String componentName = eventSourceElement.getAttribute("name");
        HashMap<String, String> clientEventParameters = new HashMap<String, String>();
        Enumeration parameterNames = clientEvent.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String name = (String)parameterNames.nextElement();
            String value = clientEvent.getParameter(name);
            clientEventParameters.put(name, value);
        }
        String queryString = clientEvent.getQueryString();
        ret.setEventSourceElement(eventSourceElement);
        ret.setClientSession(clientSession);
        ret.setUiDocument(uiDocument);
        ret.setEventType(eventType);
        ret.setEventSourceElementName(componentName);
        ret.setClientEventParameters(clientEventParameters);
        ret.setQueryString(queryString);
        ret.setRunModelsAndNoWait(false);
        ret.setClientEvent(clientEvent);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object invoke(Class<? extends Action> actionClass, ParameterMapping parameterMapping) {
        Object ret = null;
        try {
            if (this.getClientLogger() != null) {
                this.getClientLogger().log((short)2, actionClass.getName());
            }
            if ((parameterMapping = this.runAction(actionClass, parameterMapping)) == null) {
                Object var4_4 = null;
                return var4_4;
            }
            List<Class<? extends Model>> modelClasses = parameterMapping.getModelClasses();
            if (modelClasses.size() > 0) {
                if (parameterMapping.isRunModelsAndNoWait()) {
                    this.runModelsAndNoWait(modelClasses, parameterMapping);
                } else {
                    this.runModels(modelClasses, parameterMapping, 0, null);
                }
            }
        }
        catch (Throwable e) {
            this.trap(e);
        }
        finally {
            this.handlerFinalize(parameterMapping);
        }
        return ret;
    }

    public ParameterMapping runAction(Class<? extends Action> actionClass, ParameterMapping parameterMapping) throws Exception {
        AbstractAction action = (AbstractAction)actionClass.newInstance();
        action.setController(this);
        parameterMapping = action.run(parameterMapping);
        if (parameterMapping == null) {
            return null;
        }
        parameterMapping.setActionInstance(action);
        return parameterMapping;
    }

    public void runModels(final List<Class<? extends Model>> modelClasses, ParameterMapping parameterMapping, int executeIndex, ModelProcessEvent modelProcessEvent) throws Exception {
        BaseAction action = (BaseAction)parameterMapping.getActionInstance();
        if (modelClasses.size() > 0) {
            Class<? extends Model> modelClass = modelClasses.remove(0);
            BaseModel model = (BaseModel)modelClass.newInstance();
            model.setParameterMapping(parameterMapping);
            model.setController(this);
            model.setExecuteIndex(executeIndex);
            model.addModelProcessListener(new ModelProcessListener(){

                @Override
                public void modelSuccess(ModelProcessEvent evt) {
                    try {
                        BaseModel model = (BaseModel)evt.getSource();
                        ParameterMapping parameterMapping = model.getParameterMapping();
                        BaseAction action = (BaseAction)parameterMapping.getActionInstance();
                        int executeIndex = model.getExecuteIndex();
                        action.successForward(executeIndex, model, evt.getResult());
                        if (model.getSuccessCount() == 1) {
                            BaseController.this.runModels(modelClasses, parameterMapping, ++executeIndex, evt);
                        }
                    }
                    catch (Exception e) {
                        BaseController.this.trap(e);
                    }
                }

                @Override
                public void modelFailure(ModelProcessEvent evt) {
                    try {
                        BaseModel model = (BaseModel)evt.getSource();
                        BaseAction action = (BaseAction)model.getParameterMapping().getActionInstance();
                        Exception e = action.failureForward(model.getExecuteIndex(), model, evt.getException());
                        if (e != null) {
                            BaseController.this.trap(e);
                        }
                    }
                    catch (Exception e) {
                        BaseController.this.trap(e);
                    }
                }
            });
            boolean isProceed = action.nextModel(executeIndex, modelProcessEvent, model);
            if (!isProceed) {
                return;
            }
            if (model.isSkip()) {
                this.runModels(modelClasses, parameterMapping, ++executeIndex, null);
            } else {
                model.run();
            }
        } else {
            action.nextModel(executeIndex, modelProcessEvent, null);
        }
    }

    public void runModelsAndNoWait(List<Class<? extends Model>> modelClasses, ParameterMapping parameterMapping) throws Exception {
        int executeIndex;
        BaseAction action = (BaseAction)parameterMapping.getActionInstance();
        for (executeIndex = 0; executeIndex < modelClasses.size(); ++executeIndex) {
            Class<? extends Model> modelClass = modelClasses.get(executeIndex);
            BaseModel model = (BaseModel)modelClass.newInstance();
            model.setParameterMapping(parameterMapping);
            model.setController(this);
            model.setExecuteIndex(executeIndex);
            model.addModelProcessListener(new ModelProcessListener(){

                @Override
                public void modelSuccess(ModelProcessEvent evt) {
                    try {
                        BaseModel model = (BaseModel)evt.getSource();
                        BaseAction action = (BaseAction)model.getParameterMapping().getActionInstance();
                        action.successForward(model.getExecuteIndex(), model, evt.getResult());
                    }
                    catch (Exception e) {
                        BaseController.this.trap(e);
                    }
                }

                @Override
                public void modelFailure(ModelProcessEvent evt) {
                    try {
                        BaseModel model = (BaseModel)evt.getSource();
                        BaseAction action = (BaseAction)model.getParameterMapping().getActionInstance();
                        Exception e = action.failureForward(model.getExecuteIndex(), model, evt.getException());
                        if (e != null) {
                            BaseController.this.trap(e);
                        }
                    }
                    catch (Exception e) {
                        BaseController.this.trap(e);
                    }
                }
            });
            boolean isProceed = action.nextModel(executeIndex, null, model);
            if (!isProceed) {
                return;
            }
            if (model.isSkip()) continue;
            model.run();
        }
        action.nextModel(executeIndex, null, null);
    }

    public Object runModel(Model model, ParameterMapping parameterMapping) throws Exception {
        ((BaseModel)model).setParameterMapping(parameterMapping);
        ((BaseModel)model).setController(this);
        model.run();
        Object result = model.getResult();
        return result;
    }

    public void runModelWithProcessListener(Model model, ModelProcessListener listener, ParameterMapping parameterMapping) throws Exception {
        ((BaseModel)model).setParameterMapping(parameterMapping);
        ((BaseModel)model).setController(this);
        model.addModelProcessListener(listener);
        model.run();
    }

    protected void trap(Throwable e) {
        if (this.getClientLogger() != null) {
            this.getClientLogger().log((short)3, e);
        }
        if (this.recursiveCheckConnectError(e)) {
            e = new CoreLogicException("EFC1007", e);
        }
        if (e instanceof CoreExceptionIF) {
            if (((CoreExceptionIF)e).isNotifyToUser()) {
                String id = ((CoreExceptionIF)e).getId();
                String message = ((CoreExceptionIF)e).getMessage();
                this.errorDialog(id, message);
            }
        } else {
            ClientConfig config = this.getClientConfig();
            this.errorDialog(config.getUnexpectedErrorDialogTitle(), config.getUnexpectedErrorDialogMessage());
        }
    }

    protected void errorDialog(String title, String message) {
        Document document = this.getSession().getDocumentRegistry().getUiDocument();
        CoreDialog cd = new CoreDialog.Builder(title, message).dialogType(CoreDialog.MessageDialogType.ERROR.getType()).build();
        DialogUtil.messageAlert(document, (CoreDialogIF)cd);
    }

    private boolean recursiveCheckConnectError(Throwable e) {
        boolean result = false;
        if (e instanceof SocketException) {
            result = true;
        } else if (e instanceof NetServiceException && ((NetServiceException)e).getCausalThrowable() != null) {
            result = this.recursiveCheckConnectError(((NetServiceException)e).getCausalThrowable());
        } else if (e.getCause() != null) {
            result = this.recursiveCheckConnectError(e.getCause());
        }
        return result;
    }

    protected void bind(EventBinder eventBinder) {
        eventBinder.loadConfig("reffi-client-config.xml");
    }

    protected void handlerFinalize(ParameterMapping mapping) {
    }
}

