/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.server.web.filter;

import java.io.IOException;
import java.text.NumberFormat;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExecutionTimeFilter
implements Filter {
    private static final Log LOG = LogFactory.getLog(ExecutionTimeFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        StringBuilder clientInfo = this.getClientInfo(request);
        LOG.info((Object)("==== Start: " + clientInfo + " ===="));
        long start = System.currentTimeMillis();
        filterChain.doFilter(request, response);
        long finish = System.currentTimeMillis();
        String executionTime = NumberFormat.getInstance().format(finish - start);
        clientInfo.append(",ExecutionTime=").append(executionTime).append("\u30df\u30ea\u79d2");
        LOG.info((Object)("---- ExecutionTime: " + executionTime));
        LOG.info((Object)("==== Finish: " + clientInfo + " ===="));
    }

    private StringBuilder getClientInfo(ServletRequest request) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        return new StringBuilder(64).append("[").append("URI=").append(httpServletRequest.getRequestURI()).append(",").append("IP=").append(httpServletRequest.getRemoteAddr()).append("]");
    }
}

