/* 
 * Copyright (c) 2008-2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.client.flex.model {
	
	/**
	 * <p>[概 要]</p>
	 * 全てのモデルの基底インターフェースです.
	 * 
	 * <p>[詳 細]</p>
	 * 
	 * <p>[備 考]</p>
	 * 
	 * <p>Copyright (c) 2008-2009 FUJITSU Japan All rights reserved.</p>
	 * @author Project Reffi
	 */
	public interface IModel {

		/**
		 * <p>[概 要]</p>
		 * イベントリスナーオブジェクトを EventDispatcher オブジェクトに登録し、
		 * リスナーがイベントの通知を受け取るようにします.
		 * 
		 * <p>[詳 細]</p>
		 * イベントリスナーオブジェクトを EventDispatcher オブジェクトに登録し、
		 * リスナーがイベントの通知を受け取るようにします。<br>
		 * イベントリスナーは、特定のタイプのイベント、
		 * 段階、および優先度に関する表示リスト内のすべてのノードに登録できます。
		 * 
		 * <p>[備 考]</p>
		 * 
		 * @param type イベントのタイプです。
		 * @param fn 削除するリスナーオブジェクトです。
		 * @param useCapture trueならキャプチャ段階、falseならバブリング段階
		 * @param priority イベントリスナーの優先度レベルです。
		 * @param useWeakReference リスナーへの参照が強参照と弱参照のいずれであるかを判断します。
		 */
		function addEventListener(type:String, fn:Function, useCapture:Boolean = false,
								   priority:int = 0, useWeakReference:Boolean = false):void;

		/**
		 * <p>[概 要]</p>
		 * EventDispatcher オブジェクトからリスナーを削除します.
		 * 
		 * <p>[詳 細]</p>
		 * EventDispatcher オブジェクトからリスナーを削除します。<br>
		 * 対応するリスナーが EventDispatcher オブジェクトに登録されていない場合は、
		 * このメソッドを呼び出しても効果はありません。
		 * 
		 * <p>[備 考]</p>
		 * 
		 * @param type イベントのタイプです。
		 * @param fn 削除するリスナーオブジェクトです。
		 * @param useCapture trueならキャプチャ段階、falseならバブリング段階
		 */
		function removeEventListener(type:String, fn:Function, useCapture:Boolean = false):void;

		/**
		 * <p>[概 要]</p>
		 * コントローラにコールされるモデルの主幹メソッドです.
		 * 
		 * <p>[詳 細]</p>
		 * 
		 * <p>[備 考]</p>
		 */
		function run():void;
	}
}
