/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.swing.db;

import jp.co.fujitsu.reffi.client.swing.db.Connector;
import jp.co.fujitsu.reffi.client.swing.model.DatabaseCore;

public class ConnectorFactory {
    public static String DATASOURCE_CONNECTOR_FQCN = "jp.co.fujitsu.reffi.client.swing.db.DataSourceConnector";
    public static String JDBC_CONNECTOR_FQCN = "jp.co.fujitsu.reffi.client.swing.db.JdbcConnector";

    public static Connector getConnector(DatabaseCore dbCore) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Connector ret = null;
        ret = ConnectorFactory.createConnector(dbCore);
        return ret;
    }

    private static Connector createConnector(DatabaseCore dbCore) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Connector c = null;
        if (dbCore.getDatasource() != null) {
            c = (Connector)Class.forName(DATASOURCE_CONNECTOR_FQCN).newInstance();
            c.setDatasource(dbCore.getDatasource());
        } else {
            c = (Connector)Class.forName(JDBC_CONNECTOR_FQCN).newInstance();
            c.setDriverFqcn(dbCore.getDriverFqcn());
            c.setUrl(dbCore.getUrl());
        }
        c.setUser(dbCore.getUser());
        c.setPassword(dbCore.getPassword());
        c.setAutoCommit(dbCore.isAutoCommit());
        return c;
    }
}

