/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.swing.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import jp.co.fujitsu.reffi.client.swing.model.JMSConsumeCore;

public class JMSConsumeCoreManager {
    private static JMSConsumeCoreManager instance;
    private Map<String, List<JMSConsumeCore>> consumerMap = new HashMap<String, List<JMSConsumeCore>>();

    public Map<String, List<JMSConsumeCore>> getSubscriberMap() {
        return this.consumerMap;
    }

    public void setSubscriberMap(Map<String, List<JMSConsumeCore>> consumerMap) {
        this.consumerMap = consumerMap;
    }

    public static JMSConsumeCoreManager getInstance() {
        if (instance == null) {
            instance = new JMSConsumeCoreManager();
        }
        return instance;
    }

    private JMSConsumeCoreManager() {
    }

    public void consume(String queueName, JMSConsumeCore consumeCore) throws NamingException, JMSException {
        List<Object> consumeCoreList = null;
        InitialContext context = new InitialContext(consumeCore.getEnvironment());
        QueueConnectionFactory tcf = (QueueConnectionFactory)context.lookup(consumeCore.getConnectionFactoryName());
        QueueConnection queueConnection = tcf.createQueueConnection();
        if (consumeCore.getClientId() != null) {
            queueConnection.setClientID(consumeCore.getClientId());
        }
        consumeCore.setQueueConnection(queueConnection);
        QueueSession queueSession = queueConnection.createQueueSession(false, 1);
        consumeCore.setQueueSession(queueSession);
        Queue queue = (Queue)context.lookup(queueName);
        consumeCore.setQueue(queue);
        MessageConsumer consumer = queueSession.createConsumer((Destination)queue);
        consumeCore.setConsumer(consumer);
        consumer.setMessageListener((MessageListener)consumeCore);
        if (!this.getSubscriberMap().containsKey(queueName)) {
            consumeCoreList = new ArrayList();
            this.getSubscriberMap().put(queueName, consumeCoreList);
        } else {
            consumeCoreList = this.getSubscriberMap().get(queueName);
        }
        consumeCoreList.add(consumeCore);
        queueConnection.start();
    }

    public void unconsume(String queueName) throws JMSException {
        this.unconsume(queueName, null);
    }

    public void unconsume(String queueName, String identifier) throws JMSException {
        Map<String, List<JMSConsumeCore>> consumerMap = this.getSubscriberMap();
        if (!consumerMap.containsKey(queueName)) {
            return;
        }
        List<JMSConsumeCore> consumeCoreList = consumerMap.get(queueName);
        if (identifier == null) {
            Iterator<JMSConsumeCore> it = consumeCoreList.iterator();
            while (it.hasNext()) {
                JMSConsumeCore consumeCore = it.next();
                this.stop(consumeCore);
                it.remove();
            }
        } else {
            Iterator<JMSConsumeCore> it = consumeCoreList.iterator();
            while (it.hasNext()) {
                JMSConsumeCore consumeCore = it.next();
                if (!identifier.equals(consumeCore.getIdentifier())) continue;
                this.stop(consumeCore);
                it.remove();
            }
        }
        if (consumeCoreList.size() == 0) {
            consumerMap.remove(queueName);
        }
    }

    protected void stop(JMSConsumeCore consumeCore) throws JMSException {
        consumeCore.onUnconsume();
        consumeCore.getQueueConnection().stop();
        consumeCore.getQueueSession().close();
        consumeCore.getQueueConnection().close();
    }
}

