/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.android.controller;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.util.Log;
import android.view.View;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.fujitsu.reffi.client.android.action.AbstractAction;
import jp.co.fujitsu.reffi.client.android.controller.ClientConfig;
import jp.co.fujitsu.reffi.client.android.controller.Controller;
import jp.co.fujitsu.reffi.client.android.controller.EventBinder;
import jp.co.fujitsu.reffi.client.android.controller.EventInvocationHandler;
import jp.co.fujitsu.reffi.client.android.controller.NamingRepository;
import jp.co.fujitsu.reffi.client.android.controller.ParameterMapping;
import jp.co.fujitsu.reffi.client.android.controller.attachment.ListenerAttachment;
import jp.co.fujitsu.reffi.client.android.controller.attachment.ListenerAttachmentFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractController
extends Application
implements Controller {
    private EventBinder eventBinder;
    private Map<Object, Object> permanent;
    private ClientConfig clientConfig;
    private Activity frontActivity;
    public static AbstractController instance;

    public EventBinder getEventBinder() {
        return this.eventBinder;
    }

    public void setEventBinder(EventBinder eventBinder) {
        this.eventBinder = eventBinder;
    }

    public Map<Object, Object> getPermanent() {
        return this.permanent;
    }

    public void setPermanent(Map<Object, Object> Permanent) {
        this.permanent = Permanent;
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public void setClientConfig(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public Activity getFrontActivity() {
        return this.frontActivity;
    }

    public void setFrontActivity(Activity frontActivity) {
        this.frontActivity = frontActivity;
    }

    public AbstractController() {
        this.setEventBinder(new EventBinder(this));
        this.setClientConfig(new ClientConfig());
        this.setPermanent(new HashMap<Object, Object>());
        this.bind(this.getEventBinder());
        this.initialize(this.getClientConfig());
        this.postInitialize(this.getClientConfig());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                AbstractController.this.shutdown();
            }
        });
        instance = this;
    }

    protected void initialize(ClientConfig config) {
    }

    protected void postInitialize(ClientConfig config) {
    }

    public void bindEvents(Context context, Object viewOrActivity) {
        String name = NamingRepository.get(context, viewOrActivity);
        if (name != null && !"".equals(name)) {
            List<Class<? extends Object>> listenerTypes = this.eventBinder.getListenerTypes(name);
            for (Class<? extends Object> listenerType : listenerTypes) {
                List<String> eventTypes = this.eventBinder.getEventTypes(name, listenerType);
                try {
                    this.addListener(context, viewOrActivity, listenerType, eventTypes);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void addListener(Context context, Object viewOrActivity, Class<? extends Object> listenerType, List<String> eventTypes) throws Exception {
        EventInvocationHandler handler = new EventInvocationHandler(context, viewOrActivity, this, listenerType, eventTypes);
        Object eventListener = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{listenerType}, (InvocationHandler)handler);
        ListenerAttachment listenerAttachment = ListenerAttachmentFactory.getAttachment(viewOrActivity.getClass());
        listenerAttachment.attachListener(viewOrActivity, listenerType, eventListener);
        Log.d((String)"bbbb = ", (String)viewOrActivity.getClass().getSimpleName());
    }

    public void handlerFacade(Context context, Object eventSource, Object[] eventArgs, Class<? extends Object> listenerType, String eventType, Object eventListenerProxy) {
        Log.d((String)"BaseController", (String)"handlerFacade called");
        String name = NamingRepository.get(context, eventSource);
        Class<? extends AbstractAction> actionClass = this.getEventBinder().getActionClass(name, listenerType, eventType);
        ParameterMapping parameterMapping = this.createParameterMapping(eventSource, name, eventArgs, listenerType, eventType, eventListenerProxy);
        this.invoke(actionClass, parameterMapping);
    }

    protected ParameterMapping createParameterMapping(Object eventSource, String eventSourceName, Object[] eventArgs, Class<? extends Object> listenerType, String eventType, Object eventListenerProxy) {
        ParameterMapping ret = new ParameterMapping();
        ret.setEventSource(eventSource);
        ret.setEventSourceName(eventSourceName);
        ret.setEventArgs(eventArgs);
        if (eventSource instanceof View) {
            ret.setContext(((View)eventSource).getContext());
        } else {
            ret.setContext((Context)eventSource);
        }
        ret.setEventListenerType(listenerType);
        ret.setEventListener(eventListenerProxy);
        ret.setEventType(eventType);
        return ret;
    }

    protected void bind(EventBinder eventBinder) {
    }

    protected void shutdown() {
    }
}

