/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.android.controller;

import android.app.AlertDialog;
import android.content.Context;
import android.os.Handler;
import android.util.Log;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import jp.co.fujitsu.reffi.client.android.action.AbstractAction;
import jp.co.fujitsu.reffi.client.android.action.Action;
import jp.co.fujitsu.reffi.client.android.action.BaseAction;
import jp.co.fujitsu.reffi.client.android.controller.AbstractController;
import jp.co.fujitsu.reffi.client.android.controller.ParameterMapping;
import jp.co.fujitsu.reffi.client.android.event.ModelProcessEvent;
import jp.co.fujitsu.reffi.client.android.listener.ModelProcessListener;
import jp.co.fujitsu.reffi.client.android.model.BaseModel;
import jp.co.fujitsu.reffi.client.android.model.DefaultModel;
import jp.co.fujitsu.reffi.client.android.model.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseController
extends AbstractController {
    private Handler handler = new Handler();

    public Handler getHandler() {
        return this.handler;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Class<? extends Action> actionClass, ParameterMapping parameterMapping) {
        Object ret = null;
        try {
            parameterMapping = this.runAction(actionClass, parameterMapping);
            if (parameterMapping == null) {
                Object var4_4 = null;
                return var4_4;
            }
            List<Class<? extends Model>> modelClasses = parameterMapping.getModelClasses();
            if (modelClasses.size() == 0) {
                modelClasses.add(DefaultModel.class);
            }
            parameterMapping.setModelReservedNum(modelClasses.size());
            parameterMapping.setModelFinishedNum(0);
            if (parameterMapping.isRunModelsAndNoWait()) {
                this.runModelsAndNoWait(modelClasses, parameterMapping);
            } else {
                this.runModels(modelClasses, parameterMapping, 0, null);
            }
        }
        catch (Throwable e) {
            this.trap(e);
        }
        finally {
            this.invokeFinalize(parameterMapping);
        }
        return ret;
    }

    public ParameterMapping runAction(Class<? extends Action> actionClass, ParameterMapping parameterMapping) throws Exception {
        AbstractAction action = (AbstractAction)actionClass.newInstance();
        action.setController(this);
        parameterMapping = action.run(parameterMapping);
        if (parameterMapping == null) {
            return null;
        }
        parameterMapping.setActionInstance(action);
        return parameterMapping;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void runModels(final List<Class<? extends Model>> modelClasses, ParameterMapping parameterMapping, int executeIndex, ModelProcessEvent modelProcessEvent) throws Exception {
        BaseAction action = (BaseAction)parameterMapping.getActionInstance();
        if (modelClasses.size() > 0) {
            Class<? extends Model> modelClass = modelClasses.remove(0);
            BaseModel model = (BaseModel)modelClass.newInstance();
            model.setParameterMapping(parameterMapping);
            model.setController(this);
            model.setExecuteIndex(executeIndex);
            model.setHandler(this.getHandler());
            model.addModelProcessListener(new ModelProcessListener(){

                public void modelSuccess(ModelProcessEvent evt) {
                    BaseModel model = (BaseModel)evt.getSource();
                    ParameterMapping parameterMapping = model.getParameterMapping();
                    BaseAction action = (BaseAction)parameterMapping.getActionInstance();
                    int executeIndex = model.getExecuteIndex();
                    try {
                        action.successForward(executeIndex, model, evt.getResult());
                        if (model.getSuccessCount() == 1) {
                            BaseController.this.runModels(modelClasses, parameterMapping, ++executeIndex, evt);
                        }
                    }
                    catch (Exception e) {
                        BaseController.this.trap(e);
                    }
                }

                public void modelFailure(ModelProcessEvent evt) {
                    BaseModel model = (BaseModel)evt.getSource();
                    ParameterMapping parameterMapping = model.getParameterMapping();
                    BaseAction action = (BaseAction)parameterMapping.getActionInstance();
                    try {
                        model.done();
                        BaseController.this.modelsDone(parameterMapping);
                        Exception e = action.failureForward(model.getExecuteIndex(), model, evt.getException());
                        if (e != null) {
                            BaseController.this.trap(e);
                        }
                    }
                    catch (Exception e) {
                        BaseController.this.trap(e);
                    }
                }

                public void modelFinished(ModelProcessEvent evt) {
                    BaseModel model = (BaseModel)evt.getSource();
                    ParameterMapping parameterMapping = model.getParameterMapping();
                    BaseAction action = (BaseAction)parameterMapping.getActionInstance();
                    try {
                        int finishedNum = parameterMapping.getModelFinishedNum();
                        parameterMapping.setModelFinishedNum(finishedNum + 1);
                        if (parameterMapping.getModelReservedNum() == parameterMapping.getModelFinishedNum()) {
                            model.done();
                            BaseController.this.modelsDone(parameterMapping);
                            action.complete(parameterMapping);
                            parameterMapping.setModelFinishedNum(0);
                        }
                    }
                    catch (Exception e) {
                        BaseController.this.trap(e);
                    }
                }
            });
            model.init();
            boolean isProceed = action.nextModel(executeIndex, modelProcessEvent, model);
            if (!isProceed) {
                model.fireModelFinished(new ModelProcessEvent(model));
                return;
            }
            if (model.isSkip()) {
                model.fireModelFinished(new ModelProcessEvent(model));
                this.runModels(modelClasses, parameterMapping, ++executeIndex, null);
                return;
            } else {
                ExecutorService executor = Executors.newCachedThreadPool();
                Future<Object> future = executor.submit(model);
                if (model.isAsync()) return;
                try {
                    future.get();
                    return;
                }
                catch (InterruptedException e) {
                    if (parameterMapping.isAllowInteruptedExceptionOnSyncModel()) return;
                    throw e;
                }
            }
        } else {
            action.nextModel(executeIndex, modelProcessEvent, null);
        }
    }

    public void runModelsAndNoWait(List<Class<? extends Model>> modelClasses, ParameterMapping parameterMapping) throws Exception {
        int executeIndex;
        BaseAction action = (BaseAction)parameterMapping.getActionInstance();
        for (executeIndex = 0; executeIndex < modelClasses.size(); ++executeIndex) {
            Class<? extends Model> modelClass = modelClasses.get(executeIndex);
            BaseModel model = (BaseModel)modelClass.newInstance();
            model.setParameterMapping(parameterMapping);
            model.setController(this);
            model.setExecuteIndex(executeIndex);
            model.setHandler(this.getHandler());
            model.addModelProcessListener(new ModelProcessListener(){

                public void modelSuccess(ModelProcessEvent evt) {
                    BaseModel model = (BaseModel)evt.getSource();
                    ParameterMapping parameterMapping = model.getParameterMapping();
                    BaseAction action = (BaseAction)parameterMapping.getActionInstance();
                    try {
                        action.successForward(model.getExecuteIndex(), model, evt.getResult());
                    }
                    catch (Exception e) {
                        BaseController.this.trap(e);
                    }
                }

                public void modelFailure(ModelProcessEvent evt) {
                    BaseModel model = (BaseModel)evt.getSource();
                    ParameterMapping parameterMapping = model.getParameterMapping();
                    BaseAction action = (BaseAction)parameterMapping.getActionInstance();
                    try {
                        model.done();
                        BaseController.this.modelsDone(parameterMapping);
                        Exception e = action.failureForward(model.getExecuteIndex(), model, evt.getException());
                        if (e != null) {
                            BaseController.this.trap(e);
                        }
                    }
                    catch (Exception e) {
                        BaseController.this.trap(e);
                    }
                }

                public void modelFinished(ModelProcessEvent evt) {
                    BaseModel model = (BaseModel)evt.getSource();
                    ParameterMapping parameterMapping = model.getParameterMapping();
                    BaseAction action = (BaseAction)parameterMapping.getActionInstance();
                    try {
                        int finishedNum = parameterMapping.getModelFinishedNum();
                        parameterMapping.setModelFinishedNum(finishedNum + 1);
                        if (parameterMapping.getModelReservedNum() == parameterMapping.getModelFinishedNum()) {
                            model.done();
                            BaseController.this.modelsDone(parameterMapping);
                            action.complete(parameterMapping);
                            parameterMapping.setModelFinishedNum(0);
                        }
                    }
                    catch (Exception e) {
                        BaseController.this.trap(e);
                    }
                }
            });
            model.init();
            boolean isProceed = action.nextModel(executeIndex, null, model);
            if (!isProceed) {
                model.fireModelFinished(new ModelProcessEvent(model));
                return;
            }
            if (model.isSkip()) {
                model.fireModelFinished(new ModelProcessEvent(model));
                continue;
            }
            ExecutorService executor = Executors.newCachedThreadPool();
            Future<Object> future = executor.submit(model);
            if (model.isAsync()) continue;
            try {
                future.get();
                continue;
            }
            catch (InterruptedException e) {
                if (parameterMapping.isAllowInteruptedExceptionOnSyncModel()) continue;
                throw e;
            }
        }
        action.nextModel(executeIndex, null, null);
    }

    protected void trap(Throwable e) {
        if (this.getClientConfig().isShowErrorDialogOnExceptionTrap()) {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getFrontActivity()).setTitle((CharSequence)this.getClientConfig().getUnexpectedErrorDialogTitle()).setMessage((CharSequence)this.getClientConfig().getUnexpectedErrorDialogMessage());
            builder.show();
        }
        if (this.getClientConfig().isPrintStackTraceOnExceptionTrap()) {
            Log.e((String)"error", (String)"BaseController caught Exception", (Throwable)e);
        }
    }

    protected void invokeFinalize(ParameterMapping mapping) {
    }

    protected void modelsDone(ParameterMapping mapping) throws Exception {
        BaseAction action = (BaseAction)mapping.getActionInstance();
        action.done(mapping);
    }
}

