/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.android.manager;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import jp.co.fujitsu.reffi.client.android.event.ModelProcessEvent;
import jp.co.fujitsu.reffi.client.android.model.TimerProcessCore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimerProcessCoreManager {
    private static TimerProcessCoreManager instance;
    private Map<String, TimerProcessCore> timers = new HashMap<String, TimerProcessCore>();

    public Map<String, TimerProcessCore> getTimers() {
        return this.timers;
    }

    public void setTimers(Map<String, TimerProcessCore> timers) {
        this.timers = timers;
    }

    private TimerProcessCoreManager() {
    }

    public static TimerProcessCoreManager getInstance() {
        if (instance == null) {
            instance = new TimerProcessCoreManager();
        }
        return instance;
    }

    public boolean isRegist(String timerId) {
        return this.getTimers().containsKey(timerId);
    }

    public boolean start(final TimerProcessCore timerProcessCore) {
        if (this.isRegist(timerProcessCore.getTimerId())) {
            return false;
        }
        ScheduledThreadPoolExecutor executorService = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(1);
        executorService.setContinueExistingPeriodicTasksAfterShutdownPolicy(true);
        executorService.setExecuteExistingDelayedTasksAfterShutdownPolicy(true);
        timerProcessCore.setExecutorService(executorService);
        ScheduledFuture<?> future = executorService.scheduleAtFixedRate(new Runnable(){

            public void run() {
                if (timerProcessCore.getIntervalAction() != null) {
                    timerProcessCore.getController().invoke(timerProcessCore.getIntervalAction(), timerProcessCore.getParameterMapping().clone());
                } else {
                    timerProcessCore.timerCompleted();
                }
            }
        }, timerProcessCore.getInitialDelay(), timerProcessCore.getPeriod(), TimeUnit.MILLISECONDS);
        if (timerProcessCore.getStopLater() > 0L) {
            executorService.schedule(new Runnable(){

                public void run() {
                    TimerProcessCoreManager.this.stop(timerProcessCore.getTimerId());
                }
            }, timerProcessCore.getStopLater(), TimeUnit.MILLISECONDS);
        }
        timerProcessCore.setFuture(future);
        this.getTimers().put(timerProcessCore.getTimerId(), timerProcessCore);
        return true;
    }

    public boolean stop(String timerId) {
        if (!this.isRegist(timerId)) {
            return false;
        }
        TimerProcessCore timerProcessCore = this.getTimers().get(timerId);
        timerProcessCore.getFuture().cancel(true);
        timerProcessCore.getExecutorService().shutdown();
        this.getTimers().remove(timerId);
        ModelProcessEvent finishedEvent = new ModelProcessEvent(timerProcessCore);
        timerProcessCore.fireModelFinished(finishedEvent);
        return true;
    }
}

