/* 
 * Copyright (c) 2008-2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * 5. All your rights under this license shall terminate automatically if you fail to
 *    comply  with any of this list of conditions. If your rights under this license terminate,
 *    you agree to cease use and distribution of this software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.client.nexaweb.validator;

import java.util.Properties;

import jp.co.fujitsu.reffi.client.nexaweb.parser.ElementValue;
import jp.co.fujitsu.reffi.client.nexaweb.parser.ElementValues;
import jp.co.fujitsu.reffi.common.util.ResourceUtil;

import com.nexaweb.plugin.validation.exceptions.ValidationException;
import com.nexaweb.xml.Element;

/**
 * <p>[概 要] </p>
 * 必須バリデータクラスです。
 * 
 * <p>[詳 細] </p>
 * 
 * <p>[備 考] </p>
 *
 *
 * @author Project Reffi
 */
public class IndispensableValidator extends CustomValidator {

	/** エラーメッセージ取得ソースです。 */
	private final String MESSAGE_RESOURCE = "jp.co.fujitsu.reffi.common.exception.corelogic_message";

	/**
	 * <p>[概 要] </p>
	 * コンストラクタです。
	 *   
	 * <p>[詳 細] </p>
	 * 引数element付きでsuper()を呼び出します。
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @param element
	 */
	public IndispensableValidator(Element element) {
		super(element);
	}

	/**
	 * <p>[概 要] </p>
	 * エラー文言登録メソッドです。
	 *  
	 * <p>[詳 細] </p>
	 * jp.co.fujitsu.reffi.shared.exception.corelogic_message.properties
	 * から対応するエラーメッセージを取得して返却します。
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @return エラー時メッセージ
	 */
	@Override
	public String registerErrorMessage() {
		Properties messages = ResourceUtil.instance.asProperties(MESSAGE_RESOURCE);
		return messages.getProperty("EFC2002");
	}

	/**
	 * <p>[概 要] </p>
	 * 必須バリデーションを行います。
	 *  
	 * <p>[詳 細] </p>
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @param value エレメント値
	 * @return エラー有：false、エラー無：true
	 */
	@Override
	protected boolean validate(Object value) throws ValidationException {
		ElementValues values = (ElementValues) value;

		for (int i = 0; i < values.size(); i++) {
			ElementValue elementValue = values.getElementValue(i);
			String val = elementValue.getValue();
			if (val == null || val.length() == 0) {
				return false;
			}
		}

		return true;
	}
}
