/* 
 * Copyright (c) 2008-2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * 5. All your rights under this license shall terminate automatically if you fail to
 *    comply  with any of this list of conditions. If your rights under this license terminate,
 *    you agree to cease use and distribution of this software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.server.invoker;

import java.util.Map;

import jp.co.fujitsu.reffi.server.model.AbstractModel;
import jp.co.fujitsu.reffi.server.model.DefaultModel;

/**
 * <p>[概 要]</p>
 * モデル実行クラス。
 * 
 * <p>[詳 細]</p>
 * {@link AbstractModel}を継承したモデルを実行します。
 * 実行するモデルはパラメータ「model.fqcn」にて指定し、指定がない場合は{@link DefaultModel}を実行します。
 * 
 * <p>[備 考]</p>
 *
 * @author Project Reffi
 */
public class DefaultInvoker implements Invoker {
	/** モデル実行クラスFQCN */
	public static final String MODEL_FQCD = "model.fqcn";

	@Override
	public Object invoke(Map<Object, Object> parameters) throws Exception {
		try {
			String fqcn = (String)parameters.get(MODEL_FQCD);
			AbstractModel model = null;
			if (fqcn != null) {
				model = Class.forName(fqcn).asSubclass(AbstractModel.class).newInstance();
			} else {
				model = getDefaultModel();
			}
			model.setRequest(parameters);
			model.run();
			return model.getResponse();
		} catch (Exception e) {
			throw e;
		}
	}

	/**
	 * <p>[概 要]</p>
	 * デフォルトモデル取得
	 * 
	 * <p>[詳 細]</p>
	 * デフォルトのモデルを取得します
	 * 
	 * <p>[備 考]</p>
	 *
	 * @return デフォルトモデル
	 */
	protected AbstractModel getDefaultModel() {
		return new DefaultModel();
	}
}
