/* 
 * Copyright (c) 2008-2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * 5. All your rights under this license shall terminate automatically if you fail to
 *    comply  with any of this list of conditions. If your rights under this license terminate,
 *    you agree to cease use and distribution of this software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.client.flex.controller {
	import flash.display.DisplayObject;
	import flash.events.Event;
	import flash.utils.Dictionary;
	
	import jp.co.fujitsu.reffi.client.flex.action.AbstractAction;
	
	/**
	 * <p>[概 要] </p>
	 * MVC各レイヤを伝播するパラメータオブジェクトです.
	 * 
	 * <p>[詳 細] </p>
	 * AVMから提供される情報、フレームワークが動作する為の情報、ビジネスロジックから
	 * 参照が必要な情報が格納されます。<br>
	 * イベント発生時にコントローラによってインスタンス生成され、
	 * アクション→コントローラ→モデル→コントローラ→アクション→コントローラ<br>
	 * と伝播して、イベントハンドリングが終了した後に破棄されます。<p>
	 * 
	 * setParameter(Object, Object)を使用することで、
	 * ビジネスロジック固有のパラメータを格納することが出来ます。<br>
	 * MVCの各フックポイントでこのクラスの同一インスタンスを参照することで、
	 * 「アクションレイヤで設定したパラメータをモデルレイヤで参照する」
	 * といった処理を、広いスコープの変数を用意することなく実装出来ます。
	 * 
	 * <p>[備 考] </p> 
	 * Reffiによって自動的にset系メソッドがコールされ、情報が設定されます。
	 * 
	 * <p>Copyright (c) 2008-2009 FUJITSU Japan All rights reserved.</p>
	 * @author Project Reffi
	 */
	public class ParameterMapping {
		
		/** モデルシーケンシャル実行フラグを示す定数です。 */
		public static const IS_RUN_MODELS_AND_NO_WAIT:String = "IS_RUN_MODELS_AND_NO_WAIT";
		
		/** アクションインスタンスを示す定数です。 */
		public static const ACTION_INSTANCE:String = "ACTION_INSTANCE";
		
		/** モデル処理待ちフラグを示す定数です。 */
		public static const WAIT_MODELS_DONE:String = "WAIT_MODELS_DONE";
		
		/** モデル処理待ちダイアログのメッセージを示す定数です。 */
		public static const WAIT_MODELS_MESSAGE:String = "WAIT_MODELS_MESSAGE";
		
		/** 登録バリデータ群を示す定数です。 */
		public static const VALIDATORS:String = "VALIDATORS";
		
		/** 登録モデル群を示す定数です。 */
		public static const MODELS:String = "MODELS";
		
		/** アクションを起動したイベントを示す定数です。 */
		public static const EVENT:String = "EVENT";

		/** モデルの登録数を示す定数です。 */
		public static const MODEL_RESERVE_NUM:String = "MODEL_RESERVE_NUM";
		
		/** モデルの終了数を示す定数です。 */
		public static const MODEL_FINISHED_NUM:String = "MODEL_FINISHED_NUM";
		
		/** コントローラ#invokeの完了時に呼ばれるファンクションを示す定数です */
		public static const INVOKE_COMPLETE_HANDLER:String = "INVOKE_COMPLETE_HANDLER";
		
		/** コントローラ#invokeの失敗時に呼ばれるファンクションを示す定数です */
		public static const INVOKE_FAILURE_HANDLER:String = "INVOKE_FAILURE_HANDLER";

		/** アクションを起動したコンポーネント */
		public static const EVENT_SOURCE_OBJECT:String = "EVENT_SOURCE_OBJECT";
		
				 
		// MVC各レイヤで使用するパラメータマッピングオブジェクト
		private var _parameters:Dictionary = new Dictionary();
		
		/**
		 * <p>[概 要]</p>
		 * パラメータデータをマップ保持するプロパティです.
		 * 
		 * <p>[詳 細]</p>
		 * 定数キーに対する値、任意に設定されたキーに対する値を保持します。
		 * 
		 * <p>[備 考]</p>
		 * 
		 */
		public function get parameters():Dictionary {
			return _parameters;
		}
		public function set parameters(parameters:Dictionary):void {
			this._parameters = parameters;
		}
		
		/**
		 * <p>[概 要]</p>
		 * パラメータデータマップ保持プロパティから値を取得します.
		 * 
		 * <p>[詳 細]</p>
		 * parametersプロパティから引数keyに対応する値を取得して返却します。
		 * 
		 * <p>[備 考]</p>
		 * 
		 * @param key 取得する値のキー
		 */
		public function getParameter(key:String):Object {
			return this._parameters[key];
		}
		
		/**
		 * <p>[概 要]</p>
		 * パラメータデータマップ保持プロパティに値を設定します.
		 * 
		 * <p>[詳 細]</p>
		 * parametersプロパティに引数keyをキーにして引数valueを登録します。
		 * 
		 * <p>[備 考]</p>
		 * 
		 * @param key 設定する値のキー
		 * @param value 設定する値
		 */
		public function setParameter(key:String, value:Object):void {
			this._parameters[key] = value;
		}

		/**		
		 * <p>[概 要] </p>
		 * 複数予約されたモデルの実行動作を制御します.
		 * 
		 * <p>[詳 細] </p>
		 * モデル群がコントローラに連続実行される際、モデルの処理結果を待たずに
		 * 次のモデルを実行するかどうかのフラグです。<br>
		 * モデルの処理結果を待たずに次のモデルを実行する場合はtrueを設定します。
		 * 
		 * <p>[備 考] </p>
		 * モデルをシーケンシャルに実行しない場合、モデルは登録された順序で実行されますが
		 * レスポンスを待たずに次のモデルが実行されます。
		 * 
		 * @default false
		 */
		public function get isRunModelsAndNoWait():Boolean {
			return this._parameters[IS_RUN_MODELS_AND_NO_WAIT];
		}
		public function set isRunModelsAndNoWait(isRunModelsAndNoWait:Boolean):void {
			this._parameters[IS_RUN_MODELS_AND_NO_WAIT] = isRunModelsAndNoWait;
		}
		
		/**
		 * <p>[概 要]</p>
		 * 実行中のアクションインスタンスです.
		 * 
		 * <p>[詳 細]</p>
		 * このParameterMappingオブジェクトが生成されたイベントで、
		 * コントローラに生成されたActionのインスタンスです。
		 * 
		 * <p>[備 考]</p>
		 * 
		 */
		public function get actionInstance():AbstractAction {
			return this._parameters[ACTION_INSTANCE];
		}
		public function set actionInstance(action:AbstractAction):void {
			this._parameters[ACTION_INSTANCE] = action;
		}
		
		/**
		 * <p>[概 要]</p>
		 * 登録されているモデル群が全終了するまで画面をモーダル状態にするかどうかのフラグです.
		 * 
		 * <p>[詳 細]</p>
		 * true設定されていると、コントローラによるモデル群実行が全て終了するまで
		 * 表示リスト最上部にモーダルポップアップを表示します。
		 * 
		 * <p>[備 考]</p>
		 * 
		 */
		public function get waitModelsDone():Boolean {
			return this._parameters[WAIT_MODELS_DONE];
		}
		public function set waitModelsDone(waitModelsDone:Boolean):void {
			this._parameters[WAIT_MODELS_DONE] = waitModelsDone;
		}
		
		/**
		 * <p>[概 要]</p>
		 * モーダル状態時のプログレスバーメッセージを設定します。
		 * 
		 * <p>[詳 細]</p>
		 * 
		 * <p>[備 考]</p>
		 * 
		 */
		public function get waitModelsMessage():String {
			return this._parameters[WAIT_MODELS_MESSAGE];
		}
		
		public function set waitModelsMessage(waitModelsMessage:String):void {
			this._parameters[WAIT_MODELS_MESSAGE] = waitModelsMessage;
		}
		
		/**
		 * <p>[概 要]</p>
		 * アクションで登録されたバリデータインスタンス配列です.
		 * 
		 * <p>[詳 細]</p>
		 * BaseAction#validateメソッドで使用されるバリデータ配列です。<br>
		 * BaseAction#validatorsメソッドの返却値が登録されます。
		 * 
		 * <p>[備 考]</p>
		 * 
		 */
		public function get validators():Array {
			return this._parameters[VALIDATORS];
		}
		public function set validators(validators:Array):void {
			this._parameters[VALIDATORS] = validators;
		}
		
		/**
		 * <p>[概 要]</p>
		 * アクションで登録された機能モデルクラス型の配列です.
		 * 
		 * <p>[詳 細]</p>
		 * BaseAction#run終了後にコントローラに実行されるモデルクラス型配列です。
		 * BaseAction#reserveModelsの返却値が登録されます。
		 * 
		 * <p>[備 考]</p>
		 * 
		 */
		public function get models():Array {
			return this._parameters[MODELS];
		}
		public function set models(models:Array):void {
			this._parameters[MODELS] = models;
		}
		
		/**
		 * <p>[概 要]</p>
		 * このParameterMappingが生成される起因となったイベントです.
		 * 
		 * <p>[詳 細]</p>
		 * 統括的なイベントハンドラであるBaseController#handlerFacade
		 * に引数譲渡されたイベントオブジェクトです。
		 * 
		 * <p>[備 考]</p>
		 * 
		 */
		public function get event():Event {
			return this._parameters[EVENT];
		}
		public function set event(event:Event):void {
			this._parameters[EVENT] = event;
		}
		
		/**
		 * <p>[概 要]</p>
		 * 登録されているモデルクラス型の数です.
		 * 
		 * <p>[詳 細]</p>
		 * コントローラに実行委譲予約された機能モデルの数です。<br>
		 * モデルが予約されなかった場合でも、デフォルト実行されるモデルの
		 * 数は換算されます。
		 * 
		 * <p>[備 考]</p>
		 * 
		 */
		public function get modelReservedNum():int {
			return this._parameters[MODEL_RESERVE_NUM];
		}
		public function set modelReservedNum(modelReservedNum:int):void {
			this._parameters[MODEL_RESERVE_NUM] = modelReservedNum;
		}
		
		/**
		 * <p>[概 要]</p>
		 * モデル完了イベント「ModelProcessEvent.FINISHED」を発行したモデルの数です.
		 * 
		 * <p>[詳 細]</p>
		 * 登録されているモデルの内、処理が完了したモデルの数を保持します。
		 * この数がmodelReservedNumと等しくなった時、アクションに対してcomplete通知
		 * が行われます。
		 * 
		 * <p>[備 考]</p>
		 * 
		 */
		public function get modelFinishedNum():int {
			return this._parameters[MODEL_FINISHED_NUM];
		}
		public function set modelFinishedNum(modelFinishedNum:int):void {
			this._parameters[MODEL_FINISHED_NUM] = modelFinishedNum;
		}
		
		/**
		 * <p>[概 要]</p>
		 * コントローラ#invokeの成功時に実行されるファンクションです.
		 * 
		 * <p>[詳 細]</p>
		 * このプロパティを設定することで、アクション#completeの後に
		 * 実行する処理を予約することができます。
		 * 
		 * <p>[備 考]</p>
		 * 
		 */
		public function get invokeCompleteHandler():Function {
			return this._parameters[INVOKE_COMPLETE_HANDLER];
		}
		public function set invokeCompleteHandler(invokeCompleteHandler:Function):void {
			this._parameters[INVOKE_COMPLETE_HANDLER] = invokeCompleteHandler;
		}

		/**
		 * <p>[概 要]</p>
		 * コントローラ#invokeの失敗時に実行されるファンクションです.
		 * 
		 * <p>[詳 細]</p>
		 * このプロパティを設定することで、アクション#failureForwardの後に
		 * 実行する処理を予約することができます。
		 * 
		 * <p>[備 考]</p>
		 * 
		 */
		public function get invokeFailureHandler():Function {
			return this._parameters[INVOKE_FAILURE_HANDLER];
		}
		public function set invokeFailureHandler(invokeFailureHandler:Function):void {
			this._parameters[INVOKE_FAILURE_HANDLER] = invokeFailureHandler;
		}
		
		/**
		 * <p>[概 要]</p>
		 * アクションを起動したDisplayObjectです.
		 * 
		 * <p>[詳 細]</p>
		 * Event#currentTargetと同値ですが、
		 * この値はイベントフェーズによって変化しません。
		 * 
		 * <p>[備 考]</p>
		 * 
		 */
		public function get eventSourceObject():DisplayObject {
			return this._parameters[EVENT_SOURCE_OBJECT];
		}
		public function set eventSourceObject(eventSourceObject:DisplayObject):void {
			this._parameters[EVENT_SOURCE_OBJECT] = eventSourceObject;
		}
		
		/**
		 * <p>[概 要]</p>
		 * このクラスオブジェクトの複製を返却します.
		 * 
		 * <p>[詳 細]</p>
		 * ParameterMappingオブジェクト、及び保持するプロパティは完全なコピーを作りますが、
		 * parametersプロパティ内で保持する定数キー要素値のアドレス参照はコピーしません。
		 * <p/>
		 * 
		 * parameterMapping.parametersと、<br>
		 * clonedParameterMapping.parameters<br>
		 * は異なるアドレスで保持されますが、
		 * <p/>
		 * 
		 * parameterMapping.eventSourceObjectと、<br>
		 * clonedParameterMapping.eventSourceObject<br>
		 * は同じアドレスを返却します。
		 *  
		 * <p>[備 考]</p>
		 * このメソッドはアクションからコントローラに別アクション実行を委譲する場合等に使用します。<br>
		 * <listing version="3.0">
            override protected function prepare(parameterMapping:ParameterMapping):Boolean {
                controller.invoke(Class(OtherAction), parameterMapping.clone());
                 
                return true;
            }
		 * </listing>
		 * コントローラはコールバック（successForwardやfailureForward）先アクションアドレスを
		 * ParameterMapping#actionInstanceで判別しますが、invokeが呼ばれると左記のアドレスを指定
		 * された新規アクションのアドレスで上書きします。<br>
		 * 上記のようにinvokeを呼び出すことで、コントローラが認識するアクションアドレスの上書き
		 * を抑止することが出来ます。
		 * <p/>
		 * 
		 * @return 複製されたParameterMappingオブジェクト
		 */
		public function clone():ParameterMapping {
			var ret:ParameterMapping = new ParameterMapping();

			// ObjectUtil.copy(parameters)やByteArrayを使用したAMFコードコピーでは
			// 複製が出来てもObject以外の型情報維持が出来ない為、スキャンした参照を
			// 新規parametersインスタンスに代入
			var clonedParameters:Dictionary = new Dictionary();
			for(var key:Object in this.parameters) {
				clonedParameters[key] = this.parameters[key];
			}
			
			ret.parameters = clonedParameters;

			return ret;
		}
	}
}
