/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.functions;

import java.sql.SQLException;
import java.util.List;

import net.morilib.db.delay.Delay;
import net.morilib.db.expr.RelationFunction;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.misc.Rational;
import net.morilib.db.relations.RelationAggregate;

public class FnCount extends RelationFunction {

	@Override
	public Object init() throws SQLException {
		return new Delay() {

			Rational count = Rational.ZERO;

			@Override
			public Object force() throws SQLException {
				return count;
			}

			@Override
			public void add(Object... args) throws SQLException {
				count = count.add(Rational.ONE);
			}

		};
	}

	/* (non-Javadoc)
	 * @see net.morilib.db.functions.FnOneValueAggregate#getName()
	 */
	public String getName() {
		return "COUNT";
	}

	@Override
	public final boolean isAggregate() {
		return true;
	}

	@Override
	public Object operate(RelationAggregate m,
			List<Object> group,
			Object... args) throws SQLException {
		Delay d;

		d = (Delay)m.get(group);
		if(args.length != 1) {
			throw ErrorBundle.getDefault(10007, getName());
		} else if(!args[0].equals("")) {
			d.add(args[0]);
		}
//		m.put(group, d);
		return d;
	}

	@Override
	public FunctionType getType() {
		return FunctionType.NUMERIC;
	}

}
