/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.misc;

import java.util.logging.Logger;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/09/14
 */
public class LoggerRelationsLogger implements RelationsLogger {

	private Logger logger;

	/**
	 * 
	 * @param l
	 */
	public LoggerRelationsLogger(Logger l) {
		logger = l;
	}

	/* (non-Javadoc)
	 * @see net.morilib.db.misc.RelationsLogger#severe(java.lang.String)
	 */
	@Override
	public void severe(String msg) {
		logger.severe(msg);
	}

	/* (non-Javadoc)
	 * @see net.morilib.db.misc.RelationsLogger#warning(java.lang.String)
	 */
	@Override
	public void warning(String msg) {
		logger.warning(msg);
	}

	/* (non-Javadoc)
	 * @see net.morilib.db.misc.RelationsLogger#info(java.lang.String)
	 */
	@Override
	public void info(String msg) {
		logger.info(msg);
	}

	/* (non-Javadoc)
	 * @see net.morilib.db.misc.RelationsLogger#config(java.lang.String)
	 */
	@Override
	public void config(String msg) {
		logger.config(msg);
	}

	/* (non-Javadoc)
	 * @see net.morilib.db.misc.RelationsLogger#fine(java.lang.String)
	 */
	@Override
	public void fine(String msg) {
		logger.fine(msg);
	}

	/* (non-Javadoc)
	 * @see net.morilib.db.misc.RelationsLogger#finer(java.lang.String)
	 */
	@Override
	public void finer(String msg) {
		logger.finer(msg);
	}

	/* (non-Javadoc)
	 * @see net.morilib.db.misc.RelationsLogger#finest(java.lang.String)
	 */
	@Override
	public void finest(String msg) {
		logger.finest(msg);
	}

}
