/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.sqlcs.ddl;

import java.util.EnumSet;

public class SqlColumnDefinition {

	//
	private String name;
	private SqlColumnType type;
	private EnumSet<SqlColumnAttribute> attrs;

	public SqlColumnDefinition(String name, SqlColumnType type,
			EnumSet<SqlColumnAttribute> attrs) {
		this.name = name;
		this.type = type;
		this.attrs = attrs;
	}

	public String getName() {
		return name;
	}

	public SqlColumnType getType() {
		return type;
	}

	public EnumSet<SqlColumnAttribute> getAttributes() {
		return EnumSet.copyOf(attrs);
	}

	public boolean isSame(SqlColumnDefinition d) {
		return (type.equals(d.type) &&
				attrs.equals(d.getAttributes()));
	}

	public String toString() {
		StringBuffer b = new StringBuffer(name);

		b.append(' ').append(type);
		for(SqlColumnAttribute a : attrs) {
			b.append(' ').append(a);
		}
		return b.toString();
	}

}
