/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.httpd;

import java.util.logging.Level;

/**
 * 
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/09/28
 */
public abstract class HTTPLogger {

	protected Level level = Level.ALL;

	public Level getLevel() {
		return level;
	}

	public void setLevel(Level level) {
		this.level = level;
	}

	/**
	 * 
	 * @param level
	 * @param format
	 * @param o
	 */
	public abstract void log(Level level, String format, Object... o);

	/**
	 * 
	 * @param format
	 * @param os
	 */
	public void severe(String format, Object... os) {
		log(Level.SEVERE, format, os);
	}

	/**
	 * 
	 * @param format
	 * @param os
	 */
	public void warning(String format, Object... os) {
		log(Level.WARNING, format, os);
	}

	/**
	 * 
	 * @param format
	 * @param os
	 */
	public void info(String format, Object... os) {
		log(Level.INFO, format, os);
	}

	/**
	 * 
	 * @param format
	 * @param os
	 */
	public void config(String format, Object... os) {
		log(Level.CONFIG, format, os);
	}

	/**
	 * 
	 * @param format
	 * @param os
	 */
	public void fine(String format, Object... os) {
		log(Level.FINE, format, os);
	}

	/**
	 * 
	 * @param format
	 * @param os
	 */
	public void finer(String format, Object... os) {
		log(Level.FINER, format, os);
	}

	/**
	 * 
	 * @param format
	 * @param os
	 */
	public void finest(String format, Object... os) {
		log(Level.FINEST, format, os);
	}

}
