/* Copyright (C) 2007 HighWide. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE HIGHWIDE "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE HIGHWIDE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * -----
 * {\tgEFA"The modified BSD license"ɏ܂B
 */
package jp.highwide.resourcechecker.sample.quickfix.resolution;

import java.util.ArrayList;
import java.util.Map;

import jp.highwide.resourcechecker.checker.ResourceCheckerMarker;

import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.AbstractTextEditor;

/**
 * ResourceChecker vOCō쐬ꂽ}[J[ResolutionGeneratorTvB
 */
public class SampleResolutionGenerator implements IMarkerResolutionGenerator {
	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.IMarkerResolutionGenerator#getResolutions(org.eclipse.core.resources.IMarker)
	 */
	public IMarkerResolution[] getResolutions(IMarker marker) {
		// }[J[Resolution쐬zŕԋpB
		ArrayList<IMarkerResolution> result = new ArrayList<IMarkerResolution>();
		String name = marker
				.getAttribute(ResourceCheckerMarker.MARKER_ATTRIBUTE_NAME, "");
		if (name.equals("֑")) {
			// Tv`FbNWbNIgnoreWordNX̃}[J[̏ꍇIgnoreWordResolutionǉB
			result.add(new IgnoreWordResolution());
		}
		return result.toArray(new IMarkerResolution[0]);
	}

	/**
	 * ֑𐳂ɏCResolution
	 */
	class IgnoreWordResolution implements IMarkerResolution {
		/* (non-Javadoc)
		 * @see org.eclipse.core.resources.IMarker.IMarkerResolution#getLabel()
		 */
		public String getLabel() {
			// NCbNtBbNXŕ\郉x
			return "ɏC";
		}

		/* (non-Javadoc)
		 * @see org.eclipse.core.resources.IMarker.IMarkerResolution#run(org.eclipse.core.resources.IMarker)
		 */
		public void run(IMarker marker) {
			try {
				// IgnoreWordNXŐݒ肵UserData擾B
				Map<String, String> userData = null;
				Object userDataObject = marker
						.getAttribute(ResourceCheckerMarker.MARKER_ATTRIBUTE_USERDATA);
				if (userDataObject == null) {
					// TODO eclipseċÑ}[J[userData͎擾łȂ
					throw new RuntimeException("userData擾ł܂łBēx\[X`FbNsANCbNtBbNXsĂB");
				}
				if (userDataObject instanceof Map) {
					userData = (Map<String, String>) userDataObject;
				} else {
					throw new RuntimeException("userDatǎ^słB");
				}

				// userData萳P擾
				String rightWord = userData.get("RightWord");

				// }[J[ĂDocument擾B
				IDocument doc = getDocument(marker);
				if (doc == null) {
					throw new RuntimeException("}[J[̃hLg擾ł܂łB");
				}

				// Document̕CB
				int start = marker.getAttribute(IMarker.CHAR_START, -1);
				int end = marker.getAttribute(IMarker.CHAR_END, -1);
				doc.replace(start, end - start, rightWord);
			} catch (Exception e) {
				// Oꍇ́AeclipsẽOɏo͂B
				throw new RuntimeException("CɎs܂B", e);
			}
		}

		/**
		 * }[J[ĂhLgԋpB
		 * @param marker }[J[
		 * @return hLg
		 */
		private IDocument getDocument(IMarker marker) {
			AbstractTextEditor textEditor = getAbstractTextEditor(marker);
			return textEditor.getDocumentProvider().getDocument(textEditor
					.getEditorInput());
		}

		/**
		 * }[J[ĂGfB^[ԋpB
		 * @param marker }[J[
		 * @return GfB^[
		 */
		private AbstractTextEditor getAbstractTextEditor(IMarker marker) {
			IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench()
					.getActiveWorkbenchWindow();
			if (workbenchWindow == null) {
				return null;
			}
			IWorkbenchPage page = workbenchWindow.getActivePage();
			if (page == null) {
				return null;
			}
			IEditorPart editorPart = null;
			try {
				editorPart = IDE.openEditor(page, marker);
			} catch (PartInitException e) {
				return null;
			}
			if (editorPart == null
					|| !(editorPart instanceof AbstractTextEditor)) {
				return null;
			}
			AbstractTextEditor textEditor = (AbstractTextEditor) editorPart;
			return textEditor;
		}

	}
}
