/*
 * Copyright 2007 Kickmogu Co. Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */



/*
 * 쐬: 2006/12/19
 *
 */
package com.kickmogu.rhythm.core;

public class AssignPermission {
	public final static String UNIQ_KEYNAME = "rhtym AssignPermission id";

	private int id;
	private int permissionId;
	private int targetId;

	public boolean equals(Object ap) {
		if (! (ap instanceof AssignPermission)) {
			return false;
		}
		return id == ((AssignPermission) ap).id;
	}
	
	/**
	 * @return permission ߂܂B
	 */
	public Permission getPermission() {
		return (Permission) RhythmTreeManager.getRoot(Permission.class).search(permissionId);
	}

	/**
	 * @return target ߂܂B
	 */
	public PermissionTarget getTarget() {
		Class targetClass = null;
		try {
			targetClass = Class.forName(getPermission().getClassName());
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		}
		return (PermissionTarget) RhythmTreeManager.getRoot(targetClass).search(targetId);
	}
	
	public AssignPermission(int id) {
		this.id = id;
	}
	/**
	 * @return id ߂܂B
	 */
	public int getId() {
		return id;
	}
	/**
	 * @param id id ݒB
	 */
	public void setId(int id) {
		this.id = id;
	}

	public int getPermissionId() {
		return permissionId;
	}

	public void setPermissionId(int permissionId) {
		this.permissionId = permissionId;
	}

	public int getTargetId() {
		return targetId;
	}

	public void setTargetId(int targetId) {
		this.targetId = targetId;
	}
}
