/*
 * Copyright 2007 Kickmogu Co. Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */



/*
 * 쐬: 2006/12/19
 *
 */
package com.kickmogu.rhythm.core.ws;

import java.io.IOException;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Category;
import java.util.*;
import com.kickmogu.rhythm.core.*;
import com.kickmogu.s2.DAOSequence;

public class RoleWs {
	static Category log = Category.getInstance(RoleWs.class.getName());

	public BaseResult addNode(Member loginMember, String name, int parentId) throws Exception {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		Role role = new Role();
		role.setId(DAOSequence.getNextId(Role.UNIQ_KEYNAME));
		role.setName(name);
		Role parent = (Role) RhythmTreeManager.getRoot(Role.class).search(parentId);
		if (parent == null) {
			result.setStatusCode(100);
			return result;
		}
		role.addToParent(parent);
		RhythmTreeManager.write(Role.class);
		result.setResult(role.getId());
		return result;
	}

	public BaseResult removeNode(Member loginMember, int targetId) throws Exception {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		Role role = (Role) RhythmTreeManager.getRoot(Role.class).search(targetId);
		role.remove();
		RhythmTreeManager.write(Role.class);
		result.setResult(role.getId());
		return result;
	}

	public BaseResult updateNode(Member loginMember, int targetId, String newName) throws Exception {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		Role role = (Role) RhythmTreeManager.getRoot(Role.class).search(targetId);
		role.setName(newName);
		RhythmTreeManager.write(Role.class);
		result.setResult(role.getId());
		return result;
	}

	public BaseResult getAllByXml(Member loginMember) {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		try {
			List<PermissionTarget> ptTree = loginMember.getAssignTarget(Permission.ROLE_MANAGE);
			String[] resultXml = new String[ptTree.size()];
			for (int i = 0; ptTree != null && i < ptTree.size(); i++) {
				resultXml[i] = ptTree.get(i).toXmlAll();
			}
			result.setResult(resultXml);
		} catch (Exception e) {
			log.error(e);
			e.printStackTrace();
		}
		return result;
	}
	
	public BaseResult getAllByXmlWithPermission(Member loginMember) {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		try {
			List<PermissionTarget> ptTree = loginMember.getAssignTarget(Permission.ROLE_MANAGE);
			String[] resultXml = new String[ptTree.size()];
			for (int i = 0; ptTree != null && i < ptTree.size(); i++) {
				resultXml[i] = ((Role) ptTree.get(i)).toXmlAllWithPermission();
			}
			result.setResult(resultXml);
		} catch (Exception e) {
			log.error(e);
			e.printStackTrace();
		}
		return result;
	}
	
	public BaseResult assignPermission(Member loginMember, int roleId, String permCode, int targetId) throws ClassNotFoundException, IOException {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		Role role = (Role) RhythmTreeManager.getRoot(Role.class).search(roleId);
		AssignPermission addedAp = role.assignPermission(permCode, targetId);
		result.setResult(addedAp.getId());
		RhythmTreeManager.write(Role.class);
		return result;
	}

	public BaseResult removePermission(Member loginMember, int roleId, int assignId) throws ClassNotFoundException, IOException {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		Role role = (Role) RhythmTreeManager.getRoot(Role.class).search(roleId);
		role.removePermission(assignId);
		RhythmTreeManager.write(Role.class);
		return result;
	}

	public BaseResult updatePermission(Member loginMember, int roleId, int apId, String permCode, int targetId) throws ClassNotFoundException, IOException {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		Role role = (Role) RhythmTreeManager.getRoot(Role.class).search(roleId);
		role.updatePermission(apId, permCode, targetId);
		RhythmTreeManager.write(Role.class);
		return result;
	}

}
