/*
 * Copyright 2007 Kickmogu Co. Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

/*
 * 쐬: 2006/12/04
 *
 */
package com.kickmogu.rhythm.timecard.ws;

import java.util.*;
import com.kickmogu.Config;
import com.kickmogu.rhythm.core.BaseResult;
import com.kickmogu.rhythm.core.Member;
import com.kickmogu.rhythm.core.dao.MemberDao;
import com.kickmogu.rhythm.timecard.*;
import com.kickmogu.rhythm.timecard.dao.*;
import com.kickmogu.s2.DAOSequence;
import com.kickmogu.s2.S2Util;

import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.commons.lang.time.DateUtils;

public class TimecardWs {
	TimecardDao tmdao = (TimecardDao) S2Util.getS2Container().getComponent(TimecardDao.class);
	MemberDao memdao = (MemberDao) S2Util.getS2Container().getComponent(MemberDao.class);

	private Timecard getCurrentTimecard(Member loginMember) {
		Calendar now = Calendar.getInstance();
		if (now.get(Calendar.HOUR_OF_DAY) < Integer.parseInt(Config.getProperty("timecard.daySplitHour"))) {
			now.add(Calendar.DATE, -1);
		}
		now = DateUtils.truncate(now, Calendar.DATE);
		now.set(Calendar.HOUR_OF_DAY, Integer.parseInt(Config.getProperty("timecard.daySplitHour")));
		Date fromDate = now.getTime();
		now.add(Calendar.DATE, 1);
		Date toDate = now.getTime();
		Timecard[] target = (Timecard[]) list(loginMember, loginMember.getId(), fromDate, toDate).getResult();
		return target != null && target.length >= 1 ? target[0] : null;
	}
	
	public BaseResult beginWork(Member loginMember) {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		Timecard target = getCurrentTimecard(loginMember);
		if (target != null) {
			return result;
		}
		Timecard tm = new Timecard();
		tm.setId(DAOSequence.getNextId(Timecard.UNIQ_KEYNAME));
		tm.setRegistrant(loginMember.getId());
		tm.setInTime(new Date());
		MessageContext context = MessageContext.getCurrentContext();
		tm.setInIpaddr(context.getStrProp(Constants.MC_REMOTE_ADDR));
		tmdao.insert(tm);
		return result;
	}
	
	public BaseResult endWork(Member loginMember) {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		Timecard target = getCurrentTimecard(loginMember);
		target.setOutTime(new Date());
		MessageContext context = MessageContext.getCurrentContext();
		target.setOutIpaddr(context.getStrProp(Constants.MC_REMOTE_ADDR));
		tmdao.update(target);
		return result;
	}

	public void update(Timecard tm) {
		tmdao.update(tm);
	}

	public void delete(Timecard tm) {
		tmdao.delete(tm);
	}

	public Timecard getById(int id) {
		return tmdao.getTimecard(id);
	}
	
	private int getTrafficPay(int trfc_exp, int trfc_type, int workday) {
		return trfc_type == 0 ? trfc_exp * workday : trfc_exp;
	}

	public BaseResult calcSalary(Member loginMember, int targetMemberId, Date fromDate, Date toDate) {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		Member targetMember = memdao.getMember(targetMemberId);
		Timecard[] tm = tmdao.listTimecards(targetMember.getId(), fromDate, toDate);
		int workDays = 0;
		int workTotal = 0, restTotal = 0;
		for (int i = 0; i < tm.length; i++) {
			if (tm[i].getOutTime() == null) {
				continue;
			}
			Calendar cal = Calendar.getInstance();
			cal.setTime(tm[i].getInTime());
			int inmin = cal.get(Calendar.HOUR_OF_DAY) * 60 + cal.get(Calendar.MINUTE);
			cal.setTime(tm[i].getOutTime());
			int outmin = 0;
			if (cal.get(Calendar.HOUR_OF_DAY) >= Integer.parseInt(Config.getProperty("timecard.daySplitHour"))) {
				outmin = cal.get(Calendar.HOUR_OF_DAY) * 60 + cal.get(Calendar.MINUTE);
			} else {
				outmin = (24 + cal.get(Calendar.HOUR_OF_DAY)) * 60 + cal.get(Calendar.MINUTE);
			}
			workTotal += (outmin - inmin);
			if ((outmin - inmin) > 6 * 60) {
				workTotal -= targetMember.getRestMinutes();
				restTotal += targetMember.getRestMinutes();
			}
			workDays++;
		}
		workTotal = workTotal / 15 * 15;
		TimecardSummary tsmry = new TimecardSummary();
		tsmry.setTotalWorkMinutes(workTotal + restTotal);
		tsmry.setTotalRestMinutes(restTotal);
		tsmry.setTotalSalariedMinutes(workTotal);
		tsmry.setSalaryPerHour(targetMember.getPayHour());
		tsmry.setBasicSalary(tsmry.getSalaryPerHour() * tsmry.getTotalSalariedMinutes() / 60);
		tsmry.setTransExpensesDay(workDays);
		tsmry.setTransExpenses(getTrafficPay(targetMember.getTrafficExpenses(), targetMember.getTrafficExpensesKind(), tsmry.getTransExpensesDay()));
		result.setResult(tsmry);
		return result;
	}

	public BaseResult list(Member loginMember, int targetMemberId, Date fromDate, Date toDate) {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		result.setResult(tmdao.listTimecards(targetMemberId, fromDate, toDate));
		return result;
	}

	public BaseResult getSplitHour() {
		BaseResult result = new BaseResult();
		result.setResult(Integer.parseInt(Config.getProperty("timecard.daySplitHour")));
		return result;
	}
	
	public void wsdldummy(Timecard tm, TimecardSummary tsmry) {
	}
}
