/*
 * Copyright 2007 Kickmogu Co. Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */



/*
 * 쐬: 2007/01/29
 *
 */
package com.kickmogu.rhythm.todo.test;

import java.util.*;
import com.kickmogu.core.Utils;
import com.kickmogu.rhythm.core.Member;
import com.kickmogu.rhythm.core.ws.MemberWs;
import com.kickmogu.rhythm.todo.*;
import com.kickmogu.rhythm.todo.dao.TodoDao;
import com.kickmogu.rhythm.todo.ws.*;
import com.kickmogu.s2.S2Util;

import jp.co.dgic.testing.framework.DJUnitTestCase;

public class TodoTest extends DJUnitTestCase {
	protected void setUp() throws Exception {
		super.setUp();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void test001() throws Exception {
        System.out.println("------------ǂݍݒTree------------");
        TodoWs ws = new TodoWs();
        MemberWs memWs = new MemberWs();
        Member member = (Member) memWs.authorize("mogu", "hfc01415").getResult();
        Date now = new Date();
        Date fromDate = new Date(0);
        Todo[] result = (Todo[]) ws.listSchedules(member, fromDate, now).getResult();
        for (int i = 0; i < result.length; i++) {
        	System.out.println("Todo:" + result[i].getSubject());
        }
	}
	
	public void test002() throws Exception {
        System.out.println("------------Todo XML\------------");
        TodoWs ws = new TodoWs();
        MemberWs memWs = new MemberWs();
        Member member = (Member) memWs.authorize("mogu", "hfc01415").getResult();
        System.out.println(ws.listCategoryAllTodos(member, 321).getResult());
	}
	
	public void test003() throws Exception {
        System.out.println("------------Todo workersz̕\------------");
    	TodoDao tododao = (TodoDao) S2Util.getS2Container().getComponent(TodoDao.class);
    	Todo todo = tododao.getTodo(0, 49);
    	System.out.println("Todo:" + Utils.dumpBean(todo));
	}
	
	static public void main(String[] arg) throws Exception {
	}
}
