/*
 * Copyright 2007 Kickmogu Co. Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */



/*
 * 쐬: 2007/01/12
 *
 */
package com.kickmogu.rhythm.util.ws;

import com.kickmogu.rhythm.util.dao.WindowPosDao;
import com.kickmogu.rhythm.core.BaseResult;
import com.kickmogu.rhythm.core.Member;
import com.kickmogu.rhythm.util.*;
import com.kickmogu.s2.DAOSequence;
import com.kickmogu.s2.S2Util;

public class GuiUtilWs {
	WindowPosDao winposdao = (WindowPosDao) S2Util.getS2Container().getComponent(WindowPosDao.class);

	public BaseResult saveWindowPos(Member loginMember, String windowName, int x, int y, int height, int width, String optXml) {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		WindowPos winPos = winposdao.getWindowPos(loginMember.getId(), windowName);
		if (winPos == null) {
			winPos = new WindowPos();
			winPos.setId(DAOSequence.getNextId(WindowPos.UNIQ_KEYNAME));
			winPos.setMemberId(loginMember.getId());
		}
		winPos.setX(x);
		winPos.setY(y);
		winPos.setHeight(height);
		winPos.setWidth(width);
		winPos.setOptionXml(optXml);
		if (winPos.getWindowName() == null) {
			winPos.setWindowName(windowName);
			winposdao.insert(winPos);
		} else {
			winposdao.update(winPos);
		}
		return result;
	}

	public BaseResult loadWindowPos(Member loginMember, String windowName) {
		BaseResult result = new BaseResult();
		if (!loginMember.isLogined(result)) {
			return result;
		}
		WindowPos winPos = winposdao.getWindowPos(loginMember.getId(), windowName);
		result.setResult(winPos);
		return result;
	}

	public void wsdldummy(WindowPos winPos) {
		
	}
}
