<?php
/* ========================================================================
 - [modules/private/forum/comment.php]
 -      コメントを書き込む
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * コメントID
     * @var integer
     */
    var $id = 0;

    /**
     * トピックID
     * @var integer
     */
    var $ref_topic = 0;

    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('private/forum/comment.tpl');

        /* PathInfo引数の設定 */
        $this->setPathInfo('ref_topic');
        $this->Assign('ref_topic', $this->ref_topic);

        $this->setSafety('id');
        $this->permission();
        $this->Assign('id', $this->id);

        /* アクション処理 */
        if (!empty($_REQUEST['again'])){
            header('Location: '.HTTP_ACTION.'private/forum/comment/'.$this->sid.'/'.$this->ref_topic.'/again/'.WAP_URI_SEPARATOR.'id='.$this->id);
            exit();
        }

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb, DB_PREFIX.'frm_comment');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            $this->id = $this->objmnp->getCurID();
            
            /* トピックの更新日を最新に */            
            $this->update_topic();

            header('Location: '.HTTP_ACTION.'private/forum/browse/'.$this->sid.'/'.$this->ref_topic.'/');
            exit();
        } elseif ($result == RKT_MANIP_VALIDATED) {
            header('Location: '.HTTP_ACTION.'private/forum/comment/'.$this->sid.'/'.$this->ref_topic.'/confirm/');
            exit();
        }

        $this->set_topic();
    }

    /**
     * 対象IDに編集権限があるか
     *
     * @access private
     * @return void
     */
    function permission()
    {
        if (empty($this->id)){
            return ;        
        }
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'frm_comment '.
            'WHERE '.
                'id = '.$this->id.' AND '.
                'ref_topic ='.$this->ref_topic.' AND '.
                'ref_account ='.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        if (empty($result['id'])){
            $this->id = null;        
        }
    }

    /**
     * トピック情報の設定
     *
     * @access private
     * @return void
     */
    function set_topic()
    {
        $sql=
            'SELECT '.
                '* '.
            'FROM '.
                DB_PREFIX.'frm_topic '.
            'WHERE '.
                'id = '.$this->ref_topic;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $this->topic = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        $this->Assign('topic', $this->topic);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        if (!empty($this->id)){
            $this->objmnp->setCurID($this->id);
        } else {
            $this->objmnp->setValue('regist_date', date('Y-m-d H:i:s'));
        }

        /* 直接入力 */
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('ref_topic', $this->ref_topic);
        $this->objmnp->setValue('ref_account', $this->account['id']);

        /* 入力フォームからをキャッチ */
        $skip = array(
            'regist_date',
        );
        return $this->objmnp->execute($this,$skip);
    }
    
    /**
     * トピックの更新日を更新
     *
     * @access private
     * @return integer  データ操作結果
     */
    function update_topic()
    {
        $this->objdb->beginTransaction();
        $sql = 
            'SELECT '.
                'count(*) as post '.
            'FROM '.
                DB_PREFIX.'frm_comment '.
            'WHERE '.
                'ref_topic = '.$this->ref_topic;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        $post = empty($result['post'])?0:$result['post'];

        $sql =
            'UPDATE '.
                DB_PREFIX.'frm_topic '.
            'SET '.
                "modify='".date('Y-m-d H:i:s')."',".
                'post = '.$post.' '.
            'WHERE '.
                'id = '.$this->ref_topic;
        $this->objdb->exec($sql);
        $this->objdb->commit();
    }
} // webapp
?>
