<?php
/* ========================================================================
 - [webapp/libs/wap_community.php]
 -      community用WebApplicationクラス
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/09/20] $this->base['uri_separator']を追加
 -      [2006/08/26] コミュニティ情報をメンバ変数に所持
 -      [2006/08/27] ベーステンプレートをコンストラクタで指定
 -      [2006/07/10] 作成
 - ======================================================================== */

require_once LIB_DIR.'rkt_db.php';
require_once LIB_DIR.'rkt_validate.php';
require_once LIB_DIR.'rkt_auth.php';
require_once LIB_DIR.'rkt_webapp.php';

/**
 * community用WebApplicationクラス
 *
 * @author 高橋 裕志郎 <yujiro@stepone.tv>
 * @package WAP_community
 * @access public
 * @version 1.0
 */
class WAP_community extends RKT_webapp
{
    /**
     * アカウント情報
     * @var object
     */
    var $accounts = array();

    /**
     * コミュニティ情報
     * @var object
     */
    var $community = array();

    /**
     * error情報
     * @var boolean
     */
    var $error = false;

    /**
     * コミュニティID
     * @var integer
     */
    var $ref_community = 0;

    /**
     * コミュニティ管理者
     * @var integer
     */
    var $admin = 0;

    /**
     * コンストラクタ
     *
     * @access public
     */
    function WAP_community()
    {
        $this->RKT_webapp();
        $this->init_tplargs();

        $objact = account::getInstance();
        $this->account = $objact->getInfo();
        $this->base['account'] = $this->account;

        $this->setTemplateBase('base/community.tpl');
        $this->base['menu'] = 'menu/community.tpl';

        $this->addCss('common.css');
        $this->addCss('member.css');
        $this->addCss('community.css');

        /* PathInfo引数の設定 */
        $this->setPathInfo('ref_community');
        $this->set_community_info();

        if (empty($this->community['id'])){
            if (!strstr($_SERVER[PATH_INFO_KEY], 'community/edit/community')){
                RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));
                header('Location: '.HTTP_ACTION.'community/edit/community/');
                exit();
            }
        } // if (empty($this->community['id']))
        
        $this->set_base_community();
        $this->set_base_member();

        /* コミュニティがアクティブか */
        $this->page_authorized();

        $this->base['ref_community'] = $this->ref_community;
        $this->base['community']     = $this->community;
    }

    /**
     * 実行処理
     *
     * @access public
     **/
    function execute()
    {
    }

    /**
     * 表示処理
     *
     * @access public
     * @return void
     **/
    function display()
    {
        if ($this->error){
            $this->template_file = 'error.tpl';
            error_log('WAP_community::error();'."\t".
                        $this->objdb->sqlerror."\r\n", 3, ERROR_LOG_FILE);
        }
        $this->mixOutput();
    }

    /**
     * コミュニティ情報の設定
     *
     * @access public
     * @return void
     **/
    function set_community_info()
    {
        $sql=
            'SELECT '.
                'com.id as id,'.
                'com.ref_account as ref_account,'.
                'com.visibility as visibility,'.
                'com.community as community,'.
                'pic.filename as src,'.
                'pic.width as width,'.
                'pic.height as height,'.
                'pic.thumbnail as t_src,'.
                'pic.t_width as t_width,'.
                'pic.t_height as t_height '.
            'FROM '.
                DB_PREFIX.'com_community com '.
                    'LEFT JOIN '.DB_PREFIX.'com_picture pic '.
                    'ON com.id = pic.ref_community AND '.
                       'pic.status = '.STATUS_PICTURE_COMMUNITY.' '.
            'WHERE '.
                'com.avail = '.AVAIL_ENABLE.' AND '.
                'com.id = '.$this->ref_community;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $this->community = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
    }

    /**
     * コミュニティの存在とページ照合
     *
     * @access public
     * @return void
     **/
    function page_authorized()
    {
        /* パスインフォからIDを取得 */
        $path_info = empty($_SERVER[PATH_INFO_KEY])?'':$_SERVER[PATH_INFO_KEY];

        $args = explode('/',$path_info);
        $community = empty($args[1])?'community':$args[1];
        $module = empty($args[2])?'edit':$args[2];
        $page   = empty($args[3])?$module:$args[3];
        
        $check = preg_match("/^communityeditcommunity$/", $community.$module.$page);
        if ($check){
            return ;
        }
        
        if (!empty($this->ref_community)){
            return ;
        }
        
        header('Location: '.HTTP_ACTION.'community/edit/community/');
        exit();        
    }

    /**
     * コミュニティ情報の設定
     *
     * @access public
     * @return void
     **/
    function set_base_community()
    {
        $this->admin = ($this->community['ref_account'] == $this->account['id']);

        $this->base['visibility'] = $this->community['visibility'];
        $this->base['admin']      = $this->admin;

        if (empty($this->community['src'])){
            $this->community['src']      = NOPHOTO_LARGE;
            $this->community['width']    = PHOTO_LARGE_SIZE;
            $this->community['height']   = PHOTO_LARGE_SIZE;
            $this->community['t_src']    = NOPHOTO_SMALL;
            $this->community['t_width']  = PHOTO_SMALL_SIZE;
            $this->community['t_height'] = PHOTO_SMALL_SIZE;
        }
    }

    /**
     * コミュニティ参加情報の設定
     *
     * @access public
     * @return void
     **/
    function set_base_member()
    {
        $sql=
            'SELECT '.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'com_names '.
            'WHERE '.
                'ref_community = '.$this->ref_community.' AND '.
                'ref_account = '.$this->account['id'].' AND '.
                '(status = '.STATUS_COMMUNITY_ADMIN.' OR '.
                 'status = '.STATUS_COMMUNITY_MEMBER.' OR '.
                 'status = '.STATUS_COMMUNITY_CHANGE.')';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $this->community['is_member'] = !empty($result['ct']);
        $this->base['is_member'] = $this->community['is_member'];
    }

    /**
     * テンプレート引数の初期化
     *
     * @access private
     */
    function init_tplargs()
    {
        $this->base['sid']  = session_id();
        $this->base['url']  = BASE_URL;
        $this->base['http'] = HTTP_ACTION;
        $this->base['ssl']  = SSL_ACTION;

        $this->base['uri_separator']  = htmlspecialchars(WAP_URI_SEPARATOR);
    }
}
// WAP_communityの終了
?>
