<?php
/* ========================================================================
 - [modules/admin/design/design.php]
 -      デザイン設定
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/05/13] 画像ファイル情報を取得しデザインに反映
 -      [2006/09/16] 背景色の追加
 -      [2006/09/12] SMARTY用定数名を変更
 -      [2006/09/11] webapp::get_text_color()内の変数名を修正
 -      [2006/08/07] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'wap_admin.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_admin
{
    /**
     * デザインID
     * @var integer
     */
    var $id = 1;

    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * ファイル情報格納
     * @var array
     */
    var $fileinfos = array();

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN));

        $this->setTemplateFile('admin/design/design.tpl');        
        $this->addJavas('admin.js');

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb, DB_PREFIX.'sys_design');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            $this->update_theme();
            header('Location: '.HTTP_ACTION.'admin/design/design/complete/');
            exit();
        }

        if (preg_match('/complete/i',$_SERVER['REQUEST_URI'])){
            $this->Assign('complete', true);
        }
        
        $this->set_theme();
    }

    /**
     * デザインテーマの設定
     *
     * @access private
     * @return void
     **/
    function set_theme()
    {
        $sql = 
            'SELECT '.
                'id,'.
                'theme '.
            'FROM '.
                DB_PREFIX.'des_theme '.
            'ORDER BY '.
                'regist_date DESC';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['theme'];
        }

        $this->Assign('themes', $list);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        // 新規登録以外の処理
        $this->objmnp->setCurID($this->id);
        $this->objmnp->catchInput();

        return $this->objmnp->doManip($this);
    }

    /**
     * アンチエイリアス色の取得
     *
     * @access private
     * @param string $color
     * @return array
     */
    function anti_alias($color)
    {
        $colors = array();
        $colors[] = $color;

        $red   = hexdec(substr($color, 0, 2));
        $blue  = hexdec(substr($color, 2, 2));
        $green = hexdec(substr($color, 4, 2));
        $back  = hexdec('FF');

        $num_red   = ($back - $red);
        $num_blue  = ($back - $blue);
        $num_green = ($back - $green);

        $rates = array(
            1.767, 1.112, 5.375, 4.031,
        );

        foreach ($rates as $rate){
            $color = '';

            $round = empty($num_red)?0:round($num_red / $rate);
            $color .= dechex($round + $red);

            $round = empty($num_blue)?0:round($num_blue / $rate);
            $color .= dechex($round + $blue);

            $round = empty($num_green)?0:round($num_green / $rate);
            $color .= dechex($round + $green);

            $colors[] = $color;
        }

        return $colors;
    }

    /**
     * 色の計算
     *
     * @access private
     * @param string $color
     * @param integer $number
     * @return $color
     */
    function add_color($color, $number)
    {
        $red   = hexdec(substr($color, 0, 2));
        $green = hexdec(substr($color, 2, 2));
        $blue  = hexdec(substr($color, 4, 2));

        $red   += $number;
        $green += $number;
        $blue  += $number;

        $red   = ($red > 255)?255:$red;
        $green = ($green > 255)?255:$green;
        $blue  = ($blue > 255)?255:$blue;

        $red   = ($red < 0)?0:$red;
        $green = ($green < 0)?0:$green;
        $blue  = ($blue < 0)?0:$blue;

        return dechex($red).dechex($green).dechex($blue);
    }

    /**
     * デザインテーマの設定
     *
     * @access private
     * @return void
     **/
    function update_theme()
    {
        $sql = 
            'SELECT '.
                'ref_common,'.
                'ref_admin,'.
                'ref_private,'.
                'ref_friend,'.
                'ref_community,'.
                'ref_public,'.
                'frame_width '.
            'FROM '.
                DB_PREFIX.'sys_design '.
            'WHERE '.
                'id = 1';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        
        $frame_width = empty($result['frame_width'])?'800':'900';

        $this->copy_image($result['ref_common'],'top');
        $this->copy_image($result['ref_common'],'header');
        $this->copy_image($result['ref_common'],'common');
        $this->update_css($result['ref_common'],'common', $frame_width);

        $this->copy_image($result['ref_admin'],'admin');
        $this->update_css($result['ref_admin'],'admin');

        $this->copy_image($result['ref_private'],'private');
        $this->update_css($result['ref_private'],'private');

        $this->copy_image($result['ref_friend'],'friend');
        $this->update_css($result['ref_friend'],'friend');

        $this->copy_image($result['ref_community'],'community');
        $this->update_css($result['ref_community'],'community');

        $this->copy_image($result['ref_public'],'public');
        $this->update_css($result['ref_public'],'public');
    }

    /**
     * 画像のコピー
     *
     * @access private
     * @param integer $id
     * @param string $target
     * @return void
     */
    function copy_image($id, $target)
    {
        $sort_func = array(
            'private'=>   'sort',
            'friend'=>    'rsort',
            'community'=> 'sort',
            'header'=>    'sort',
            'admin'=>     'rsort',
        );

        $dir = THEME_DIR.$id.DIRECTORY_SEPARATOR;
        $prefix = '{'.$target.'_,joker_}';
        if ($target === 'common'){
            $prefix = 'common_';
        } elseif ($target === 'top'){
            $prefix = 'top_';
        } elseif ($target === 'header'){
            $prefix = 'header_';
        }
        $files = glob($dir.$prefix.'{*.jpg,*.jpeg,*.gif}', GLOB_BRACE);
        eval($sort_func[$target].'($files);');

        $img_path = RESOURCE_DIR.'img'.DIRECTORY_SEPARATOR.$target.DIRECTORY_SEPARATOR;

        $infos = array();
        foreach ($files as $source){
            $file  = basename($source);
            $name  = preg_replace('/(^'.$target.'_|joker_)/','',$file);
            $split = explode('.', $name);
            copy($source, $img_path.$name);
            
            $size = getimagesize($img_path.$name);
            $infos[$split[0]] = array(
                'filename'=>  $target.'/'.$name,
                'extension'=> $split[1],
                'width'=>     $size[0],
                'height'=>    $size[1],
            );
        }
        $this->fileinfos[$target] = $infos;
    }

    /**
     * テキスト色の取得
     *
     * @access private
     * @param strig $color
     * @return string
     */
    function get_text_color($color)
    {
        $red   = hexdec(substr($color, 0, 2));
        $green = hexdec(substr($color, 2, 2));
        $blue  = hexdec(substr($color, 4, 2));

        $color = 'white';
        if (165 < $red){
            $color = 'black';
        }
        if (165 < $blue){
            $color = 'black';
        }
        if (165 < $green){
            $color = 'black';
        }
        return $color;
    }

    /**
     * スタイルシートの書き込み
     *
     * @access private
     * @param integer $id
     * @param string $css
     * @param string $frame_width
     * @return void
     */
    function update_css($id,$css,$frame_width='800')
    {
        if (empty($_REQUEST[$css.'_css'])){
            return ;
        }
        $sql=
            'SELECT '.
                '* '.
            'FROM '.
                DB_PREFIX.'des_theme '.
            'WHERE '.
                'id = '.$id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }


        $smarty = new Smarty();

        $smarty->template_dir = SMARTY_TEMPLATE_DIR;
        $smarty->compile_dir = SMARTY_COMPILE_DIR;

        $smarty->assign('url', BASE_URL);

        $colors = $this->anti_alias($result['round']);
        $smarty->assign('round', $colors);
        $colors = $this->anti_alias($result['box']);
        $smarty->assign('box', $colors);

        $smarty->assign('frame_width', $frame_width);
        $smarty->assign('border', $result['border']);
        $smarty->assign('text', $result['text']);
        $smarty->assign('column', $result['column']);
        $smarty->assign('button', $result['button']);
        $smarty->assign('focus', $result['focus']);
        $smarty->assign('header', $result['header']);
        $smarty->assign('background', $result['background']);
        $smarty->assign('copyright', $this->get_text_color($result['header']));

        $smarty->assign('bg_column',  $this->add_color($result['border'], 10));
        $smarty->assign('bg_title',   $this->add_color($result['box'],    40));
        $smarty->assign('bg_subject', $this->add_color($result['border'], 20));

        $smarty->assign('fileinfo', $this->fileinfos);

        $output = $smarty->fetch('admin/design/css/'.$css.'.tpl');
        $output = mb_convert_encoding($output, 'SJIS', ENCODE_TYPE);

        /* ファイルの読み込み */
        $filename = RESOURCE_DIR.'css'.DIRECTORY_SEPARATOR.$css.'.css';
        $fp = fopen($filename, 'w');
        if (!$fp){
            return ;
        }
        fwrite($fp, $output);
        fclose($fp);
    }
} // webapp
?>
