<?php
/* ========================================================================
 - [modules/admin/inquire/list.php]
 -      問合せ一覧
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'sql_query.php';
require_once WEBAPP_LIB_DIR.'wap_admin.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_admin
{
    /**
     * ステータス
     * @var integer
     */
    var $status = 0;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN));
        
        $this->setTemplateFile('admin/inquire/list.tpl');

        /* PathInfo引数の設定 */
        $this->setPathInfo('status');
        $this->status = empty($this->status)?STATAS_INQUIRE_NEW:$this->status; 
        $this->Assign('status', $this->status);

        $this->set_list();
        $this->set_category();

        $statuses = array(
            STATAS_INQUIRE_NEW=> STATAS_INQUIRE_LABEL_NEW,
            STATAS_INQUIRE_PENDING=> STATAS_INQUIRE_LABEL_PENDING,
            STATAS_INQUIRE_RESPONDED=> STATAS_INQUIRE_LABEL_RESPONDED,
            STATAS_INQUIRE_TRASH=> STATAS_INQUIRE_LABEL_TRASH
        );
        $this->baseAssign('title', $statuses[$this->status]);
        $this->Assign('statuses', $statuses);

        $icons = array(
            MESSAGE_FLAG_UNREAD=> 'unread',
            MESSAGE_FLAG_READ=>   'read',
            MESSAGE_FLAG_RETURN=> 'return',
        );
        $this->Assign('icons', $icons);

        /* メッセージ操作 */
        if ($this->update_query()){
            header('Location: '.HTTP_ACTION.'admin/inquire/list/'.$this->status.'/updated/');
            exit();
        }

        /* メッセージ削除 */
        if ($this->delete_query()){
            header('Location: '.HTTP_ACTION.'admin/inquire/list/'.$this->status.'/deleted/');
            exit();
        }
        $this->set_result();
    }

    /**
     * アクション結果の設定
     *
     * @access private
     * @return void
     */
    function set_result()
    {
        if (preg_match('/complete/i',$_SERVER['REQUEST_URI'])){
            $this->Assign('complete', true);
        }
        if (preg_match('/updated/i',$_SERVER['REQUEST_URI'])){
            $this->Assign('updated', true);
        }
        if (preg_match('/deleted/i',$_SERVER['REQUEST_URI'])){
            $this->Assign('deleted', true);
        }
    }

    /**
     * カテゴリの設定
     *
     * @access private
     * @return void
     */
    function set_category()
    {
        $sql=
            'SELECT '.
                'id,'.
                'category '.
            'FROM '.
                DB_PREFIX.'inq_category '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['category'];
        }
        
        $this->Assign('categorys',$list);
    }

    /**
     * 問合せ日リストの設定
     *
     * @access private
     * @return void
     */
    function set_regist_date()
    {
        $date_format = sql_query::dateFormat('regist_date','%Y%m');
        $label_format = sql_query::dateFormat('regist_date','%Y-%m-01');
        $sql=
            'SELECT '.
                $date_format.' value,'.
                $label_format.' label '.
            'FROM '.
                DB_PREFIX.'inq_inquire '.
            'GROUP BY '.
                'value';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }

        $list = array();
        foreach ($result as $value){
            $list[$value['value']] = $value['label'];
        }
        
        $this->Assign('regist_dates',$list);
    }

    /**
     * 問合せリストの設定
     *
     * @access private
     * @return void
     **/
    function set_list()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_ROWS);    // クラスの生成
        $where = $this->add_where();
        $sql = 
            'SELECT '.
                '* '.
            'FROM '.
                DB_PREFIX.'inq_inquire '.
            'WHERE '.
                'status = '.$this->status.' '.
                $where.
            'ORDER BY '.
                'regist_date';
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();
        $this->Assign('list', $result);
    }

    /**
     * リストの絞込み
     *
     * @access private
     * @return string   絞込み句
     **/
    function add_where()
    {
        /* 絞込条件の取得 */
        $validates = array(
            /* 問合せ日 */
            'regist_date'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
            /* 問合せの状態 */
            'status'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
        );
        $conditions = $this->catchCondition($validates);

        // 絞込み条件の初期化
        $where = array();
        /* 問合せ日時 */
        if (!empty($conditions['regist_date'])){
            $date_format = sql_query::dateFormat('regist_date','%Y%m');
            $where[] = $date_format."='".$conditions['regist_date']."'";
        }

        /* 問合せの状態 */
        if (!empty($conditions['status'])){
            $where[] = 'status='.$conditions['status'];
        }
        
        if (!count($where)){
            return '';
        }

        return 'AND '. implode(' AND ',$where) .' ';
    }


    /**
     * メッセージボックスの移動
     *
     * @access private
     * @return integer  データ操作結果
     */
    function update_query()
    {
        if (empty($_POST['manip'])){
            return false;
        }
        if (empty($_POST['msgs'])){
            return false;
        }

        $statuses = array(
            STATAS_INQUIRE_NEW,
            STATAS_INQUIRE_PENDING,
            STATAS_INQUIRE_RESPONDED,
            STATAS_INQUIRE_TRASH,
        );
        $this->status = empty($_POST['status'])?STATAS_INQUIRE_TRASH:$_POST['status'];        
        $this->status = in_array($this->status,$statuses)?$this->status:STATAS_INQUIRE_TRASH;
        
        foreach ($_POST['msgs'] as $values){
            $this->update_inquire($values['id'], $this->status);
        }
        return true;
    }

    /**
     * メッセージの更新
     *
     * @access private
     * @param integer $id
     * @param string $status
     * @return integer  データ操作結果
     */
    function update_inquire($id, $status)
    {
        $sql =
            'UPDATE '.
                DB_PREFIX.'inq_inquire '.
            ' SET '.
                'status='.$status.' '.
            ' WHERE '.
                'id = '.$this->objdb->quote($id);
        $this->objdb->exec($sql);
    }

    /**
     * メッセージの削除
     *
     * @access private
     * @return integer  データ操作結果
     */
    function delete_query()
    {
        if (empty($_POST['delete'])){
            return false;
        }
        if (empty($_POST['msgs'])){
            return false;
        }
        
        foreach ($_POST['msgs'] as $values){
            $id = $this->objdb->quote($values['id']);
            $sql =
                'DELETE FROM '.
                    DB_PREFIX.'inq_response '.
                'WHERE '.
                    'ref_inquire ='.$id;
            $this->objdb->exec($sql);

            $sql =
                'DELETE FROM '.
                    DB_PREFIX.'inq_inquire '.
                'WHERE '.
                    'id ='.$id;
            $this->objdb->exec($sql);
        }
        return true;
    }
} // webapp
?>
