<?php
/* ========================================================================
 - [modules/admin/profile/enquetes.php]
 -      プロフィール項目一覧
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/29] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once WEBAPP_LIB_DIR.'wap_admin.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_admin
{
    /**
     * カバーID
     * @var integer
     */
    var $id = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN));

        $this->setTemplateFile('admin/profile/enquetes.tpl');

        if ( preg_match('/complete/i',$_SERVER['REQUEST_URI'])){
            $this->Assign('complete', true);
        }

        // 一括更新
        if ($this->do_querys()){
            header('Location: '.HTTP_ACTION.'admin/profile/enquetes/complete/');
            exit();
        }

        $this->set_list();

        /* 必須項目 */
        $this->Assign('requireds',array('任意','必須'));

        /* 公開設定 */
        $visibilitys = array( 
            '1'=> '常に公開',
            '2'=> 'ユーザー選択',
        );
        $this->Assign('visibilitys',$visibilitys);

        /* フォームタイプ */
        $form_types = array(
            FORM_TYPE_TEXT=>     'テキスト',
            FORM_TYPE_TEXTAREA=> 'テキストエリア',
            FORM_TYPE_SELECT=>   '選択リスト',
            FORM_TYPE_CHECKBOX=> 'チェックボックス',
            FORM_TYPE_RADIO=>    'ラジオボタン',
            FORM_TYPE_DATE=>     '日付リスト',
        );
        $this->Assign('form_types',$form_types);
    }

    /**
     * アンケート項目の設定
     *
     * @access private
     * @return void
     **/
    function set_list()
    {
        $sql = 
            'SELECT '.
                'id,'.
                'required,'.
                'form_type,'.
                'visibility,'.
                'sort,'.
                'enquete '.
            'FROM '.
                DB_PREFIX.'act_enquete '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $this->Assign('list', $result);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @param array $values
     * @return integer  データ操作結果
     */
    function do_querys()
    {
        if (empty($_POST['manips'])){
            return false;
        }
        foreach ($_POST['edits'] as $values){
            $this->update_query($values);
        }
        return true;
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @param array $values
     * @return integer  データ操作結果
     */
    function update_query($values)
    {
        $id   = RKT_validate::number($values['id'])?$values['id']:0;
        $sort = RKT_validate::number($values['sort'])?$values['sort']:0;
        $id   = $this->objdb->quote($id);
        $sort = $this->objdb->quote($sort);

        $sql =
            'UPDATE '.
                DB_PREFIX.'act_enquete '.
            'SET '.
                'sort = '.$sort.' '.
            'WHERE '.
                'id = '.$id;
        return $this->objdb->query($sql);
    }

} // webapp
?>
