-- ========================================================================
-- [sqls/insert.sql]
-- 		テーブルデータ挿入
--      Copyright (c) 2006 Yujiro Takahashi
-- ライセンス:
--      This program is free software; you can redistribute it and/or
--      modify it under the terms of the GNU General Public License
--      as published by the Free Software Foundation; either version 2
--      of the License, or (at your option) any later version.
--
--      This program is distributed in the hope that it will be useful,
--      but WITHOUT ANY WARRANTY; without even the implied warranty of
--      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--      GNU General Public License for more details.
--
--      You should have received a copy of the GNU General Public License
--      along with this program; if not, write to the Free Software
--      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
-- 問い合わせ先：
--      yujiro@rakuto.net
--      http://rakuto.net/rktSNS/
-- 更新履歴：
--      [2007/05/27] デフォルトユーザーの削除
--      [2007/01/08] sns_act_accountのインサート文を修正
--      [2006/09/17] 印刷用フォントの変更
--      [2006/09/11] 印刷用テーブルの追加
--      [2006/07/10] 作成
-- ========================================================================

BEGIN TRANSACTION;

-- 
-- 管理者の作成
-- 
INSERT INTO sns_act_account VALUES('1','2006-08-04 12:13:01','2006-08-21 15:17:48','2006-07-22 21:49:14','1','1','c31edc5fe15a0c24e6dad5fc071dcc6c','HCpvg5XntvxYv/w6XWQ2iQ==','0505da36b6137f9e590bde6de97766e0',null,null,null,null,null,0,null,null);
INSERT INTO sns_act_profile VALUES('1','1','2006-08-21 18:26:49','f65zE1w5xFs=','5v8gklyJXuvWF8c9M05AgA==','2','管理者','2','11','536','2','2','2','4','2','2006-07-10','2','4','2','2','11','536','2','管理者');
INSERT INTO sns_dia_diary VALUES (1,'2006-08-21 18:26:49',1,3,null,null,null);

-- 
-- 血液型
-- 
INSERT INTO sns_act_blood VALUES (1, 1, 'A型');
INSERT INTO sns_act_blood VALUES (2, 2, 'B型');
INSERT INTO sns_act_blood VALUES (3, 3, 'AB型');
INSERT INTO sns_act_blood VALUES (4, 4, 'O型');
INSERT INTO sns_act_blood VALUES (5, 5, '不明');

-- 
-- 既婚・独身
-- 
INSERT INTO sns_act_married VALUES (1, 1, '無回答');
INSERT INTO sns_act_married VALUES (2, 2, '独身');
INSERT INTO sns_act_married VALUES (3, 3, '既婚');
INSERT INTO sns_act_married VALUES (4, 4, '交際関係');
INSERT INTO sns_act_married VALUES (5, 5, '独身・恋人を探していない');
INSERT INTO sns_act_married VALUES (6, 6, '独身・恋人を探している');
INSERT INTO sns_act_married VALUES (7, 7, '既婚・恋人を探している');
INSERT INTO sns_act_married VALUES (8, 8, '別居');
INSERT INTO sns_act_married VALUES (9, 9, '離婚');
INSERT INTO sns_act_married VALUES (10, 10, 'その他');

-- 
-- 性別
-- 
INSERT INTO sns_act_sex VALUES (1, 1, '男性');
INSERT INTO sns_act_sex VALUES (2, 2, '女性');
INSERT INTO sns_act_sex VALUES (3, 3, '未記入');

-- 
-- 地区
-- 
INSERT INTO sns_ara_area VALUES (1, 1, '北海道・東北');
INSERT INTO sns_ara_area VALUES (2, 2, '関東・信越');
INSERT INTO sns_ara_area VALUES (3, 3, '北陸・東海');
INSERT INTO sns_ara_area VALUES (4, 4, '近畿');
INSERT INTO sns_ara_area VALUES (5, 5, '中国・四国');
INSERT INTO sns_ara_area VALUES (6, 6, '九州・沖縄');
INSERT INTO sns_ara_area VALUES (7, 7, 'その他');

-- 
-- 市区町村
-- 
INSERT INTO sns_ara_local VALUES (1,1,1,'札幌市中央区');
INSERT INTO sns_ara_local VALUES (2,1,2,'札幌市北区');
INSERT INTO sns_ara_local VALUES (3,1,3,'札幌市東区');
INSERT INTO sns_ara_local VALUES (4,1,4,'札幌市白石区');
INSERT INTO sns_ara_local VALUES (5,1,5,'札幌市豊平区');
INSERT INTO sns_ara_local VALUES (6,1,6,'札幌市南区');
INSERT INTO sns_ara_local VALUES (7,1,7,'札幌市西区');
INSERT INTO sns_ara_local VALUES (8,1,8,'札幌市厚別区');
INSERT INTO sns_ara_local VALUES (9,1,9,'札幌市手稲区');
INSERT INTO sns_ara_local VALUES (10,1,10,'札幌市清田区');
INSERT INTO sns_ara_local VALUES (11,1,11,'函館市');
INSERT INTO sns_ara_local VALUES (12,1,12,'小樽市');
INSERT INTO sns_ara_local VALUES (13,1,13,'旭川市');
INSERT INTO sns_ara_local VALUES (14,1,14,'釧路市');
INSERT INTO sns_ara_local VALUES (15,1,15,'帯広市');
INSERT INTO sns_ara_local VALUES (16,1,16,'北見市');
INSERT INTO sns_ara_local VALUES (17,1,17,'夕張市');
INSERT INTO sns_ara_local VALUES (18,1,18,'岩見沢市');
INSERT INTO sns_ara_local VALUES (19,1,19,'留萌市');
INSERT INTO sns_ara_local VALUES (20,1,20,'苫小牧市');
INSERT INTO sns_ara_local VALUES (21,1,21,'稚内市');
INSERT INTO sns_ara_local VALUES (22,1,22,'美唄市');
INSERT INTO sns_ara_local VALUES (23,1,23,'芦別市');
INSERT INTO sns_ara_local VALUES (24,1,24,'江別市');
INSERT INTO sns_ara_local VALUES (25,1,25,'赤平市');
INSERT INTO sns_ara_local VALUES (26,1,26,'紋別市');
INSERT INTO sns_ara_local VALUES (27,1,27,'士別市');
INSERT INTO sns_ara_local VALUES (28,1,28,'名寄市');
INSERT INTO sns_ara_local VALUES (29,1,29,'三笠市');
INSERT INTO sns_ara_local VALUES (30,1,30,'根室市');
INSERT INTO sns_ara_local VALUES (31,1,31,'千歳市');
INSERT INTO sns_ara_local VALUES (32,1,32,'滝川市');
INSERT INTO sns_ara_local VALUES (33,1,33,'砂川市');
INSERT INTO sns_ara_local VALUES (34,1,34,'歌志内市');
INSERT INTO sns_ara_local VALUES (35,1,35,'深川市');
INSERT INTO sns_ara_local VALUES (36,1,36,'富良野市');
INSERT INTO sns_ara_local VALUES (37,1,37,'登別市');
INSERT INTO sns_ara_local VALUES (38,1,38,'恵庭市');
INSERT INTO sns_ara_local VALUES (39,1,39,'伊達市');
INSERT INTO sns_ara_local VALUES (40,1,40,'北広島市');
INSERT INTO sns_ara_local VALUES (41,1,41,'石狩市');
INSERT INTO sns_ara_local VALUES (42,1,42,'北斗市');
INSERT INTO sns_ara_local VALUES (43,1,43,'石狩郡当別町');
INSERT INTO sns_ara_local VALUES (44,1,44,'石狩郡新篠津村');
INSERT INTO sns_ara_local VALUES (45,1,45,'松前郡松前町');
INSERT INTO sns_ara_local VALUES (46,1,46,'松前郡福島町');
INSERT INTO sns_ara_local VALUES (47,1,47,'上磯郡知内町');
INSERT INTO sns_ara_local VALUES (48,1,48,'上磯郡木古内町');
INSERT INTO sns_ara_local VALUES (49,1,49,'亀田郡七飯町');
INSERT INTO sns_ara_local VALUES (50,1,50,'茅部郡鹿部町');
INSERT INTO sns_ara_local VALUES (51,1,51,'茅部郡森町');
INSERT INTO sns_ara_local VALUES (52,1,52,'二海郡八雲町');
INSERT INTO sns_ara_local VALUES (53,1,53,'山越郡長万部町');
INSERT INTO sns_ara_local VALUES (54,1,54,'檜山郡江差町');
INSERT INTO sns_ara_local VALUES (55,1,55,'檜山郡上ノ国町');
INSERT INTO sns_ara_local VALUES (56,1,56,'檜山郡厚沢部町');
INSERT INTO sns_ara_local VALUES (57,1,57,'爾志郡乙部町');
INSERT INTO sns_ara_local VALUES (58,1,58,'奥尻郡奥尻町');
INSERT INTO sns_ara_local VALUES (59,1,59,'瀬棚郡今金町');
INSERT INTO sns_ara_local VALUES (60,1,60,'久遠郡せたな町');
INSERT INTO sns_ara_local VALUES (61,1,61,'島牧郡島牧村');
INSERT INTO sns_ara_local VALUES (62,1,62,'寿都郡寿都町');
INSERT INTO sns_ara_local VALUES (63,1,63,'寿都郡黒松内町');
INSERT INTO sns_ara_local VALUES (64,1,64,'磯谷郡蘭越町');
INSERT INTO sns_ara_local VALUES (65,1,65,'虻田郡ニセコ町');
INSERT INTO sns_ara_local VALUES (66,1,66,'虻田郡真狩村');
INSERT INTO sns_ara_local VALUES (67,1,67,'虻田郡留寿都村');
INSERT INTO sns_ara_local VALUES (68,1,68,'虻田郡喜茂別町');
INSERT INTO sns_ara_local VALUES (69,1,69,'虻田郡京極町');
INSERT INTO sns_ara_local VALUES (70,1,70,'虻田郡倶知安町');
INSERT INTO sns_ara_local VALUES (71,1,71,'岩内郡共和町');
INSERT INTO sns_ara_local VALUES (72,1,72,'岩内郡岩内町');
INSERT INTO sns_ara_local VALUES (73,1,73,'古宇郡泊村');
INSERT INTO sns_ara_local VALUES (74,1,74,'古宇郡神恵内村');
INSERT INTO sns_ara_local VALUES (75,1,75,'積丹郡積丹町');
INSERT INTO sns_ara_local VALUES (76,1,76,'古平郡古平町');
INSERT INTO sns_ara_local VALUES (77,1,77,'余市郡仁木町');
INSERT INTO sns_ara_local VALUES (78,1,78,'余市郡余市町');
INSERT INTO sns_ara_local VALUES (79,1,79,'余市郡赤井川村');
INSERT INTO sns_ara_local VALUES (80,1,80,'空知郡南幌町');
INSERT INTO sns_ara_local VALUES (81,1,81,'空知郡奈井江町');
INSERT INTO sns_ara_local VALUES (82,1,82,'空知郡上砂川町');
INSERT INTO sns_ara_local VALUES (83,1,83,'夕張郡由仁町');
INSERT INTO sns_ara_local VALUES (84,1,84,'夕張郡長沼町');
INSERT INTO sns_ara_local VALUES (85,1,85,'夕張郡栗山町');
INSERT INTO sns_ara_local VALUES (86,1,86,'樺戸郡月形町');
INSERT INTO sns_ara_local VALUES (87,1,87,'樺戸郡浦臼町');
INSERT INTO sns_ara_local VALUES (88,1,88,'樺戸郡新十津川町');
INSERT INTO sns_ara_local VALUES (89,1,89,'雨竜郡妹背牛町');
INSERT INTO sns_ara_local VALUES (90,1,90,'雨竜郡秩父別町');
INSERT INTO sns_ara_local VALUES (91,1,91,'雨竜郡雨竜町');
INSERT INTO sns_ara_local VALUES (92,1,92,'雨竜郡北竜町');
INSERT INTO sns_ara_local VALUES (93,1,93,'雨竜郡沼田町');
INSERT INTO sns_ara_local VALUES (94,1,94,'雨竜郡幌加内町');
INSERT INTO sns_ara_local VALUES (95,1,95,'上川郡鷹栖町');
INSERT INTO sns_ara_local VALUES (96,1,96,'上川郡東神楽町');
INSERT INTO sns_ara_local VALUES (97,1,97,'上川郡当麻町');
INSERT INTO sns_ara_local VALUES (98,1,98,'上川郡比布町');
INSERT INTO sns_ara_local VALUES (99,1,99,'上川郡愛別町');
INSERT INTO sns_ara_local VALUES (100,1,100,'上川郡上川町');
INSERT INTO sns_ara_local VALUES (101,1,101,'上川郡東川町');
INSERT INTO sns_ara_local VALUES (102,1,102,'上川郡美瑛町');
INSERT INTO sns_ara_local VALUES (103,1,103,'空知郡上富良野町');
INSERT INTO sns_ara_local VALUES (104,1,104,'空知郡中富良野町');
INSERT INTO sns_ara_local VALUES (105,1,105,'空知郡南富良野町');
INSERT INTO sns_ara_local VALUES (106,1,106,'勇払郡占冠村');
INSERT INTO sns_ara_local VALUES (107,1,107,'上川郡和寒町');
INSERT INTO sns_ara_local VALUES (108,1,108,'上川郡剣淵町');
INSERT INTO sns_ara_local VALUES (109,1,109,'上川郡下川町');
INSERT INTO sns_ara_local VALUES (110,1,110,'中川郡美深町');
INSERT INTO sns_ara_local VALUES (111,1,111,'中川郡音威子府村');
INSERT INTO sns_ara_local VALUES (112,1,112,'中川郡中川町');
INSERT INTO sns_ara_local VALUES (113,1,113,'増毛郡増毛町');
INSERT INTO sns_ara_local VALUES (114,1,114,'留萌郡小平町');
INSERT INTO sns_ara_local VALUES (115,1,115,'苫前郡苫前町');
INSERT INTO sns_ara_local VALUES (116,1,116,'苫前郡羽幌町');
INSERT INTO sns_ara_local VALUES (117,1,117,'苫前郡初山別村');
INSERT INTO sns_ara_local VALUES (118,1,118,'天塩郡遠別町');
INSERT INTO sns_ara_local VALUES (119,1,119,'天塩郡天塩町');
INSERT INTO sns_ara_local VALUES (120,1,120,'天塩郡幌延町');
INSERT INTO sns_ara_local VALUES (121,1,121,'宗谷郡猿払村');
INSERT INTO sns_ara_local VALUES (122,1,122,'枝幸郡浜頓別町');
INSERT INTO sns_ara_local VALUES (123,1,123,'枝幸郡中頓別町');
INSERT INTO sns_ara_local VALUES (124,1,124,'枝幸郡枝幸町');
INSERT INTO sns_ara_local VALUES (125,1,125,'天塩郡豊富町');
INSERT INTO sns_ara_local VALUES (126,1,126,'礼文郡礼文町');
INSERT INTO sns_ara_local VALUES (127,1,127,'利尻郡利尻町');
INSERT INTO sns_ara_local VALUES (128,1,128,'利尻郡利尻富士町');
INSERT INTO sns_ara_local VALUES (129,1,129,'網走郡美幌町');
INSERT INTO sns_ara_local VALUES (130,1,130,'網走郡津別町');
INSERT INTO sns_ara_local VALUES (131,1,131,'斜里郡斜里町');
INSERT INTO sns_ara_local VALUES (132,1,132,'斜里郡清里町');
INSERT INTO sns_ara_local VALUES (133,1,133,'斜里郡小清水町');
INSERT INTO sns_ara_local VALUES (134,1,134,'常呂郡訓子府町');
INSERT INTO sns_ara_local VALUES (135,1,135,'常呂郡置戸町');
INSERT INTO sns_ara_local VALUES (136,1,136,'常呂郡佐呂間町');
INSERT INTO sns_ara_local VALUES (137,1,137,'紋別郡遠軽町');
INSERT INTO sns_ara_local VALUES (138,1,138,'紋別郡上湧別町');
INSERT INTO sns_ara_local VALUES (139,1,139,'紋別郡湧別町');
INSERT INTO sns_ara_local VALUES (140,1,140,'紋別郡滝上町');
INSERT INTO sns_ara_local VALUES (141,1,141,'紋別郡興部町');
INSERT INTO sns_ara_local VALUES (142,1,142,'紋別郡西興部村');
INSERT INTO sns_ara_local VALUES (143,1,143,'紋別郡雄武町');
INSERT INTO sns_ara_local VALUES (144,1,144,'網走郡大空町');
INSERT INTO sns_ara_local VALUES (145,1,145,'虻田郡豊浦町');
INSERT INTO sns_ara_local VALUES (146,1,146,'有珠郡壮瞥町');
INSERT INTO sns_ara_local VALUES (147,1,147,'白老郡白老町');
INSERT INTO sns_ara_local VALUES (148,1,148,'勇払郡厚真町');
INSERT INTO sns_ara_local VALUES (149,1,149,'虻田郡洞爺湖町');
INSERT INTO sns_ara_local VALUES (150,1,150,'勇払郡安平町');
INSERT INTO sns_ara_local VALUES (151,1,151,'勇払郡むかわ町');
INSERT INTO sns_ara_local VALUES (152,1,152,'沙流郡日高町');
INSERT INTO sns_ara_local VALUES (153,1,153,'沙流郡平取町');
INSERT INTO sns_ara_local VALUES (154,1,154,'新冠郡新冠町');
INSERT INTO sns_ara_local VALUES (155,1,155,'浦河郡浦河町');
INSERT INTO sns_ara_local VALUES (156,1,156,'様似郡様似町');
INSERT INTO sns_ara_local VALUES (157,1,157,'幌泉郡えりも町');
INSERT INTO sns_ara_local VALUES (158,1,158,'日高郡新ひだか町');
INSERT INTO sns_ara_local VALUES (159,1,159,'河東郡音更町');
INSERT INTO sns_ara_local VALUES (160,1,160,'河東郡士幌町');
INSERT INTO sns_ara_local VALUES (161,1,161,'河東郡上士幌町');
INSERT INTO sns_ara_local VALUES (162,1,162,'河東郡鹿追町');
INSERT INTO sns_ara_local VALUES (163,1,163,'上川郡新得町');
INSERT INTO sns_ara_local VALUES (164,1,164,'上川郡清水町');
INSERT INTO sns_ara_local VALUES (165,1,165,'河西郡芽室町');
INSERT INTO sns_ara_local VALUES (166,1,166,'河西郡中札内村');
INSERT INTO sns_ara_local VALUES (167,1,167,'河西郡更別村');
INSERT INTO sns_ara_local VALUES (168,1,168,'広尾郡大樹町');
INSERT INTO sns_ara_local VALUES (169,1,169,'広尾郡広尾町');
INSERT INTO sns_ara_local VALUES (170,1,170,'中川郡幕別町');
INSERT INTO sns_ara_local VALUES (171,1,171,'中川郡池田町');
INSERT INTO sns_ara_local VALUES (172,1,172,'中川郡豊頃町');
INSERT INTO sns_ara_local VALUES (173,1,173,'中川郡本別町');
INSERT INTO sns_ara_local VALUES (174,1,174,'足寄郡足寄町');
INSERT INTO sns_ara_local VALUES (175,1,175,'足寄郡陸別町');
INSERT INTO sns_ara_local VALUES (176,1,176,'釧路郡釧路町');
INSERT INTO sns_ara_local VALUES (177,1,177,'厚岸郡厚岸町');
INSERT INTO sns_ara_local VALUES (178,1,178,'厚岸郡浜中町');
INSERT INTO sns_ara_local VALUES (179,1,179,'川上郡標茶町');
INSERT INTO sns_ara_local VALUES (180,1,180,'川上郡弟子屈町');
INSERT INTO sns_ara_local VALUES (181,1,181,'阿寒郡鶴居村');
INSERT INTO sns_ara_local VALUES (182,1,182,'白糠郡白糠町');
INSERT INTO sns_ara_local VALUES (183,1,183,'野付郡別海町');
INSERT INTO sns_ara_local VALUES (184,1,184,'標津郡中標津町');
INSERT INTO sns_ara_local VALUES (185,1,185,'標津郡標津町');
INSERT INTO sns_ara_local VALUES (186,1,186,'目梨郡羅臼町');
INSERT INTO sns_ara_local VALUES (187,2,1,'青森市');
INSERT INTO sns_ara_local VALUES (188,2,2,'弘前市');
INSERT INTO sns_ara_local VALUES (189,2,3,'八戸市');
INSERT INTO sns_ara_local VALUES (190,2,4,'黒石市');
INSERT INTO sns_ara_local VALUES (191,2,5,'五所川原市');
INSERT INTO sns_ara_local VALUES (192,2,6,'三沢市');
INSERT INTO sns_ara_local VALUES (193,2,7,'むつ市');
INSERT INTO sns_ara_local VALUES (194,2,8,'つがる市');
INSERT INTO sns_ara_local VALUES (195,2,9,'平川市');
INSERT INTO sns_ara_local VALUES (196,2,10,'東津軽郡平内町');
INSERT INTO sns_ara_local VALUES (197,2,11,'東津軽郡今別町');
INSERT INTO sns_ara_local VALUES (198,2,12,'東津軽郡蓬田村');
INSERT INTO sns_ara_local VALUES (199,2,13,'東津軽郡外ヶ浜町');
INSERT INTO sns_ara_local VALUES (200,2,14,'西津軽郡鰺ケ沢町');
INSERT INTO sns_ara_local VALUES (201,2,15,'西津軽郡深浦町');
INSERT INTO sns_ara_local VALUES (202,2,16,'中津軽郡西目屋村');
INSERT INTO sns_ara_local VALUES (203,2,17,'南津軽郡藤崎町');
INSERT INTO sns_ara_local VALUES (204,2,18,'南津軽郡大鰐町');
INSERT INTO sns_ara_local VALUES (205,2,19,'南津軽郡田舎館村');
INSERT INTO sns_ara_local VALUES (206,2,20,'北津軽郡板柳町');
INSERT INTO sns_ara_local VALUES (207,2,21,'北津軽郡鶴田町');
INSERT INTO sns_ara_local VALUES (208,2,22,'北津軽郡中泊町');
INSERT INTO sns_ara_local VALUES (209,2,23,'上北郡野辺地町');
INSERT INTO sns_ara_local VALUES (210,2,24,'上北郡七戸町');
INSERT INTO sns_ara_local VALUES (211,2,25,'上北郡六戸町');
INSERT INTO sns_ara_local VALUES (212,2,26,'上北郡横浜町');
INSERT INTO sns_ara_local VALUES (213,2,27,'上北郡東北町');
INSERT INTO sns_ara_local VALUES (214,2,28,'上北郡六ケ所村');
INSERT INTO sns_ara_local VALUES (215,2,29,'上北郡おいらせ町');
INSERT INTO sns_ara_local VALUES (216,2,30,'下北郡大間町');
INSERT INTO sns_ara_local VALUES (217,2,31,'下北郡東通村');
INSERT INTO sns_ara_local VALUES (218,2,32,'下北郡風間浦村');
INSERT INTO sns_ara_local VALUES (219,2,33,'下北郡佐井村');
INSERT INTO sns_ara_local VALUES (220,2,34,'三戸郡三戸町');
INSERT INTO sns_ara_local VALUES (221,2,35,'三戸郡五戸町');
INSERT INTO sns_ara_local VALUES (222,2,36,'三戸郡田子町');
INSERT INTO sns_ara_local VALUES (223,2,37,'三戸郡南部町');
INSERT INTO sns_ara_local VALUES (224,2,38,'三戸郡階上町');
INSERT INTO sns_ara_local VALUES (225,2,39,'三戸郡新郷村');
INSERT INTO sns_ara_local VALUES (226,3,1,'盛岡市');
INSERT INTO sns_ara_local VALUES (227,3,2,'宮古市');
INSERT INTO sns_ara_local VALUES (228,3,3,'大船渡市');
INSERT INTO sns_ara_local VALUES (229,3,4,'花巻市');
INSERT INTO sns_ara_local VALUES (230,3,5,'北上市');
INSERT INTO sns_ara_local VALUES (231,3,6,'久慈市');
INSERT INTO sns_ara_local VALUES (232,3,7,'遠野市');
INSERT INTO sns_ara_local VALUES (233,3,8,'一関市');
INSERT INTO sns_ara_local VALUES (234,3,9,'陸前高田市');
INSERT INTO sns_ara_local VALUES (235,3,10,'釜石市');
INSERT INTO sns_ara_local VALUES (236,3,11,'二戸市');
INSERT INTO sns_ara_local VALUES (237,3,12,'八幡平市');
INSERT INTO sns_ara_local VALUES (238,3,13,'奥州市');
INSERT INTO sns_ara_local VALUES (239,3,14,'岩手郡雫石町');
INSERT INTO sns_ara_local VALUES (240,3,15,'岩手郡葛巻町');
INSERT INTO sns_ara_local VALUES (241,3,16,'岩手郡岩手町');
INSERT INTO sns_ara_local VALUES (242,3,17,'岩手郡滝沢村');
INSERT INTO sns_ara_local VALUES (243,3,18,'紫波郡紫波町');
INSERT INTO sns_ara_local VALUES (244,3,19,'紫波郡矢巾町');
INSERT INTO sns_ara_local VALUES (245,3,20,'和賀郡西和賀町');
INSERT INTO sns_ara_local VALUES (246,3,21,'胆沢郡金ケ崎町');
INSERT INTO sns_ara_local VALUES (247,3,22,'西磐井郡平泉町');
INSERT INTO sns_ara_local VALUES (248,3,23,'東磐井郡藤沢町');
INSERT INTO sns_ara_local VALUES (249,3,24,'気仙郡住田町');
INSERT INTO sns_ara_local VALUES (250,3,25,'上閉伊郡大槌町');
INSERT INTO sns_ara_local VALUES (251,3,26,'下閉伊郡山田町');
INSERT INTO sns_ara_local VALUES (252,3,27,'下閉伊郡岩泉町');
INSERT INTO sns_ara_local VALUES (253,3,28,'下閉伊郡田野畑村');
INSERT INTO sns_ara_local VALUES (254,3,29,'下閉伊郡普代村');
INSERT INTO sns_ara_local VALUES (255,3,30,'下閉伊郡川井村');
INSERT INTO sns_ara_local VALUES (256,3,31,'九戸郡軽米町');
INSERT INTO sns_ara_local VALUES (257,3,32,'九戸郡野田村');
INSERT INTO sns_ara_local VALUES (258,3,33,'九戸郡九戸村');
INSERT INTO sns_ara_local VALUES (259,3,34,'九戸郡洋野町');
INSERT INTO sns_ara_local VALUES (260,3,35,'二戸郡一戸町');
INSERT INTO sns_ara_local VALUES (261,4,1,'仙台市青葉区');
INSERT INTO sns_ara_local VALUES (262,4,2,'仙台市宮城野区');
INSERT INTO sns_ara_local VALUES (263,4,3,'仙台市若林区');
INSERT INTO sns_ara_local VALUES (264,4,4,'仙台市太白区');
INSERT INTO sns_ara_local VALUES (265,4,5,'仙台市泉区');
INSERT INTO sns_ara_local VALUES (266,4,6,'石巻市');
INSERT INTO sns_ara_local VALUES (267,4,7,'塩竈市');
INSERT INTO sns_ara_local VALUES (268,4,8,'気仙沼市');
INSERT INTO sns_ara_local VALUES (269,4,9,'白石市');
INSERT INTO sns_ara_local VALUES (270,4,10,'名取市');
INSERT INTO sns_ara_local VALUES (271,4,11,'角田市');
INSERT INTO sns_ara_local VALUES (272,4,12,'多賀城市');
INSERT INTO sns_ara_local VALUES (273,4,13,'岩沼市');
INSERT INTO sns_ara_local VALUES (274,4,14,'登米市');
INSERT INTO sns_ara_local VALUES (275,4,15,'栗原市');
INSERT INTO sns_ara_local VALUES (276,4,16,'東松島市');
INSERT INTO sns_ara_local VALUES (277,4,17,'大崎市');
INSERT INTO sns_ara_local VALUES (278,4,18,'刈田郡蔵王町');
INSERT INTO sns_ara_local VALUES (279,4,19,'刈田郡七ケ宿町');
INSERT INTO sns_ara_local VALUES (280,4,20,'柴田郡大河原町');
INSERT INTO sns_ara_local VALUES (281,4,21,'柴田郡村田町');
INSERT INTO sns_ara_local VALUES (282,4,22,'柴田郡柴田町');
INSERT INTO sns_ara_local VALUES (283,4,23,'柴田郡川崎町');
INSERT INTO sns_ara_local VALUES (284,4,24,'伊具郡丸森町');
INSERT INTO sns_ara_local VALUES (285,4,25,'亘理郡亘理町');
INSERT INTO sns_ara_local VALUES (286,4,26,'亘理郡山元町');
INSERT INTO sns_ara_local VALUES (287,4,27,'宮城郡松島町');
INSERT INTO sns_ara_local VALUES (288,4,28,'宮城郡七ヶ浜町');
INSERT INTO sns_ara_local VALUES (289,4,29,'宮城郡利府町');
INSERT INTO sns_ara_local VALUES (290,4,30,'黒川郡大和町');
INSERT INTO sns_ara_local VALUES (291,4,31,'黒川郡大郷町');
INSERT INTO sns_ara_local VALUES (292,4,32,'黒川郡富谷町');
INSERT INTO sns_ara_local VALUES (293,4,33,'黒川郡大衡村');
INSERT INTO sns_ara_local VALUES (294,4,34,'加美郡色麻町');
INSERT INTO sns_ara_local VALUES (295,4,35,'加美郡加美町');
INSERT INTO sns_ara_local VALUES (296,4,36,'遠田郡涌谷町');
INSERT INTO sns_ara_local VALUES (297,4,37,'遠田郡美里町');
INSERT INTO sns_ara_local VALUES (298,4,38,'牡鹿郡女川町');
INSERT INTO sns_ara_local VALUES (299,4,39,'本吉郡本吉町');
INSERT INTO sns_ara_local VALUES (300,4,40,'本吉郡南三陸町');
INSERT INTO sns_ara_local VALUES (301,5,1,'秋田市');
INSERT INTO sns_ara_local VALUES (302,5,2,'横手市');
INSERT INTO sns_ara_local VALUES (303,5,3,'大館市');
INSERT INTO sns_ara_local VALUES (304,5,4,'男鹿市');
INSERT INTO sns_ara_local VALUES (305,5,5,'湯沢市');
INSERT INTO sns_ara_local VALUES (306,5,6,'鹿角市');
INSERT INTO sns_ara_local VALUES (307,5,7,'由利本荘市');
INSERT INTO sns_ara_local VALUES (308,5,8,'潟上市');
INSERT INTO sns_ara_local VALUES (309,5,9,'大仙市');
INSERT INTO sns_ara_local VALUES (310,5,10,'北秋田市');
INSERT INTO sns_ara_local VALUES (311,5,11,'にかほ市');
INSERT INTO sns_ara_local VALUES (312,5,12,'仙北市');
INSERT INTO sns_ara_local VALUES (313,5,13,'鹿角郡小坂町');
INSERT INTO sns_ara_local VALUES (314,5,14,'山本郡藤里町');
INSERT INTO sns_ara_local VALUES (315,5,15,'山本郡三種町');
INSERT INTO sns_ara_local VALUES (316,5,16,'山本郡八峰町');
INSERT INTO sns_ara_local VALUES (317,5,17,'南秋田郡五城目町');
INSERT INTO sns_ara_local VALUES (318,5,18,'南秋田郡八郎潟町');
INSERT INTO sns_ara_local VALUES (319,5,19,'南秋田郡井川町');
INSERT INTO sns_ara_local VALUES (320,5,20,'南秋田郡大潟村');
INSERT INTO sns_ara_local VALUES (321,5,21,'仙北郡美郷町');
INSERT INTO sns_ara_local VALUES (322,5,22,'雄勝郡羽後町');
INSERT INTO sns_ara_local VALUES (323,5,23,'雄勝郡東成瀬村');
INSERT INTO sns_ara_local VALUES (324,6,1,'山形市');
INSERT INTO sns_ara_local VALUES (325,6,2,'米沢市');
INSERT INTO sns_ara_local VALUES (326,6,3,'鶴岡市');
INSERT INTO sns_ara_local VALUES (327,6,4,'酒田市');
INSERT INTO sns_ara_local VALUES (328,6,5,'新庄市');
INSERT INTO sns_ara_local VALUES (329,6,6,'寒河江市');
INSERT INTO sns_ara_local VALUES (330,6,7,'上山市');
INSERT INTO sns_ara_local VALUES (331,6,8,'村山市');
INSERT INTO sns_ara_local VALUES (332,6,9,'長井市');
INSERT INTO sns_ara_local VALUES (333,6,10,'天童市');
INSERT INTO sns_ara_local VALUES (334,6,11,'東根市');
INSERT INTO sns_ara_local VALUES (335,6,12,'尾花沢市');
INSERT INTO sns_ara_local VALUES (336,6,13,'南陽市');
INSERT INTO sns_ara_local VALUES (337,6,14,'東村山郡山辺町');
INSERT INTO sns_ara_local VALUES (338,6,15,'東村山郡中山町');
INSERT INTO sns_ara_local VALUES (339,6,16,'西村山郡河北町');
INSERT INTO sns_ara_local VALUES (340,6,17,'西村山郡西川町');
INSERT INTO sns_ara_local VALUES (341,6,18,'西村山郡朝日町');
INSERT INTO sns_ara_local VALUES (342,6,19,'西村山郡大江町');
INSERT INTO sns_ara_local VALUES (343,6,20,'北村山郡大石田町');
INSERT INTO sns_ara_local VALUES (344,6,21,'最上郡金山町');
INSERT INTO sns_ara_local VALUES (345,6,22,'最上郡最上町');
INSERT INTO sns_ara_local VALUES (346,6,23,'最上郡舟形町');
INSERT INTO sns_ara_local VALUES (347,6,24,'最上郡真室川町');
INSERT INTO sns_ara_local VALUES (348,6,25,'最上郡大蔵村');
INSERT INTO sns_ara_local VALUES (349,6,26,'最上郡鮭川村');
INSERT INTO sns_ara_local VALUES (350,6,27,'最上郡戸沢村');
INSERT INTO sns_ara_local VALUES (351,6,28,'東置賜郡高畠町');
INSERT INTO sns_ara_local VALUES (352,6,29,'東置賜郡川西町');
INSERT INTO sns_ara_local VALUES (353,6,30,'西置賜郡小国町');
INSERT INTO sns_ara_local VALUES (354,6,31,'西置賜郡白鷹町');
INSERT INTO sns_ara_local VALUES (355,6,32,'西置賜郡飯豊町');
INSERT INTO sns_ara_local VALUES (356,6,33,'東田川郡三川町');
INSERT INTO sns_ara_local VALUES (357,6,34,'東田川郡庄内町');
INSERT INTO sns_ara_local VALUES (358,6,35,'飽海郡遊佐町');
INSERT INTO sns_ara_local VALUES (359,7,1,'福島市');
INSERT INTO sns_ara_local VALUES (360,7,2,'会津若松市');
INSERT INTO sns_ara_local VALUES (361,7,3,'郡山市');
INSERT INTO sns_ara_local VALUES (362,7,4,'いわき市');
INSERT INTO sns_ara_local VALUES (363,7,5,'白河市');
INSERT INTO sns_ara_local VALUES (364,7,6,'須賀川市');
INSERT INTO sns_ara_local VALUES (365,7,7,'喜多方市');
INSERT INTO sns_ara_local VALUES (366,7,8,'相馬市');
INSERT INTO sns_ara_local VALUES (367,7,9,'二本松市');
INSERT INTO sns_ara_local VALUES (368,7,10,'田村市');
INSERT INTO sns_ara_local VALUES (369,7,11,'南相馬市');
INSERT INTO sns_ara_local VALUES (370,7,12,'伊達市');
INSERT INTO sns_ara_local VALUES (371,7,13,'伊達郡桑折町');
INSERT INTO sns_ara_local VALUES (372,7,14,'伊達郡国見町');
INSERT INTO sns_ara_local VALUES (373,7,15,'伊達郡川俣町');
INSERT INTO sns_ara_local VALUES (374,7,16,'伊達郡飯野町');
INSERT INTO sns_ara_local VALUES (375,7,17,'安達郡大玉村');
INSERT INTO sns_ara_local VALUES (376,7,18,'安達郡本宮町');
INSERT INTO sns_ara_local VALUES (377,7,19,'安達郡白沢村');
INSERT INTO sns_ara_local VALUES (378,7,20,'岩瀬郡鏡石町');
INSERT INTO sns_ara_local VALUES (379,7,21,'岩瀬郡天栄村');
INSERT INTO sns_ara_local VALUES (380,7,22,'南会津郡下郷町');
INSERT INTO sns_ara_local VALUES (381,7,23,'南会津郡檜枝岐村');
INSERT INTO sns_ara_local VALUES (382,7,24,'南会津郡只見町');
INSERT INTO sns_ara_local VALUES (383,7,25,'南会津郡南会津町');
INSERT INTO sns_ara_local VALUES (384,7,26,'耶麻郡北塩原村');
INSERT INTO sns_ara_local VALUES (385,7,27,'耶麻郡西会津町');
INSERT INTO sns_ara_local VALUES (386,7,28,'耶麻郡磐梯町');
INSERT INTO sns_ara_local VALUES (387,7,29,'耶麻郡猪苗代町');
INSERT INTO sns_ara_local VALUES (388,7,30,'河沼郡会津坂下町');
INSERT INTO sns_ara_local VALUES (389,7,31,'河沼郡湯川村');
INSERT INTO sns_ara_local VALUES (390,7,32,'河沼郡柳津町');
INSERT INTO sns_ara_local VALUES (391,7,33,'大沼郡三島町');
INSERT INTO sns_ara_local VALUES (392,7,34,'大沼郡金山町');
INSERT INTO sns_ara_local VALUES (393,7,35,'大沼郡昭和村');
INSERT INTO sns_ara_local VALUES (394,7,36,'大沼郡会津美里町');
INSERT INTO sns_ara_local VALUES (395,7,37,'西白河郡西郷村');
INSERT INTO sns_ara_local VALUES (396,7,38,'西白河郡泉崎村');
INSERT INTO sns_ara_local VALUES (397,7,39,'西白河郡中島村');
INSERT INTO sns_ara_local VALUES (398,7,40,'西白河郡矢吹町');
INSERT INTO sns_ara_local VALUES (399,7,41,'東白川郡棚倉町');
INSERT INTO sns_ara_local VALUES (400,7,42,'東白川郡矢祭町');
INSERT INTO sns_ara_local VALUES (401,7,43,'東白川郡塙町');
INSERT INTO sns_ara_local VALUES (402,7,44,'東白川郡鮫川村');
INSERT INTO sns_ara_local VALUES (403,7,45,'石川郡石川町');
INSERT INTO sns_ara_local VALUES (404,7,46,'石川郡玉川村');
INSERT INTO sns_ara_local VALUES (405,7,47,'石川郡平田村');
INSERT INTO sns_ara_local VALUES (406,7,48,'石川郡浅川町');
INSERT INTO sns_ara_local VALUES (407,7,49,'石川郡古殿町');
INSERT INTO sns_ara_local VALUES (408,7,50,'田村郡三春町');
INSERT INTO sns_ara_local VALUES (409,7,51,'田村郡小野町');
INSERT INTO sns_ara_local VALUES (410,7,52,'双葉郡広野町');
INSERT INTO sns_ara_local VALUES (411,7,53,'双葉郡楢葉町');
INSERT INTO sns_ara_local VALUES (412,7,54,'双葉郡富岡町');
INSERT INTO sns_ara_local VALUES (413,7,55,'双葉郡川内村');
INSERT INTO sns_ara_local VALUES (414,7,56,'双葉郡大熊町');
INSERT INTO sns_ara_local VALUES (415,7,57,'双葉郡双葉町');
INSERT INTO sns_ara_local VALUES (416,7,58,'双葉郡浪江町');
INSERT INTO sns_ara_local VALUES (417,7,59,'双葉郡葛尾村');
INSERT INTO sns_ara_local VALUES (418,7,60,'相馬郡新地町');
INSERT INTO sns_ara_local VALUES (419,7,61,'相馬郡飯舘村');
INSERT INTO sns_ara_local VALUES (420,8,1,'水戸市');
INSERT INTO sns_ara_local VALUES (421,8,2,'日立市');
INSERT INTO sns_ara_local VALUES (422,8,3,'土浦市');
INSERT INTO sns_ara_local VALUES (423,8,4,'古河市');
INSERT INTO sns_ara_local VALUES (424,8,5,'石岡市');
INSERT INTO sns_ara_local VALUES (425,8,6,'結城市');
INSERT INTO sns_ara_local VALUES (426,8,7,'龍ケ崎市');
INSERT INTO sns_ara_local VALUES (427,8,8,'下妻市');
INSERT INTO sns_ara_local VALUES (428,8,9,'常総市');
INSERT INTO sns_ara_local VALUES (429,8,10,'常陸太田市');
INSERT INTO sns_ara_local VALUES (430,8,11,'高萩市');
INSERT INTO sns_ara_local VALUES (431,8,12,'北茨城市');
INSERT INTO sns_ara_local VALUES (432,8,13,'笠間市');
INSERT INTO sns_ara_local VALUES (433,8,14,'取手市');
INSERT INTO sns_ara_local VALUES (434,8,15,'牛久市');
INSERT INTO sns_ara_local VALUES (435,8,16,'つくば市');
INSERT INTO sns_ara_local VALUES (436,8,17,'ひたちなか市');
INSERT INTO sns_ara_local VALUES (437,8,18,'鹿嶋市');
INSERT INTO sns_ara_local VALUES (438,8,19,'潮来市');
INSERT INTO sns_ara_local VALUES (439,8,20,'守谷市');
INSERT INTO sns_ara_local VALUES (440,8,21,'常陸大宮市');
INSERT INTO sns_ara_local VALUES (441,8,22,'那珂市');
INSERT INTO sns_ara_local VALUES (442,8,23,'筑西市');
INSERT INTO sns_ara_local VALUES (443,8,24,'坂東市');
INSERT INTO sns_ara_local VALUES (444,8,25,'稲敷市');
INSERT INTO sns_ara_local VALUES (445,8,26,'かすみがうら市');
INSERT INTO sns_ara_local VALUES (446,8,27,'桜川市');
INSERT INTO sns_ara_local VALUES (447,8,28,'神栖市');
INSERT INTO sns_ara_local VALUES (448,8,29,'行方市');
INSERT INTO sns_ara_local VALUES (449,8,30,'鉾田市');
INSERT INTO sns_ara_local VALUES (450,8,31,'つくばみらい市');
INSERT INTO sns_ara_local VALUES (451,8,32,'小美玉市');
INSERT INTO sns_ara_local VALUES (452,8,33,'東茨城郡茨城町');
INSERT INTO sns_ara_local VALUES (453,8,34,'東茨城郡大洗町');
INSERT INTO sns_ara_local VALUES (454,8,35,'東茨城郡城里町');
INSERT INTO sns_ara_local VALUES (455,8,36,'那珂郡東海村');
INSERT INTO sns_ara_local VALUES (456,8,37,'久慈郡大子町');
INSERT INTO sns_ara_local VALUES (457,8,38,'稲敷郡美浦村');
INSERT INTO sns_ara_local VALUES (458,8,39,'稲敷郡阿見町');
INSERT INTO sns_ara_local VALUES (459,8,40,'稲敷郡河内町');
INSERT INTO sns_ara_local VALUES (460,8,41,'結城郡八千代町');
INSERT INTO sns_ara_local VALUES (461,8,42,'猿島郡五霞町');
INSERT INTO sns_ara_local VALUES (462,8,43,'猿島郡境町');
INSERT INTO sns_ara_local VALUES (463,8,44,'北相馬郡利根町');
INSERT INTO sns_ara_local VALUES (464,9,1,'宇都宮市');
INSERT INTO sns_ara_local VALUES (465,9,2,'足利市');
INSERT INTO sns_ara_local VALUES (466,9,3,'栃木市');
INSERT INTO sns_ara_local VALUES (467,9,4,'佐野市');
INSERT INTO sns_ara_local VALUES (468,9,5,'鹿沼市');
INSERT INTO sns_ara_local VALUES (469,9,6,'日光市');
INSERT INTO sns_ara_local VALUES (470,9,7,'小山市');
INSERT INTO sns_ara_local VALUES (471,9,8,'真岡市');
INSERT INTO sns_ara_local VALUES (472,9,9,'大田原市');
INSERT INTO sns_ara_local VALUES (473,9,10,'矢板市');
INSERT INTO sns_ara_local VALUES (474,9,11,'那須塩原市');
INSERT INTO sns_ara_local VALUES (475,9,12,'さくら市');
INSERT INTO sns_ara_local VALUES (476,9,13,'那須烏山市');
INSERT INTO sns_ara_local VALUES (477,9,14,'下野市');
INSERT INTO sns_ara_local VALUES (478,9,15,'河内郡上三川町');
INSERT INTO sns_ara_local VALUES (479,9,16,'河内郡上河内町');
INSERT INTO sns_ara_local VALUES (480,9,17,'河内郡河内町');
INSERT INTO sns_ara_local VALUES (481,9,18,'上都賀郡西方町');
INSERT INTO sns_ara_local VALUES (482,9,19,'芳賀郡二宮町');
INSERT INTO sns_ara_local VALUES (483,9,20,'芳賀郡益子町');
INSERT INTO sns_ara_local VALUES (484,9,21,'芳賀郡茂木町');
INSERT INTO sns_ara_local VALUES (485,9,22,'芳賀郡市貝町');
INSERT INTO sns_ara_local VALUES (486,9,23,'芳賀郡芳賀町');
INSERT INTO sns_ara_local VALUES (487,9,24,'下都賀郡壬生町');
INSERT INTO sns_ara_local VALUES (488,9,25,'下都賀郡野木町');
INSERT INTO sns_ara_local VALUES (489,9,26,'下都賀郡大平町');
INSERT INTO sns_ara_local VALUES (490,9,27,'下都賀郡藤岡町');
INSERT INTO sns_ara_local VALUES (491,9,28,'下都賀郡岩舟町');
INSERT INTO sns_ara_local VALUES (492,9,29,'下都賀郡都賀町');
INSERT INTO sns_ara_local VALUES (493,9,30,'塩谷郡塩谷町');
INSERT INTO sns_ara_local VALUES (494,9,31,'塩谷郡高根沢町');
INSERT INTO sns_ara_local VALUES (495,9,32,'那須郡那須町');
INSERT INTO sns_ara_local VALUES (496,9,33,'那須郡那珂川町');
INSERT INTO sns_ara_local VALUES (497,10,1,'前橋市');
INSERT INTO sns_ara_local VALUES (498,10,2,'高崎市');
INSERT INTO sns_ara_local VALUES (499,10,3,'桐生市');
INSERT INTO sns_ara_local VALUES (500,10,4,'伊勢崎市');
INSERT INTO sns_ara_local VALUES (501,10,5,'太田市');
INSERT INTO sns_ara_local VALUES (502,10,6,'沼田市');
INSERT INTO sns_ara_local VALUES (503,10,7,'館林市');
INSERT INTO sns_ara_local VALUES (504,10,8,'渋川市');
INSERT INTO sns_ara_local VALUES (505,10,9,'藤岡市');
INSERT INTO sns_ara_local VALUES (506,10,10,'富岡市');
INSERT INTO sns_ara_local VALUES (507,10,11,'安中市');
INSERT INTO sns_ara_local VALUES (508,10,12,'みどり市');
INSERT INTO sns_ara_local VALUES (509,10,13,'勢多郡富士見村');
INSERT INTO sns_ara_local VALUES (510,10,14,'群馬郡榛名町');
INSERT INTO sns_ara_local VALUES (511,10,15,'北群馬郡榛東村');
INSERT INTO sns_ara_local VALUES (512,10,16,'北群馬郡吉岡町');
INSERT INTO sns_ara_local VALUES (513,10,17,'多野郡吉井町');
INSERT INTO sns_ara_local VALUES (514,10,18,'多野郡上野村');
INSERT INTO sns_ara_local VALUES (515,10,19,'多野郡神流町');
INSERT INTO sns_ara_local VALUES (516,10,20,'甘楽郡下仁田町');
INSERT INTO sns_ara_local VALUES (517,10,21,'甘楽郡南牧村');
INSERT INTO sns_ara_local VALUES (518,10,22,'甘楽郡甘楽町');
INSERT INTO sns_ara_local VALUES (519,10,23,'吾妻郡中之条町');
INSERT INTO sns_ara_local VALUES (520,10,24,'吾妻郡長野原町');
INSERT INTO sns_ara_local VALUES (521,10,25,'吾妻郡嬬恋村');
INSERT INTO sns_ara_local VALUES (522,10,26,'吾妻郡草津町');
INSERT INTO sns_ara_local VALUES (523,10,27,'吾妻郡六合村');
INSERT INTO sns_ara_local VALUES (524,10,28,'吾妻郡高山村');
INSERT INTO sns_ara_local VALUES (525,10,29,'吾妻郡東吾妻町');
INSERT INTO sns_ara_local VALUES (526,10,30,'利根郡片品村');
INSERT INTO sns_ara_local VALUES (527,10,31,'利根郡川場村');
INSERT INTO sns_ara_local VALUES (528,10,32,'利根郡昭和村');
INSERT INTO sns_ara_local VALUES (529,10,33,'利根郡みなかみ町');
INSERT INTO sns_ara_local VALUES (530,10,34,'佐波郡玉村町');
INSERT INTO sns_ara_local VALUES (531,10,35,'邑楽郡板倉町');
INSERT INTO sns_ara_local VALUES (532,10,36,'邑楽郡明和町');
INSERT INTO sns_ara_local VALUES (533,10,37,'邑楽郡千代田町');
INSERT INTO sns_ara_local VALUES (534,10,38,'邑楽郡大泉町');
INSERT INTO sns_ara_local VALUES (535,10,39,'邑楽郡邑楽町');
INSERT INTO sns_ara_local VALUES (536,11,1,'さいたま市西区');
INSERT INTO sns_ara_local VALUES (537,11,2,'さいたま市北区');
INSERT INTO sns_ara_local VALUES (538,11,3,'さいたま市大宮区');
INSERT INTO sns_ara_local VALUES (539,11,4,'さいたま市見沼区');
INSERT INTO sns_ara_local VALUES (540,11,5,'さいたま市中央区');
INSERT INTO sns_ara_local VALUES (541,11,6,'さいたま市桜区');
INSERT INTO sns_ara_local VALUES (542,11,7,'さいたま市浦和区');
INSERT INTO sns_ara_local VALUES (543,11,8,'さいたま市南区');
INSERT INTO sns_ara_local VALUES (544,11,9,'さいたま市緑区');
INSERT INTO sns_ara_local VALUES (545,11,10,'さいたま市岩槻区');
INSERT INTO sns_ara_local VALUES (546,11,11,'川越市');
INSERT INTO sns_ara_local VALUES (547,11,12,'熊谷市');
INSERT INTO sns_ara_local VALUES (548,11,13,'川口市');
INSERT INTO sns_ara_local VALUES (549,11,14,'行田市');
INSERT INTO sns_ara_local VALUES (550,11,15,'秩父市');
INSERT INTO sns_ara_local VALUES (551,11,16,'所沢市');
INSERT INTO sns_ara_local VALUES (552,11,17,'飯能市');
INSERT INTO sns_ara_local VALUES (553,11,18,'加須市');
INSERT INTO sns_ara_local VALUES (554,11,19,'本庄市');
INSERT INTO sns_ara_local VALUES (555,11,20,'東松山市');
INSERT INTO sns_ara_local VALUES (556,11,21,'春日部市');
INSERT INTO sns_ara_local VALUES (557,11,22,'狭山市');
INSERT INTO sns_ara_local VALUES (558,11,23,'羽生市');
INSERT INTO sns_ara_local VALUES (559,11,24,'鴻巣市');
INSERT INTO sns_ara_local VALUES (560,11,25,'深谷市');
INSERT INTO sns_ara_local VALUES (561,11,26,'上尾市');
INSERT INTO sns_ara_local VALUES (562,11,27,'草加市');
INSERT INTO sns_ara_local VALUES (563,11,28,'越谷市');
INSERT INTO sns_ara_local VALUES (564,11,29,'蕨市');
INSERT INTO sns_ara_local VALUES (565,11,30,'戸田市');
INSERT INTO sns_ara_local VALUES (566,11,31,'入間市');
INSERT INTO sns_ara_local VALUES (567,11,32,'鳩ケ谷市');
INSERT INTO sns_ara_local VALUES (568,11,33,'朝霞市');
INSERT INTO sns_ara_local VALUES (569,11,34,'志木市');
INSERT INTO sns_ara_local VALUES (570,11,35,'和光市');
INSERT INTO sns_ara_local VALUES (571,11,36,'新座市');
INSERT INTO sns_ara_local VALUES (572,11,37,'桶川市');
INSERT INTO sns_ara_local VALUES (573,11,38,'久喜市');
INSERT INTO sns_ara_local VALUES (574,11,39,'北本市');
INSERT INTO sns_ara_local VALUES (575,11,40,'八潮市');
INSERT INTO sns_ara_local VALUES (576,11,41,'富士見市');
INSERT INTO sns_ara_local VALUES (577,11,42,'三郷市');
INSERT INTO sns_ara_local VALUES (578,11,43,'蓮田市');
INSERT INTO sns_ara_local VALUES (579,11,44,'坂戸市');
INSERT INTO sns_ara_local VALUES (580,11,45,'幸手市');
INSERT INTO sns_ara_local VALUES (581,11,46,'鶴ケ島市');
INSERT INTO sns_ara_local VALUES (582,11,47,'日高市');
INSERT INTO sns_ara_local VALUES (583,11,48,'吉川市');
INSERT INTO sns_ara_local VALUES (584,11,49,'ふじみ野市');
INSERT INTO sns_ara_local VALUES (585,11,50,'北足立郡伊奈町');
INSERT INTO sns_ara_local VALUES (586,11,51,'入間郡三芳町');
INSERT INTO sns_ara_local VALUES (587,11,52,'入間郡毛呂山町');
INSERT INTO sns_ara_local VALUES (588,11,53,'入間郡越生町');
INSERT INTO sns_ara_local VALUES (589,11,54,'比企郡滑川町');
INSERT INTO sns_ara_local VALUES (590,11,55,'比企郡嵐山町');
INSERT INTO sns_ara_local VALUES (591,11,56,'比企郡小川町');
INSERT INTO sns_ara_local VALUES (592,11,57,'比企郡川島町');
INSERT INTO sns_ara_local VALUES (593,11,58,'比企郡吉見町');
INSERT INTO sns_ara_local VALUES (594,11,59,'比企郡鳩山町');
INSERT INTO sns_ara_local VALUES (595,11,60,'比企郡ときがわ町');
INSERT INTO sns_ara_local VALUES (596,11,61,'秩父郡横瀬町');
INSERT INTO sns_ara_local VALUES (597,11,62,'秩父郡皆野町');
INSERT INTO sns_ara_local VALUES (598,11,63,'秩父郡長瀞町');
INSERT INTO sns_ara_local VALUES (599,11,64,'秩父郡小鹿野町');
INSERT INTO sns_ara_local VALUES (600,11,65,'秩父郡東秩父村');
INSERT INTO sns_ara_local VALUES (601,11,66,'児玉郡美里町');
INSERT INTO sns_ara_local VALUES (602,11,67,'児玉郡神川町');
INSERT INTO sns_ara_local VALUES (603,11,68,'児玉郡上里町');
INSERT INTO sns_ara_local VALUES (604,11,69,'大里郡江南町');
INSERT INTO sns_ara_local VALUES (605,11,70,'大里郡寄居町');
INSERT INTO sns_ara_local VALUES (606,11,71,'北埼玉郡騎西町');
INSERT INTO sns_ara_local VALUES (607,11,72,'北埼玉郡北川辺町');
INSERT INTO sns_ara_local VALUES (608,11,73,'北埼玉郡大利根町');
INSERT INTO sns_ara_local VALUES (609,11,74,'南埼玉郡宮代町');
INSERT INTO sns_ara_local VALUES (610,11,75,'南埼玉郡白岡町');
INSERT INTO sns_ara_local VALUES (611,11,76,'南埼玉郡菖蒲町');
INSERT INTO sns_ara_local VALUES (612,11,77,'北葛飾郡栗橋町');
INSERT INTO sns_ara_local VALUES (613,11,78,'北葛飾郡鷲宮町');
INSERT INTO sns_ara_local VALUES (614,11,79,'北葛飾郡杉戸町');
INSERT INTO sns_ara_local VALUES (615,11,80,'北葛飾郡松伏町');
INSERT INTO sns_ara_local VALUES (616,12,1,'千葉市中央区');
INSERT INTO sns_ara_local VALUES (617,12,2,'千葉市花見川区');
INSERT INTO sns_ara_local VALUES (618,12,3,'千葉市稲毛区');
INSERT INTO sns_ara_local VALUES (619,12,4,'千葉市若葉区');
INSERT INTO sns_ara_local VALUES (620,12,5,'千葉市緑区');
INSERT INTO sns_ara_local VALUES (621,12,6,'千葉市美浜区');
INSERT INTO sns_ara_local VALUES (622,12,7,'銚子市');
INSERT INTO sns_ara_local VALUES (623,12,8,'市川市');
INSERT INTO sns_ara_local VALUES (624,12,9,'船橋市');
INSERT INTO sns_ara_local VALUES (625,12,10,'館山市');
INSERT INTO sns_ara_local VALUES (626,12,11,'木更津市');
INSERT INTO sns_ara_local VALUES (627,12,12,'松戸市');
INSERT INTO sns_ara_local VALUES (628,12,13,'野田市');
INSERT INTO sns_ara_local VALUES (629,12,14,'茂原市');
INSERT INTO sns_ara_local VALUES (630,12,15,'成田市');
INSERT INTO sns_ara_local VALUES (631,12,16,'佐倉市');
INSERT INTO sns_ara_local VALUES (632,12,17,'東金市');
INSERT INTO sns_ara_local VALUES (633,12,18,'旭市');
INSERT INTO sns_ara_local VALUES (634,12,19,'習志野市');
INSERT INTO sns_ara_local VALUES (635,12,20,'柏市');
INSERT INTO sns_ara_local VALUES (636,12,21,'勝浦市');
INSERT INTO sns_ara_local VALUES (637,12,22,'市原市');
INSERT INTO sns_ara_local VALUES (638,12,23,'流山市');
INSERT INTO sns_ara_local VALUES (639,12,24,'八千代市');
INSERT INTO sns_ara_local VALUES (640,12,25,'我孫子市');
INSERT INTO sns_ara_local VALUES (641,12,26,'鴨川市');
INSERT INTO sns_ara_local VALUES (642,12,27,'鎌ケ谷市');
INSERT INTO sns_ara_local VALUES (643,12,28,'君津市');
INSERT INTO sns_ara_local VALUES (644,12,29,'富津市');
INSERT INTO sns_ara_local VALUES (645,12,30,'浦安市');
INSERT INTO sns_ara_local VALUES (646,12,31,'四街道市');
INSERT INTO sns_ara_local VALUES (647,12,32,'袖ケ浦市');
INSERT INTO sns_ara_local VALUES (648,12,33,'八街市');
INSERT INTO sns_ara_local VALUES (649,12,34,'印西市');
INSERT INTO sns_ara_local VALUES (650,12,35,'白井市');
INSERT INTO sns_ara_local VALUES (651,12,36,'富里市');
INSERT INTO sns_ara_local VALUES (652,12,37,'南房総市');
INSERT INTO sns_ara_local VALUES (653,12,38,'匝瑳市');
INSERT INTO sns_ara_local VALUES (654,12,39,'香取市');
INSERT INTO sns_ara_local VALUES (655,12,40,'山武市');
INSERT INTO sns_ara_local VALUES (656,12,41,'いすみ市');
INSERT INTO sns_ara_local VALUES (657,12,42,'印旛郡酒々井町');
INSERT INTO sns_ara_local VALUES (658,12,43,'印旛郡印旛村');
INSERT INTO sns_ara_local VALUES (659,12,44,'印旛郡本埜村');
INSERT INTO sns_ara_local VALUES (660,12,45,'印旛郡栄町');
INSERT INTO sns_ara_local VALUES (661,12,46,'香取郡神崎町');
INSERT INTO sns_ara_local VALUES (662,12,47,'香取郡多古町');
INSERT INTO sns_ara_local VALUES (663,12,48,'香取郡東庄町');
INSERT INTO sns_ara_local VALUES (664,12,49,'山武郡大網白里町');
INSERT INTO sns_ara_local VALUES (665,12,50,'山武郡九十九里町');
INSERT INTO sns_ara_local VALUES (666,12,51,'山武郡芝山町');
INSERT INTO sns_ara_local VALUES (667,12,52,'山武郡横芝光町');
INSERT INTO sns_ara_local VALUES (668,12,53,'長生郡一宮町');
INSERT INTO sns_ara_local VALUES (669,12,54,'長生郡睦沢町');
INSERT INTO sns_ara_local VALUES (670,12,55,'長生郡長生村');
INSERT INTO sns_ara_local VALUES (671,12,56,'長生郡白子町');
INSERT INTO sns_ara_local VALUES (672,12,57,'長生郡長柄町');
INSERT INTO sns_ara_local VALUES (673,12,58,'長生郡長南町');
INSERT INTO sns_ara_local VALUES (674,12,59,'夷隅郡大多喜町');
INSERT INTO sns_ara_local VALUES (675,12,60,'夷隅郡御宿町');
INSERT INTO sns_ara_local VALUES (676,12,61,'安房郡鋸南町');
INSERT INTO sns_ara_local VALUES (677,13,1,'千代田区');
INSERT INTO sns_ara_local VALUES (678,13,2,'中央区');
INSERT INTO sns_ara_local VALUES (679,13,3,'港区');
INSERT INTO sns_ara_local VALUES (680,13,4,'新宿区');
INSERT INTO sns_ara_local VALUES (681,13,5,'文京区');
INSERT INTO sns_ara_local VALUES (682,13,6,'台東区');
INSERT INTO sns_ara_local VALUES (683,13,7,'墨田区');
INSERT INTO sns_ara_local VALUES (684,13,8,'江東区');
INSERT INTO sns_ara_local VALUES (685,13,9,'品川区');
INSERT INTO sns_ara_local VALUES (686,13,10,'目黒区');
INSERT INTO sns_ara_local VALUES (687,13,11,'大田区');
INSERT INTO sns_ara_local VALUES (688,13,12,'世田谷区');
INSERT INTO sns_ara_local VALUES (689,13,13,'渋谷区');
INSERT INTO sns_ara_local VALUES (690,13,14,'中野区');
INSERT INTO sns_ara_local VALUES (691,13,15,'杉並区');
INSERT INTO sns_ara_local VALUES (692,13,16,'豊島区');
INSERT INTO sns_ara_local VALUES (693,13,17,'北区');
INSERT INTO sns_ara_local VALUES (694,13,18,'荒川区');
INSERT INTO sns_ara_local VALUES (695,13,19,'板橋区');
INSERT INTO sns_ara_local VALUES (696,13,20,'練馬区');
INSERT INTO sns_ara_local VALUES (697,13,21,'足立区');
INSERT INTO sns_ara_local VALUES (698,13,22,'葛飾区');
INSERT INTO sns_ara_local VALUES (699,13,23,'江戸川区');
INSERT INTO sns_ara_local VALUES (700,13,24,'八王子市');
INSERT INTO sns_ara_local VALUES (701,13,25,'立川市');
INSERT INTO sns_ara_local VALUES (702,13,26,'武蔵野市');
INSERT INTO sns_ara_local VALUES (703,13,27,'三鷹市');
INSERT INTO sns_ara_local VALUES (704,13,28,'青梅市');
INSERT INTO sns_ara_local VALUES (705,13,29,'府中市');
INSERT INTO sns_ara_local VALUES (706,13,30,'昭島市');
INSERT INTO sns_ara_local VALUES (707,13,31,'調布市');
INSERT INTO sns_ara_local VALUES (708,13,32,'町田市');
INSERT INTO sns_ara_local VALUES (709,13,33,'小金井市');
INSERT INTO sns_ara_local VALUES (710,13,34,'小平市');
INSERT INTO sns_ara_local VALUES (711,13,35,'日野市');
INSERT INTO sns_ara_local VALUES (712,13,36,'東村山市');
INSERT INTO sns_ara_local VALUES (713,13,37,'国分寺市');
INSERT INTO sns_ara_local VALUES (714,13,38,'国立市');
INSERT INTO sns_ara_local VALUES (715,13,39,'福生市');
INSERT INTO sns_ara_local VALUES (716,13,40,'狛江市');
INSERT INTO sns_ara_local VALUES (717,13,41,'東大和市');
INSERT INTO sns_ara_local VALUES (718,13,42,'清瀬市');
INSERT INTO sns_ara_local VALUES (719,13,43,'東久留米市');
INSERT INTO sns_ara_local VALUES (720,13,44,'武蔵村山市');
INSERT INTO sns_ara_local VALUES (721,13,45,'多摩市');
INSERT INTO sns_ara_local VALUES (722,13,46,'稲城市');
INSERT INTO sns_ara_local VALUES (723,13,47,'羽村市');
INSERT INTO sns_ara_local VALUES (724,13,48,'あきる野市');
INSERT INTO sns_ara_local VALUES (725,13,49,'西東京市');
INSERT INTO sns_ara_local VALUES (726,13,50,'西多摩郡瑞穂町');
INSERT INTO sns_ara_local VALUES (727,13,51,'西多摩郡日の出町');
INSERT INTO sns_ara_local VALUES (728,13,52,'西多摩郡檜原村');
INSERT INTO sns_ara_local VALUES (729,13,53,'西多摩郡奥多摩町');
INSERT INTO sns_ara_local VALUES (730,13,54,'大島大島町');
INSERT INTO sns_ara_local VALUES (731,13,55,'新島新島村');
INSERT INTO sns_ara_local VALUES (732,13,56,'三宅島三宅村');
INSERT INTO sns_ara_local VALUES (733,13,57,'八丈島八丈町');
INSERT INTO sns_ara_local VALUES (734,13,58,'小笠原諸島小笠原村');
INSERT INTO sns_ara_local VALUES (735,14,1,'横浜市鶴見区');
INSERT INTO sns_ara_local VALUES (736,14,2,'横浜市神奈川区');
INSERT INTO sns_ara_local VALUES (737,14,3,'横浜市西区');
INSERT INTO sns_ara_local VALUES (738,14,4,'横浜市中区');
INSERT INTO sns_ara_local VALUES (739,14,5,'横浜市南区');
INSERT INTO sns_ara_local VALUES (740,14,6,'横浜市保土ケ谷区');
INSERT INTO sns_ara_local VALUES (741,14,7,'横浜市磯子区');
INSERT INTO sns_ara_local VALUES (742,14,8,'横浜市金沢区');
INSERT INTO sns_ara_local VALUES (743,14,9,'横浜市港北区');
INSERT INTO sns_ara_local VALUES (744,14,10,'横浜市戸塚区');
INSERT INTO sns_ara_local VALUES (745,14,11,'横浜市港南区');
INSERT INTO sns_ara_local VALUES (746,14,12,'横浜市旭区');
INSERT INTO sns_ara_local VALUES (747,14,13,'横浜市緑区');
INSERT INTO sns_ara_local VALUES (748,14,14,'横浜市瀬谷区');
INSERT INTO sns_ara_local VALUES (749,14,15,'横浜市栄区');
INSERT INTO sns_ara_local VALUES (750,14,16,'横浜市泉区');
INSERT INTO sns_ara_local VALUES (751,14,17,'横浜市青葉区');
INSERT INTO sns_ara_local VALUES (752,14,18,'横浜市都筑区');
INSERT INTO sns_ara_local VALUES (753,14,19,'川崎市川崎区');
INSERT INTO sns_ara_local VALUES (754,14,20,'川崎市幸区');
INSERT INTO sns_ara_local VALUES (755,14,21,'川崎市中原区');
INSERT INTO sns_ara_local VALUES (756,14,22,'川崎市高津区');
INSERT INTO sns_ara_local VALUES (757,14,23,'川崎市多摩区');
INSERT INTO sns_ara_local VALUES (758,14,24,'川崎市宮前区');
INSERT INTO sns_ara_local VALUES (759,14,25,'川崎市麻生区');
INSERT INTO sns_ara_local VALUES (760,14,26,'横須賀市');
INSERT INTO sns_ara_local VALUES (761,14,27,'平塚市');
INSERT INTO sns_ara_local VALUES (762,14,28,'鎌倉市');
INSERT INTO sns_ara_local VALUES (763,14,29,'藤沢市');
INSERT INTO sns_ara_local VALUES (764,14,30,'小田原市');
INSERT INTO sns_ara_local VALUES (765,14,31,'茅ヶ崎市');
INSERT INTO sns_ara_local VALUES (766,14,32,'逗子市');
INSERT INTO sns_ara_local VALUES (767,14,33,'相模原市');
INSERT INTO sns_ara_local VALUES (768,14,34,'三浦市');
INSERT INTO sns_ara_local VALUES (769,14,35,'秦野市');
INSERT INTO sns_ara_local VALUES (770,14,36,'厚木市');
INSERT INTO sns_ara_local VALUES (771,14,37,'大和市');
INSERT INTO sns_ara_local VALUES (772,14,38,'伊勢原市');
INSERT INTO sns_ara_local VALUES (773,14,39,'海老名市');
INSERT INTO sns_ara_local VALUES (774,14,40,'座間市');
INSERT INTO sns_ara_local VALUES (775,14,41,'南足柄市');
INSERT INTO sns_ara_local VALUES (776,14,42,'綾瀬市');
INSERT INTO sns_ara_local VALUES (777,14,43,'三浦郡葉山町');
INSERT INTO sns_ara_local VALUES (778,14,44,'高座郡寒川町');
INSERT INTO sns_ara_local VALUES (779,14,45,'中郡大磯町');
INSERT INTO sns_ara_local VALUES (780,14,46,'中郡二宮町');
INSERT INTO sns_ara_local VALUES (781,14,47,'足柄上郡中井町');
INSERT INTO sns_ara_local VALUES (782,14,48,'足柄上郡大井町');
INSERT INTO sns_ara_local VALUES (783,14,49,'足柄上郡松田町');
INSERT INTO sns_ara_local VALUES (784,14,50,'足柄上郡山北町');
INSERT INTO sns_ara_local VALUES (785,14,51,'足柄上郡開成町');
INSERT INTO sns_ara_local VALUES (786,14,52,'足柄下郡箱根町');
INSERT INTO sns_ara_local VALUES (787,14,53,'足柄下郡真鶴町');
INSERT INTO sns_ara_local VALUES (788,14,54,'足柄下郡湯河原町');
INSERT INTO sns_ara_local VALUES (789,14,55,'愛甲郡愛川町');
INSERT INTO sns_ara_local VALUES (790,14,56,'愛甲郡清川村');
INSERT INTO sns_ara_local VALUES (791,14,57,'津久井郡城山町');
INSERT INTO sns_ara_local VALUES (792,14,58,'津久井郡藤野町');
INSERT INTO sns_ara_local VALUES (793,15,1,'新潟市');
INSERT INTO sns_ara_local VALUES (794,15,2,'長岡市');
INSERT INTO sns_ara_local VALUES (795,15,3,'三条市');
INSERT INTO sns_ara_local VALUES (796,15,4,'柏崎市');
INSERT INTO sns_ara_local VALUES (797,15,5,'新発田市');
INSERT INTO sns_ara_local VALUES (798,15,6,'小千谷市');
INSERT INTO sns_ara_local VALUES (799,15,7,'加茂市');
INSERT INTO sns_ara_local VALUES (800,15,8,'見附市');
INSERT INTO sns_ara_local VALUES (801,15,9,'村上市');
INSERT INTO sns_ara_local VALUES (802,15,10,'燕市');
INSERT INTO sns_ara_local VALUES (803,15,11,'糸魚川市');
INSERT INTO sns_ara_local VALUES (804,15,12,'妙高市');
INSERT INTO sns_ara_local VALUES (805,15,13,'五泉市');
INSERT INTO sns_ara_local VALUES (806,15,14,'上越市');
INSERT INTO sns_ara_local VALUES (807,15,15,'阿賀野市');
INSERT INTO sns_ara_local VALUES (808,15,16,'佐渡市');
INSERT INTO sns_ara_local VALUES (809,15,17,'魚沼市');
INSERT INTO sns_ara_local VALUES (810,15,18,'南魚沼市');
INSERT INTO sns_ara_local VALUES (811,15,19,'胎内市');
INSERT INTO sns_ara_local VALUES (812,15,20,'北蒲原郡聖籠町');
INSERT INTO sns_ara_local VALUES (813,15,21,'西蒲原郡弥彦村');
INSERT INTO sns_ara_local VALUES (814,15,22,'南蒲原郡田上町');
INSERT INTO sns_ara_local VALUES (815,15,23,'東蒲原郡阿賀町');
INSERT INTO sns_ara_local VALUES (816,15,24,'三島郡出雲崎町');
INSERT INTO sns_ara_local VALUES (817,15,25,'北魚沼郡川口町');
INSERT INTO sns_ara_local VALUES (818,15,26,'南魚沼郡湯沢町');
INSERT INTO sns_ara_local VALUES (819,15,27,'中魚沼郡津南町');
INSERT INTO sns_ara_local VALUES (820,15,28,'刈羽郡刈羽村');
INSERT INTO sns_ara_local VALUES (821,15,29,'岩船郡関川村');
INSERT INTO sns_ara_local VALUES (822,15,30,'岩船郡荒川町');
INSERT INTO sns_ara_local VALUES (823,15,31,'岩船郡神林村');
INSERT INTO sns_ara_local VALUES (824,15,32,'岩船郡朝日村');
INSERT INTO sns_ara_local VALUES (825,15,33,'岩船郡山北町');
INSERT INTO sns_ara_local VALUES (826,16,1,'富山市');
INSERT INTO sns_ara_local VALUES (827,16,2,'高岡市');
INSERT INTO sns_ara_local VALUES (828,16,3,'魚津市');
INSERT INTO sns_ara_local VALUES (829,16,4,'氷見市');
INSERT INTO sns_ara_local VALUES (830,16,5,'滑川市');
INSERT INTO sns_ara_local VALUES (831,16,6,'黒部市');
INSERT INTO sns_ara_local VALUES (832,16,7,'砺波市');
INSERT INTO sns_ara_local VALUES (833,16,8,'小矢部市');
INSERT INTO sns_ara_local VALUES (834,16,9,'南砺市');
INSERT INTO sns_ara_local VALUES (835,16,10,'射水市');
INSERT INTO sns_ara_local VALUES (836,16,11,'中新川郡舟橋村');
INSERT INTO sns_ara_local VALUES (837,16,12,'中新川郡上市町');
INSERT INTO sns_ara_local VALUES (838,16,13,'中新川郡立山町');
INSERT INTO sns_ara_local VALUES (839,16,14,'下新川郡入善町');
INSERT INTO sns_ara_local VALUES (840,16,15,'下新川郡朝日町');
INSERT INTO sns_ara_local VALUES (841,17,1,'金沢市');
INSERT INTO sns_ara_local VALUES (842,17,2,'七尾市');
INSERT INTO sns_ara_local VALUES (843,17,3,'小松市');
INSERT INTO sns_ara_local VALUES (844,17,4,'輪島市');
INSERT INTO sns_ara_local VALUES (845,17,5,'珠洲市');
INSERT INTO sns_ara_local VALUES (846,17,6,'加賀市');
INSERT INTO sns_ara_local VALUES (847,17,7,'羽咋市');
INSERT INTO sns_ara_local VALUES (848,17,8,'かほく市');
INSERT INTO sns_ara_local VALUES (849,17,9,'白山市');
INSERT INTO sns_ara_local VALUES (850,17,10,'石川郡野々市町');
INSERT INTO sns_ara_local VALUES (851,17,11,'河北郡津幡町');
INSERT INTO sns_ara_local VALUES (852,17,12,'河北郡内灘町');
INSERT INTO sns_ara_local VALUES (853,17,13,'羽咋郡志賀町');
INSERT INTO sns_ara_local VALUES (854,17,14,'羽咋郡宝達志水町');
INSERT INTO sns_ara_local VALUES (855,17,15,'鹿島郡中能登町');
INSERT INTO sns_ara_local VALUES (856,17,16,'鳳珠郡穴水町');
INSERT INTO sns_ara_local VALUES (857,17,17,'鳳珠郡能登町');
INSERT INTO sns_ara_local VALUES (858,18,1,'福井市');
INSERT INTO sns_ara_local VALUES (859,18,2,'敦賀市');
INSERT INTO sns_ara_local VALUES (860,18,3,'小浜市');
INSERT INTO sns_ara_local VALUES (861,18,4,'大野市');
INSERT INTO sns_ara_local VALUES (862,18,5,'勝山市');
INSERT INTO sns_ara_local VALUES (863,18,6,'鯖江市');
INSERT INTO sns_ara_local VALUES (864,18,7,'あわら市');
INSERT INTO sns_ara_local VALUES (865,18,8,'越前市');
INSERT INTO sns_ara_local VALUES (866,18,9,'坂井市');
INSERT INTO sns_ara_local VALUES (867,18,10,'吉田郡永平寺町');
INSERT INTO sns_ara_local VALUES (868,18,11,'今立郡池田町');
INSERT INTO sns_ara_local VALUES (869,18,12,'南条郡南越前町');
INSERT INTO sns_ara_local VALUES (870,18,13,'丹生郡越前町');
INSERT INTO sns_ara_local VALUES (871,18,14,'三方郡美浜町');
INSERT INTO sns_ara_local VALUES (872,18,15,'大飯郡高浜町');
INSERT INTO sns_ara_local VALUES (873,18,16,'大飯郡おおい町');
INSERT INTO sns_ara_local VALUES (874,18,17,'三方上中郡若狭町');
INSERT INTO sns_ara_local VALUES (875,19,1,'甲府市');
INSERT INTO sns_ara_local VALUES (876,19,2,'富士吉田市');
INSERT INTO sns_ara_local VALUES (877,19,3,'都留市');
INSERT INTO sns_ara_local VALUES (878,19,4,'山梨市');
INSERT INTO sns_ara_local VALUES (879,19,5,'大月市');
INSERT INTO sns_ara_local VALUES (880,19,6,'韮崎市');
INSERT INTO sns_ara_local VALUES (881,19,7,'南アルプス市');
INSERT INTO sns_ara_local VALUES (882,19,8,'北杜市');
INSERT INTO sns_ara_local VALUES (883,19,9,'甲斐市');
INSERT INTO sns_ara_local VALUES (884,19,10,'笛吹市');
INSERT INTO sns_ara_local VALUES (885,19,11,'上野原市');
INSERT INTO sns_ara_local VALUES (886,19,12,'甲州市');
INSERT INTO sns_ara_local VALUES (887,19,13,'中央市');
INSERT INTO sns_ara_local VALUES (888,19,14,'東八代郡芦川村');
INSERT INTO sns_ara_local VALUES (889,19,15,'西八代郡市川三郷町');
INSERT INTO sns_ara_local VALUES (890,19,16,'南巨摩郡増穂町');
INSERT INTO sns_ara_local VALUES (891,19,17,'南巨摩郡鰍沢町');
INSERT INTO sns_ara_local VALUES (892,19,18,'南巨摩郡早川町');
INSERT INTO sns_ara_local VALUES (893,19,19,'南巨摩郡身延町');
INSERT INTO sns_ara_local VALUES (894,19,20,'南巨摩郡南部町');
INSERT INTO sns_ara_local VALUES (895,19,21,'中巨摩郡昭和町');
INSERT INTO sns_ara_local VALUES (896,19,22,'南都留郡道志村');
INSERT INTO sns_ara_local VALUES (897,19,23,'南都留郡西桂町');
INSERT INTO sns_ara_local VALUES (898,19,24,'南都留郡忍野村');
INSERT INTO sns_ara_local VALUES (899,19,25,'南都留郡山中湖村');
INSERT INTO sns_ara_local VALUES (900,19,26,'南都留郡富士河口湖町');
INSERT INTO sns_ara_local VALUES (901,19,27,'北都留郡小菅村');
INSERT INTO sns_ara_local VALUES (902,19,28,'北都留郡丹波山村');
INSERT INTO sns_ara_local VALUES (903,20,1,'長野市');
INSERT INTO sns_ara_local VALUES (904,20,2,'松本市');
INSERT INTO sns_ara_local VALUES (905,20,3,'上田市');
INSERT INTO sns_ara_local VALUES (906,20,4,'岡谷市');
INSERT INTO sns_ara_local VALUES (907,20,5,'飯田市');
INSERT INTO sns_ara_local VALUES (908,20,6,'諏訪市');
INSERT INTO sns_ara_local VALUES (909,20,7,'須坂市');
INSERT INTO sns_ara_local VALUES (910,20,8,'小諸市');
INSERT INTO sns_ara_local VALUES (911,20,9,'伊那市');
INSERT INTO sns_ara_local VALUES (912,20,10,'駒ケ根市');
INSERT INTO sns_ara_local VALUES (913,20,11,'中野市');
INSERT INTO sns_ara_local VALUES (914,20,12,'大町市');
INSERT INTO sns_ara_local VALUES (915,20,13,'飯山市');
INSERT INTO sns_ara_local VALUES (916,20,14,'茅野市');
INSERT INTO sns_ara_local VALUES (917,20,15,'塩尻市');
INSERT INTO sns_ara_local VALUES (918,20,16,'佐久市');
INSERT INTO sns_ara_local VALUES (919,20,17,'千曲市');
INSERT INTO sns_ara_local VALUES (920,20,18,'東御市');
INSERT INTO sns_ara_local VALUES (921,20,19,'安曇野市');
INSERT INTO sns_ara_local VALUES (922,20,20,'南佐久郡小海町');
INSERT INTO sns_ara_local VALUES (923,20,21,'南佐久郡川上村');
INSERT INTO sns_ara_local VALUES (924,20,22,'南佐久郡南牧村');
INSERT INTO sns_ara_local VALUES (925,20,23,'南佐久郡佐久穂町');
INSERT INTO sns_ara_local VALUES (926,20,24,'北佐久郡軽井沢町');
INSERT INTO sns_ara_local VALUES (927,20,25,'北佐久郡御代田町');
INSERT INTO sns_ara_local VALUES (928,20,26,'北佐久郡立科町');
INSERT INTO sns_ara_local VALUES (929,20,27,'小県郡青木村');
INSERT INTO sns_ara_local VALUES (930,20,28,'小県郡長和町');
INSERT INTO sns_ara_local VALUES (931,20,29,'諏訪郡下諏訪町');
INSERT INTO sns_ara_local VALUES (932,20,30,'諏訪郡富士見町');
INSERT INTO sns_ara_local VALUES (933,20,31,'諏訪郡原村');
INSERT INTO sns_ara_local VALUES (934,20,32,'上伊那郡辰野町');
INSERT INTO sns_ara_local VALUES (935,20,33,'上伊那郡箕輪町');
INSERT INTO sns_ara_local VALUES (936,20,34,'上伊那郡飯島町');
INSERT INTO sns_ara_local VALUES (937,20,35,'上伊那郡中川村');
INSERT INTO sns_ara_local VALUES (938,20,36,'下伊那郡松川町');
INSERT INTO sns_ara_local VALUES (939,20,37,'下伊那郡高森町');
INSERT INTO sns_ara_local VALUES (940,20,38,'下伊那郡阿南町');
INSERT INTO sns_ara_local VALUES (941,20,39,'下伊那郡阿智村');
INSERT INTO sns_ara_local VALUES (942,20,40,'下伊那郡下條村');
INSERT INTO sns_ara_local VALUES (943,20,41,'下伊那郡天龍村');
INSERT INTO sns_ara_local VALUES (944,20,42,'下伊那郡喬木村');
INSERT INTO sns_ara_local VALUES (945,20,43,'下伊那郡豊丘村');
INSERT INTO sns_ara_local VALUES (946,20,44,'下伊那郡大鹿村');
INSERT INTO sns_ara_local VALUES (947,20,45,'木曽郡上松町');
INSERT INTO sns_ara_local VALUES (948,20,46,'木曽郡南木曽町');
INSERT INTO sns_ara_local VALUES (949,20,47,'木曽郡木祖村');
INSERT INTO sns_ara_local VALUES (950,20,48,'木曽郡大桑村');
INSERT INTO sns_ara_local VALUES (951,20,49,'木曽郡木曽町');
INSERT INTO sns_ara_local VALUES (952,20,50,'東筑摩郡麻績村');
INSERT INTO sns_ara_local VALUES (953,20,51,'東筑摩郡生坂村');
INSERT INTO sns_ara_local VALUES (954,20,52,'東筑摩郡朝日村');
INSERT INTO sns_ara_local VALUES (955,20,53,'東筑摩郡筑北村');
INSERT INTO sns_ara_local VALUES (956,20,54,'北安曇郡池田町');
INSERT INTO sns_ara_local VALUES (957,20,55,'北安曇郡白馬村');
INSERT INTO sns_ara_local VALUES (958,20,56,'北安曇郡小谷村');
INSERT INTO sns_ara_local VALUES (959,20,57,'埴科郡坂城町');
INSERT INTO sns_ara_local VALUES (960,20,58,'上高井郡小布施町');
INSERT INTO sns_ara_local VALUES (961,20,59,'上高井郡高山村');
INSERT INTO sns_ara_local VALUES (962,20,60,'下高井郡山ノ内町');
INSERT INTO sns_ara_local VALUES (963,20,61,'下高井郡木島平村');
INSERT INTO sns_ara_local VALUES (964,20,62,'下高井郡野沢温泉村');
INSERT INTO sns_ara_local VALUES (965,20,63,'上水内郡信州新町');
INSERT INTO sns_ara_local VALUES (966,20,64,'上水内郡信濃町');
INSERT INTO sns_ara_local VALUES (967,20,65,'上水内郡小川村');
INSERT INTO sns_ara_local VALUES (968,20,66,'上水内郡中条村');
INSERT INTO sns_ara_local VALUES (969,20,67,'上水内郡飯綱町');
INSERT INTO sns_ara_local VALUES (970,20,68,'下水内郡栄村');
INSERT INTO sns_ara_local VALUES (971,21,1,'岐阜市');
INSERT INTO sns_ara_local VALUES (972,21,2,'大垣市');
INSERT INTO sns_ara_local VALUES (973,21,3,'高山市');
INSERT INTO sns_ara_local VALUES (974,21,4,'多治見市');
INSERT INTO sns_ara_local VALUES (975,21,5,'関市');
INSERT INTO sns_ara_local VALUES (976,21,6,'中津川市');
INSERT INTO sns_ara_local VALUES (977,21,7,'美濃市');
INSERT INTO sns_ara_local VALUES (978,21,8,'瑞浪市');
INSERT INTO sns_ara_local VALUES (979,21,9,'羽島市');
INSERT INTO sns_ara_local VALUES (980,21,10,'恵那市');
INSERT INTO sns_ara_local VALUES (981,21,11,'美濃加茂市');
INSERT INTO sns_ara_local VALUES (982,21,12,'土岐市');
INSERT INTO sns_ara_local VALUES (983,21,13,'各務原市');
INSERT INTO sns_ara_local VALUES (984,21,14,'可児市');
INSERT INTO sns_ara_local VALUES (985,21,15,'山県市');
INSERT INTO sns_ara_local VALUES (986,21,16,'瑞穂市');
INSERT INTO sns_ara_local VALUES (987,21,17,'飛騨市');
INSERT INTO sns_ara_local VALUES (988,21,18,'本巣市');
INSERT INTO sns_ara_local VALUES (989,21,19,'郡上市');
INSERT INTO sns_ara_local VALUES (990,21,20,'下呂市');
INSERT INTO sns_ara_local VALUES (991,21,21,'海津市');
INSERT INTO sns_ara_local VALUES (992,21,22,'羽島郡岐南町');
INSERT INTO sns_ara_local VALUES (993,21,23,'羽島郡笠松町');
INSERT INTO sns_ara_local VALUES (994,21,24,'養老郡養老町');
INSERT INTO sns_ara_local VALUES (995,21,25,'不破郡垂井町');
INSERT INTO sns_ara_local VALUES (996,21,26,'不破郡関ケ原町');
INSERT INTO sns_ara_local VALUES (997,21,27,'安八郡神戸町');
INSERT INTO sns_ara_local VALUES (998,21,28,'安八郡輪之内町');
INSERT INTO sns_ara_local VALUES (999,21,29,'安八郡安八町');
INSERT INTO sns_ara_local VALUES (1000,21,30,'揖斐郡揖斐川町');
INSERT INTO sns_ara_local VALUES (1001,21,31,'揖斐郡大野町');
INSERT INTO sns_ara_local VALUES (1002,21,32,'揖斐郡池田町');
INSERT INTO sns_ara_local VALUES (1003,21,33,'本巣郡北方町');
INSERT INTO sns_ara_local VALUES (1004,21,34,'加茂郡坂祝町');
INSERT INTO sns_ara_local VALUES (1005,21,35,'加茂郡富加町');
INSERT INTO sns_ara_local VALUES (1006,21,36,'加茂郡川辺町');
INSERT INTO sns_ara_local VALUES (1007,21,37,'加茂郡七宗町');
INSERT INTO sns_ara_local VALUES (1008,21,38,'加茂郡八百津町');
INSERT INTO sns_ara_local VALUES (1009,21,39,'加茂郡白川町');
INSERT INTO sns_ara_local VALUES (1010,21,40,'加茂郡東白川村');
INSERT INTO sns_ara_local VALUES (1011,21,41,'可児郡御嵩町');
INSERT INTO sns_ara_local VALUES (1012,21,42,'大野郡白川村');
INSERT INTO sns_ara_local VALUES (1013,22,1,'静岡市葵区');
INSERT INTO sns_ara_local VALUES (1014,22,2,'静岡市駿河区');
INSERT INTO sns_ara_local VALUES (1015,22,3,'静岡市清水区');
INSERT INTO sns_ara_local VALUES (1016,22,4,'浜松市');
INSERT INTO sns_ara_local VALUES (1017,22,5,'沼津市');
INSERT INTO sns_ara_local VALUES (1018,22,6,'熱海市');
INSERT INTO sns_ara_local VALUES (1019,22,7,'三島市');
INSERT INTO sns_ara_local VALUES (1020,22,8,'富士宮市');
INSERT INTO sns_ara_local VALUES (1021,22,9,'伊東市');
INSERT INTO sns_ara_local VALUES (1022,22,10,'島田市');
INSERT INTO sns_ara_local VALUES (1023,22,11,'富士市');
INSERT INTO sns_ara_local VALUES (1024,22,12,'磐田市');
INSERT INTO sns_ara_local VALUES (1025,22,13,'焼津市');
INSERT INTO sns_ara_local VALUES (1026,22,14,'掛川市');
INSERT INTO sns_ara_local VALUES (1027,22,15,'藤枝市');
INSERT INTO sns_ara_local VALUES (1028,22,16,'御殿場市');
INSERT INTO sns_ara_local VALUES (1029,22,17,'袋井市');
INSERT INTO sns_ara_local VALUES (1030,22,18,'下田市');
INSERT INTO sns_ara_local VALUES (1031,22,19,'裾野市');
INSERT INTO sns_ara_local VALUES (1032,22,20,'湖西市');
INSERT INTO sns_ara_local VALUES (1033,22,21,'伊豆市');
INSERT INTO sns_ara_local VALUES (1034,22,22,'御前崎市');
INSERT INTO sns_ara_local VALUES (1035,22,23,'菊川市');
INSERT INTO sns_ara_local VALUES (1036,22,24,'伊豆の国市');
INSERT INTO sns_ara_local VALUES (1037,22,25,'牧之原市');
INSERT INTO sns_ara_local VALUES (1038,22,26,'賀茂郡東伊豆町');
INSERT INTO sns_ara_local VALUES (1039,22,27,'賀茂郡河津町');
INSERT INTO sns_ara_local VALUES (1040,22,28,'賀茂郡南伊豆町');
INSERT INTO sns_ara_local VALUES (1041,22,29,'賀茂郡松崎町');
INSERT INTO sns_ara_local VALUES (1042,22,30,'賀茂郡西伊豆町');
INSERT INTO sns_ara_local VALUES (1043,22,31,'田方郡函南町');
INSERT INTO sns_ara_local VALUES (1044,22,32,'駿東郡清水町');
INSERT INTO sns_ara_local VALUES (1045,22,33,'駿東郡長泉町');
INSERT INTO sns_ara_local VALUES (1046,22,34,'駿東郡小山町');
INSERT INTO sns_ara_local VALUES (1047,22,35,'富士郡芝川町');
INSERT INTO sns_ara_local VALUES (1048,22,36,'庵原郡富士川町');
INSERT INTO sns_ara_local VALUES (1049,22,37,'庵原郡由比町');
INSERT INTO sns_ara_local VALUES (1050,22,38,'志太郡岡部町');
INSERT INTO sns_ara_local VALUES (1051,22,39,'志太郡大井川町');
INSERT INTO sns_ara_local VALUES (1052,22,40,'榛原郡吉田町');
INSERT INTO sns_ara_local VALUES (1053,22,41,'榛原郡川根町');
INSERT INTO sns_ara_local VALUES (1054,22,42,'榛原郡川根本町');
INSERT INTO sns_ara_local VALUES (1055,22,43,'周智郡森町');
INSERT INTO sns_ara_local VALUES (1056,22,44,'浜名郡新居町');
INSERT INTO sns_ara_local VALUES (1057,23,1,'名古屋市千種区');
INSERT INTO sns_ara_local VALUES (1058,23,2,'名古屋市東区');
INSERT INTO sns_ara_local VALUES (1059,23,3,'名古屋市北区');
INSERT INTO sns_ara_local VALUES (1060,23,4,'名古屋市西区');
INSERT INTO sns_ara_local VALUES (1061,23,5,'名古屋市中村区');
INSERT INTO sns_ara_local VALUES (1062,23,6,'名古屋市中区');
INSERT INTO sns_ara_local VALUES (1063,23,7,'名古屋市昭和区');
INSERT INTO sns_ara_local VALUES (1064,23,8,'名古屋市瑞穂区');
INSERT INTO sns_ara_local VALUES (1065,23,9,'名古屋市熱田区');
INSERT INTO sns_ara_local VALUES (1066,23,10,'名古屋市中川区');
INSERT INTO sns_ara_local VALUES (1067,23,11,'名古屋市港区');
INSERT INTO sns_ara_local VALUES (1068,23,12,'名古屋市南区');
INSERT INTO sns_ara_local VALUES (1069,23,13,'名古屋市守山区');
INSERT INTO sns_ara_local VALUES (1070,23,14,'名古屋市緑区');
INSERT INTO sns_ara_local VALUES (1071,23,15,'名古屋市名東区');
INSERT INTO sns_ara_local VALUES (1072,23,16,'名古屋市天白区');
INSERT INTO sns_ara_local VALUES (1073,23,17,'豊橋市');
INSERT INTO sns_ara_local VALUES (1074,23,18,'岡崎市');
INSERT INTO sns_ara_local VALUES (1075,23,19,'一宮市');
INSERT INTO sns_ara_local VALUES (1076,23,20,'瀬戸市');
INSERT INTO sns_ara_local VALUES (1077,23,21,'半田市');
INSERT INTO sns_ara_local VALUES (1078,23,22,'春日井市');
INSERT INTO sns_ara_local VALUES (1079,23,23,'豊川市');
INSERT INTO sns_ara_local VALUES (1080,23,24,'津島市');
INSERT INTO sns_ara_local VALUES (1081,23,25,'碧南市');
INSERT INTO sns_ara_local VALUES (1082,23,26,'刈谷市');
INSERT INTO sns_ara_local VALUES (1083,23,27,'豊田市');
INSERT INTO sns_ara_local VALUES (1084,23,28,'安城市');
INSERT INTO sns_ara_local VALUES (1085,23,29,'西尾市');
INSERT INTO sns_ara_local VALUES (1086,23,30,'蒲郡市');
INSERT INTO sns_ara_local VALUES (1087,23,31,'犬山市');
INSERT INTO sns_ara_local VALUES (1088,23,32,'常滑市');
INSERT INTO sns_ara_local VALUES (1089,23,33,'江南市');
INSERT INTO sns_ara_local VALUES (1090,23,34,'小牧市');
INSERT INTO sns_ara_local VALUES (1091,23,35,'稲沢市');
INSERT INTO sns_ara_local VALUES (1092,23,36,'新城市');
INSERT INTO sns_ara_local VALUES (1093,23,37,'東海市');
INSERT INTO sns_ara_local VALUES (1094,23,38,'大府市');
INSERT INTO sns_ara_local VALUES (1095,23,39,'知多市');
INSERT INTO sns_ara_local VALUES (1096,23,40,'知立市');
INSERT INTO sns_ara_local VALUES (1097,23,41,'尾張旭市');
INSERT INTO sns_ara_local VALUES (1098,23,42,'高浜市');
INSERT INTO sns_ara_local VALUES (1099,23,43,'岩倉市');
INSERT INTO sns_ara_local VALUES (1100,23,44,'豊明市');
INSERT INTO sns_ara_local VALUES (1101,23,45,'日進市');
INSERT INTO sns_ara_local VALUES (1102,23,46,'田原市');
INSERT INTO sns_ara_local VALUES (1103,23,47,'愛西市');
INSERT INTO sns_ara_local VALUES (1104,23,48,'清須市');
INSERT INTO sns_ara_local VALUES (1105,23,49,'北名古屋市');
INSERT INTO sns_ara_local VALUES (1106,23,50,'弥富市');
INSERT INTO sns_ara_local VALUES (1107,23,51,'愛知郡東郷町');
INSERT INTO sns_ara_local VALUES (1108,23,52,'愛知郡長久手町');
INSERT INTO sns_ara_local VALUES (1109,23,53,'西春日井郡豊山町');
INSERT INTO sns_ara_local VALUES (1110,23,54,'西春日井郡春日町');
INSERT INTO sns_ara_local VALUES (1111,23,55,'丹羽郡大口町');
INSERT INTO sns_ara_local VALUES (1112,23,56,'丹羽郡扶桑町');
INSERT INTO sns_ara_local VALUES (1113,23,57,'海部郡七宝町');
INSERT INTO sns_ara_local VALUES (1114,23,58,'海部郡美和町');
INSERT INTO sns_ara_local VALUES (1115,23,59,'海部郡甚目寺町');
INSERT INTO sns_ara_local VALUES (1116,23,60,'海部郡大治町');
INSERT INTO sns_ara_local VALUES (1117,23,61,'海部郡蟹江町');
INSERT INTO sns_ara_local VALUES (1118,23,62,'海部郡飛島村');
INSERT INTO sns_ara_local VALUES (1119,23,63,'知多郡阿久比町');
INSERT INTO sns_ara_local VALUES (1120,23,64,'知多郡東浦町');
INSERT INTO sns_ara_local VALUES (1121,23,65,'知多郡南知多町');
INSERT INTO sns_ara_local VALUES (1122,23,66,'知多郡美浜町');
INSERT INTO sns_ara_local VALUES (1123,23,67,'知多郡武豊町');
INSERT INTO sns_ara_local VALUES (1124,23,68,'幡豆郡一色町');
INSERT INTO sns_ara_local VALUES (1125,23,69,'幡豆郡吉良町');
INSERT INTO sns_ara_local VALUES (1126,23,70,'幡豆郡幡豆町');
INSERT INTO sns_ara_local VALUES (1127,23,71,'額田郡幸田町');
INSERT INTO sns_ara_local VALUES (1128,23,72,'西加茂郡三好町');
INSERT INTO sns_ara_local VALUES (1129,23,73,'北設楽郡設楽町');
INSERT INTO sns_ara_local VALUES (1130,23,74,'北設楽郡東栄町');
INSERT INTO sns_ara_local VALUES (1131,23,75,'北設楽郡豊根村');
INSERT INTO sns_ara_local VALUES (1132,23,76,'宝飯郡音羽町');
INSERT INTO sns_ara_local VALUES (1133,23,77,'宝飯郡小坂井町');
INSERT INTO sns_ara_local VALUES (1134,23,78,'宝飯郡御津町');
INSERT INTO sns_ara_local VALUES (1135,24,1,'津市');
INSERT INTO sns_ara_local VALUES (1136,24,2,'四日市市');
INSERT INTO sns_ara_local VALUES (1137,24,3,'伊勢市');
INSERT INTO sns_ara_local VALUES (1138,24,4,'松阪市');
INSERT INTO sns_ara_local VALUES (1139,24,5,'桑名市');
INSERT INTO sns_ara_local VALUES (1140,24,6,'鈴鹿市');
INSERT INTO sns_ara_local VALUES (1141,24,7,'名張市');
INSERT INTO sns_ara_local VALUES (1142,24,8,'尾鷲市');
INSERT INTO sns_ara_local VALUES (1143,24,9,'亀山市');
INSERT INTO sns_ara_local VALUES (1144,24,10,'鳥羽市');
INSERT INTO sns_ara_local VALUES (1145,24,11,'熊野市');
INSERT INTO sns_ara_local VALUES (1146,24,12,'いなべ市');
INSERT INTO sns_ara_local VALUES (1147,24,13,'志摩市');
INSERT INTO sns_ara_local VALUES (1148,24,14,'伊賀市');
INSERT INTO sns_ara_local VALUES (1149,24,15,'員弁郡東員町');
INSERT INTO sns_ara_local VALUES (1150,24,16,'三重郡菰野町');
INSERT INTO sns_ara_local VALUES (1151,24,17,'三重郡朝日町');
INSERT INTO sns_ara_local VALUES (1152,24,18,'三重郡川越町');
INSERT INTO sns_ara_local VALUES (1153,24,19,'多気郡多気町');
INSERT INTO sns_ara_local VALUES (1154,24,20,'多気郡明和町');
INSERT INTO sns_ara_local VALUES (1155,24,21,'多気郡大台町');
INSERT INTO sns_ara_local VALUES (1156,24,22,'度会郡玉城町');
INSERT INTO sns_ara_local VALUES (1157,24,23,'度会郡度会町');
INSERT INTO sns_ara_local VALUES (1158,24,24,'度会郡大紀町');
INSERT INTO sns_ara_local VALUES (1159,24,25,'度会郡南伊勢町');
INSERT INTO sns_ara_local VALUES (1160,24,26,'北牟婁郡紀北町');
INSERT INTO sns_ara_local VALUES (1161,24,27,'南牟婁郡御浜町');
INSERT INTO sns_ara_local VALUES (1162,24,28,'南牟婁郡紀宝町');
INSERT INTO sns_ara_local VALUES (1163,25,1,'大津市');
INSERT INTO sns_ara_local VALUES (1164,25,2,'彦根市');
INSERT INTO sns_ara_local VALUES (1165,25,3,'長浜市');
INSERT INTO sns_ara_local VALUES (1166,25,4,'近江八幡市');
INSERT INTO sns_ara_local VALUES (1167,25,5,'草津市');
INSERT INTO sns_ara_local VALUES (1168,25,6,'守山市');
INSERT INTO sns_ara_local VALUES (1169,25,7,'栗東市');
INSERT INTO sns_ara_local VALUES (1170,25,8,'甲賀市');
INSERT INTO sns_ara_local VALUES (1171,25,9,'野洲市');
INSERT INTO sns_ara_local VALUES (1172,25,10,'湖南市');
INSERT INTO sns_ara_local VALUES (1173,25,11,'高島市');
INSERT INTO sns_ara_local VALUES (1174,25,12,'東近江市');
INSERT INTO sns_ara_local VALUES (1175,25,13,'米原市');
INSERT INTO sns_ara_local VALUES (1176,25,14,'蒲生郡安土町');
INSERT INTO sns_ara_local VALUES (1177,25,15,'蒲生郡日野町');
INSERT INTO sns_ara_local VALUES (1178,25,16,'蒲生郡竜王町');
INSERT INTO sns_ara_local VALUES (1179,25,17,'愛知郡愛荘町');
INSERT INTO sns_ara_local VALUES (1180,25,18,'犬上郡豊郷町');
INSERT INTO sns_ara_local VALUES (1181,25,19,'犬上郡甲良町');
INSERT INTO sns_ara_local VALUES (1182,25,20,'犬上郡多賀町');
INSERT INTO sns_ara_local VALUES (1183,25,21,'東浅井郡虎姫町');
INSERT INTO sns_ara_local VALUES (1184,25,22,'東浅井郡湖北町');
INSERT INTO sns_ara_local VALUES (1185,25,23,'伊香郡高月町');
INSERT INTO sns_ara_local VALUES (1186,25,24,'伊香郡木之本町');
INSERT INTO sns_ara_local VALUES (1187,25,25,'伊香郡余呉町');
INSERT INTO sns_ara_local VALUES (1188,25,26,'伊香郡西浅井町');
INSERT INTO sns_ara_local VALUES (1189,26,1,'京都市北区');
INSERT INTO sns_ara_local VALUES (1190,26,2,'京都市上京区');
INSERT INTO sns_ara_local VALUES (1191,26,3,'京都市左京区');
INSERT INTO sns_ara_local VALUES (1192,26,4,'京都市中京区');
INSERT INTO sns_ara_local VALUES (1193,26,5,'京都市東山区');
INSERT INTO sns_ara_local VALUES (1194,26,6,'京都市下京区');
INSERT INTO sns_ara_local VALUES (1195,26,7,'京都市南区');
INSERT INTO sns_ara_local VALUES (1196,26,8,'京都市右京区');
INSERT INTO sns_ara_local VALUES (1197,26,9,'京都市伏見区');
INSERT INTO sns_ara_local VALUES (1198,26,10,'京都市山科区');
INSERT INTO sns_ara_local VALUES (1199,26,11,'京都市西京区');
INSERT INTO sns_ara_local VALUES (1200,26,12,'福知山市');
INSERT INTO sns_ara_local VALUES (1201,26,13,'舞鶴市');
INSERT INTO sns_ara_local VALUES (1202,26,14,'綾部市');
INSERT INTO sns_ara_local VALUES (1203,26,15,'宇治市');
INSERT INTO sns_ara_local VALUES (1204,26,16,'宮津市');
INSERT INTO sns_ara_local VALUES (1205,26,17,'亀岡市');
INSERT INTO sns_ara_local VALUES (1206,26,18,'城陽市');
INSERT INTO sns_ara_local VALUES (1207,26,19,'向日市');
INSERT INTO sns_ara_local VALUES (1208,26,20,'長岡京市');
INSERT INTO sns_ara_local VALUES (1209,26,21,'八幡市');
INSERT INTO sns_ara_local VALUES (1210,26,22,'京田辺市');
INSERT INTO sns_ara_local VALUES (1211,26,23,'京丹後市');
INSERT INTO sns_ara_local VALUES (1212,26,24,'南丹市');
INSERT INTO sns_ara_local VALUES (1213,26,25,'乙訓郡大山崎町');
INSERT INTO sns_ara_local VALUES (1214,26,26,'久世郡久御山町');
INSERT INTO sns_ara_local VALUES (1215,26,27,'綴喜郡井手町');
INSERT INTO sns_ara_local VALUES (1216,26,28,'綴喜郡宇治田原町');
INSERT INTO sns_ara_local VALUES (1217,26,29,'相楽郡山城町');
INSERT INTO sns_ara_local VALUES (1218,26,30,'相楽郡木津町');
INSERT INTO sns_ara_local VALUES (1219,26,31,'相楽郡加茂町');
INSERT INTO sns_ara_local VALUES (1220,26,32,'相楽郡笠置町');
INSERT INTO sns_ara_local VALUES (1221,26,33,'相楽郡和束町');
INSERT INTO sns_ara_local VALUES (1222,26,34,'相楽郡精華町');
INSERT INTO sns_ara_local VALUES (1223,26,35,'相楽郡南山城村');
INSERT INTO sns_ara_local VALUES (1224,26,36,'船井郡京丹波町');
INSERT INTO sns_ara_local VALUES (1225,26,37,'与謝郡伊根町');
INSERT INTO sns_ara_local VALUES (1226,26,38,'与謝郡与謝野町');
INSERT INTO sns_ara_local VALUES (1227,27,1,'大阪市都島区');
INSERT INTO sns_ara_local VALUES (1228,27,2,'大阪市福島区');
INSERT INTO sns_ara_local VALUES (1229,27,3,'大阪市此花区');
INSERT INTO sns_ara_local VALUES (1230,27,4,'大阪市西区');
INSERT INTO sns_ara_local VALUES (1231,27,5,'大阪市港区');
INSERT INTO sns_ara_local VALUES (1232,27,6,'大阪市大正区');
INSERT INTO sns_ara_local VALUES (1233,27,7,'大阪市天王寺区');
INSERT INTO sns_ara_local VALUES (1234,27,8,'大阪市浪速区');
INSERT INTO sns_ara_local VALUES (1235,27,9,'大阪市西淀川区');
INSERT INTO sns_ara_local VALUES (1236,27,10,'大阪市東淀川区');
INSERT INTO sns_ara_local VALUES (1237,27,11,'大阪市東成区');
INSERT INTO sns_ara_local VALUES (1238,27,12,'大阪市生野区');
INSERT INTO sns_ara_local VALUES (1239,27,13,'大阪市旭区');
INSERT INTO sns_ara_local VALUES (1240,27,14,'大阪市城東区');
INSERT INTO sns_ara_local VALUES (1241,27,15,'大阪市阿倍野区');
INSERT INTO sns_ara_local VALUES (1242,27,16,'大阪市住吉区');
INSERT INTO sns_ara_local VALUES (1243,27,17,'大阪市東住吉区');
INSERT INTO sns_ara_local VALUES (1244,27,18,'大阪市西成区');
INSERT INTO sns_ara_local VALUES (1245,27,19,'大阪市淀川区');
INSERT INTO sns_ara_local VALUES (1246,27,20,'大阪市鶴見区');
INSERT INTO sns_ara_local VALUES (1247,27,21,'大阪市住之江区');
INSERT INTO sns_ara_local VALUES (1248,27,22,'大阪市平野区');
INSERT INTO sns_ara_local VALUES (1249,27,23,'大阪市北区');
INSERT INTO sns_ara_local VALUES (1250,27,24,'大阪市中央区');
INSERT INTO sns_ara_local VALUES (1251,27,25,'堺市堺区');
INSERT INTO sns_ara_local VALUES (1252,27,26,'堺市中区');
INSERT INTO sns_ara_local VALUES (1253,27,27,'堺市東区');
INSERT INTO sns_ara_local VALUES (1254,27,28,'堺市西区');
INSERT INTO sns_ara_local VALUES (1255,27,29,'堺市南区');
INSERT INTO sns_ara_local VALUES (1256,27,30,'堺市北区');
INSERT INTO sns_ara_local VALUES (1257,27,31,'堺市美原区');
INSERT INTO sns_ara_local VALUES (1258,27,32,'岸和田市');
INSERT INTO sns_ara_local VALUES (1259,27,33,'豊中市');
INSERT INTO sns_ara_local VALUES (1260,27,34,'池田市');
INSERT INTO sns_ara_local VALUES (1261,27,35,'吹田市');
INSERT INTO sns_ara_local VALUES (1262,27,36,'泉大津市');
INSERT INTO sns_ara_local VALUES (1263,27,37,'高槻市');
INSERT INTO sns_ara_local VALUES (1264,27,38,'貝塚市');
INSERT INTO sns_ara_local VALUES (1265,27,39,'守口市');
INSERT INTO sns_ara_local VALUES (1266,27,40,'枚方市');
INSERT INTO sns_ara_local VALUES (1267,27,41,'茨木市');
INSERT INTO sns_ara_local VALUES (1268,27,42,'八尾市');
INSERT INTO sns_ara_local VALUES (1269,27,43,'泉佐野市');
INSERT INTO sns_ara_local VALUES (1270,27,44,'富田林市');
INSERT INTO sns_ara_local VALUES (1271,27,45,'寝屋川市');
INSERT INTO sns_ara_local VALUES (1272,27,46,'河内長野市');
INSERT INTO sns_ara_local VALUES (1273,27,47,'松原市');
INSERT INTO sns_ara_local VALUES (1274,27,48,'大東市');
INSERT INTO sns_ara_local VALUES (1275,27,49,'和泉市');
INSERT INTO sns_ara_local VALUES (1276,27,50,'箕面市');
INSERT INTO sns_ara_local VALUES (1277,27,51,'柏原市');
INSERT INTO sns_ara_local VALUES (1278,27,52,'羽曳野市');
INSERT INTO sns_ara_local VALUES (1279,27,53,'門真市');
INSERT INTO sns_ara_local VALUES (1280,27,54,'摂津市');
INSERT INTO sns_ara_local VALUES (1281,27,55,'高石市');
INSERT INTO sns_ara_local VALUES (1282,27,56,'藤井寺市');
INSERT INTO sns_ara_local VALUES (1283,27,57,'東大阪市');
INSERT INTO sns_ara_local VALUES (1284,27,58,'泉南市');
INSERT INTO sns_ara_local VALUES (1285,27,59,'四條畷市');
INSERT INTO sns_ara_local VALUES (1286,27,60,'交野市');
INSERT INTO sns_ara_local VALUES (1287,27,61,'大阪狭山市');
INSERT INTO sns_ara_local VALUES (1288,27,62,'阪南市');
INSERT INTO sns_ara_local VALUES (1289,27,63,'三島郡島本町');
INSERT INTO sns_ara_local VALUES (1290,27,64,'豊能郡豊能町');
INSERT INTO sns_ara_local VALUES (1291,27,65,'豊能郡能勢町');
INSERT INTO sns_ara_local VALUES (1292,27,66,'泉北郡忠岡町');
INSERT INTO sns_ara_local VALUES (1293,27,67,'泉南郡熊取町');
INSERT INTO sns_ara_local VALUES (1294,27,68,'泉南郡田尻町');
INSERT INTO sns_ara_local VALUES (1295,27,69,'泉南郡岬町');
INSERT INTO sns_ara_local VALUES (1296,27,70,'南河内郡太子町');
INSERT INTO sns_ara_local VALUES (1297,27,71,'南河内郡河南町');
INSERT INTO sns_ara_local VALUES (1298,27,72,'南河内郡千早赤阪村');
INSERT INTO sns_ara_local VALUES (1299,28,1,'神戸市東灘区');
INSERT INTO sns_ara_local VALUES (1300,28,2,'神戸市灘区');
INSERT INTO sns_ara_local VALUES (1301,28,3,'神戸市兵庫区');
INSERT INTO sns_ara_local VALUES (1302,28,4,'神戸市長田区');
INSERT INTO sns_ara_local VALUES (1303,28,5,'神戸市須磨区');
INSERT INTO sns_ara_local VALUES (1304,28,6,'神戸市垂水区');
INSERT INTO sns_ara_local VALUES (1305,28,7,'神戸市北区');
INSERT INTO sns_ara_local VALUES (1306,28,8,'神戸市中央区');
INSERT INTO sns_ara_local VALUES (1307,28,9,'神戸市西区');
INSERT INTO sns_ara_local VALUES (1308,28,10,'姫路市');
INSERT INTO sns_ara_local VALUES (1309,28,11,'尼崎市');
INSERT INTO sns_ara_local VALUES (1310,28,12,'明石市');
INSERT INTO sns_ara_local VALUES (1311,28,13,'西宮市');
INSERT INTO sns_ara_local VALUES (1312,28,14,'洲本市');
INSERT INTO sns_ara_local VALUES (1313,28,15,'芦屋市');
INSERT INTO sns_ara_local VALUES (1314,28,16,'伊丹市');
INSERT INTO sns_ara_local VALUES (1315,28,17,'相生市');
INSERT INTO sns_ara_local VALUES (1316,28,18,'豊岡市');
INSERT INTO sns_ara_local VALUES (1317,28,19,'加古川市');
INSERT INTO sns_ara_local VALUES (1318,28,20,'赤穂市');
INSERT INTO sns_ara_local VALUES (1319,28,21,'西脇市');
INSERT INTO sns_ara_local VALUES (1320,28,22,'宝塚市');
INSERT INTO sns_ara_local VALUES (1321,28,23,'三木市');
INSERT INTO sns_ara_local VALUES (1322,28,24,'高砂市');
INSERT INTO sns_ara_local VALUES (1323,28,25,'川西市');
INSERT INTO sns_ara_local VALUES (1324,28,26,'小野市');
INSERT INTO sns_ara_local VALUES (1325,28,27,'三田市');
INSERT INTO sns_ara_local VALUES (1326,28,28,'加西市');
INSERT INTO sns_ara_local VALUES (1327,28,29,'篠山市');
INSERT INTO sns_ara_local VALUES (1328,28,30,'養父市');
INSERT INTO sns_ara_local VALUES (1329,28,31,'丹波市');
INSERT INTO sns_ara_local VALUES (1330,28,32,'南あわじ市');
INSERT INTO sns_ara_local VALUES (1331,28,33,'朝来市');
INSERT INTO sns_ara_local VALUES (1332,28,34,'淡路市');
INSERT INTO sns_ara_local VALUES (1333,28,35,'宍粟市');
INSERT INTO sns_ara_local VALUES (1334,28,36,'加東市');
INSERT INTO sns_ara_local VALUES (1335,28,37,'たつの市');
INSERT INTO sns_ara_local VALUES (1336,28,38,'川辺郡猪名川町');
INSERT INTO sns_ara_local VALUES (1337,28,39,'多可郡多可町');
INSERT INTO sns_ara_local VALUES (1338,28,40,'加古郡稲美町');
INSERT INTO sns_ara_local VALUES (1339,28,41,'加古郡播磨町');
INSERT INTO sns_ara_local VALUES (1340,28,42,'神崎郡市川町');
INSERT INTO sns_ara_local VALUES (1341,28,43,'神崎郡福崎町');
INSERT INTO sns_ara_local VALUES (1342,28,44,'神崎郡神河町');
INSERT INTO sns_ara_local VALUES (1343,28,45,'揖保郡太子町');
INSERT INTO sns_ara_local VALUES (1344,28,46,'赤穂郡上郡町');
INSERT INTO sns_ara_local VALUES (1345,28,47,'佐用郡佐用町');
INSERT INTO sns_ara_local VALUES (1346,28,48,'美方郡香美町');
INSERT INTO sns_ara_local VALUES (1347,28,49,'美方郡新温泉町');
INSERT INTO sns_ara_local VALUES (1348,29,1,'奈良市');
INSERT INTO sns_ara_local VALUES (1349,29,2,'大和高田市');
INSERT INTO sns_ara_local VALUES (1350,29,3,'大和郡山市');
INSERT INTO sns_ara_local VALUES (1351,29,4,'天理市');
INSERT INTO sns_ara_local VALUES (1352,29,5,'橿原市');
INSERT INTO sns_ara_local VALUES (1353,29,6,'桜井市');
INSERT INTO sns_ara_local VALUES (1354,29,7,'五條市');
INSERT INTO sns_ara_local VALUES (1355,29,8,'御所市');
INSERT INTO sns_ara_local VALUES (1356,29,9,'生駒市');
INSERT INTO sns_ara_local VALUES (1357,29,10,'香芝市');
INSERT INTO sns_ara_local VALUES (1358,29,11,'葛城市');
INSERT INTO sns_ara_local VALUES (1359,29,12,'宇陀市');
INSERT INTO sns_ara_local VALUES (1360,29,13,'山辺郡山添村');
INSERT INTO sns_ara_local VALUES (1361,29,14,'生駒郡平群町');
INSERT INTO sns_ara_local VALUES (1362,29,15,'生駒郡三郷町');
INSERT INTO sns_ara_local VALUES (1363,29,16,'生駒郡斑鳩町');
INSERT INTO sns_ara_local VALUES (1364,29,17,'生駒郡安堵町');
INSERT INTO sns_ara_local VALUES (1365,29,18,'磯城郡川西町');
INSERT INTO sns_ara_local VALUES (1366,29,19,'磯城郡三宅町');
INSERT INTO sns_ara_local VALUES (1367,29,20,'磯城郡田原本町');
INSERT INTO sns_ara_local VALUES (1368,29,21,'宇陀郡曽爾村');
INSERT INTO sns_ara_local VALUES (1369,29,22,'宇陀郡御杖村');
INSERT INTO sns_ara_local VALUES (1370,29,23,'高市郡高取町');
INSERT INTO sns_ara_local VALUES (1371,29,24,'高市郡明日香村');
INSERT INTO sns_ara_local VALUES (1372,29,25,'北葛城郡上牧町');
INSERT INTO sns_ara_local VALUES (1373,29,26,'北葛城郡王寺町');
INSERT INTO sns_ara_local VALUES (1374,29,27,'北葛城郡広陵町');
INSERT INTO sns_ara_local VALUES (1375,29,28,'北葛城郡河合町');
INSERT INTO sns_ara_local VALUES (1376,29,29,'吉野郡吉野町');
INSERT INTO sns_ara_local VALUES (1377,29,30,'吉野郡大淀町');
INSERT INTO sns_ara_local VALUES (1378,29,31,'吉野郡下市町');
INSERT INTO sns_ara_local VALUES (1379,29,32,'吉野郡黒滝村');
INSERT INTO sns_ara_local VALUES (1380,29,33,'吉野郡天川村');
INSERT INTO sns_ara_local VALUES (1381,29,34,'吉野郡野迫川村');
INSERT INTO sns_ara_local VALUES (1382,29,35,'吉野郡十津川村');
INSERT INTO sns_ara_local VALUES (1383,29,36,'吉野郡下北山村');
INSERT INTO sns_ara_local VALUES (1384,29,37,'吉野郡上北山村');
INSERT INTO sns_ara_local VALUES (1385,29,38,'吉野郡川上村');
INSERT INTO sns_ara_local VALUES (1386,29,39,'吉野郡東吉野村');
INSERT INTO sns_ara_local VALUES (1387,30,1,'和歌山市');
INSERT INTO sns_ara_local VALUES (1388,30,2,'海南市');
INSERT INTO sns_ara_local VALUES (1389,30,3,'橋本市');
INSERT INTO sns_ara_local VALUES (1390,30,4,'有田市');
INSERT INTO sns_ara_local VALUES (1391,30,5,'御坊市');
INSERT INTO sns_ara_local VALUES (1392,30,6,'田辺市');
INSERT INTO sns_ara_local VALUES (1393,30,7,'新宮市');
INSERT INTO sns_ara_local VALUES (1394,30,8,'紀の川市');
INSERT INTO sns_ara_local VALUES (1395,30,9,'岩出市');
INSERT INTO sns_ara_local VALUES (1396,30,10,'海草郡紀美野町');
INSERT INTO sns_ara_local VALUES (1397,30,11,'伊都郡かつらぎ町');
INSERT INTO sns_ara_local VALUES (1398,30,12,'伊都郡九度山町');
INSERT INTO sns_ara_local VALUES (1399,30,13,'伊都郡高野町');
INSERT INTO sns_ara_local VALUES (1400,30,14,'有田郡湯浅町');
INSERT INTO sns_ara_local VALUES (1401,30,15,'有田郡広川町');
INSERT INTO sns_ara_local VALUES (1402,30,16,'有田郡有田川町');
INSERT INTO sns_ara_local VALUES (1403,30,17,'日高郡美浜町');
INSERT INTO sns_ara_local VALUES (1404,30,18,'日高郡日高町');
INSERT INTO sns_ara_local VALUES (1405,30,19,'日高郡由良町');
INSERT INTO sns_ara_local VALUES (1406,30,20,'日高郡印南町');
INSERT INTO sns_ara_local VALUES (1407,30,21,'日高郡みなべ町');
INSERT INTO sns_ara_local VALUES (1408,30,22,'日高郡日高川町');
INSERT INTO sns_ara_local VALUES (1409,30,23,'西牟婁郡白浜町');
INSERT INTO sns_ara_local VALUES (1410,30,24,'西牟婁郡上富田町');
INSERT INTO sns_ara_local VALUES (1411,30,25,'西牟婁郡すさみ町');
INSERT INTO sns_ara_local VALUES (1412,30,26,'東牟婁郡那智勝浦町');
INSERT INTO sns_ara_local VALUES (1413,30,27,'東牟婁郡太地町');
INSERT INTO sns_ara_local VALUES (1414,30,28,'東牟婁郡古座川町');
INSERT INTO sns_ara_local VALUES (1415,30,29,'東牟婁郡北山村');
INSERT INTO sns_ara_local VALUES (1416,30,30,'東牟婁郡串本町');
INSERT INTO sns_ara_local VALUES (1417,31,1,'鳥取市');
INSERT INTO sns_ara_local VALUES (1418,31,2,'米子市');
INSERT INTO sns_ara_local VALUES (1419,31,3,'倉吉市');
INSERT INTO sns_ara_local VALUES (1420,31,4,'境港市');
INSERT INTO sns_ara_local VALUES (1421,31,5,'岩美郡岩美町');
INSERT INTO sns_ara_local VALUES (1422,31,6,'八頭郡若桜町');
INSERT INTO sns_ara_local VALUES (1423,31,7,'八頭郡智頭町');
INSERT INTO sns_ara_local VALUES (1424,31,8,'八頭郡八頭町');
INSERT INTO sns_ara_local VALUES (1425,31,9,'東伯郡三朝町');
INSERT INTO sns_ara_local VALUES (1426,31,10,'東伯郡湯梨浜町');
INSERT INTO sns_ara_local VALUES (1427,31,11,'東伯郡琴浦町');
INSERT INTO sns_ara_local VALUES (1428,31,12,'東伯郡北栄町');
INSERT INTO sns_ara_local VALUES (1429,31,13,'西伯郡日吉津村');
INSERT INTO sns_ara_local VALUES (1430,31,14,'西伯郡大山町');
INSERT INTO sns_ara_local VALUES (1431,31,15,'西伯郡南部町');
INSERT INTO sns_ara_local VALUES (1432,31,16,'西伯郡伯耆町');
INSERT INTO sns_ara_local VALUES (1433,31,17,'日野郡日南町');
INSERT INTO sns_ara_local VALUES (1434,31,18,'日野郡日野町');
INSERT INTO sns_ara_local VALUES (1435,31,19,'日野郡江府町');
INSERT INTO sns_ara_local VALUES (1436,32,1,'松江市');
INSERT INTO sns_ara_local VALUES (1437,32,2,'浜田市');
INSERT INTO sns_ara_local VALUES (1438,32,3,'出雲市');
INSERT INTO sns_ara_local VALUES (1439,32,4,'益田市');
INSERT INTO sns_ara_local VALUES (1440,32,5,'大田市');
INSERT INTO sns_ara_local VALUES (1441,32,6,'安来市');
INSERT INTO sns_ara_local VALUES (1442,32,7,'江津市');
INSERT INTO sns_ara_local VALUES (1443,32,8,'雲南市');
INSERT INTO sns_ara_local VALUES (1444,32,9,'八束郡東出雲町');
INSERT INTO sns_ara_local VALUES (1445,32,10,'仁多郡奥出雲町');
INSERT INTO sns_ara_local VALUES (1446,32,11,'飯石郡飯南町');
INSERT INTO sns_ara_local VALUES (1447,32,12,'簸川郡斐川町');
INSERT INTO sns_ara_local VALUES (1448,32,13,'邑智郡川本町');
INSERT INTO sns_ara_local VALUES (1449,32,14,'邑智郡美郷町');
INSERT INTO sns_ara_local VALUES (1450,32,15,'邑智郡邑南町');
INSERT INTO sns_ara_local VALUES (1451,32,16,'鹿足郡津和野町');
INSERT INTO sns_ara_local VALUES (1452,32,17,'鹿足郡吉賀町');
INSERT INTO sns_ara_local VALUES (1453,32,18,'隠岐郡海士町');
INSERT INTO sns_ara_local VALUES (1454,32,19,'隠岐郡西ノ島町');
INSERT INTO sns_ara_local VALUES (1455,32,20,'隠岐郡知夫村');
INSERT INTO sns_ara_local VALUES (1456,32,21,'隠岐郡隠岐の島町');
INSERT INTO sns_ara_local VALUES (1457,33,1,'岡山市');
INSERT INTO sns_ara_local VALUES (1458,33,2,'倉敷市');
INSERT INTO sns_ara_local VALUES (1459,33,3,'津山市');
INSERT INTO sns_ara_local VALUES (1460,33,4,'玉野市');
INSERT INTO sns_ara_local VALUES (1461,33,5,'笠岡市');
INSERT INTO sns_ara_local VALUES (1462,33,6,'井原市');
INSERT INTO sns_ara_local VALUES (1463,33,7,'総社市');
INSERT INTO sns_ara_local VALUES (1464,33,8,'高梁市');
INSERT INTO sns_ara_local VALUES (1465,33,9,'新見市');
INSERT INTO sns_ara_local VALUES (1466,33,10,'備前市');
INSERT INTO sns_ara_local VALUES (1467,33,11,'瀬戸内市');
INSERT INTO sns_ara_local VALUES (1468,33,12,'赤磐市');
INSERT INTO sns_ara_local VALUES (1469,33,13,'真庭市');
INSERT INTO sns_ara_local VALUES (1470,33,14,'美作市');
INSERT INTO sns_ara_local VALUES (1471,33,15,'浅口市');
INSERT INTO sns_ara_local VALUES (1472,33,16,'御津郡建部町');
INSERT INTO sns_ara_local VALUES (1473,33,17,'赤磐郡瀬戸町');
INSERT INTO sns_ara_local VALUES (1474,33,18,'和気郡和気町');
INSERT INTO sns_ara_local VALUES (1475,33,19,'都窪郡早島町');
INSERT INTO sns_ara_local VALUES (1476,33,20,'浅口郡里庄町');
INSERT INTO sns_ara_local VALUES (1477,33,21,'小田郡矢掛町');
INSERT INTO sns_ara_local VALUES (1478,33,22,'苫田郡鏡野町');
INSERT INTO sns_ara_local VALUES (1479,33,23,'勝田郡勝央町');
INSERT INTO sns_ara_local VALUES (1480,33,24,'勝田郡奈義町');
INSERT INTO sns_ara_local VALUES (1481,33,25,'英田郡西粟倉村');
INSERT INTO sns_ara_local VALUES (1482,33,26,'久米郡久米南町');
INSERT INTO sns_ara_local VALUES (1483,33,27,'久米郡美咲町');
INSERT INTO sns_ara_local VALUES (1484,33,28,'加賀郡吉備中央町');
INSERT INTO sns_ara_local VALUES (1485,34,1,'広島市中区');
INSERT INTO sns_ara_local VALUES (1486,34,2,'広島市東区');
INSERT INTO sns_ara_local VALUES (1487,34,3,'広島市南区');
INSERT INTO sns_ara_local VALUES (1488,34,4,'広島市西区');
INSERT INTO sns_ara_local VALUES (1489,34,5,'広島市安佐南区');
INSERT INTO sns_ara_local VALUES (1490,34,6,'広島市安佐北区');
INSERT INTO sns_ara_local VALUES (1491,34,7,'広島市安芸区');
INSERT INTO sns_ara_local VALUES (1492,34,8,'広島市佐伯区');
INSERT INTO sns_ara_local VALUES (1493,34,9,'呉市');
INSERT INTO sns_ara_local VALUES (1494,34,10,'竹原市');
INSERT INTO sns_ara_local VALUES (1495,34,11,'三原市');
INSERT INTO sns_ara_local VALUES (1496,34,12,'尾道市');
INSERT INTO sns_ara_local VALUES (1497,34,13,'福山市');
INSERT INTO sns_ara_local VALUES (1498,34,14,'府中市');
INSERT INTO sns_ara_local VALUES (1499,34,15,'三次市');
INSERT INTO sns_ara_local VALUES (1500,34,16,'庄原市');
INSERT INTO sns_ara_local VALUES (1501,34,17,'大竹市');
INSERT INTO sns_ara_local VALUES (1502,34,18,'東広島市');
INSERT INTO sns_ara_local VALUES (1503,34,19,'廿日市市');
INSERT INTO sns_ara_local VALUES (1504,34,20,'安芸高田市');
INSERT INTO sns_ara_local VALUES (1505,34,21,'江田島市');
INSERT INTO sns_ara_local VALUES (1506,34,22,'安芸郡海田町');
INSERT INTO sns_ara_local VALUES (1507,34,23,'安芸郡熊野町');
INSERT INTO sns_ara_local VALUES (1508,34,24,'安芸郡坂町');
INSERT INTO sns_ara_local VALUES (1509,34,25,'山県郡安芸太田町');
INSERT INTO sns_ara_local VALUES (1510,34,26,'山県郡北広島町');
INSERT INTO sns_ara_local VALUES (1511,34,27,'豊田郡大崎上島町');
INSERT INTO sns_ara_local VALUES (1512,34,28,'世羅郡世羅町');
INSERT INTO sns_ara_local VALUES (1513,34,29,'神石郡神石高原町');
INSERT INTO sns_ara_local VALUES (1514,35,1,'下関市');
INSERT INTO sns_ara_local VALUES (1515,35,2,'宇部市');
INSERT INTO sns_ara_local VALUES (1516,35,3,'山口市');
INSERT INTO sns_ara_local VALUES (1517,35,4,'萩市');
INSERT INTO sns_ara_local VALUES (1518,35,5,'防府市');
INSERT INTO sns_ara_local VALUES (1519,35,6,'下松市');
INSERT INTO sns_ara_local VALUES (1520,35,7,'岩国市');
INSERT INTO sns_ara_local VALUES (1521,35,8,'光市');
INSERT INTO sns_ara_local VALUES (1522,35,9,'長門市');
INSERT INTO sns_ara_local VALUES (1523,35,10,'柳井市');
INSERT INTO sns_ara_local VALUES (1524,35,11,'美祢市');
INSERT INTO sns_ara_local VALUES (1525,35,12,'周南市');
INSERT INTO sns_ara_local VALUES (1526,35,13,'山陽小野田市');
INSERT INTO sns_ara_local VALUES (1527,35,14,'大島郡周防大島町');
INSERT INTO sns_ara_local VALUES (1528,35,15,'玖珂郡和木町');
INSERT INTO sns_ara_local VALUES (1529,35,16,'熊毛郡上関町');
INSERT INTO sns_ara_local VALUES (1530,35,17,'熊毛郡田布施町');
INSERT INTO sns_ara_local VALUES (1531,35,18,'熊毛郡平生町');
INSERT INTO sns_ara_local VALUES (1532,35,19,'美祢郡美東町');
INSERT INTO sns_ara_local VALUES (1533,35,20,'美祢郡秋芳町');
INSERT INTO sns_ara_local VALUES (1534,35,21,'阿武郡阿武町');
INSERT INTO sns_ara_local VALUES (1535,35,22,'阿武郡阿東町');
INSERT INTO sns_ara_local VALUES (1536,36,1,'徳島市');
INSERT INTO sns_ara_local VALUES (1537,36,2,'鳴門市');
INSERT INTO sns_ara_local VALUES (1538,36,3,'小松島市');
INSERT INTO sns_ara_local VALUES (1539,36,4,'阿南市');
INSERT INTO sns_ara_local VALUES (1540,36,5,'吉野川市');
INSERT INTO sns_ara_local VALUES (1541,36,6,'阿波市');
INSERT INTO sns_ara_local VALUES (1542,36,7,'美馬市');
INSERT INTO sns_ara_local VALUES (1543,36,8,'三好市');
INSERT INTO sns_ara_local VALUES (1544,36,9,'勝浦郡勝浦町');
INSERT INTO sns_ara_local VALUES (1545,36,10,'勝浦郡上勝町');
INSERT INTO sns_ara_local VALUES (1546,36,11,'名東郡佐那河内村');
INSERT INTO sns_ara_local VALUES (1547,36,12,'名西郡石井町');
INSERT INTO sns_ara_local VALUES (1548,36,13,'名西郡神山町');
INSERT INTO sns_ara_local VALUES (1549,36,14,'那賀郡那賀町');
INSERT INTO sns_ara_local VALUES (1550,36,15,'海部郡牟岐町');
INSERT INTO sns_ara_local VALUES (1551,36,16,'海部郡美波町');
INSERT INTO sns_ara_local VALUES (1552,36,17,'海部郡海陽町');
INSERT INTO sns_ara_local VALUES (1553,36,18,'板野郡松茂町');
INSERT INTO sns_ara_local VALUES (1554,36,19,'板野郡北島町');
INSERT INTO sns_ara_local VALUES (1555,36,20,'板野郡藍住町');
INSERT INTO sns_ara_local VALUES (1556,36,21,'板野郡板野町');
INSERT INTO sns_ara_local VALUES (1557,36,22,'板野郡上板町');
INSERT INTO sns_ara_local VALUES (1558,36,23,'美馬郡つるぎ町');
INSERT INTO sns_ara_local VALUES (1559,36,24,'三好郡東みよし町');
INSERT INTO sns_ara_local VALUES (1560,37,1,'高松市');
INSERT INTO sns_ara_local VALUES (1561,37,2,'丸亀市');
INSERT INTO sns_ara_local VALUES (1562,37,3,'坂出市');
INSERT INTO sns_ara_local VALUES (1563,37,4,'善通寺市');
INSERT INTO sns_ara_local VALUES (1564,37,5,'観音寺市');
INSERT INTO sns_ara_local VALUES (1565,37,6,'さぬき市');
INSERT INTO sns_ara_local VALUES (1566,37,7,'東かがわ市');
INSERT INTO sns_ara_local VALUES (1567,37,8,'三豊市');
INSERT INTO sns_ara_local VALUES (1568,37,9,'小豆郡土庄町');
INSERT INTO sns_ara_local VALUES (1569,37,10,'小豆郡小豆島町');
INSERT INTO sns_ara_local VALUES (1570,37,11,'木田郡三木町');
INSERT INTO sns_ara_local VALUES (1571,37,12,'綾歌郡宇多津町');
INSERT INTO sns_ara_local VALUES (1572,37,13,'綾歌郡綾川町');
INSERT INTO sns_ara_local VALUES (1573,37,14,'仲多度郡琴平町');
INSERT INTO sns_ara_local VALUES (1574,37,15,'仲多度郡多度津町');
INSERT INTO sns_ara_local VALUES (1575,37,16,'仲多度郡まんのう町');
INSERT INTO sns_ara_local VALUES (1576,38,1,'松山市');
INSERT INTO sns_ara_local VALUES (1577,38,2,'今治市');
INSERT INTO sns_ara_local VALUES (1578,38,3,'宇和島市');
INSERT INTO sns_ara_local VALUES (1579,38,4,'八幡浜市');
INSERT INTO sns_ara_local VALUES (1580,38,5,'新居浜市');
INSERT INTO sns_ara_local VALUES (1581,38,6,'西条市');
INSERT INTO sns_ara_local VALUES (1582,38,7,'大洲市');
INSERT INTO sns_ara_local VALUES (1583,38,8,'伊予市');
INSERT INTO sns_ara_local VALUES (1584,38,9,'四国中央市');
INSERT INTO sns_ara_local VALUES (1585,38,10,'西予市');
INSERT INTO sns_ara_local VALUES (1586,38,11,'東温市');
INSERT INTO sns_ara_local VALUES (1587,38,12,'越智郡上島町');
INSERT INTO sns_ara_local VALUES (1588,38,13,'上浮穴郡久万高原町');
INSERT INTO sns_ara_local VALUES (1589,38,14,'伊予郡松前町');
INSERT INTO sns_ara_local VALUES (1590,38,15,'伊予郡砥部町');
INSERT INTO sns_ara_local VALUES (1591,38,16,'喜多郡内子町');
INSERT INTO sns_ara_local VALUES (1592,38,17,'西宇和郡伊方町');
INSERT INTO sns_ara_local VALUES (1593,38,18,'北宇和郡松野町');
INSERT INTO sns_ara_local VALUES (1594,38,19,'北宇和郡鬼北町');
INSERT INTO sns_ara_local VALUES (1595,38,20,'南宇和郡愛南町');
INSERT INTO sns_ara_local VALUES (1596,39,1,'高知市');
INSERT INTO sns_ara_local VALUES (1597,39,2,'室戸市');
INSERT INTO sns_ara_local VALUES (1598,39,3,'安芸市');
INSERT INTO sns_ara_local VALUES (1599,39,4,'南国市');
INSERT INTO sns_ara_local VALUES (1600,39,5,'土佐市');
INSERT INTO sns_ara_local VALUES (1601,39,6,'須崎市');
INSERT INTO sns_ara_local VALUES (1602,39,7,'宿毛市');
INSERT INTO sns_ara_local VALUES (1603,39,8,'土佐清水市');
INSERT INTO sns_ara_local VALUES (1604,39,9,'四万十市');
INSERT INTO sns_ara_local VALUES (1605,39,10,'香南市');
INSERT INTO sns_ara_local VALUES (1606,39,11,'香美市');
INSERT INTO sns_ara_local VALUES (1607,39,12,'安芸郡東洋町');
INSERT INTO sns_ara_local VALUES (1608,39,13,'安芸郡奈半利町');
INSERT INTO sns_ara_local VALUES (1609,39,14,'安芸郡安田町');
INSERT INTO sns_ara_local VALUES (1610,39,15,'安芸郡北川村');
INSERT INTO sns_ara_local VALUES (1611,39,16,'安芸郡馬路村');
INSERT INTO sns_ara_local VALUES (1612,39,17,'安芸郡芸西村');
INSERT INTO sns_ara_local VALUES (1613,39,18,'長岡郡本山町');
INSERT INTO sns_ara_local VALUES (1614,39,19,'長岡郡大豊町');
INSERT INTO sns_ara_local VALUES (1615,39,20,'土佐郡土佐町');
INSERT INTO sns_ara_local VALUES (1616,39,21,'土佐郡大川村');
INSERT INTO sns_ara_local VALUES (1617,39,22,'吾川郡春野町');
INSERT INTO sns_ara_local VALUES (1618,39,23,'吾川郡いの町');
INSERT INTO sns_ara_local VALUES (1619,39,24,'吾川郡仁淀川町');
INSERT INTO sns_ara_local VALUES (1620,39,25,'高岡郡中土佐町');
INSERT INTO sns_ara_local VALUES (1621,39,26,'高岡郡佐川町');
INSERT INTO sns_ara_local VALUES (1622,39,27,'高岡郡越知町');
INSERT INTO sns_ara_local VALUES (1623,39,28,'高岡郡檮原町');
INSERT INTO sns_ara_local VALUES (1624,39,29,'高岡郡日高村');
INSERT INTO sns_ara_local VALUES (1625,39,30,'高岡郡津野町');
INSERT INTO sns_ara_local VALUES (1626,39,31,'高岡郡四万十町');
INSERT INTO sns_ara_local VALUES (1627,39,32,'幡多郡大月町');
INSERT INTO sns_ara_local VALUES (1628,39,33,'幡多郡三原村');
INSERT INTO sns_ara_local VALUES (1629,39,34,'幡多郡黒潮町');
INSERT INTO sns_ara_local VALUES (1630,40,1,'北九州市門司区');
INSERT INTO sns_ara_local VALUES (1631,40,2,'北九州市若松区');
INSERT INTO sns_ara_local VALUES (1632,40,3,'北九州市戸畑区');
INSERT INTO sns_ara_local VALUES (1633,40,4,'北九州市小倉北区');
INSERT INTO sns_ara_local VALUES (1634,40,5,'北九州市小倉南区');
INSERT INTO sns_ara_local VALUES (1635,40,6,'北九州市八幡東区');
INSERT INTO sns_ara_local VALUES (1636,40,7,'北九州市八幡西区');
INSERT INTO sns_ara_local VALUES (1637,40,8,'福岡市東区');
INSERT INTO sns_ara_local VALUES (1638,40,9,'福岡市博多区');
INSERT INTO sns_ara_local VALUES (1639,40,10,'福岡市中央区');
INSERT INTO sns_ara_local VALUES (1640,40,11,'福岡市南区');
INSERT INTO sns_ara_local VALUES (1641,40,12,'福岡市西区');
INSERT INTO sns_ara_local VALUES (1642,40,13,'福岡市城南区');
INSERT INTO sns_ara_local VALUES (1643,40,14,'福岡市早良区');
INSERT INTO sns_ara_local VALUES (1644,40,15,'大牟田市');
INSERT INTO sns_ara_local VALUES (1645,40,16,'久留米市');
INSERT INTO sns_ara_local VALUES (1646,40,17,'直方市');
INSERT INTO sns_ara_local VALUES (1647,40,18,'飯塚市');
INSERT INTO sns_ara_local VALUES (1648,40,19,'田川市');
INSERT INTO sns_ara_local VALUES (1649,40,20,'柳川市');
INSERT INTO sns_ara_local VALUES (1650,40,21,'八女市');
INSERT INTO sns_ara_local VALUES (1651,40,22,'筑後市');
INSERT INTO sns_ara_local VALUES (1652,40,23,'大川市');
INSERT INTO sns_ara_local VALUES (1653,40,24,'行橋市');
INSERT INTO sns_ara_local VALUES (1654,40,25,'豊前市');
INSERT INTO sns_ara_local VALUES (1655,40,26,'中間市');
INSERT INTO sns_ara_local VALUES (1656,40,27,'小郡市');
INSERT INTO sns_ara_local VALUES (1657,40,28,'筑紫野市');
INSERT INTO sns_ara_local VALUES (1658,40,29,'春日市');
INSERT INTO sns_ara_local VALUES (1659,40,30,'大野城市');
INSERT INTO sns_ara_local VALUES (1660,40,31,'宗像市');
INSERT INTO sns_ara_local VALUES (1661,40,32,'太宰府市');
INSERT INTO sns_ara_local VALUES (1662,40,33,'前原市');
INSERT INTO sns_ara_local VALUES (1663,40,34,'古賀市');
INSERT INTO sns_ara_local VALUES (1664,40,35,'福津市');
INSERT INTO sns_ara_local VALUES (1665,40,36,'うきは市');
INSERT INTO sns_ara_local VALUES (1666,40,37,'宮若市');
INSERT INTO sns_ara_local VALUES (1667,40,38,'嘉麻市');
INSERT INTO sns_ara_local VALUES (1668,40,39,'朝倉市');
INSERT INTO sns_ara_local VALUES (1669,40,40,'筑紫郡那珂川町');
INSERT INTO sns_ara_local VALUES (1670,40,41,'糟屋郡宇美町');
INSERT INTO sns_ara_local VALUES (1671,40,42,'糟屋郡篠栗町');
INSERT INTO sns_ara_local VALUES (1672,40,43,'糟屋郡志免町');
INSERT INTO sns_ara_local VALUES (1673,40,44,'糟屋郡須惠町');
INSERT INTO sns_ara_local VALUES (1674,40,45,'糟屋郡新宮町');
INSERT INTO sns_ara_local VALUES (1675,40,46,'糟屋郡久山町');
INSERT INTO sns_ara_local VALUES (1676,40,47,'糟屋郡粕屋町');
INSERT INTO sns_ara_local VALUES (1677,40,48,'遠賀郡芦屋町');
INSERT INTO sns_ara_local VALUES (1678,40,49,'遠賀郡水巻町');
INSERT INTO sns_ara_local VALUES (1679,40,50,'遠賀郡岡垣町');
INSERT INTO sns_ara_local VALUES (1680,40,51,'遠賀郡遠賀町');
INSERT INTO sns_ara_local VALUES (1681,40,52,'鞍手郡小竹町');
INSERT INTO sns_ara_local VALUES (1682,40,53,'鞍手郡鞍手町');
INSERT INTO sns_ara_local VALUES (1683,40,54,'嘉穂郡桂川町');
INSERT INTO sns_ara_local VALUES (1684,40,55,'朝倉郡筑前町');
INSERT INTO sns_ara_local VALUES (1685,40,56,'朝倉郡東峰村');
INSERT INTO sns_ara_local VALUES (1686,40,57,'糸島郡二丈町');
INSERT INTO sns_ara_local VALUES (1687,40,58,'糸島郡志摩町');
INSERT INTO sns_ara_local VALUES (1688,40,59,'三井郡大刀洗町');
INSERT INTO sns_ara_local VALUES (1689,40,60,'三潴郡大木町');
INSERT INTO sns_ara_local VALUES (1690,40,61,'八女郡黒木町');
INSERT INTO sns_ara_local VALUES (1691,40,62,'八女郡上陽町');
INSERT INTO sns_ara_local VALUES (1692,40,63,'八女郡立花町');
INSERT INTO sns_ara_local VALUES (1693,40,64,'八女郡広川町');
INSERT INTO sns_ara_local VALUES (1694,40,65,'八女郡矢部村');
INSERT INTO sns_ara_local VALUES (1695,40,66,'山門郡瀬高町');
INSERT INTO sns_ara_local VALUES (1696,40,67,'山門郡山川町');
INSERT INTO sns_ara_local VALUES (1697,40,68,'三池郡高田町');
INSERT INTO sns_ara_local VALUES (1698,40,69,'田川郡香春町');
INSERT INTO sns_ara_local VALUES (1699,40,70,'田川郡添田町');
INSERT INTO sns_ara_local VALUES (1700,40,71,'田川郡糸田町');
INSERT INTO sns_ara_local VALUES (1701,40,72,'田川郡川崎町');
INSERT INTO sns_ara_local VALUES (1702,40,73,'田川郡大任町');
INSERT INTO sns_ara_local VALUES (1703,40,74,'田川郡赤村');
INSERT INTO sns_ara_local VALUES (1704,40,75,'田川郡福智町');
INSERT INTO sns_ara_local VALUES (1705,40,76,'京都郡苅田町');
INSERT INTO sns_ara_local VALUES (1706,40,77,'京都郡みやこ町');
INSERT INTO sns_ara_local VALUES (1707,40,78,'築上郡吉富町');
INSERT INTO sns_ara_local VALUES (1708,40,79,'築上郡上毛町');
INSERT INTO sns_ara_local VALUES (1709,40,80,'築上郡築上町');
INSERT INTO sns_ara_local VALUES (1710,41,1,'佐賀市');
INSERT INTO sns_ara_local VALUES (1711,41,2,'唐津市');
INSERT INTO sns_ara_local VALUES (1712,41,3,'鳥栖市');
INSERT INTO sns_ara_local VALUES (1713,41,4,'多久市');
INSERT INTO sns_ara_local VALUES (1714,41,5,'伊万里市');
INSERT INTO sns_ara_local VALUES (1715,41,6,'武雄市');
INSERT INTO sns_ara_local VALUES (1716,41,7,'鹿島市');
INSERT INTO sns_ara_local VALUES (1717,41,8,'小城市');
INSERT INTO sns_ara_local VALUES (1718,41,9,'嬉野市');
INSERT INTO sns_ara_local VALUES (1719,41,10,'神埼市');
INSERT INTO sns_ara_local VALUES (1720,41,11,'佐賀郡川副町');
INSERT INTO sns_ara_local VALUES (1721,41,12,'佐賀郡東与賀町');
INSERT INTO sns_ara_local VALUES (1722,41,13,'佐賀郡久保田町');
INSERT INTO sns_ara_local VALUES (1723,41,14,'神埼郡吉野ケ里町');
INSERT INTO sns_ara_local VALUES (1724,41,15,'三養基郡基山町');
INSERT INTO sns_ara_local VALUES (1725,41,16,'三養基郡上峰町');
INSERT INTO sns_ara_local VALUES (1726,41,17,'三養基郡みやき町');
INSERT INTO sns_ara_local VALUES (1727,41,18,'東松浦郡玄海町');
INSERT INTO sns_ara_local VALUES (1728,41,19,'西松浦郡有田町');
INSERT INTO sns_ara_local VALUES (1729,41,20,'杵島郡大町町');
INSERT INTO sns_ara_local VALUES (1730,41,21,'杵島郡江北町');
INSERT INTO sns_ara_local VALUES (1731,41,22,'杵島郡白石町');
INSERT INTO sns_ara_local VALUES (1732,41,23,'藤津郡太良町');
INSERT INTO sns_ara_local VALUES (1733,42,1,'長崎市');
INSERT INTO sns_ara_local VALUES (1734,42,2,'佐世保市');
INSERT INTO sns_ara_local VALUES (1735,42,3,'島原市');
INSERT INTO sns_ara_local VALUES (1736,42,4,'諫早市');
INSERT INTO sns_ara_local VALUES (1737,42,5,'大村市');
INSERT INTO sns_ara_local VALUES (1738,42,6,'平戸市');
INSERT INTO sns_ara_local VALUES (1739,42,7,'松浦市');
INSERT INTO sns_ara_local VALUES (1740,42,8,'対馬市');
INSERT INTO sns_ara_local VALUES (1741,42,9,'壱岐市');
INSERT INTO sns_ara_local VALUES (1742,42,10,'五島市');
INSERT INTO sns_ara_local VALUES (1743,42,11,'西海市');
INSERT INTO sns_ara_local VALUES (1744,42,12,'雲仙市');
INSERT INTO sns_ara_local VALUES (1745,42,13,'南島原市');
INSERT INTO sns_ara_local VALUES (1746,42,14,'西彼杵郡長与町');
INSERT INTO sns_ara_local VALUES (1747,42,15,'西彼杵郡時津町');
INSERT INTO sns_ara_local VALUES (1748,42,16,'東彼杵郡東彼杵町');
INSERT INTO sns_ara_local VALUES (1749,42,17,'東彼杵郡川棚町');
INSERT INTO sns_ara_local VALUES (1750,42,18,'東彼杵郡波佐見町');
INSERT INTO sns_ara_local VALUES (1751,42,19,'北松浦郡小値賀町');
INSERT INTO sns_ara_local VALUES (1752,42,20,'北松浦郡江迎町');
INSERT INTO sns_ara_local VALUES (1753,42,21,'北松浦郡鹿町町');
INSERT INTO sns_ara_local VALUES (1754,42,22,'北松浦郡佐々町');
INSERT INTO sns_ara_local VALUES (1755,42,23,'南松浦郡新上五島町');
INSERT INTO sns_ara_local VALUES (1756,43,1,'熊本市');
INSERT INTO sns_ara_local VALUES (1757,43,2,'八代市');
INSERT INTO sns_ara_local VALUES (1758,43,3,'人吉市');
INSERT INTO sns_ara_local VALUES (1759,43,4,'荒尾市');
INSERT INTO sns_ara_local VALUES (1760,43,5,'水俣市');
INSERT INTO sns_ara_local VALUES (1761,43,6,'玉名市');
INSERT INTO sns_ara_local VALUES (1762,43,7,'山鹿市');
INSERT INTO sns_ara_local VALUES (1763,43,8,'菊池市');
INSERT INTO sns_ara_local VALUES (1764,43,9,'宇土市');
INSERT INTO sns_ara_local VALUES (1765,43,10,'上天草市');
INSERT INTO sns_ara_local VALUES (1766,43,11,'宇城市');
INSERT INTO sns_ara_local VALUES (1767,43,12,'阿蘇市');
INSERT INTO sns_ara_local VALUES (1768,43,13,'天草市');
INSERT INTO sns_ara_local VALUES (1769,43,14,'合志市');
INSERT INTO sns_ara_local VALUES (1770,43,15,'下益城郡城南町');
INSERT INTO sns_ara_local VALUES (1771,43,16,'下益城郡富合町');
INSERT INTO sns_ara_local VALUES (1772,43,17,'下益城郡美里町');
INSERT INTO sns_ara_local VALUES (1773,43,18,'玉名郡玉東町');
INSERT INTO sns_ara_local VALUES (1774,43,19,'玉名郡南関町');
INSERT INTO sns_ara_local VALUES (1775,43,20,'玉名郡長洲町');
INSERT INTO sns_ara_local VALUES (1776,43,21,'玉名郡和水町');
INSERT INTO sns_ara_local VALUES (1777,43,22,'鹿本郡植木町');
INSERT INTO sns_ara_local VALUES (1778,43,23,'菊池郡大津町');
INSERT INTO sns_ara_local VALUES (1779,43,24,'菊池郡菊陽町');
INSERT INTO sns_ara_local VALUES (1780,43,25,'阿蘇郡南小国町');
INSERT INTO sns_ara_local VALUES (1781,43,26,'阿蘇郡小国町');
INSERT INTO sns_ara_local VALUES (1782,43,27,'阿蘇郡産山村');
INSERT INTO sns_ara_local VALUES (1783,43,28,'阿蘇郡高森町');
INSERT INTO sns_ara_local VALUES (1784,43,29,'阿蘇郡西原村');
INSERT INTO sns_ara_local VALUES (1785,43,30,'阿蘇郡南阿蘇村');
INSERT INTO sns_ara_local VALUES (1786,43,31,'上益城郡御船町');
INSERT INTO sns_ara_local VALUES (1787,43,32,'上益城郡嘉島町');
INSERT INTO sns_ara_local VALUES (1788,43,33,'上益城郡益城町');
INSERT INTO sns_ara_local VALUES (1789,43,34,'上益城郡甲佐町');
INSERT INTO sns_ara_local VALUES (1790,43,35,'上益城郡山都町');
INSERT INTO sns_ara_local VALUES (1791,43,36,'八代郡氷川町');
INSERT INTO sns_ara_local VALUES (1792,43,37,'葦北郡芦北町');
INSERT INTO sns_ara_local VALUES (1793,43,38,'葦北郡津奈木町');
INSERT INTO sns_ara_local VALUES (1794,43,39,'球磨郡錦町');
INSERT INTO sns_ara_local VALUES (1795,43,40,'球磨郡多良木町');
INSERT INTO sns_ara_local VALUES (1796,43,41,'球磨郡湯前町');
INSERT INTO sns_ara_local VALUES (1797,43,42,'球磨郡水上村');
INSERT INTO sns_ara_local VALUES (1798,43,43,'球磨郡相良村');
INSERT INTO sns_ara_local VALUES (1799,43,44,'球磨郡五木村');
INSERT INTO sns_ara_local VALUES (1800,43,45,'球磨郡山江村');
INSERT INTO sns_ara_local VALUES (1801,43,46,'球磨郡球磨村');
INSERT INTO sns_ara_local VALUES (1802,43,47,'球磨郡あさぎり町');
INSERT INTO sns_ara_local VALUES (1803,43,48,'天草郡苓北町');
INSERT INTO sns_ara_local VALUES (1804,44,1,'大分市');
INSERT INTO sns_ara_local VALUES (1805,44,2,'別府市');
INSERT INTO sns_ara_local VALUES (1806,44,3,'中津市');
INSERT INTO sns_ara_local VALUES (1807,44,4,'日田市');
INSERT INTO sns_ara_local VALUES (1808,44,5,'佐伯市');
INSERT INTO sns_ara_local VALUES (1809,44,6,'臼杵市');
INSERT INTO sns_ara_local VALUES (1810,44,7,'津久見市');
INSERT INTO sns_ara_local VALUES (1811,44,8,'竹田市');
INSERT INTO sns_ara_local VALUES (1812,44,9,'豊後高田市');
INSERT INTO sns_ara_local VALUES (1813,44,10,'杵築市');
INSERT INTO sns_ara_local VALUES (1814,44,11,'宇佐市');
INSERT INTO sns_ara_local VALUES (1815,44,12,'豊後大野市');
INSERT INTO sns_ara_local VALUES (1816,44,13,'由布市');
INSERT INTO sns_ara_local VALUES (1817,44,14,'国東市');
INSERT INTO sns_ara_local VALUES (1818,44,15,'速見郡日出町');
INSERT INTO sns_ara_local VALUES (1819,44,16,'玖珠郡九重町');
INSERT INTO sns_ara_local VALUES (1820,44,17,'玖珠郡玖珠町');
INSERT INTO sns_ara_local VALUES (1821,45,1,'宮崎市');
INSERT INTO sns_ara_local VALUES (1822,45,2,'都城市');
INSERT INTO sns_ara_local VALUES (1823,45,3,'延岡市');
INSERT INTO sns_ara_local VALUES (1824,45,4,'日南市');
INSERT INTO sns_ara_local VALUES (1825,45,5,'小林市');
INSERT INTO sns_ara_local VALUES (1826,45,6,'日向市');
INSERT INTO sns_ara_local VALUES (1827,45,7,'串間市');
INSERT INTO sns_ara_local VALUES (1828,45,8,'西都市');
INSERT INTO sns_ara_local VALUES (1829,45,9,'えびの市');
INSERT INTO sns_ara_local VALUES (1830,45,10,'宮崎郡清武町');
INSERT INTO sns_ara_local VALUES (1831,45,11,'南那珂郡北郷町');
INSERT INTO sns_ara_local VALUES (1832,45,12,'南那珂郡南郷町');
INSERT INTO sns_ara_local VALUES (1833,45,13,'北諸県郡三股町');
INSERT INTO sns_ara_local VALUES (1834,45,14,'西諸県郡高原町');
INSERT INTO sns_ara_local VALUES (1835,45,15,'西諸県郡野尻町');
INSERT INTO sns_ara_local VALUES (1836,45,16,'東諸県郡国富町');
INSERT INTO sns_ara_local VALUES (1837,45,17,'東諸県郡綾町');
INSERT INTO sns_ara_local VALUES (1838,45,18,'児湯郡高鍋町');
INSERT INTO sns_ara_local VALUES (1839,45,19,'児湯郡新富町');
INSERT INTO sns_ara_local VALUES (1840,45,20,'児湯郡西米良村');
INSERT INTO sns_ara_local VALUES (1841,45,21,'児湯郡木城町');
INSERT INTO sns_ara_local VALUES (1842,45,22,'児湯郡川南町');
INSERT INTO sns_ara_local VALUES (1843,45,23,'児湯郡都農町');
INSERT INTO sns_ara_local VALUES (1844,45,24,'東臼杵郡門川町');
INSERT INTO sns_ara_local VALUES (1845,45,25,'東臼杵郡北川町');
INSERT INTO sns_ara_local VALUES (1846,45,26,'東臼杵郡諸塚村');
INSERT INTO sns_ara_local VALUES (1847,45,27,'東臼杵郡椎葉村');
INSERT INTO sns_ara_local VALUES (1848,45,28,'東臼杵郡美郷町');
INSERT INTO sns_ara_local VALUES (1849,45,29,'西臼杵郡高千穂町');
INSERT INTO sns_ara_local VALUES (1850,45,30,'西臼杵郡日之影町');
INSERT INTO sns_ara_local VALUES (1851,45,31,'西臼杵郡五ケ瀬町');
INSERT INTO sns_ara_local VALUES (1852,46,1,'鹿児島市');
INSERT INTO sns_ara_local VALUES (1853,46,2,'鹿屋市');
INSERT INTO sns_ara_local VALUES (1854,46,3,'枕崎市');
INSERT INTO sns_ara_local VALUES (1855,46,4,'阿久根市');
INSERT INTO sns_ara_local VALUES (1856,46,5,'出水市');
INSERT INTO sns_ara_local VALUES (1857,46,6,'大口市');
INSERT INTO sns_ara_local VALUES (1858,46,7,'指宿市');
INSERT INTO sns_ara_local VALUES (1859,46,8,'西之表市');
INSERT INTO sns_ara_local VALUES (1860,46,9,'垂水市');
INSERT INTO sns_ara_local VALUES (1861,46,10,'薩摩川内市');
INSERT INTO sns_ara_local VALUES (1862,46,11,'日置市');
INSERT INTO sns_ara_local VALUES (1863,46,12,'曽於市');
INSERT INTO sns_ara_local VALUES (1864,46,13,'霧島市');
INSERT INTO sns_ara_local VALUES (1865,46,14,'いちき串木野市');
INSERT INTO sns_ara_local VALUES (1866,46,15,'南さつま市');
INSERT INTO sns_ara_local VALUES (1867,46,16,'志布志市');
INSERT INTO sns_ara_local VALUES (1868,46,17,'奄美市');
INSERT INTO sns_ara_local VALUES (1869,46,18,'鹿児島郡三島村');
INSERT INTO sns_ara_local VALUES (1870,46,19,'鹿児島郡十島村');
INSERT INTO sns_ara_local VALUES (1871,46,20,'揖宿郡頴娃町');
INSERT INTO sns_ara_local VALUES (1872,46,21,'川辺郡知覧町');
INSERT INTO sns_ara_local VALUES (1873,46,22,'川辺郡川辺町');
INSERT INTO sns_ara_local VALUES (1874,46,23,'薩摩郡さつま町');
INSERT INTO sns_ara_local VALUES (1875,46,24,'出水郡長島町');
INSERT INTO sns_ara_local VALUES (1876,46,25,'伊佐郡菱刈町');
INSERT INTO sns_ara_local VALUES (1877,46,26,'姶良郡加治木町');
INSERT INTO sns_ara_local VALUES (1878,46,27,'姶良郡姶良町');
INSERT INTO sns_ara_local VALUES (1879,46,28,'姶良郡蒲生町');
INSERT INTO sns_ara_local VALUES (1880,46,29,'姶良郡湧水町');
INSERT INTO sns_ara_local VALUES (1881,46,30,'曽於郡大崎町');
INSERT INTO sns_ara_local VALUES (1882,46,31,'肝属郡東串良町');
INSERT INTO sns_ara_local VALUES (1883,46,32,'肝属郡錦江町');
INSERT INTO sns_ara_local VALUES (1884,46,33,'肝属郡南大隅町');
INSERT INTO sns_ara_local VALUES (1885,46,34,'肝属郡肝付町');
INSERT INTO sns_ara_local VALUES (1886,46,35,'熊毛郡中種子町');
INSERT INTO sns_ara_local VALUES (1887,46,36,'熊毛郡南種子町');
INSERT INTO sns_ara_local VALUES (1888,46,37,'熊毛郡上屋久町');
INSERT INTO sns_ara_local VALUES (1889,46,38,'熊毛郡屋久町');
INSERT INTO sns_ara_local VALUES (1890,46,39,'大島郡大和村');
INSERT INTO sns_ara_local VALUES (1891,46,40,'大島郡宇検村');
INSERT INTO sns_ara_local VALUES (1892,46,41,'大島郡瀬戸内町');
INSERT INTO sns_ara_local VALUES (1893,46,42,'大島郡龍郷町');
INSERT INTO sns_ara_local VALUES (1894,46,43,'大島郡喜界町');
INSERT INTO sns_ara_local VALUES (1895,46,44,'大島郡徳之島町');
INSERT INTO sns_ara_local VALUES (1896,46,45,'大島郡天城町');
INSERT INTO sns_ara_local VALUES (1897,46,46,'大島郡伊仙町');
INSERT INTO sns_ara_local VALUES (1898,46,47,'大島郡和泊町');
INSERT INTO sns_ara_local VALUES (1899,46,48,'大島郡知名町');
INSERT INTO sns_ara_local VALUES (1900,46,49,'大島郡与論町');
INSERT INTO sns_ara_local VALUES (1901,47,1,'那覇市');
INSERT INTO sns_ara_local VALUES (1902,47,2,'宜野湾市');
INSERT INTO sns_ara_local VALUES (1903,47,3,'石垣市');
INSERT INTO sns_ara_local VALUES (1904,47,4,'浦添市');
INSERT INTO sns_ara_local VALUES (1905,47,5,'名護市');
INSERT INTO sns_ara_local VALUES (1906,47,6,'糸満市');
INSERT INTO sns_ara_local VALUES (1907,47,7,'沖縄市');
INSERT INTO sns_ara_local VALUES (1908,47,8,'豊見城市');
INSERT INTO sns_ara_local VALUES (1909,47,9,'うるま市');
INSERT INTO sns_ara_local VALUES (1910,47,10,'宮古島市');
INSERT INTO sns_ara_local VALUES (1911,47,11,'南城市');
INSERT INTO sns_ara_local VALUES (1912,47,12,'国頭郡国頭村');
INSERT INTO sns_ara_local VALUES (1913,47,13,'国頭郡大宜味村');
INSERT INTO sns_ara_local VALUES (1914,47,14,'国頭郡東村');
INSERT INTO sns_ara_local VALUES (1915,47,15,'国頭郡今帰仁村');
INSERT INTO sns_ara_local VALUES (1916,47,16,'国頭郡本部町');
INSERT INTO sns_ara_local VALUES (1917,47,17,'国頭郡恩納村');
INSERT INTO sns_ara_local VALUES (1918,47,18,'国頭郡宜野座村');
INSERT INTO sns_ara_local VALUES (1919,47,19,'国頭郡金武町');
INSERT INTO sns_ara_local VALUES (1920,47,20,'国頭郡伊江村');
INSERT INTO sns_ara_local VALUES (1921,47,21,'中頭郡読谷村');
INSERT INTO sns_ara_local VALUES (1922,47,22,'中頭郡嘉手納町');
INSERT INTO sns_ara_local VALUES (1923,47,23,'中頭郡北谷町');
INSERT INTO sns_ara_local VALUES (1924,47,24,'中頭郡北中城村');
INSERT INTO sns_ara_local VALUES (1925,47,25,'中頭郡中城村');
INSERT INTO sns_ara_local VALUES (1926,47,26,'中頭郡西原町');
INSERT INTO sns_ara_local VALUES (1927,47,27,'島尻郡与那原町');
INSERT INTO sns_ara_local VALUES (1928,47,28,'島尻郡南風原町');
INSERT INTO sns_ara_local VALUES (1929,47,29,'島尻郡渡嘉敷村');
INSERT INTO sns_ara_local VALUES (1930,47,30,'島尻郡座間味村');
INSERT INTO sns_ara_local VALUES (1931,47,31,'島尻郡粟国村');
INSERT INTO sns_ara_local VALUES (1932,47,32,'島尻郡南大東村');
INSERT INTO sns_ara_local VALUES (1933,47,33,'島尻郡北大東村');
INSERT INTO sns_ara_local VALUES (1934,47,34,'島尻郡伊平屋村');
INSERT INTO sns_ara_local VALUES (1935,47,35,'島尻郡伊是名村');
INSERT INTO sns_ara_local VALUES (1936,47,36,'島尻郡久米島町');
INSERT INTO sns_ara_local VALUES (1937,47,37,'島尻郡八重瀬町');
INSERT INTO sns_ara_local VALUES (1938,47,38,'宮古郡多良間村');
INSERT INTO sns_ara_local VALUES (1939,47,39,'八重山郡竹富町');
INSERT INTO sns_ara_local VALUES (1940,47,40,'八重山郡与那国町');

-- 
-- 都道府県
-- 
INSERT INTO sns_ara_prefecture VALUES (1,1,1,'北海道');
INSERT INTO sns_ara_prefecture VALUES (2,1,2,'青森県');
INSERT INTO sns_ara_prefecture VALUES (3,1,3,'岩手県');
INSERT INTO sns_ara_prefecture VALUES (4,1,4,'宮城県');
INSERT INTO sns_ara_prefecture VALUES (5,1,5,'秋田県');
INSERT INTO sns_ara_prefecture VALUES (6,1,6,'山形県');
INSERT INTO sns_ara_prefecture VALUES (7,1,7,'福島県');
INSERT INTO sns_ara_prefecture VALUES (8,2,8,'茨城県');
INSERT INTO sns_ara_prefecture VALUES (9,2,9,'栃木県');
INSERT INTO sns_ara_prefecture VALUES (10,2,10,'群馬県');
INSERT INTO sns_ara_prefecture VALUES (11,2,11,'埼玉県');
INSERT INTO sns_ara_prefecture VALUES (12,2,12,'千葉県');
INSERT INTO sns_ara_prefecture VALUES (13,2,13,'東京都');
INSERT INTO sns_ara_prefecture VALUES (14,2,14,'神奈川県');
INSERT INTO sns_ara_prefecture VALUES (15,2,15,'新潟県');
INSERT INTO sns_ara_prefecture VALUES (16,3,16,'富山県');
INSERT INTO sns_ara_prefecture VALUES (17,3,17,'石川県');
INSERT INTO sns_ara_prefecture VALUES (18,3,18,'福井県');
INSERT INTO sns_ara_prefecture VALUES (19,2,19,'山梨県');
INSERT INTO sns_ara_prefecture VALUES (20,2,20,'長野県');
INSERT INTO sns_ara_prefecture VALUES (21,3,21,'岐阜県');
INSERT INTO sns_ara_prefecture VALUES (22,3,22,'静岡県');
INSERT INTO sns_ara_prefecture VALUES (23,3,23,'愛知県');
INSERT INTO sns_ara_prefecture VALUES (24,3,24,'三重県');
INSERT INTO sns_ara_prefecture VALUES (25,4,25,'滋賀県');
INSERT INTO sns_ara_prefecture VALUES (26,4,26,'京都府');
INSERT INTO sns_ara_prefecture VALUES (27,4,27,'大阪府');
INSERT INTO sns_ara_prefecture VALUES (28,4,28,'兵庫県');
INSERT INTO sns_ara_prefecture VALUES (29,4,29,'奈良県');
INSERT INTO sns_ara_prefecture VALUES (30,4,30,'和歌山県');
INSERT INTO sns_ara_prefecture VALUES (31,5,31,'鳥取県');
INSERT INTO sns_ara_prefecture VALUES (32,5,32,'島根県');
INSERT INTO sns_ara_prefecture VALUES (33,5,33,'岡山県');
INSERT INTO sns_ara_prefecture VALUES (34,5,34,'広島県');
INSERT INTO sns_ara_prefecture VALUES (35,5,35,'山口県');
INSERT INTO sns_ara_prefecture VALUES (36,5,36,'徳島県');
INSERT INTO sns_ara_prefecture VALUES (37,5,37,'香川県');
INSERT INTO sns_ara_prefecture VALUES (38,5,38,'愛媛県');
INSERT INTO sns_ara_prefecture VALUES (39,5,39,'高知県');
INSERT INTO sns_ara_prefecture VALUES (40,6,40,'福岡県');
INSERT INTO sns_ara_prefecture VALUES (41,6,41,'佐賀県');
INSERT INTO sns_ara_prefecture VALUES (42,6,42,'長崎県');
INSERT INTO sns_ara_prefecture VALUES (43,6,43,'熊本県');
INSERT INTO sns_ara_prefecture VALUES (44,6,44,'大分県');
INSERT INTO sns_ara_prefecture VALUES (45,6,45,'宮崎県');
INSERT INTO sns_ara_prefecture VALUES (46,6,46,'鹿児島県');
INSERT INTO sns_ara_prefecture VALUES (47,6,47,'沖縄県');
INSERT INTO sns_ara_prefecture VALUES (48,7,48,'海外');
INSERT INTO sns_ara_prefecture VALUES (49,7,49,'その他');

-- 
-- フォーラムジャンル
-- 
INSERT INTO sns_frm_genre VALUES (1, 1, 'エンターテイメント');
INSERT INTO sns_frm_genre VALUES (2, 2, '趣味・芸術・文化');
INSERT INTO sns_frm_genre VALUES (3, 3, 'コンピュータ・インターネット');
INSERT INTO sns_frm_genre VALUES (4, 4, 'スポーツ・レジャー');
INSERT INTO sns_frm_genre VALUES (5, 5, '学問');
INSERT INTO sns_frm_genre VALUES (6, 6, 'ゲーム');
INSERT INTO sns_frm_genre VALUES (7, 7, 'ライフスタイル');
INSERT INTO sns_frm_genre VALUES (8, 8, 'ビジネス・経済');

-- 
-- フォーラムカテゴリ
-- 
INSERT INTO sns_frm_category VALUES (1, 1, 1, '音楽');
INSERT INTO sns_frm_category VALUES (2, 1, 2, '芸能人・タレント');
INSERT INTO sns_frm_category VALUES (3, 1, 3, 'アニメ・まんが');
INSERT INTO sns_frm_category VALUES (4, 1, 4, '映画・舞台');
INSERT INTO sns_frm_category VALUES (5, 1, 5, 'お笑い');
INSERT INTO sns_frm_category VALUES (6, 1, 6, 'テレビ・ラジオ');
INSERT INTO sns_frm_category VALUES (7, 2, 1, '写真・カメラ');
INSERT INTO sns_frm_category VALUES (8, 2, 2, '鉄道・列車');
INSERT INTO sns_frm_category VALUES (9, 2, 3, '模型・フィギア');
INSERT INTO sns_frm_category VALUES (10, 2, 4, '工芸・手芸');
INSERT INTO sns_frm_category VALUES (11, 2, 5, '絵画・書道');
INSERT INTO sns_frm_category VALUES (12, 2, 6, '文化・カルチャー');
INSERT INTO sns_frm_category VALUES (13, 3, 1, 'ハードウェア');
INSERT INTO sns_frm_category VALUES (14, 3, 2, 'インターネット');
INSERT INTO sns_frm_category VALUES (15, 3, 3, '掲示板');
INSERT INTO sns_frm_category VALUES (16, 3, 4, 'ＳＮＳ・ブログ');
INSERT INTO sns_frm_category VALUES (17, 3, 5, 'プログラミング');
INSERT INTO sns_frm_category VALUES (18, 3, 6, 'お悩み・相談');
INSERT INTO sns_frm_category VALUES (19, 4, 1, '野球');
INSERT INTO sns_frm_category VALUES (20, 4, 2, 'サッカー');
INSERT INTO sns_frm_category VALUES (21, 4, 3, 'ゴルフ');
INSERT INTO sns_frm_category VALUES (22, 4, 4, '釣り');
INSERT INTO sns_frm_category VALUES (23, 4, 5, '球技');
INSERT INTO sns_frm_category VALUES (24, 4, 6, 'マリンスポーツ');
INSERT INTO sns_frm_category VALUES (25, 4, 7, 'カースポーツ');
INSERT INTO sns_frm_category VALUES (26, 4, 8, 'ボクシング');
INSERT INTO sns_frm_category VALUES (27, 4, 9, 'フィットネス');
INSERT INTO sns_frm_category VALUES (28, 4, 10, '旅行・観光');
INSERT INTO sns_frm_category VALUES (29, 4, 11, 'キャンプ');
INSERT INTO sns_frm_category VALUES (30, 4, 12, '遊園地・施設');
INSERT INTO sns_frm_category VALUES (31, 5, 1, '大学');
INSERT INTO sns_frm_category VALUES (32, 5, 2, '高校');
INSERT INTO sns_frm_category VALUES (33, 5, 3, '生涯学習');
INSERT INTO sns_frm_category VALUES (34, 5, 4, '各種言語');
INSERT INTO sns_frm_category VALUES (35, 5, 5, '脳トレーニング');
INSERT INTO sns_frm_category VALUES (36, 5, 6, '資格・試験');
INSERT INTO sns_frm_category VALUES (37, 6, 1, 'テレビゲーム');
INSERT INTO sns_frm_category VALUES (38, 6, 2, 'テーブルゲーム');
INSERT INTO sns_frm_category VALUES (39, 6, 3, 'モバイルゲーム');
INSERT INTO sns_frm_category VALUES (40, 6, 4, 'フィールドゲーム');
INSERT INTO sns_frm_category VALUES (41, 6, 5, 'オンラインゲーム');
INSERT INTO sns_frm_category VALUES (42, 6, 6, 'ギャンブル');
INSERT INTO sns_frm_category VALUES (43, 7, 1, 'お金・株');
INSERT INTO sns_frm_category VALUES (44, 7, 2, '人間関係');
INSERT INTO sns_frm_category VALUES (45, 7, 3, '結婚');
INSERT INTO sns_frm_category VALUES (46, 7, 4, '子供');
INSERT INTO sns_frm_category VALUES (47, 7, 5, 'ペット');
INSERT INTO sns_frm_category VALUES (48, 7, 6, 'お悩み・相談');
INSERT INTO sns_frm_category VALUES (49, 8, 1, 'ショッピング');
INSERT INTO sns_frm_category VALUES (50, 8, 2, '仕事・キャリア');
INSERT INTO sns_frm_category VALUES (51, 8, 3, '株式・企業');
INSERT INTO sns_frm_category VALUES (52, 8, 4, '起業・経営');
INSERT INTO sns_frm_category VALUES (53, 8, 5, '経済・マネー');
INSERT INTO sns_frm_category VALUES (54, 8, 6, 'モラル・マナー');

-- 
-- コミュニティジャンル
-- 
INSERT INTO sns_com_genre VALUES (1, 1, 'エンターテイメント');
INSERT INTO sns_com_genre VALUES (2, 2, '趣味・芸術・文化');
INSERT INTO sns_com_genre VALUES (3, 3, 'コンピュータ・インターネット');
INSERT INTO sns_com_genre VALUES (4, 4, 'スポーツ・レジャー');
INSERT INTO sns_com_genre VALUES (5, 5, '学問');
INSERT INTO sns_com_genre VALUES (6, 6, 'ゲーム');
INSERT INTO sns_com_genre VALUES (7, 7, 'ライフスタイル');
INSERT INTO sns_com_genre VALUES (8, 8, 'ビジネス・経済');

-- 
-- コミュニティカテゴリ
-- 
INSERT INTO sns_com_category VALUES (1, 1, 1, '音楽');
INSERT INTO sns_com_category VALUES (2, 1, 2, '芸能人・タレント');
INSERT INTO sns_com_category VALUES (3, 1, 3, 'アニメ・まんが');
INSERT INTO sns_com_category VALUES (4, 1, 4, '映画・舞台');
INSERT INTO sns_com_category VALUES (5, 1, 5, 'お笑い');
INSERT INTO sns_com_category VALUES (6, 1, 6, 'テレビ・ラジオ');
INSERT INTO sns_com_category VALUES (7, 2, 1, '写真・カメラ');
INSERT INTO sns_com_category VALUES (8, 2, 2, '鉄道・列車');
INSERT INTO sns_com_category VALUES (9, 2, 3, '模型・フィギア');
INSERT INTO sns_com_category VALUES (10, 2, 4, '工芸・手芸');
INSERT INTO sns_com_category VALUES (11, 2, 5, '絵画・書道');
INSERT INTO sns_com_category VALUES (12, 2, 6, '文化・カルチャー');
INSERT INTO sns_com_category VALUES (13, 3, 1, 'ハードウェア');
INSERT INTO sns_com_category VALUES (14, 3, 2, 'インターネット');
INSERT INTO sns_com_category VALUES (15, 3, 3, '掲示板');
INSERT INTO sns_com_category VALUES (16, 3, 4, 'ＳＮＳ・ブログ');
INSERT INTO sns_com_category VALUES (17, 3, 5, 'プログラミング');
INSERT INTO sns_com_category VALUES (18, 3, 6, 'お悩み・相談');
INSERT INTO sns_com_category VALUES (19, 4, 1, '野球');
INSERT INTO sns_com_category VALUES (20, 4, 2, 'サッカー');
INSERT INTO sns_com_category VALUES (21, 4, 3, 'ゴルフ');
INSERT INTO sns_com_category VALUES (22, 4, 4, '釣り');
INSERT INTO sns_com_category VALUES (23, 4, 5, '球技');
INSERT INTO sns_com_category VALUES (24, 4, 6, 'マリンスポーツ');
INSERT INTO sns_com_category VALUES (25, 4, 7, 'カースポーツ');
INSERT INTO sns_com_category VALUES (26, 4, 8, 'ボクシング');
INSERT INTO sns_com_category VALUES (27, 4, 9, 'フィットネス');
INSERT INTO sns_com_category VALUES (28, 4, 10, '旅行・観光');
INSERT INTO sns_com_category VALUES (29, 4, 11, 'キャンプ');
INSERT INTO sns_com_category VALUES (30, 4, 12, '遊園地・施設');
INSERT INTO sns_com_category VALUES (31, 5, 1, '大学');
INSERT INTO sns_com_category VALUES (32, 5, 2, '高校');
INSERT INTO sns_com_category VALUES (33, 5, 3, '生涯学習');
INSERT INTO sns_com_category VALUES (34, 5, 4, '各種言語');
INSERT INTO sns_com_category VALUES (35, 5, 5, '脳トレーニング');
INSERT INTO sns_com_category VALUES (36, 5, 6, '資格・試験');
INSERT INTO sns_com_category VALUES (37, 6, 1, 'テレビゲーム');
INSERT INTO sns_com_category VALUES (38, 6, 2, 'テーブルゲーム');
INSERT INTO sns_com_category VALUES (39, 6, 3, 'モバイルゲーム');
INSERT INTO sns_com_category VALUES (40, 6, 4, 'フィールドゲーム');
INSERT INTO sns_com_category VALUES (41, 6, 5, 'オンラインゲーム');
INSERT INTO sns_com_category VALUES (42, 6, 6, 'ギャンブル');
INSERT INTO sns_com_category VALUES (43, 7, 1, 'お金・株');
INSERT INTO sns_com_category VALUES (44, 7, 2, '人間関係');
INSERT INTO sns_com_category VALUES (45, 7, 3, '結婚');
INSERT INTO sns_com_category VALUES (46, 7, 4, '子供');
INSERT INTO sns_com_category VALUES (47, 7, 5, 'ペット');
INSERT INTO sns_com_category VALUES (48, 7, 6, 'お悩み・相談');
INSERT INTO sns_com_category VALUES (49, 8, 1, 'ショッピング');
INSERT INTO sns_com_category VALUES (50, 8, 2, '仕事・キャリア');
INSERT INTO sns_com_category VALUES (51, 8, 3, '株式・企業');
INSERT INTO sns_com_category VALUES (52, 8, 4, '起業・経営');
INSERT INTO sns_com_category VALUES (53, 8, 5, '経済・マネー');
INSERT INTO sns_com_category VALUES (54, 8, 6, 'モラル・マナー');

-- 
-- レビューカテゴリ
-- 
INSERT INTO sns_rev_category VALUES (1, 1, 1, '和書', 'books-jp');
INSERT INTO sns_rev_category VALUES (2, 1, 2, '洋書', 'books-us');
INSERT INTO sns_rev_category VALUES (3, 1, 3, 'エレクトロニクス', 'electronics-jp');
INSERT INTO sns_rev_category VALUES (4, 1, 4, 'ホーム＆キッチン', 'kitchen-jp');
INSERT INTO sns_rev_category VALUES (5, 1, 5, 'ポピュラー音楽', 'popular-jp');
INSERT INTO sns_rev_category VALUES (6, 1, 6, 'クラシック', 'classical-jp');
INSERT INTO sns_rev_category VALUES (7, 1, 7, 'DVD', 'dvd-jp');
INSERT INTO sns_rev_category VALUES (8, 1, 8, 'ソフトウェア', 'software-jp');
INSERT INTO sns_rev_category VALUES (9, 1, 9, 'ゲーム', 'videogames-jp');
INSERT INTO sns_rev_category VALUES (10, 1, 10, 'おもちゃ＆ホビー', 'toys-jp');
INSERT INTO sns_rev_category VALUES (11, 1, 11, 'スポーツ', 'sporting-goods-jp');
INSERT INTO sns_rev_category VALUES (12, 1, 12, 'ヘルス＆ビューティー', 'hpc-jp');

-- 
-- 問合せカテゴリ
-- 
INSERT INTO sns_inq_category VALUES (1, 1, '新機能・アイディア');
INSERT INTO sns_inq_category VALUES (2, 2, 'エラー報告');
INSERT INTO sns_inq_category VALUES (3, 3, 'マナー・規約違反');
INSERT INTO sns_inq_category VALUES (4, 4, 'その他');

-- 
-- リスト表示ソート
-- 
INSERT INTO sns_sys_sort VALUES (1, 1, 1, '名前の順：昇順', 'pro.nickname ASC');
INSERT INTO sns_sys_sort VALUES (2, 1, 2, '名前の順：降順', 'pro.nickname DESC');
INSERT INTO sns_sys_sort VALUES (3, 1, 3, '最終ログイン順：昇順', 'act.last_login ASC');
INSERT INTO sns_sys_sort VALUES (4, 1, 4, '最終ログイン順：降順', 'act.last_login DESC');
INSERT INTO sns_sys_sort VALUES (5, 1, 5, '友達の人数順：昇順', 'act.friend_number ASC');
INSERT INTO sns_sys_sort VALUES (6, 1, 6, '友達の人数順：降順', 'act.friend_number DESC');
INSERT INTO sns_sys_sort VALUES (7, 2, 1, 'コミュニティ名順：昇順', 'com.community ASC');
INSERT INTO sns_sys_sort VALUES (8, 2, 2, 'コミュニティ名順：降順', 'com.community DESC');
INSERT INTO sns_sys_sort VALUES (9, 2, 3, '参加人数の順：昇順', 'com.total ASC');
INSERT INTO sns_sys_sort VALUES (10, 2, 4, '参加人数の順：降順', 'com.total DESC');
INSERT INTO sns_sys_sort VALUES (11, 2, 5, '設立年月日の順：昇順', 'com.regist_date ASC');
INSERT INTO sns_sys_sort VALUES (12, 2, 6, '設立年月日の順：降順', 'com.regist_date DESC');
INSERT INTO sns_sys_sort VALUES (13, 3, 1, 'イベント名順：昇順', 'tpc.topic ASC');
INSERT INTO sns_sys_sort VALUES (14, 3, 2, 'イベント名順：降順', 'tpc.topic DESC');
INSERT INTO sns_sys_sort VALUES (15, 3, 3, '開催日の順：昇順', 'tpc.start_date ASC');
INSERT INTO sns_sys_sort VALUES (16, 3, 4, '開催日の順：降順', 'tpc.start_date DESC');
INSERT INTO sns_sys_sort VALUES (17, 4, 1, 'タイトル名順：昇順', 'ent.subject ASC');
INSERT INTO sns_sys_sort VALUES (18, 4, 2, 'タイトル名順：降順', 'ent.subject DESC');
INSERT INTO sns_sys_sort VALUES (19, 4, 3, '日付の順：昇順', 'ent.regist_date ASC');
INSERT INTO sns_sys_sort VALUES (20, 4, 4, '日付の順：降順', 'ent.regist_date DESC');
INSERT INTO sns_sys_sort VALUES (21, 5, 1, '満足度の高い順', 'itm.total DESC');
INSERT INTO sns_sys_sort VALUES (22, 5, 2, '投稿数の多い順', 'itm.post DESC');
INSERT INTO sns_sys_sort VALUES (23, 5, 3, '投稿日の順：昇順', 'itm.modify ASC');
INSERT INTO sns_sys_sort VALUES (24, 5, 4, '投稿日の順：降順', 'itm.modify DESC');
INSERT INTO sns_sys_sort VALUES (25, 6, 1, '新しい書き込みの順', 'tpc.modify DESC');
INSERT INTO sns_sys_sort VALUES (26, 6, 2, '書き込みの多い順', 'tpc.post DESC');
INSERT INTO sns_sys_sort VALUES (27, 6, 3, 'トピック作成日の順：昇順', 'tpc.regist_date ASC');
INSERT INTO sns_sys_sort VALUES (28, 6, 4, 'トピック作成日の順：降順', 'tpc.regist_date DESC');

-- 
-- レビュー評価
-- 
INSERT INTO sns_rev_point VALUES (1, 0, 1, '星０コ');
INSERT INTO sns_rev_point VALUES (2, 1, 2, '星１コ');
INSERT INTO sns_rev_point VALUES (3, 2, 3, '星２コ');
INSERT INTO sns_rev_point VALUES (4, 3, 4, '星３コ');
INSERT INTO sns_rev_point VALUES (5, 4, 5, '星４コ');
INSERT INTO sns_rev_point VALUES (6, 5, 6, '星５コ');

-- 
-- デザインテーマ
-- 
INSERT INTO sns_des_theme VALUES(1,'2006-08-31 22:38:57','2006-08-10 17:50:32','rktGreen', '7DC11E','B5FA56','DFFDD2','000000','1E8506','1E8506','948C20','8CD724','DFFDD2');
INSERT INTO sns_des_theme VALUES(2,'2006-08-31 22:36:39','2006-08-10 23:00:12','rktBlue',  '49B8D5','BEF5EB','CFECF3','000000','1D5C9B','097794','5E9B1D','76C9DF','CFECF3');
INSERT INTO sns_des_theme VALUES(3,'2006-08-31 22:33:50','2006-08-10 23:00:26','rktRed',   'FF5D5D','FDB2B2','FDE6E6','5F0D0D','A01F1F','A30000','A33008','E3B7B7','FDE6E6');
INSERT INTO sns_des_theme VALUES(4,'2006-08-11 05:41:58','2006-08-10 23:00:38','rktYellow','FDDE32','FFE96B','FFEC82','000000','C6AB15','C6AB15','A5B900','DAC93E','FFEC82');
INSERT INTO sns_des_theme VALUES(5,'2006-08-31 22:27:23','2006-08-10 23:00:48','rktBlack', '818281','DBDCDA','DADADA','030202','000000','4B4747','878787','808180','DADADA');
INSERT INTO sns_des_theme VALUES(6,'2006-08-11 05:26:19','2006-08-10 23:01:13','rktOrange','F89427','F8BB79','F8DC79','000000','DA7B13','DA7B13','C82929','DDA53A','F8DC79');

-- 
-- スポンサー
-- 
INSERT INTO sns_sys_sponsor VALUES('1','1','1','rktSNS','<a href="http://rakuto.net/rktSNS/"><img  src="http://sns.rakuto.net/resource/img/sponsor/ads.gif" width="468" height="60" alt="rktSNS" /></a>');
INSERT INTO sns_sys_sponsor VALUES('2','1','2','rktSNS','<a href="http://rakuto.net/rktSNS/"><img  src="http://sns.rakuto.net/resource/img/sponsor/middle.gif" width="336" height="280" alt="rktSNS" /></a>');

-- 
-- 選択デザイン
-- 
INSERT INTO sns_sys_design VALUES('1','1','5','1','2','6','1','0');

-- 
-- コンテンツカテゴリ
-- 
INSERT INTO sns_itm_category VALUES('1','固定コンテンツ','1');
INSERT INTO sns_itm_category VALUES('2','お知らせ・情報','2');
INSERT INTO sns_itm_category VALUES('3','アンケート','3');

-- 
-- コンテンツ
-- 
INSERT INTO sns_itm_item VALUES('1','2006-08-11 00:00:00','1','1','2006-08-11',NULL,NULL,'about','rktSNSについて','SNSについて');
INSERT INTO sns_itm_item VALUES('2','2006-08-11 00:00:00','1','1','2006-08-11',NULL,NULL,'privacy','プライバシーポリシー','プライバシーポリシー');
INSERT INTO sns_itm_item VALUES('3','2006-08-11 00:00:00','1','1','2006-08-11',NULL,NULL,'rule','利用規約','利用規約');
INSERT INTO sns_itm_item VALUES('4','2006-08-11 00:00:00','1','1','2006-08-11',NULL,NULL,'help','ヘルプ','ヘルプ');

-- 
-- 日記印刷用カラー
-- 
INSERT INTO sns_dia_color VALUES('1','Black', '000000');
INSERT INTO sns_dia_color VALUES('2','Maroon','800000');
INSERT INTO sns_dia_color VALUES('3','Olive', '808000');
INSERT INTO sns_dia_color VALUES('4','Green', '008000');
INSERT INTO sns_dia_color VALUES('5','Teal',  '008080');
INSERT INTO sns_dia_color VALUES('6','Navy',  '000080');
INSERT INTO sns_dia_color VALUES('7','Purple','800080');

-- 
-- 日記印刷用フォント
-- 
INSERT INTO sns_dia_font VALUES('1','FS-Gothic', 'ゴシック');
INSERT INTO sns_dia_font VALUES('2','FS-Mincho', '明朝');
INSERT INTO sns_dia_font VALUES('3','mikachan-P', 'みかちゃん');
INSERT INTO sns_dia_font VALUES('4','onryou', '怨念');
INSERT INTO sns_dia_font VALUES('5','HuiFont27', 'ふい字');

COMMIT;