<?php
/* ========================================================================
 - [webapp/libs/wap_public.php]
 -      WebApplicationクラス
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/09/20] $this->base['uri_separator']を追加
 -      [2006/07/10] 作成
 - ======================================================================== */

require_once LIB_DIR.'rkt_db.php';
require_once LIB_DIR.'rkt_validate.php';
require_once LIB_DIR.'rkt_auth.php';
require_once LIB_DIR.'rkt_webapp.php';

/**
 * WebApplicationクラス
 *
 * @author 高橋 裕志郎 <yujiro@stepone.tv>
 * @package WAP_public
 * @access public
 * @version 1.0
 */
class WAP_public extends RKT_webapp
{
    /**
     * PHPSESSID
     * @var string
     */
    var $sid = '';

    /**
     * アカウント情報
     * @var object
     */
    var $account = array();

    /**
     * error情報
     * @var boolean
     */
    var $error = false;

    /**
     * コンストラクタ
     *
     * @access public
     */
    function WAP_public()
    {
        $this->RKT_webapp();

        $objact = account::getInstance();
        $this->sid = $objact->getSessionID();
        $this->account = $objact->getInfo();
        $this->base['account'] = $this->account;

        $this->__initialize();
    }

    /**
     * MobileAppの初期化
     *
     * @access private
     * @return void
     */
    function __initialize()
    {
        $this->smarty->register_outputfilter('tpl_utf2sjis');

        foreach ($_POST as $key=> $value){
            if (is_string($value)){
                $_POST[$key] = mb_convert_encoding($value, ENCODE_TYPE, 'SJIS');
                $_REQUEST[$key] = $_POST[$key];
            }
        } // foreach ($_POST as $key=> $value)
        foreach ($_GET as $key=> $value){
            if (is_string($value)){
                $_GET[$key] = mb_convert_encoding($value, ENCODE_TYPE, 'SJIS');
                $_REQUEST[$key] = $_GET[$key];
            }
        } // foreach ($_GET as $key=> $value)

        $this->base['sid']    = session_id();
        $this->base['url']    = BASE_URL;
        $this->base['http']   = HTTP_ACTION;
        $this->base['ssl']    = SSL_ACTION;
        $this->base['config'] = 'public.conf';

        $this->base['uri_separator']  = htmlspecialchars(WAP_URI_SEPARATOR);
    }

    /**
     * 実行処理
     *
     * @access public
     **/
    function execute()
    {
    }

    /**
     * 表示処理
     *
     * @access public
     * @return void
     **/
    function display()
    {
        if ($this->error){
            $this->template_file = 'error.tpl';
            error_log('WAP_public::error'."\r\n", 3, ERROR_LOG_FILE);
        }
        $this->mixOutput();
    }
}
// WAP_publicの終了
?>
